/* 
 *
 * routines for sanity checks
 *
 */

#include <config.h>

#include <stdio.h>

#include "globals.h"
#include "utils.h"
#include "protos.h"

int checkon_world(int gno)
{
    double dx = g[gno].w.xg2 - g[gno].w.xg1;
    double dy = g[gno].w.yg2 - g[gno].w.yg1;

    if (g[gno].xscale == SCALE_LOG) {
	if (g[gno].w.xg1 <= 0) {
	    errmsg("World X-min <= 0.0");
	    return FALSE;
	}
	if (g[gno].w.xg2 <= 0) {
	    errmsg("World X-max <= 0.0");
	    return FALSE;
	}
    } else if (g[gno].xscale == SCALE_REC) {
        if (sign(g[gno].w.xg1) != sign(g[gno].w.xg2)) {
	    errmsg("X-axis contains 0");
	    return FALSE;        
        }
    }
    if (dx <= 0.0) {
	errmsg("World DX <= 0.0");
	return FALSE;
    }
    if (g[gno].yscale == SCALE_LOG) {
	if (g[gno].w.yg1 <= 0.0) {
	    errmsg("World Y-min <= 0.0");
	    return FALSE;
	}
	if (g[gno].w.yg2 <= 0.0) {
	    errmsg("World Y-max <= 0.0");
	    return FALSE;
	}
    } else if (g[gno].yscale == SCALE_REC) {
        if (sign(g[gno].w.yg1) != sign(g[gno].w.yg2)) {
	    errmsg("Y-axis contains 0");
	    return FALSE;        
        }
    }
    
    if (dy <= 0.0) {
	errmsg("World DY <= 0.0");
	return 0;
    }
    return 1;
}

int isvalid_viewport(view v)
{
    if ((v.xv2 <= v.xv1) || (v.yv2 <= v.yv1)) {
	return FALSE;
    } else {
        return TRUE;
    }
}

/* check viewport (min < max) */
int checkon_viewport(int gno)
{
    if (isvalid_viewport(g[gno].v) == FALSE) {
        errmsg("Invalid viewport coordinates");
        return FALSE;
    } else {
        return TRUE;
    }
}

