#ifndef __DRAW_H_
#define __DRAW_H_

#include "defines.h"

/* bpp that Grace uses internally ( = 256 colors) */
#define GRACE_BPP	8
#define MAXCOLORS	(0x01 << GRACE_BPP)

#define MAXPATTERNS 16

#define MAXLINESTYLES 6

#define POLYLINE_OPEN	0
#define POLYLINE_CLOSED	1

#define PIXMAP_TRANSPARENT	0
#define PIXMAP_OPAQUE		1

typedef struct {
    int red;
    int green;
    int blue;
} RGB;

typedef struct {
    double y;
    double i;
    double q;
} YIQ;

#define BAD_COLOR	-1

#define COLOR_AUX 	0
#define COLOR_MAIN 	1

typedef struct {
    RGB rgb;
    char *cname;
    int ctype;
    int tstamp;
} CMap_entry;

#define BBOX_TYPE_GLOB	0
#define BBOX_TYPE_TEMP	1

typedef struct {
    int active;
    view v;
    view fv;
} BBox_type;

void setpen(Pen pen);
Pen getpen(void);

void setcolor(int color);
int getcolor(void);

void setbgcolor(int bgcolor);
int getbgcolor(void);

void setlinestyle(int lines);
int getlinestyle(void);

void setlinewidth(int linew);
double getlinewidth(void);

void setpattern(int pattern);
int getpattern(void);

void setfont(int font);
int getfont(void);

void setcharsize(double charsize);
double getcharsize(void);

void symplus(VPoint vp, double s);
void symx(VPoint vp, double s);
void symsplat(VPoint vp, double s);

void leavegraphics(void);

void DrawRect(VPoint vp1, VPoint vp2);
void FillRect(VPoint vp1, VPoint vp2);
void DrawLine(VPoint vp1, VPoint vp2);
void DrawPolyline(VPoint *vps, int n, int mode);
void DrawPolygon(VPoint *vps, int n);
void DrawArc(VPoint vp1, VPoint vp2, int angle1, int angle2);
void DrawFilledArc(VPoint vp1, VPoint vp2, int angle1, int angle2);
void DrawEllipse(VPoint vp1, VPoint vp2);
void DrawFilledEllipse(VPoint vp1, VPoint vp2);
void DrawCircle(VPoint vp, double radius);
void DrawFilledCircle(VPoint vp, double radius);

void setclipping(int fl);
int doclipping(void);
int is_vpoint_inside(view v, VPoint vp);
int is_validVPoint(VPoint vp);
int is_validWPoint(WPoint wp);
VPoint *line_intersect(VPoint vp1, VPoint vp2, VPoint vp1p, VPoint vp2p, int mode);
int clip_line(VPoint vp1, VPoint vp2, VPoint *vp1c, VPoint *vp2c);
int intersect_polygon(VPoint *vps, int n, VPoint vp1p, VPoint vp2p);
int clip_polygon(VPoint *vps, int n);

int is_valid_color(RGB rgb);
int find_color(RGB rgb);
int add_color(CMap_entry cmap);
RGB *get_rgb(unsigned int cindex);
CMap_entry *get_cmap_entry(unsigned int cindex);
char *get_colorname(unsigned int cindex);
int get_colortype(unsigned int cindex);
YIQ RGB2YIQ(RGB rgb);
double get_colorintensity(int cindex);
void initialize_cmap(void);

double fscale(double wc, int scale);
double ifscale(double vc, int scale);

double xconv(double wx);
double yconv(double wy);
VPoint Wpoint2Vpoint(WPoint wp);
int world2view(double x, double y, double *xv, double *yv);
void view2world(double xv, double yv, double *xw, double *yw);
view getviewport(void);

int definewindow(world w, view v, int xscale, int yscale, int xinv, int yinv);

void reset_bbox(int type);
void reset_bboxes(void);
void freeze_bbox(int type);
view get_bbox(int type);
int is_valid_bbox(view v);
view merge_bboxes(view v1, view v2);
void update_bbox(int type, VPoint vp);
void update_bboxes(VPoint vp);
void melt_bbox(int type);
void activate_bbox(int type, int status);

void set_draw_mode(int mode);
int get_draw_mode(void);

int number_of_colors(void);
int number_of_patterns(void);
int number_of_linestyles(void);

#endif /* __DRAW_H_ */
