/* $Id: motifutils.c,v 1.2 1995/04/18 15:21:26 pturner Exp pturner $
 *
 * utilities for Motif
 *
 */

#include <config.h>
#include <cmath.h>

#include <stdlib.h>
#include <stdarg.h>

#include "protos.h"

#include <X11/X.h>
#include <X11/Xatom.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Protocols.h>

#include "Tab.h"

#include "defines.h"
#include "globals.h"
#include "motifinc.h"

#define Infinity (1./0.)	/* this will create an Inf exception */

/* lookup table to determine if character is a floating point digit 
 * only allowable char's [0-9.eE]
 */
unsigned char fpdigit[256] = {  
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
			      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

extern Widget app_shell;
extern XmStringCharSet charset;

extern XtAppContext app_con;

extern Display *disp;
extern int screennumber;

extern int number_of_colors();

void errwin(char *s);
void savewidget(Widget w);

void SetChoice(Widget * w, int value)
{
    Arg a;

    if (w == (Widget *) NULL) {
	errwin("Internal error, SetChoice called with NULL argument");
	return;
    }
    if (w[value + 2] == (Widget) NULL) {
	errwin("Internal error, SetChoice: Attempt to set NULL Widget");
	return;
    }
    XtSetArg(a, XmNmenuHistory, w[value + 2]);
    XtSetValues(w[0], &a, 1);
}

int GetChoice(Widget * w)
{
    Arg a;
    Widget warg;
    int i;

    if (w == (Widget *) NULL) {
	errwin("Internal error, GetChoice called with NULL argument");
	return 0;
    }
    XtSetArg(a, XmNmenuHistory, &warg);
    XtGetValues(w[0], &a, 1);
    i = 0;
    while (w[i + 2] != warg) {
	if (w[i + 2] == (Widget) NULL) {
	    errwin("Internal error, GetChoice: Found NULL in Widget list");
	    return 0;
	}
	i++;
    }
    return i;
}

Widget *CreatePanelChoice(Widget parent, char *labelstr, int nchoices,...)
{
    va_list var;
    int i = 0;
    XmString str;
    char *s;
    Widget *retval;

    nchoices--;

    retval = (Widget *) XtMalloc((nchoices + 2) * sizeof(Widget));

    retval[1] = XmCreatePulldownMenu(parent, "pulldown", NULL, 0);

    i = 0;
    va_start(var, nchoices);
    while ((s = va_arg(var, char *)) != NULL) {
	retval[i + 2] = XmCreatePushButton(retval[1], s, NULL, 0);
	i++;
    }
    if (i != nchoices) {
	errmsg("Incorrect number of selections in CreatePanelChoice()");
    }
    XtManageChildren(retval + 2, nchoices);
    va_end(var);

    str = XmStringCreate(labelstr, charset);

    retval[0] = XmCreateOptionMenu(parent, "optionmenu", NULL, 0);
    XtVaSetValues(retval[0],
		  XmNlabelString, str,
		  XmNsubMenuId, retval[1],
		  XmNwhichButton, 1,
		  NULL);
    XtManageChild(retval[0]);
    for (i = 0; i < nchoices + 2; i++) {
	retval[i] = retval[i];
    }
    return retval;
}

Widget *CreatePanelChoice0(Widget parent, char *labelstr, int ncols, int nchoices,...)
{
    va_list var;
    int i = 0;
    XmString str;
    char *s;
    Widget *retval;

    nchoices--;

    retval = (Widget *) XtMalloc((nchoices + 2) * sizeof(Widget));

    retval[1] = XmCreatePulldownMenu(parent, "pulldown", NULL, 0);
    XtVaSetValues(retval[1],
		  XmNorientation, XmVERTICAL,
		  XmNpacking, XmPACK_COLUMN,
		  XmNnumColumns, ncols,
		  NULL);

    i = 0;

    va_start(var, nchoices);
    while ((s = va_arg(var, char *)) != NULL) {
	retval[i + 2] = XmCreatePushButton(retval[1], s, NULL, 0);
	i++;
    }
    if (i != nchoices) {
	errmsg("Incorrect number of selections in CreatePanelChoice0()");
    }
    va_end(var);

    XtManageChildren(retval + 2, nchoices);

    str = XmStringCreate(labelstr, charset);

    retval[0] = XmCreateOptionMenu(parent, "optionmenu", NULL, 0);
    XtVaSetValues(retval[0],
		  XmNlabelString, str,
		  XmNsubMenuId, retval[1],
		  XmNwhichButton, 1,
		  NULL);
    XtManageChild(retval[0]);
    for (i = 0; i < nchoices + 2; i++) {
	retval[i] = retval[i];
    }
    return retval;
}

Widget *CreateGraphChoice(Widget parent, char *labelstr, int ngraphs, int type)
{
    int i = 0;
    XmString str;
    char *name, buf[32];
    Widget *retval = NULL;

    strcpy(buf, "graphchoice");
    name = buf;

    switch (type) {
    case 0:
	retval = (Widget *) XtMalloc((ngraphs + 2) * sizeof(Widget));
	retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[1],
		      XmNorientation, XmVERTICAL,
		      XmNpacking, XmPACK_COLUMN,
		      XmNnumColumns, 4,
		      NULL);
	i = 0;
	for (i = 0; i < ngraphs; i++) {
	    sprintf(buf, "%d", i);
	    retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
	}
	XtManageChildren(retval + 2, ngraphs);

	str = XmStringCreate(labelstr, charset);

	retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[0],
		      XmNlabelString, str,
		      XmNsubMenuId, retval[1],
		      XmNwhichButton, 1,
		      NULL);
	XtManageChild(retval[0]);
	break;

    case 1:
	retval = (Widget *) XtMalloc((ngraphs + 3) * sizeof(Widget));
	retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[1],
		      XmNorientation, XmVERTICAL,
		      XmNpacking, XmPACK_COLUMN,
		      XmNnumColumns, 4,
		      NULL);
	retval[2] = XmCreatePushButton(retval[1], "Current", NULL, 0);
	for (i = 1; i <= ngraphs; i++) {
	    sprintf(buf, "%d", i - 1);
	    retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
	}
	XtManageChildren(retval + 2, ngraphs + 1);
	str = XmStringCreate(labelstr, charset);
	retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[0],
		      XmNlabelString, str,
		      XmNsubMenuId, retval[1],
		      XmNwhichButton, 1,
		      NULL);
	XtManageChild(retval[0]);
	break;
    case 2:
	retval = (Widget *) XtMalloc((ngraphs + 4) * sizeof(Widget));
	retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[1],
		      XmNorientation, XmVERTICAL,
		      XmNpacking, XmPACK_COLUMN,
		      XmNnumColumns, 4,
		      NULL);
	retval[2] = XmCreatePushButton(retval[1], "Current", NULL, 0);
	for (i = 1; i <= ngraphs; i++) {
	    sprintf(buf, "%d", i - 1);
	    retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
	}
	retval[ngraphs + 3] = XmCreatePushButton(retval[1], "All", NULL, 0);

	XtManageChildren(retval + 2, ngraphs + 2);
	str = XmStringCreate(labelstr, charset);
	retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
	XtVaSetValues(retval[0],
		      XmNlabelString, str,
		      XmNsubMenuId, retval[1],
		      XmNwhichButton, 1,
		      NULL);
	XtManageChild(retval[0]);
	break;
    }
    return retval;
}

void UpdateFrameWinColors(unsigned color);
void UpdateLabelWinColors(unsigned color);
void UpdateMiscWinColors(unsigned color);
void UpdateStrWinColors(unsigned color);
void UpdateSymWinColors(unsigned color);
void UpdateTickWinColors(unsigned color);

void UpdateAllColorChoice(unsigned color) {
}

void UpdateColorChoice(Widget* w, unsigned color) {
  extern unsigned long xvlibcolors[];
  if (w) {
      XtVaSetValues(w[color+2],XmNbackground,xvlibcolors[color],NULL);
  }
}

Widget *CreateColorChoice(Widget parent, char *s)
{
    int nchoices, ncols, i = 0;
    char *name, labelstr[32], buf[32];
    
    extern unsigned long xvlibcolors[];
    
    Widget *retval;
    XmString str;

    if (s == NULL) {
	strcpy(labelstr, "");
    } else {
	strcpy(labelstr, s);
    }

    ncols = (int) sqrt((double) number_of_colors());
    if (ncols == 0) {
	ncols = 1;
    }
    nchoices = number_of_colors();
    retval = (Widget *) XtMalloc((number_of_colors() + 2) * sizeof(Widget));

    strcpy(buf, "colorchoice");
    name = buf;
    retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
    XtVaSetValues(retval[1],
		  XmNorientation, XmVERTICAL,
		  XmNpacking, XmPACK_COLUMN,
		  XmNnumColumns, ncols,
		  NULL);
    for (i = 0; i < number_of_colors(); i++) {
	strcpy(buf, get_colorname(i));
	if (get_colortype(i) == COLOR_AUX) {
	    strcat(buf, " (a)");
	}
	retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
	XtVaSetValues(retval[i + 2], XmNbackground, xvlibcolors[i], NULL);
	if (get_colorintensity(i) < 0.5) {
	    XtVaSetValues(retval[i + 2], 
	                  XmNforeground, WhitePixel(disp, screennumber), NULL);
	} else {
	    XtVaSetValues(retval[i + 2], 
	                  XmNforeground, BlackPixel(disp, screennumber), NULL);
	}
    }
    XtManageChildren(retval + 2, nchoices);

    strcpy(buf, "coloroption");
    str = XmStringCreate(labelstr, charset);

    retval[0] = XmCreateOptionMenu(parent, buf, NULL, 0);
    XtVaSetValues(retval[0],
		  XmNlabelString, str,
		  XmNsubMenuId, retval[1],
		  XmNwhichButton, 1,
		  NULL);
    XtManageChild(retval[0]);
    return retval;
}

Widget *CreateSetChoice(Widget parent, char *labelstr, int nsets, int type)
{
    int nmal, i = 0;
    XmString str;
    char *name = "setchoice";
    char buf[10];
    Widget *retval = NULL;
 
    switch (type) {
    case 0:
        nmal = nsets + 2;
        retval = (Widget *) XtMalloc(nmal * sizeof(Widget));
        retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[1],
                      XmNorientation, XmVERTICAL,
                      XmNpacking, XmPACK_COLUMN,
                      XmNnumColumns, nsets / 10,
                      NULL);
        i = 0;
        for (i = 0; i < nsets; i++) {
            sprintf(buf, "%d", i);
            retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
        }
        XtManageChildren(retval + 2, nsets);
 
        str = XmStringCreate(labelstr, charset);
 
        retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[0],
                      XmNlabelString, str,
                      XmNsubMenuId, retval[1],
                      XmNwhichButton, 1,
                      NULL);
        XtManageChild(retval[0]);
        break;
    case 1:
        nmal = nsets + 3;
        retval = (Widget *) XtMalloc(nmal * sizeof(Widget));
        retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[1],
                      XmNorientation, XmVERTICAL,
                      XmNpacking, XmPACK_COLUMN,
                      XmNnumColumns, nsets / 10,
                      NULL);
        i = 0;
        for (i = 0; i < nsets; i++) {
            sprintf(buf, "%d", i);
            retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
        }
        retval[nsets + 2] = XmCreatePushButton(retval[1], "All", NULL, 0);
        XtManageChildren(retval + 2, nsets + 1);
 
        str = XmStringCreate(labelstr, charset);
 
        retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[0],
                      XmNlabelString, str,
                      XmNsubMenuId, retval[1],
                      XmNwhichButton, 1,
                      NULL);
        XtManageChild(retval[0]);
        break;
    case 2:
        retval = (Widget *) XtMalloc((nsets + 3) * sizeof(Widget));
        strcpy(buf, "setchoice");
        name = buf;
        retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[1],
                      XmNorientation, XmVERTICAL,
                      XmNpacking, XmPACK_COLUMN,
                      XmNnumColumns, nsets / 10,
                      NULL);
        i = 0;
        for (i = 0; i < nsets; i++) {
            sprintf(buf, "%d", i);
            retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
        }
        retval[nsets + 2] = XmCreatePushButton(retval[1], "All", NULL, 0);
        XtManageChildren(retval + 2, nsets + 1);
 
        str = XmStringCreate(labelstr, charset);
 
        retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[0],
                      XmNlabelString, str,
                      XmNsubMenuId, retval[1],
                      XmNwhichButton, 1,
                      NULL);
        XtManageChild(retval[0]);
        break;
/* 4 is Next */
    case 4:
        retval = (Widget *) XtMalloc((nsets + 3) * sizeof(Widget));
        strcpy(buf, "setchoice");
        name = buf;
        retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[1],
                      XmNorientation, XmVERTICAL,
                      XmNpacking, XmPACK_COLUMN,
                      XmNnumColumns, nsets / 10,
                      NULL);
        retval[2] = XmCreatePushButton(retval[1], "Next", NULL, 0);
        for (i = 1; i <= nsets; i++) {
            sprintf(buf, "%d", i - 1);
            retval[i + 2] = XmCreatePushButton(retval[1], buf, NULL, 0);
        }
        XtManageChildren(retval + 2, nsets + 1);
 
        str = XmStringCreate(labelstr, charset);
 
        retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[0],
                      XmNlabelString, str,
                      XmNsubMenuId, retval[1],
                      XmNwhichButton, 1,
                      NULL);
        XtManageChild(retval[0]);
        break;
/* 5 is Next, Same */
    case 6:                     /* All, then sets */
        nmal = nsets + 3;
        retval = (Widget *) XtMalloc(nmal * sizeof(Widget));
        retval[1] = XmCreatePulldownMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[1],
                      XmNorientation, XmVERTICAL,
                      XmNpacking, XmPACK_COLUMN,
                      XmNnumColumns, nsets / 10,
                      NULL);
        retval[2] = XmCreatePushButton(retval[1], "All", NULL, 0);
        for (i = 0; i < nsets; i++) {
            sprintf(buf, "%d", i);
            retval[i + 3] = XmCreatePushButton(retval[1], buf, NULL, 0);
        }
        XtManageChildren(retval + 2, nsets + 1);
 
        str = XmStringCreate(labelstr, charset);
 
        retval[0] = XmCreateOptionMenu(parent, name, NULL, 0);
        XtVaSetValues(retval[0],
                      XmNlabelString, str,
                      XmNsubMenuId, retval[1],
                      XmNwhichButton, 1,
                      NULL);
        XtManageChild(retval[0]);
        break;
    }
    return retval;
}

Widget *CreateFontChoice(Widget parent, char *s)
{
    Widget *wp, rc;

    rc = XmCreateRowColumn(parent, "rcFont", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    wp = CreatePanelChoice(rc, s,
                             11,
                             "Times-Roman", "Times-Bold", "Times-Italic",
                             "Times-BoldItalic", "Helvetica",
                             "Helvetica-Bold", "Helvetica-Oblique",
                             "Helvetica-BoldOblique", "Symbol", "Dingbats",
                             NULL,
                             0);
    XtManageChild(rc);
    
    return wp;
}

Widget *CreateLineStyleChoice(Widget parent, char *s)
{
    Widget *wp, rc;

    rc = XmCreateRowColumn(parent, "rcLineStyle", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    wp = CreatePanelChoice(rc, s,
                           7,
                           "None",
                           "Solid line",
                           "Dotted line",
                           "Dashed line",
                           "Long dashed",
                           "Dot-dashed",
                           NULL,
                           0);
    XtManageChild(rc);
    
    return wp;
}

Widget *CreateLineWidthChoice(Widget parent, char *s)
{
    Widget *wp, rc;

    rc = XmCreateRowColumn(parent, "rcLineWidth", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    wp = CreatePanelChoice(rc, s,
                           11,
                           "0", "1", "2", "3", "4", "5",
                           "6", "7", "8", "9",
                           NULL,
                           0);
    XtManageChild(rc);
    
    return wp;
}

Widget *CreateFormatChoice(Widget parent, char *s)
{
    Widget *w;
    
    w = CreatePanelChoice0(parent,
                       s, 4,
                       30,
                       "Decimal",
                       "Exponential",
                       "Power",
                       "General",
                       "DD-MM-YY",
                       "MM-DD-YY",
                       "YY-MM-DD",
                       "MM-YY",
                       "MM-DD",
                       "Month-DD",
                       "DD-Month",
                       "Month (abrev.)",
                       "Month (abrev.)-YY",
                       "Month",
                       "Day of week (abrev.)",
                       "Day of week",
                       "Day of year",
                       "HH:MM:SS.s",
                       "MM-DD HH:MM:SS.s",
                       "MM-DD-YY HH:MM:SS.s",
                       "YY-MM-DD HH:MM:SS.s",
                       "Degrees (lon)",
                       "DD MM' (lon)",
                       "DD MM' SS.s\" (lon)",
                       "MM' SS.s\" (lon)",
                       "Degrees (lat)",
                       "DD MM' (lat)",
                       "DD MM' SS.s\" (lat)",
                       "MM' SS.s\" (lat)", 
                       NULL,
                       0);
    
    return(w);
}

Widget *CreatePrecisionChoice(Widget parent, char *s)
{
    Widget *w;
    
    w = CreatePanelChoice(parent, s,
                          11,
                          "0", "1", "2", "3", "4",
                          "5", "6", "7", "8", "9",
                          NULL,
                          0);

    return(w);
}
    

Widget *CreatePatternChoice(Widget parent, char *s)
{
    Widget *wp, rc;

    rc = XmCreateRowColumn(parent, "rcLineWidth", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    wp = CreatePanelChoice0(rc, s, 4,
			    17,
			    "None", "1", "2", "3",
                            "4", "5", "6", "7",
                            "8", "9", "10", "11",
                            "12", "13", "14", "15",
			    NULL,
			    0);
    XtManageChild(rc);
    
    return wp;
}

Widget CreateCharSizeChoice(Widget parent, char *s)
{
    Widget w;
    XmString str;
    
/*
 *     rc = XmCreateRowColumn(parent, "rcCharSize", NULL, 0);
 *     XtVaSetValues(rc, 
 *                   XmNorientation, XmHORIZONTAL,
 *                   XmNisAligned, True,
 *                   XmNentryAlignment, XmALIGNMENT_END,
 *                   XmNadjustLast, True,
 *                   NULL);
 * 
 *     XtVaCreateManagedWidget(s, xmLabelWidgetClass, rc, NULL);
 */

    str = XmStringCreate(s, charset);
    w = XtVaCreateManagedWidget("charSize", xmScaleWidgetClass, parent,
				XmNtitleString, str,
				XmNminimum, 0,
				XmNmaximum, 400,
				XmNvalue, 100,
				XmNshowValue, True,
#if XmVersion >= 2000    
				XmNsliderMark, XmROUND_MARK,
#endif
				XmNprocessingDirection, XmMAX_ON_RIGHT,
				XmNorientation, XmHORIZONTAL,
				NULL);
    XmStringFree(str);
/*
 *     XtManageChild(rc);
 */
    
    return w;
}

double GetCharSizeChoice(Widget w)
{
    Arg arg;
    int value;
    
    XtSetArg(arg, XmNvalue, &value);
    XtGetValues(w, &arg, 1);
    
    return ((double) value / 100);
}

void SetCharSizeChoice(Widget w, double size)
{
    Arg arg;
    int value;
    
    value = (int) rint(size*100);
    XtSetArg(arg, XmNvalue, value);
    XtSetValues(w, &arg, 1);
    
    return;
}

Widget CreateAngleChoice(Widget parent, char *s)
{
    Widget w;
    XmString str;
    
    str = XmStringCreate(s, charset);
    w = XtVaCreateManagedWidget("angle", xmScaleWidgetClass, parent,
				XmNtitleString, str,
				XmNminimum, 0,
				XmNmaximum, 360,
				XmNvalue, 100,
				XmNshowValue, True,
#if XmVersion >= 2000    
				XmNsliderMark, XmROUND_MARK,
#endif
				XmNprocessingDirection, XmMAX_ON_RIGHT,
				XmNorientation, XmHORIZONTAL,
				NULL);
    XmStringFree(str);

    return w;
}

int GetAngleChoice(Widget w)
{
    Arg arg;
    int value;
    
    XtSetArg(arg, XmNvalue, &value);
    XtGetValues(w, &arg, 1);
    
    return (value);
}

void SetAngleChoice(Widget w, int angle)
{
    Arg arg;
    
    XtSetArg(arg, XmNvalue, angle);
    XtSetValues(w, &arg, 1);
    
    return;
}


Widget CreateToggleButton(Widget parent, char *s)
{
    return (XtVaCreateManagedWidget(s, xmToggleButtonWidgetClass, parent, NULL));
}

int GetToggleButtonState(Widget w)
{
    return (XmToggleButtonGetState(w));
}

void SetToggleButtonState(Widget w, int value)
{
    XmToggleButtonSetState(w, value ? True:False, False);
    
    return;
}

Widget CreateFrame(Widget parent, char *s)
{
    Widget fr;
    
    fr = XtVaCreateManagedWidget("frame", xmFrameWidgetClass, parent, NULL);
    if (s != NULL) {
        XtVaCreateManagedWidget(s, xmLabelWidgetClass, fr,
				XmNchildType, XmFRAME_TITLE_CHILD,
				NULL);
    }
    
    return (fr);   
}

Widget CreateTab(Widget parent)
{
    Widget tab;
    
    tab = XtVaCreateManagedWidget("tab", xmTabWidgetClass, parent, NULL);
    
    return (tab);
}

Widget CreateTabPage(Widget parent, char *s)
{
    Widget w;
    XmString str;
    
    w = XmCreateRowColumn(parent, "tabPage", NULL, 0);
    str = XmStringCreateSimple(s);
    XtVaSetValues(w, XmNtabLabel, str, NULL);
    XmStringFree(str);
    XtManageChild(w);
    
    return (w);
}

void SelectTabPage(Widget tab, Widget w)
{
    XmTabSetTabWidget(tab, w, True);
}

Widget CreateTextItem2(Widget parent, int len, char *s)
{
    Widget w;
    Widget rc;
    XmString str;
    rc = XmCreateRowColumn(parent, "rc", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    str = XmStringCreateLtoR(s, charset);
    XtVaCreateManagedWidget("label", xmLabelWidgetClass, rc,
			    XmNlabelString, str,
			    NULL);
    XmStringFree(str);
    w = XtVaCreateManagedWidget("text", xmTextWidgetClass, rc,
				XmNtraversalOn, True,
				XmNcolumns, len,
				NULL);
    XtManageChild(rc);
    return w;
}

Widget CreateTextItem4(Widget parent, int len, char *label)
{
    Widget retval;
    XtVaCreateManagedWidget(label, xmLabelWidgetClass, parent, NULL);
    retval = XtVaCreateManagedWidget("text", xmTextWidgetClass, parent, NULL);
    XtVaSetValues(retval, XmNcolumns, len, NULL);
    return retval;
}

/* 
 * create a multiline editable window
 * parent = parent widget
 * len    = width of edit window
 * hgt    = number of lines in edit window
 * s      = label for window
 * 
 * returns the edit window widget
 */
Widget CreateScrollTextItem2(Widget parent, int len, int hgt, char *s)
{
    Widget w;
    Widget rc;
    XmString str;
	
    rc = XmCreateRowColumn(parent, "rc", NULL, 0);
    XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
    str = XmStringCreateLtoR(s, charset);
    XtVaCreateManagedWidget("label", xmLabelWidgetClass, rc,
			    XmNlabelString, str,
			    NULL);
    XmStringFree(str);
    w = XmCreateScrolledText( rc, "text", NULL, 0 );
	XtVaSetValues( w,
			XmNcolumns, len,
			XmNrows, hgt,
			XmNeditMode, XmMULTI_LINE_EDIT,
		    XmNwordWrap, True,		
			NULL);
    XtManageChild(w);
    XtManageChild(rc);
    return w;
}


char *xv_getstr(Widget w)
/* 
 * return the string from a text widget
 *
 * NB - newlines are converted to spaces
 */
{
    char *s;
    int i;
    static char buf[MAX_STRING_LENGTH];

    strncpy(buf, s = XmTextGetString(w), MAX_STRING_LENGTH - 1);
    XtFree(s);
    
    i=strlen(buf);
    for (i--; i >= 0; i--) {
        if (buf[i] == '\n') {
            buf[i] = ' ';
        }
    }
    return buf;
}


/*
 * xv_evalexpr - take a text field and pass it to the parser if it needs to
 * 					evaluated, else use atof().
 *               place the double result in answer
 *               if an error, return False, else True
 */
Boolean xv_evalexpr(Widget w, double *answer )
{
    char *s;
    static char buf[MAX_STRING_LENGTH];
    int i, len, ier = 0;
    double x, y, a, b, c, d;
    extern double result;
	
    strncpy(buf, s = XmTextGetString(w), MAX_STRING_LENGTH - 1);
    XtFree(s);

    if (!(len = strlen( buf ) )) { /* check for zero length */
        *answer = 0;
        return GRACE_EXIT_FAILURE;
    }
    /* first character may be a sign */
    if (!fpdigit[(int) s[0]] && s[0] != '-' && s[0] != '+') {
        i = len +1;
    } else {
        i = 1;
    }

    for (; i<len; i++) {
        if (!fpdigit[(int) buf[i]]) {
            break;
        }
    }

    if (i == len) {         /* only floating point digits */
        *answer = atof( buf );
        return GRACE_EXIT_SUCCESS;
    } else {                /* must evaluate an expression */
        scanner(buf, &x, &y, 1, &a, &b, &c, &d, 1, 0, 0, &ier);
        if( !ier ) {
            *answer = result;
            return GRACE_EXIT_SUCCESS;
        } else {
            *answer = 0;
            return GRACE_EXIT_FAILURE;
        }
    }
}

/*
 * xv_evalexpri - take a text field and pass it to the parser if it needs to
 * 					evaluated, else use atoi().
 *               place the integer result in answer
 *               if an error, return False, else True
 */
Boolean xv_evalexpri(Widget w, int *answer )
{
    char *s;
    static char buf[MAX_STRING_LENGTH];
    int i, len, ier = 0;
    double x, y, a, b, c, d;
    extern double result;
	
    strncpy(buf, s = XmTextGetString(w), MAX_STRING_LENGTH - 1);
    XtFree(s);

    if (!(len = strlen( buf ) )) { /* check for zero length */
        *answer = 0;
        return GRACE_EXIT_FAILURE;
    }
    /* first character may be a sign */
    if (!fpdigit[(int) s[0]] && s[0] != '-' && s[0] != '+') {
        i = len +1;
    } else {
        i = 1;
    }
    
    for (; i<len; i++) {
        if (!fpdigit[(int) buf[i]]) {
            break;
        }
    }

    if (i == len) {             /* only floating point digits */
        *answer = atoi(buf);
        return GRACE_EXIT_SUCCESS;
    } else {                    /* must evaluate an expression */
        scanner(buf, &x, &y, 1, &a, &b, &c, &d, 1, 0, 0, &ier);
        if( !ier ) {
            *answer = (int)result;
            return GRACE_EXIT_SUCCESS;
        } else {
            *answer = 0;
            return GRACE_EXIT_FAILURE;
        }
    }
}


void xv_setstr(Widget w, char *s)
{
    if (s != NULL && w != NULL) {
        XmTextSetString(w, s);
    }
}

/*
 * generic unmanage popup routine, used elswhere
 */
void destroy_dialog(Widget w, XtPointer p)
{
    XtUnmanageChild((Widget) p);
}

/*
 * handle the close item on the WM menu
 */
void handle_close(Widget w)
{
    Atom WM_DELETE_WINDOW;
    XtVaSetValues(w,
		  XmNdeleteResponse, XmDO_NOTHING,
		  NULL);
    WM_DELETE_WINDOW = XmInternAtom(XtDisplay(app_shell), "WM_DELETE_WINDOW",
                                    False);
    XmAddProtocolCallback((Widget) w, (Atom) XM_WM_PROTOCOL_ATOM(w),
                          (Atom) WM_DELETE_WINDOW,
			  (XtCallbackProc) destroy_dialog, (XtPointer) w);
}

/*
 * Manage and raise
 */
void XtRaise(Widget w)
{
    XtManageChild(w);
    XMapRaised(XtDisplay(w), XtWindow(w));
    savewidget(w);
}

/*
 * save dialog widgets for cursor control
 */

typedef struct _SaveDialogState {
    Widget w;
    char *name;
    int open;
    int restore;
    int x, y;
    int width, height;
}
SaveDialogState;

static Widget *savewidgets = NULL;
static int nsavedwidgets = 0;

void savewidget(Widget w)
{
    int i;
    if (savewidgets == NULL) {
	savewidgets = (Widget *) malloc(sizeof(Widget));
    } else {
	for (i = 0; i < nsavedwidgets; i++) {
	    if (w == savewidgets[i]) {
		return;
	    }
	}
	savewidgets = (Widget *) realloc(savewidgets, (nsavedwidgets + 2) * sizeof(Widget));
    }
    savewidgets[nsavedwidgets] = w;
    nsavedwidgets++;
}

void savewidgetstate(Widget w)
{
    int i;
    if (savewidgets == NULL) {
    } else {
	for (i = 0; i < nsavedwidgets; i++) {
	}
    }
}

void restorewidgetstate(Widget w)
{
    int i;
    if (savewidgets == NULL) {
    } else {
	for (i = 0; i < nsavedwidgets; i++) {
	}
    }
}

void deletewidget(Widget w)
{
    int i, j;
    if (savewidgets == NULL || nsavedwidgets == 0) {
	return;
    } else {
	/* find the widget */
	for (i = 0; i < nsavedwidgets; i++) {
	    if (w == savewidgets[i]) {
		break;
	    }
	}
/* shouldn't happen, widget not in the saved widget list */
	if (i == nsavedwidgets) {
	    return;
	}
/* remove the widget from the list */
	for (j = i; j < nsavedwidgets - 1; j++) {
	    savewidgets[j] = savewidgets[j + 1];
	}
	if (nsavedwidgets - 1 > 0) {
	    savewidgets = (Widget *) realloc(savewidgets, (nsavedwidgets - 1) * sizeof(Widget));
	    nsavedwidgets--;
	} else {
	    free(savewidgets);
	    savewidgets = NULL;
	}
    }
}

void DefineDialogCursor(Cursor c)
{
    int i;
    for (i = 0; i < nsavedwidgets; i++) {
	XDefineCursor(disp, XtWindow(savewidgets[i]), c);
	XDefineCursor(disp, XtWindow(app_shell), c);
/*
        attrs.cursor = c;
        XChangeWindowAttributes(disp, XtWindow(savewidgets[i]), CWCursor, &attrs);
*/
    }
    XFlush(disp);
}

void UndefineDialogCursor()
{
    int i;
    for (i = 0; i < nsavedwidgets; i++) {
	XUndefineCursor(disp, XtWindow(savewidgets[i]));
	XUndefineCursor(disp, XtWindow(app_shell));
    }
    XFlush(disp);
}

Widget CreateCommandButtonsNoDefault(Widget parent, int n, Widget * buts, char **l)
{
    int i;
    Widget form;
    Dimension h;

    form = XtVaCreateWidget("form", xmFormWidgetClass, parent,
			    XmNfractionBase, n,
			    NULL);

    for (i = 0; i < n; i++) {
	buts[i] = XtVaCreateManagedWidget(l[i],
					  xmPushButtonWidgetClass, form,
					  XmNtopAttachment, XmATTACH_FORM,
					  XmNbottomAttachment, XmATTACH_FORM,
					  XmNleftAttachment, XmATTACH_POSITION,
					  XmNleftPosition, i,
					  XmNrightAttachment, XmATTACH_POSITION,
					  XmNrightPosition, i + 1,
					  XmNleftOffset, (i == 0) ? 2 : 0,
					  XmNrightOffset, 3,
					  XmNtopOffset, 2,
					  XmNbottomOffset, 3,
					  NULL);
    }
    XtManageChild(form);
    XtVaGetValues(buts[0], XmNheight, &h, NULL);
    XtVaSetValues(form, XmNpaneMaximum, h, XmNpaneMinimum, h, NULL);
    
    return form;
}

Widget CreateCommandButtons(Widget parent, int n, Widget * buts, char **l)
{
    int i;
    Widget form;
    Dimension h;

    form = XtVaCreateWidget("form", xmFormWidgetClass, parent,
			    XmNfractionBase, n,
			    NULL);

    for (i = 0; i < n; i++) {
	buts[i] = XtVaCreateManagedWidget(l[i],
					  xmPushButtonWidgetClass, form,
					  XmNtopAttachment, XmATTACH_FORM,
					  XmNbottomAttachment, XmATTACH_FORM,
					  XmNleftAttachment, XmATTACH_POSITION,
					  XmNleftPosition, i,
					  XmNrightAttachment, XmATTACH_POSITION,
					  XmNrightPosition, i + 1,
					  XmNdefaultButtonShadowThickness, 1,
					  XmNshowAsDefault, (i == 0) ? True : False,
					  NULL);
    }
    XtManageChild(form);
    XtVaGetValues(buts[0], XmNheight, &h, NULL);
    XtVaSetValues(form, XmNpaneMaximum, h, XmNpaneMinimum, h, NULL);
    
    return form;
}

static SetChoiceItem *plist = NULL;
static int nplist = 0;

int GetSetFromString(char *buf)
{
    int retval = SET_SELECT_ERROR;
    if (strcmp(buf, "New set") == 0) {
	retval = SET_SELECT_NEXT;
    } else if (strcmp(buf, "All sets") == 0) {
	retval = SET_SELECT_ALL;
    } else {
	sscanf(buf, "S%d", &retval);
    }
    return retval;
}

int GetSelectedSet(SetChoiceItem l)
{
    int retval = SET_SELECT_ERROR;
    int *pos_list;
    int pos_cnt, cnt;
    char buf[256];
	
    if (XmListGetSelectedPos(l.list, &pos_list, &pos_cnt)) {
	XmString *s, cs;
	char *cstr;
	XtVaGetValues(l.list,
		      XmNselectedItemCount, &cnt,
		      XmNselectedItems, &s,
		      NULL);
	cs = XmStringCopy(*s);
	if (XmStringGetLtoR(cs, charset, &cstr)) {
	    strcpy(buf, cstr);
	    if (strcmp(buf, "New set") == 0) {
		retval = SET_SELECT_NEXT;
	    } else if (strcmp(buf, "All sets") == 0) {
		retval = SET_SELECT_ALL;
	    } else if (strcmp(buf, "Nearest set") == 0) {
		retval = SET_SELECT_NEAREST;
	    } else {
		sscanf(buf, "S%d", &retval);
	    }
	    XtFree(cstr);
	}
        XmStringFree(cs);
    }
    
    return retval;
}

/* TODO */
int SetSelectedSet(int gno, int setno, SetChoiceItem l)
{
    char buf[1024];
    XmString xms;
    sprintf(buf, "S%d (N=%d, %s)", setno, getsetlength(gno, setno), getcomment(gno, setno));
    xms = XmStringCreateLtoR(buf, charset);
    XmListSelectItem(l.list, xms, True);
    XmStringFree(xms);
    return 0;
}

/*
 * if the set selection type is multiple, then get a
 * list of sets, returns the number of selected sets.
 */
int GetSelectedSets(SetChoiceItem l, int **sets)
{
    int i;
    int cnt = SET_SELECT_ERROR, retval = SET_SELECT_ERROR;
    int *ptr;
    int *pos_list;
    int pos_cnt, gno;
    if (XmListGetSelectedPos(l.list, &pos_list, &pos_cnt)) {
	char buf[256];
	char *cstr;
	XmString *s, cs;

	XtVaGetValues(l.list,
		      XmNselectedItemCount, &cnt,
		      XmNselectedItems, &s,
		      NULL);
	*sets = (int *) malloc(cnt * sizeof(int));
	ptr = *sets;
	for (i = 0; i < cnt; i++) {
	    cs = XmStringCopy(s[i]);
	    if (XmStringGetLtoR(cs, charset, &cstr)) {
		strcpy(buf, cstr);
		if (strcmp(buf, "New set") == 0) {
		    retval = SET_SELECT_NEXT;
		    return retval;
		} else if (strcmp(buf, "All sets") == 0) {
		    int j, nsets = 0;
		    retval = SET_SELECT_ALL;
		    if (l.gno == GRAPH_SELECT_CURRENT) {
			gno = cg;
		    } else {
			gno = l.gno;
		    }
		    retval = nactive(gno);
		    *sets = (int *) realloc(*sets, retval * sizeof(int));
		    ptr = *sets;
		    for (j = 0; j < g[gno].maxplot; j++) {
			if (isactive_set(gno, j)) {
			    ptr[nsets] = j;
			    nsets++;
			}
		    }
		    if (nsets != retval) {
			errwin("Nsets != reval, can't happen!");
		    }
		    return retval;
		} else {
		    sscanf(buf, "S%d", &retval);
		}
		ptr[i] = retval;
/*
		printf("S%d %d\n", retval, ptr[i]);
*/
		XtFree(cstr);
	    }
	    XmStringFree(cs);
	}
    }
/*
    printf("Selected sets:");
    for (i = 0; i < cnt; i++) {
	printf(" %d", ptr[i]);
    }
    printf("\n");
*/
    return cnt;
}

void SetSelectorFilterCB(Widget w, XtPointer clientd, XtPointer calld)
{
    SetChoiceItem *s = (SetChoiceItem *) clientd;
    if (XmToggleButtonGetState(w)) {
	int i;
	for (i = 0; i < 4; i++) {
	    if (w == s->but[i]) {
		break;
	    }
	}
	/* update the list in s->list */
	s->fflag = i + 1;
	plist[s->indx].fflag = i + 1;
	update_set_list(cg, *s);
    }
}

void DefineSetSelectorFilter(SetChoiceItem * s)
{
    XtAddCallback(s->but[0], XmNvalueChangedCallback, (XtCallbackProc) SetSelectorFilterCB, (XtPointer) s);
    XtAddCallback(s->but[1], XmNvalueChangedCallback, (XtCallbackProc) SetSelectorFilterCB, (XtPointer) s);
    XtAddCallback(s->but[2], XmNvalueChangedCallback, (XtCallbackProc) SetSelectorFilterCB, (XtPointer) s);
    XtAddCallback(s->but[3], XmNvalueChangedCallback, (XtCallbackProc) SetSelectorFilterCB, (XtPointer) s);
}

SetChoiceItem CreateSetSelector(Widget parent,
				char *label,
				int type,
				int ff,
				int gtype,
				int stype)
{
    Arg args[3];
    Widget rc, rc2, lab;
    SetChoiceItem sel;
    
    rc2 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, parent,
			      XmNorientation, XmVERTICAL, NULL);
    lab = XmCreateLabel(rc2, label, NULL, 0);
    XtManageChild(lab);
    XtSetArg(args[0], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
    XtSetArg(args[1], XmNvisibleItemCount, 8);
    sel.list = XmCreateScrolledList(rc2, "list", args, 2);
    if (stype == SELECTION_TYPE_MULTIPLE) {	/* multiple select */
	XtVaSetValues(sel.list,
		      XmNselectionPolicy, XmEXTENDED_SELECT,
		      NULL);
    } else {			/* single select */
    	XtVaSetValues(sel.list,
		      XmNselectionPolicy, XmSINGLE_SELECT,
		      NULL);
    }
    sel.type = type;
    sel.fflag = ff;
    sel.gno = gtype;
    XtManageChild(sel.list);
    sel.indx = save_set_list(sel);
    update_set_list(gtype==GRAPH_SELECT_CURRENT?cg:sel.gno, sel);
    
    if (ff) {			/* need a filter gadget */
	rc = XmCreateRowColumn(rc2, "rc", NULL, 0);
	XtVaSetValues(rc,
		      XmNorientation, XmHORIZONTAL,
		      NULL);
	lab = XmCreateLabel(rc, "Display:", NULL, 0);
	XtManageChild(lab);
	sel.rb = XmCreateRadioBox(rc, "rb", NULL, 0);
	XtVaSetValues(sel.rb,
		      XmNorientation, XmHORIZONTAL,
		      XmNpacking, XmPACK_TIGHT,
		      NULL);
	sel.but[0] = XtVaCreateManagedWidget("Active", xmToggleButtonWidgetClass, sel.rb,
					XmNalignment, XmALIGNMENT_CENTER,
			    XmNindicatorOn, False, XmNshadowThickness, 2,
					     NULL);
	sel.but[1] = XtVaCreateManagedWidget("All", xmToggleButtonWidgetClass, sel.rb,
					XmNalignment, XmALIGNMENT_CENTER,
			    XmNindicatorOn, False, XmNshadowThickness, 2,
					     NULL);
	sel.but[2] = XtVaCreateManagedWidget("Inactive", xmToggleButtonWidgetClass, sel.rb,
					XmNalignment, XmALIGNMENT_CENTER,
			    XmNindicatorOn, False, XmNshadowThickness, 2,
					     NULL);
	sel.but[3] = XtVaCreateManagedWidget("Deact", xmToggleButtonWidgetClass, sel.rb,
					XmNalignment, XmALIGNMENT_CENTER,
			    XmNindicatorOn, False, XmNshadowThickness, 2,
					     NULL);
	XmToggleButtonSetState(sel.but[ff - 1], True, False);
	XtManageChild(sel.rb);
	XtManageChild(rc);
    }
    XtManageChild(rc2);
    return sel;
}

int save_set_list(SetChoiceItem l)
{
    nplist++;
    if (plist == NULL) {
	plist = (SetChoiceItem *) malloc(nplist * sizeof(SetChoiceItem));
    } else {
	plist = (SetChoiceItem *) realloc(plist, nplist * sizeof(SetChoiceItem));
    }
    plist[nplist - 1] = l;
    return nplist - 1;
}

void update_save_set_list( SetChoiceItem l, int newgr )
{
	plist[l.indx] = l;
	update_set_list( newgr, plist[l.indx] );
}

void update_set_list(int gno, SetChoiceItem l)
{
    int i, cnt, scnt=0;
    char buf[1024];
    XmString *xms;
    
    XmListDeleteAllItems(l.list);
    for (i = 0; i < g[gno].maxplot; i++) {
	switch (l.fflag) {
	case FILTER_SELECT_NONE:	/* Active sets */
	    if (isactive_set(gno, i)) {
		scnt++;
	    }
	    break;
	case FILTER_SELECT_ALL:/* All sets */
	    scnt++;
	    break;
	case FILTER_SELECT_ACTIVE:	/* Active sets */
	    if (isactive_set(gno, i)) {
		scnt++;
	    }
	    break;
	case FILTER_SELECT_INACT:	/* Inactive sets */
	    if (!isactive_set(gno, i)) {
		scnt++;
	    }
	    break;
	case FILTER_SELECT_DEACT:	/* Deactivated sets */
	    if (!isactive_set(gno, i) && g[gno].p[i].deact) {
		scnt++;
	    }
	    break;
	}
    }
    switch (l.type) {		/* TODO */
    case SET_SELECT_ACTIVE:
	xms = (XmString *) malloc(sizeof(XmString) * scnt);
	cnt = 0;
	break;
    case SET_SELECT_ALL:
	xms = (XmString *) malloc(sizeof(XmString) * (scnt + 1));
	xms[0] = XmStringCreateLtoR("All sets", charset);
	cnt = 1;
	break;
    case SET_SELECT_NEXT:
	xms = (XmString *) malloc(sizeof(XmString) * (scnt + 1));
	xms[0] = XmStringCreateLtoR("New set", charset);
	cnt = 1;
	break;
    case SET_SELECT_NEAREST:
	xms = (XmString *) malloc(sizeof(XmString) * (scnt + 1));
	xms[0] = XmStringCreateLtoR("Nearest set", charset);
	cnt = 1;
	break;
    default:
	xms = (XmString *) malloc(sizeof(XmString) * scnt);
	cnt = 0;
	break;
    }

    for (i = 0; i < g[gno].maxplot ; i++) {
	switch (l.fflag) {
	case FILTER_SELECT_NONE:	/* Active sets */
	    if (isactive_set(gno, i)) {
		sprintf(buf, "S%d (N=%d, %s)", i, getsetlength(gno, i), getcomment(gno, i));
		xms[cnt] = XmStringCreateLtoR(buf, charset);
		cnt++;
	    }
	    break;
	case FILTER_SELECT_ALL:/* All sets */
	    if (isactive_set(gno, i)) {
		sprintf(buf, "S%d (N=%d, %s)", i, getsetlength(gno, i), getcomment(gno, i));
	    } else if (g[gno].p[i].deact) {
		sprintf(buf, "S%d (DEACTIVATED)", i);
	    } else {
		sprintf(buf, "S%d (INACTIVE)", i);
	    }
	    xms[cnt] = XmStringCreateLtoR(buf, charset);
	    cnt++;
	    break;
	case FILTER_SELECT_ACTIVE:	/* Active sets */
	    if (isactive_set(gno, i)) {
		sprintf(buf, "S%d (N=%d, %s)", i, getsetlength(gno, i), getcomment(gno, i));
		xms[cnt] = XmStringCreateLtoR(buf, charset);
		cnt++;
	    }
	    break;
	case FILTER_SELECT_INACT:	/* Inactive sets */
	    if (!isactive_set(gno, i)) {
		sprintf(buf, "S%d (INACTIVE)", i);
		xms[cnt] = XmStringCreateLtoR(buf, charset);
		cnt++;
	    }
	    break;
	case FILTER_SELECT_DEACT:	/* Deactivated sets */
	    if (!isactive_set(gno, i) && g[gno].p[i].deact) {
		sprintf(buf, "S%d (DEACTIVATED, N=%d, %s)",
			i, getsetlength(gno, i), getcomment(gno, i));
		xms[cnt] = XmStringCreateLtoR(buf, charset);
		cnt++;
	    }
	    break;
	}
    }
#if XmVersion > 1001    
    XmListAddItemsUnselected(l.list, xms, cnt, 0);
#endif

	/* automatically highlight if only 1 selection */
	if( scnt == 1 ){
		XmListSelectItem( l.list, xms[cnt-1], True );
	}
	
	
    for (i = 0; i < cnt; i++) {
#if XmVersion < 1002   /* For Motif 1.1 */
        XmListAddItemUnselected(l.list, xms[i], 0);
#endif    
        XmStringFree(xms[i]);
    }
    free(xms);
}

void update_set_lists(int gno)
{
    int i;
/*
printf("dirty = %d pending = %d\n", lists_dirty(),work_pending());
*/
    if (inwin && lists_dirty() && !work_pending()) {
	for (i = 0; i < nplist; i++) {
		if( plist[i].gno == gno || 
				(gno==cg && plist[i].gno==GRAPH_SELECT_CURRENT) )
	    	update_set_list(gno, plist[i]);
	}
	set_lists_dirty(FALSE);
    }
}

void AddSetToLists(int gno, int setno)
{
    if (nplist) {
	int i;
	XmString xms = NULL;
	char buf[256];
	if (isactive_set(gno, setno)) {
	    sprintf(buf, "S%d (N=%d, %s)", setno, getsetlength(gno, setno), getcomment(gno, setno));
	    xms = XmStringCreateLtoR(buf, charset);
	}
	for (i = 0; i < nplist; i++) {
	    XmListAddItemUnselected(plist[i].list, xms, 0);
	}
	XmStringFree(xms);
    }
}

void UpdateSetInLists(int gno, int setno)
{
    if (nplist) {
	int i;
	XmString xms = NULL;
	char buf[256];
	if (isactive_set(gno, setno)) {
	    sprintf(buf, "S%d (N=%d, %s)", setno, getsetlength(gno, setno), getcomment(gno, setno));
	    xms = XmStringCreateLtoR(buf, charset);
	}
	for (i = 0; i < nplist; i++) {
	    XmListAddItemUnselected(plist[i].list, xms, 0);
	}
	XmStringFree(xms);
    }
}

Widget CreateMenuBar(Widget parent, char *name, char *help_anchor)
{
    Widget menubar;
    
    menubar = XmCreateMenuBar(parent, name, NULL, 0);
    
    if (help_anchor) {
     	XtAddCallback(menubar, XmNhelpCallback, (XtCallbackProc) HelpCB,
    			(XtPointer) help_anchor);
    }

    return menubar;
}

Widget CreateMenu(Widget parent, char *name, char *label, char mnemonic,
	Widget *cascade, char *help_anchor)
{
    Widget menu, cascadeTmp;
    XmString str;
    
    str = XmStringCreateSimple(label);
    menu = XmCreatePulldownMenu(parent, name, NULL, 0);
    cascadeTmp = XtVaCreateWidget((String) name, xmCascadeButtonWidgetClass, parent, 
    	XmNlabelString, str, 
    	XmNmnemonic, mnemonic,
    	XmNsubMenuId, menu, 
    	0);
    XmStringFree(str);
    if (help_anchor) {
     	XtAddCallback(menu, XmNhelpCallback, (XtCallbackProc) HelpCB,
    			(XtPointer) help_anchor);
    }
    XtManageChild(cascadeTmp);
    if (cascade != NULL) {
    	*cascade = cascadeTmp;
    }

    return menu;
}


Widget CreateMenuButton(Widget parent, char *name, char *label, char mnemonic,
	XtCallbackProc cb, XtPointer data, char *help_anchor)
{
    Widget button;
    XmString str;
    
    str = XmStringCreateSimple(label);
    button = XtVaCreateManagedWidget((String) name, xmPushButtonWidgetClass, parent, 
    	XmNlabelString, str,
    	XmNmnemonic, mnemonic,
    	NULL);
    XmStringFree(str);
    XtAddCallback(button, XmNactivateCallback, cb, data);
    if (help_anchor) {
     	XtAddCallback(button, XmNhelpCallback, (XtCallbackProc) HelpCB,
    			(XtPointer) help_anchor);
    }

    return button;
}

Widget CreateMenuToggle(Widget parent, char *name, char *label, char mnemonic,
	XtCallbackProc cb, XtPointer data, char *help_anchor)
{
    Widget button;
    XmString str;
    
    str = XmStringCreateSimple(label);
    button = XtVaCreateManagedWidget((String) name, xmToggleButtonWidgetClass, parent, 
    	XmNlabelString, str,
    	XmNmnemonic, mnemonic,
    	XmNvisibleWhenOff, True,
    	XmNindicatorOn, True,
    	NULL);
    XmStringFree(str);
    if (cb) {
        XtAddCallback(button, XmNvalueChangedCallback, cb, data);
    }
    if (help_anchor) {
     	XtAddCallback(button, XmNhelpCallback, (XtCallbackProc) HelpCB,
    			(XtPointer) help_anchor);
    }

    return button;
}

Widget CreateMenuSeparator(Widget parent, char *name)
{
    Widget sep;
    
    sep = XmCreateSeparator(parent, name, NULL, 0);
    XtManageChild(sep);
    return sep;
}


static int yesno_retval = 0;
static Boolean keep_grab = True;

void infowin(char *s);

void yesnoCB(Widget w, Boolean * keep_grab, XmAnyCallbackStruct * reason)
{
    int why = reason->reason;

    *keep_grab = False;
    XtRemoveGrab(XtParent(w));
    XtUnmanageChild(w);
    switch (why) {
    case XmCR_OK:
	yesno_retval = 1;
	/* process ok action */
	break;
    case XmCR_CANCEL:
	yesno_retval = 0;
	/* process cancel action */
	break;
    }
}

int yesnowin(char *msg, char *s1, char *s2, char *help_anchor)
{
    Widget yesno_popup = NULL;
    XmString str;
    XEvent event;

    keep_grab = True;

    if (yesno_popup == NULL) {
	yesno_popup = XmCreateErrorDialog(app_shell, "warndlg", NULL, 0);
	if (msg != NULL) {
	    str = XmStringCreateLtoR(msg, charset);
	} else {
	    str = XmStringCreateLtoR("Warning", charset);
	}
	XtVaSetValues(yesno_popup, XmNmessageString, str, NULL);
	XmStringFree(str);
	
	if (s1 != NULL) {
	    str = XmStringCreateLtoR(s1, charset);
	} else {
	    str = XmStringCreateLtoR("OK", charset);
	}
	XtVaSetValues(yesno_popup, str, XmNokLabelString, NULL);
	XmStringFree(str);
	
	if (s2 != NULL) {
	    str = XmStringCreateLtoR(s2, charset);
	} else {
	    str = XmStringCreateLtoR("Cancel", charset);
	}
	XtVaSetValues(yesno_popup, str, XmNcancelLabelString, NULL);
	XmStringFree(str);
	
	XtAddCallback(yesno_popup, XmNokCallback, (XtCallbackProc) yesnoCB,
	(XtPointer) & keep_grab);
	XtAddCallback(yesno_popup, XmNcancelCallback, (XtCallbackProc) yesnoCB,
	(XtPointer) & keep_grab);

	if (help_anchor) {
	    XtAddCallback(yesno_popup, XmNhelpCallback, (XtCallbackProc) HelpCB,
	    (XtPointer) help_anchor);
	    XtSetSensitive(XtNameToWidget(yesno_popup, "Help"), True);
	} else {    
	    XtSetSensitive(XtNameToWidget(yesno_popup, "Help"), False);
	}
	XtManageChild(yesno_popup);
    }
    XtRaise(yesno_popup);
    XtAddGrab(XtParent(yesno_popup), True, False);
    while (keep_grab || XtAppPending(app_con)) {
	XtAppNextEvent(app_con, &event);
	XtDispatchEvent(&event);
    }
    return yesno_retval;
}

/*
 * close error window and set message to null
 */
void cancelerrwin( Widget w, XtPointer client_data, XtPointer call_data)
{
	XmString empty;
	
	empty = XmStringCreateLtoR( "", charset);
	XtVaSetValues( (Widget)client_data, XmNmessageString, empty, NULL );
	XmStringFree( empty );
	XtUnmanageChild( (Widget)client_data );
}	

/*
 * open error window
 * all errors are sent to the same window
 */
void errwin(char *s)
{
    XmString str, str1, nl;
    static Widget error_popup = NULL;

    keep_grab = True;
    
    log_results(s);
    
    if (error_popup == NULL) {
        error_popup = XmCreateErrorDialog(app_shell, "errorDialog", NULL, 0);
		str = XmStringCreateLtoR(s, charset);
		XtVaSetValues(error_popup, XmNmessageString, str, NULL);
		XmStringFree(str);
		XtVaSetValues(error_popup,
		  XmNdialogTitle, XmStringCreateLtoR("Error (you may hit return to cancel)", charset),
		  XmNdialogStyle, XmDIALOG_APPLICATION_MODAL,
		  NULL);
		XtAddCallback(error_popup, XmNokCallback, 
				(XtCallbackProc) cancelerrwin, (XtPointer) error_popup);
		XtAddCallback(error_popup, XmNhelpCallback, (XtCallbackProc) HelpCB,
		  (XtPointer) NULL);
		XtUnmanageChild(XmMessageBoxGetChild(error_popup,
		XmDIALOG_CANCEL_BUTTON));
		XtUnmanageChild(XmMessageBoxGetChild(error_popup,
		XmDIALOG_HELP_BUTTON));
		XtManageChild(error_popup);
    } else {									/* add new error onto end */
		nl = XmStringCreateLtoR( "\n", charset);
		XtVaGetValues( error_popup, XmNmessageString, &str, NULL );
		str1 = 	XmStringConcat( str, nl );
		XmStringFree( str );
		str = XmStringCreateLtoR(s, charset);
		XtVaSetValues(error_popup,XmNmessageString,
					XmStringConcat( str1, str), NULL);
		XmStringFree( str );
		XmStringFree( str1 );
		XmStringFree( nl );
	}
    XtRaise(error_popup);
}

Widget CreateAACButtons(Widget parent, Widget form, XtCallbackProc aac_cb)
{
    Widget w;
    Widget aacbut[3];
    static char *aaclab[3] = {"Apply", "Accept", "Close"};
    
    w = CreateCommandButtons(parent, 3, aacbut, aaclab);
    XtAddCallback(aacbut[0], XmNactivateCallback, aac_cb, (XtPointer) AAC_APPLY);
    XtAddCallback(aacbut[1], XmNactivateCallback, aac_cb, (XtPointer) AAC_ACCEPT);
    XtAddCallback(aacbut[2], XmNactivateCallback, aac_cb, (XtPointer) AAC_CLOSE);
    
    if (form != NULL) {
        XtVaSetValues(form, XmNcancelButton, aacbut[2], NULL);
    }
    
    return w;
}

void update_all(int gno)
{
    set_lists_dirty(TRUE);
    update_set_lists(gno);
    update_view(gno);
    update_status(gno, cur_statusitem, -1);
    update_ticks(gno);
    update_autos(gno);
    updatesymbols(gno, -1);
    update_graphapp_items(gno);
/*
 *     updatelegends(gno);
 */
/*
 *     update_label_proc();
 */
    update_locator_items(gno);
    update_draw();
    update_frame_items(gno);
    update_graph_items();
    update_hotlinks();
    update_prune_frame();
    update_describe_popup ();
}

static int dp = 0;

void set_lists_dirty(int d)
{
    dp = d;
}

int lists_dirty(void)
{
    return dp;
}

