/* 
 *
 * symbols and error bars
 *
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/RowColumn.h>

#include "globals.h"

#include "motifinc.h"

#include "protos.h"

int cset = 0;                   /* the current set from the symbols panel */

static Widget setapp_dialog = NULL;

static Widget *toggle_symbols_item;
static Widget symsize_item;
static Widget symskip_item;
static Widget *symcolor_item;
static Widget *sympattern_item;
static Widget *symfillcolor_item;
static Widget *symfillpattern_item;
static Widget *symlinew_item;
static Widget *symlines_item;
static Widget symchar_item;
static Widget *char_font_item;

static Widget *toggle_color_item;
static Widget *toggle_pattern_item;
static Widget *toggle_width_item;
static Widget dropline_item;
static Widget *toggle_lines_item;
static Widget *toggle_linet_item;
static Widget *toggle_fill_item;
static Widget *toggle_fillpat_item;
static Widget *toggle_fillcol_item;
static SetChoiceItem toggle_symset_item;
static Widget baseline_item;
static Widget *baselinetype_item;

static Widget legend_str_panel;

static Widget errbar_active_item;
static Widget errbar_size_item;
static Widget *errbar_width_item;
static Widget *errbar_lines_item;
static Widget *errbar_type_item;
static Widget *errbar_riserlinew_item;
static Widget *errbar_riserlines_item;

static Widget avalue_active_item;
static Widget *avalue_type_item;
static Widget *avalue_font_item;
static Widget *avalue_color_item;
static Widget avalue_charsize_item ;
static Widget avalue_angle_item;
static Widget *avalue_format_item;
static Widget *avalue_precision_item;
static Widget avalue_offsetx;
static Widget avalue_offsety;
static Widget avalue_prestr;
static Widget avalue_appstr;

static void setapp_aac_cb(Widget w, XtPointer client_data, XtPointer call_data);
static void setall_colors_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void setall_sym_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void setall_linew_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void set_cset_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void setall_linesty_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void set_bw_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void strip_leg_proc( Widget w, XtPointer client_data, XtPointer call_data);

static void UpdateSymbols(int gno, int value);

/*
 * create the symbols popup
 */
void define_symbols_popup(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget setapp_panel, setapp_tab, setapp_main, setapp_symbols, 
           setapp_line, setapp_errbar, setapp_avalue, rc_head, fr, rc, rc1, rc2;
    Widget menubar, menupane, cascade;

    set_wait_cursor();
    if (setapp_dialog == NULL) {
        setapp_dialog = XmCreateDialogShell(app_shell, "SetAppearance", NULL, 0);
        handle_close(setapp_dialog);
        setapp_panel = XtVaCreateWidget("setapp_panel", xmFormWidgetClass, 
                                          setapp_dialog, NULL, 0);

        menubar = CreateMenuBar(setapp_panel, "setappMenuBar", NULL);
        
        menupane = CreateMenu(menubar, "setappFileMenu", "File", 'F', NULL, NULL);
        CreateMenuButton(menupane, "close", "Close", 'C',
            (XtCallbackProc) setapp_aac_cb, (XtPointer) AAC_CLOSE, NULL);

        menupane = CreateMenu(menubar, "setappDataMenu", "Data", 'D', NULL, NULL);

        CreateMenuButton(menupane, "allColors", "All colors", 'c',
            (XtCallbackProc) setall_colors_proc, (XtPointer) NULL, 0);
        CreateMenuButton(menupane, "allSymbols", "All symbols", 's',
            (XtCallbackProc) setall_sym_proc, (XtPointer) NULL, 0);
        CreateMenuButton(menupane, "allLineWidths", "All line widths", 'w',
            (XtCallbackProc) setall_linew_proc, (XtPointer) NULL, 0);
        CreateMenuButton(menupane, "allLineStyles", "All line styles", 'y',
            (XtCallbackProc) setall_linesty_proc, (XtPointer) NULL, 0);
        CreateMenuButton(menupane, "setBW", "Black & white", 'B',
            (XtCallbackProc) set_bw_proc, (XtPointer) NULL, 0);
        CreateMenuSeparator(menupane, "sep");
        CreateMenuButton(menupane, "loadComments", "Load comments", 'm',
            (XtCallbackProc) legend_load_proc, (XtPointer) NULL, 0);
        CreateMenuButton(menupane, "stripLabels", "Strip labels", 'l',
            (XtCallbackProc) strip_leg_proc, (XtPointer) NULL, 0);
        
        
        menupane = CreateMenu(menubar, "setappOptionsMenu", "Options", 'O', NULL, NULL);
      
        /* nonl_autol_item =  */CreateMenuToggle(menupane, "masterSwitch", "Master switch (N/I)", 'M',
            (XtCallbackProc) NULL, (XtPointer) NULL, NULL);

        menupane = CreateMenu(menubar, "nonlHelpMenu", "Help", 'H', &cascade, NULL);
        XtVaSetValues(menubar, XmNmenuHelpWidget, cascade, NULL);

        CreateMenuButton(menupane, "onSetAppearance", "On set appearance", 's',
            (XtCallbackProc) HelpCB, (XtPointer) NULL, 0);

        CreateMenuButton(menupane, "onContext", "On context", 'x',
            (XtCallbackProc) ContextHelpCB, (XtPointer) NULL, 0);
        
        XtManageChild(menubar);
        XtVaSetValues(menubar,
                      XmNtopAttachment, XmATTACH_FORM,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      NULL);



        rc_head = XmCreateRowColumn(setapp_panel, "rc_head", NULL, 0);

        toggle_symset_item = CreateSetSelector(rc_head, "Select set:",
                                             SET_SELECT_ACTIVE,
                                             FILTER_SELECT_NONE,
                                             GRAPH_SELECT_CURRENT,
                                             SELECTION_TYPE_MULTIPLE);

        XtAddCallback(toggle_symset_item.list, XmNextendedSelectionCallback,
                      (XtCallbackProc) set_cset_proc, (XtPointer) 0);

        XtManageChild(rc_head);
        XtVaSetValues(rc_head,
                      XmNtopAttachment, XmATTACH_WIDGET,
                      XmNtopWidget, menubar,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      NULL);


        /* ------------ Tabs --------------*/

        setapp_tab = CreateTab(setapp_panel);        


        /* ------------ Main tab --------------*/
        
        setapp_main = CreateTabPage(setapp_tab, "Main");

        rc2 = XmCreateRowColumn(setapp_main, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);

        fr = CreateFrame(rc2, "Symbol properties");
        rc = XtVaCreateWidget("symbolsbb", xmRowColumnWidgetClass, fr, NULL);
        toggle_symbols_item = CreatePanelChoice(rc,
                                                 "Type:",
                                                 13,
                                                 "None",            /* 0 */
                                                 "Circle",          /* 1 */
                                                 "Square",          /* 2 */
                                                 "Diamond",         /* 3 */
                                                 "Triangle up",     /* 4 */
                                                 "Triangle left",   /* 5 */
                                                 "Triangle down",   /* 6 */
                                                 "Triangle right",  /* 7 */
                                                 "Plus",            /* 8 */
                                                 "X",               /* 9 */
                                                 "Star",            /* 10 */
                                                 "Char",            /* 11 */
                                                 NULL,
                                                 0);

        symsize_item = CreateCharSizeChoice(rc, "Size");
        symcolor_item = CreateColorChoice(rc, "Color:");
        symchar_item = CreateTextItem2(rc, 3, "Symbol char:");
        XtManageChild(rc);

        fr = CreateFrame(rc2, "Line properties");
        rc = XtVaCreateWidget("linesrc", xmRowColumnWidgetClass, fr, NULL);
        toggle_linet_item = CreatePanelChoice(rc, "Type:",
                                              7,
                                              "None",
                                              "Straight",
                                              "Left stairs",
                                              "Right stairs",
                                              "Segments",
                                              "3-Segments",
                                              NULL,
                                              0);
        toggle_lines_item = CreateLineStyleChoice(rc, "Style:");
        toggle_width_item = CreateLineWidthChoice(rc, "Width:");
        toggle_color_item = CreateColorChoice(rc, "Color:");
        XtManageChild(rc);
        
        XtManageChild(rc2);

        fr = CreateFrame(setapp_main, "Legend");
        rc = XmCreateRowColumn(fr, "rc", NULL, 0);
        legend_str_panel = CreateTextItem2(rc, 33, "String:");
        XtManageChild(rc);

        fr = CreateFrame(setapp_main, "Display options");
        rc2 = XmCreateRowColumn(fr, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
        avalue_active_item = CreateToggleButton(rc2, "Annotate values");
        errbar_active_item = CreateToggleButton(rc2, "Display error bars");
        XtManageChild(rc2);


        /* ------------ Symbols tab --------------*/
        
        setapp_symbols = CreateTabPage(setapp_tab, "Symbols");

        fr = CreateFrame(setapp_symbols, "Symbol outline");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);

        rc2 = XmCreateRowColumn(rc, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
        symlines_item = CreateLineStyleChoice(rc2, "Style:");
        symlinew_item = CreateLineWidthChoice(rc2, "Width:");
        XtManageChild(rc2);
        sympattern_item = CreatePatternChoice(rc, "Pattern:");
        XtManageChild(rc);

        fr = CreateFrame(setapp_symbols, "Symbol fill");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
        symfillcolor_item = CreateColorChoice(rc, "Color:");
        symfillpattern_item = CreatePatternChoice(rc, "Pattern:");
        XtManageChild(rc);

        fr = CreateFrame(setapp_symbols, "Extra");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        symskip_item = CreateTextItem2(rc, 4, "Sym skip:");
        char_font_item = CreateFontChoice(rc, "Font:");
        XtManageChild(rc);


        /* ------------ Line tab --------------*/
        
        setapp_line = CreateTabPage(setapp_tab, "Line");

        fr = CreateFrame(setapp_line, "Line properties");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
        toggle_pattern_item = CreatePatternChoice(rc, "Pattern:");
        dropline_item = CreateToggleButton(rc, "Draw drop lines");
        XtManageChild(rc);

        fr = CreateFrame(setapp_line, "Fill properties");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        toggle_fill_item = CreatePanelChoice(rc, "Type:",
                                             4,
                                             "None",
                                             "As polygon",
                                             "To baseline",
                                             NULL,
                                             0);
        rc2 = XmCreateRowColumn(rc, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
        toggle_fillpat_item = CreatePatternChoice(rc2, "Pattern:");
        toggle_fillcol_item = CreateColorChoice(rc2, "Color:");
        XtManageChild(rc2);
        XtManageChild(rc);
        
        fr = CreateFrame(setapp_line, "Base line");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        XtVaSetValues(rc, XmNorientation, XmHORIZONTAL, NULL);
        baselinetype_item = CreatePanelChoice(rc, "Type:",
                                             6,
                                             "Zero",
                                             "Set min",
                                             "Set max",
                                             "Graph min",
                                             "Graph max",
                                             NULL,
                                             0);
        baseline_item = CreateToggleButton(rc, "Draw line");
        XtManageChild(rc);
        
        
        /* ------------ AValue tab --------------*/
        
        setapp_avalue = CreateTabPage(setapp_tab, "Ann. values");

	fr = CreateFrame(setapp_avalue, "Text properties");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        
        rc2 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
	avalue_font_item = CreateFontChoice(rc2, "Font:");
	avalue_charsize_item = CreateCharSizeChoice(rc2, "Char size");
	XtVaSetValues(avalue_charsize_item, XmNscaleWidth, 120, NULL);
	XtManageChild(rc2);
        
        rc2 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
	avalue_color_item = CreateColorChoice(rc2, "Color:");
	avalue_angle_item = CreateAngleChoice(rc2, "Angle");
	XtVaSetValues(avalue_angle_item, XmNscaleWidth, 180, NULL);
	XtManageChild(rc2);

        rc2 = XmCreateRowColumn(rc, "rc", NULL, 0);
	XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
        avalue_prestr = CreateTextItem2(rc2, 10, "Prepend:");
        avalue_appstr = CreateTextItem2(rc2, 10, "Append:");
	XtManageChild(rc2);
        
        XtManageChild(rc);
        
	fr = CreateFrame(setapp_avalue, "Format options");
	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        rc2 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc, NULL);
	XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
	avalue_format_item = CreateFormatChoice(rc, "Format:");
        avalue_type_item = CreatePanelChoice(rc2, "Type:",
                                             5,
                                             "None",
                                             "X",
                                             "Y",
                                             "X, Y",
                                             NULL,
                                             0);
	avalue_precision_item = CreatePrecisionChoice(rc2, "Precision:");
	XtManageChild(rc2);
        
        XtManageChild(rc);


	fr = CreateFrame(setapp_avalue, "Placement");
        rc2 = XmCreateRowColumn(fr, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);
        avalue_offsetx = CreateTextItem2(rc2, 10, "X offset:");
        avalue_offsety = CreateTextItem2(rc2, 10, "Y offset:");
        XtManageChild(rc2);
        

        /* ------------ Errbar tab --------------*/
        
        setapp_errbar = CreateTabPage(setapp_tab, "Error bars");

        rc2 = XmCreateRowColumn(setapp_errbar, "rc", NULL, 0);
        XtVaSetValues(rc2, XmNorientation, XmHORIZONTAL, NULL);

        fr = CreateFrame(rc2, "Bar line");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        errbar_size_item = CreateCharSizeChoice(rc, "Size");
        errbar_width_item = CreateLineWidthChoice(rc, "Width:");
        errbar_lines_item = CreateLineStyleChoice(rc, "Style:");
        XtManageChild(rc);

        rc1 = XtVaCreateWidget("rc", xmRowColumnWidgetClass, rc2, NULL);
        fr = CreateFrame(rc1, "Placement");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        errbar_type_item = CreatePanelChoice(rc,
                                             "Type:",
                                             4,
                                             "Both",
                                             "Top/left",
                                             "Bottom/right",
                                             NULL,
                                             0);
        XtManageChild(rc);
        
        fr = CreateFrame(rc1, "Riser line");
        rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, fr, NULL);
        errbar_riserlinew_item = CreateLineWidthChoice(rc, "Width:");
        errbar_riserlines_item = CreateLineStyleChoice(rc, "Style:");
        XtManageChild(rc);
        XtManageChild(rc1);
        
        XtManageChild(rc2);

        SelectTabPage(setapp_tab, setapp_main);


        fr = CreateFrame(setapp_panel, NULL); 
        rc = XmCreateRowColumn(fr, "rc", NULL, 0);

        CreateAACButtons(rc, setapp_panel, setapp_aac_cb);
        
        XtManageChild(rc);
        XtManageChild(fr);
        XtVaSetValues(fr,
                      XmNtopAttachment, XmATTACH_NONE,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      XmNbottomAttachment, XmATTACH_FORM,
                      NULL);
        XtVaSetValues(setapp_tab,
                      XmNtopAttachment, XmATTACH_WIDGET,
                      XmNtopWidget, rc_head,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      XmNbottomAttachment, XmATTACH_WIDGET,
                      XmNbottomWidget, fr,
                      NULL);

        XtManageChild(setapp_panel);
    }
    
    updatesymbols(cg, cset);
    XtRaise(setapp_dialog);
    unset_wait_cursor();
}

/*
 * define symbols for the current set
 */
static void setapp_aac_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
    int aac_mode;
    int sym, symskip, symlinew, symlines;
    int line, linet, color, pattern, wid, dropline, fill, fillpat, fillcol, i;
    int symcolor, sympattern, symfillcolor, symfillpattern;
    double symsize;
    int etype_tmp, errbar_type;
    int baseline, baselinetype;
    Errbar errbar;
    AValue avalue;
    char symchar;
    int charfont;
    
    int *selset, cd;

    aac_mode = (int) client_data;
    
    if (aac_mode == AAC_CLOSE) {
        XtUnmanageChild(setapp_dialog);
        return;
    }

    symsize = GetCharSizeChoice(symsize_item);
    sym = GetChoice(toggle_symbols_item);
    color = GetChoice(toggle_color_item);
    pattern = GetChoice(toggle_pattern_item);
    wid = GetChoice(toggle_width_item);
    baseline = GetToggleButtonState(baseline_item);
    baselinetype = GetChoice(baselinetype_item);
    dropline = GetToggleButtonState(dropline_item);
    line = GetChoice(toggle_lines_item);
    linet = GetChoice(toggle_linet_item);
    fill = GetChoice(toggle_fill_item);
    fillpat = GetChoice(toggle_fillpat_item);
    fillcol = GetChoice(toggle_fillcol_item);
    xv_evalexpri(symskip_item, &symskip);
    symcolor = GetChoice(symcolor_item);
    sympattern = GetChoice(sympattern_item);
    symfillcolor = GetChoice(symfillcolor_item);
    symfillpattern = GetChoice(symfillpattern_item);
    symlinew = GetChoice(symlinew_item);
    symlines = GetChoice(symlines_item);
    symchar = atoi(xv_getstr(symchar_item));
    charfont = GetChoice(char_font_item);
    
    errbar.active = GetToggleButtonState(errbar_active_item);
    errbar.length = GetCharSizeChoice(errbar_size_item);
    errbar.linew = GetChoice(errbar_width_item);
    errbar.lines = GetChoice(errbar_lines_item);
    errbar.riser_linew = GetChoice(errbar_riserlinew_item);
    errbar.riser_lines = GetChoice(errbar_riserlines_item);
        
    avalue.active = GetToggleButtonState(avalue_active_item);
    avalue.type = GetChoice(avalue_type_item);
    avalue.size = GetCharSizeChoice(avalue_charsize_item);
    avalue.font = GetChoice(avalue_font_item);
    avalue.color = GetChoice(avalue_color_item);
    avalue.angle = GetAngleChoice(avalue_angle_item);
    avalue.format = GetChoice(avalue_format_item);
    avalue.prec = GetChoice(avalue_precision_item);
    strcpy(avalue.prestr, xv_getstr(avalue_prestr));
    strcpy(avalue.appstr, xv_getstr(avalue_appstr));
    xv_evalexpr(avalue_offsetx, &avalue.offset.x );
    xv_evalexpr(avalue_offsety, &avalue.offset.y);
                    
    cd = GetSelectedSets(toggle_symset_item, &selset);
    if (cd == SET_SELECT_ERROR) {
        errwin("No set selected");
        return;
    } else {
        for(i = 0; i < cd; i++) {
            cset = selset[i];
            g[cg].p[cset].symskip = symskip;
            g[cg].p[cset].symsize = symsize;
            g[cg].p[cset].symlinew = symlinew;
            g[cg].p[cset].symlines = symlines;
            g[cg].p[cset].symchar = symchar;
            g[cg].p[cset].charfont = charfont;
            g[cg].p[cset].fill = fill;
            g[cg].p[cset].setfillpen.pattern = fillpat;
            g[cg].p[cset].setfillpen.color = fillcol;
            strcpy(g[cg].p[cset].lstr, xv_getstr(legend_str_panel));
            setplotsym(cg, cset, sym);
            setplotlinet(cg, cset, linet);
            setplotlines(cg, cset, line);
            setplotlinew(cg, cset, wid);
            setplotcolor(cg, cset, color);
            setplotpattern(cg, cset, pattern);
            setplotsymcolor(cg, cset, symcolor);
            setplotsympattern(cg, cset, sympattern);
            setplotsymfillcolor(cg, cset, symfillcolor);
            setplotsymfillpattern(cg, cset, symfillpattern);
            g[cg].p[cset].dropline = dropline;
            g[cg].p[cset].baseline = baseline;
            g[cg].p[cset].baseline_type = baselinetype;

            etype_tmp = GetChoice(errbar_type_item);
            switch (dataset_type(cg, cset)) {
            case SET_XYDX:
            case SET_XYDXDX:
                if (etype_tmp == 0) {
                    errbar_type = PLACE_BOTH;;
                } else if (etype_tmp == 1) {
                    errbar_type = PLACE_LEFT;
                } else {
                    errbar_type = PLACE_RIGHT;
                }
                break;
            case SET_XYDY:
            case SET_XYDYDY:
                if (etype_tmp == 0) {
                    errbar_type = PLACE_BOTH;;
                } else if (etype_tmp == 1) {
                    errbar_type = PLACE_TOP;
                } else {
                    errbar_type = PLACE_BOTTOM;
                }
                break;
            default:
                errbar_type = PLACE_BOTH;
                break;
            }
            errbar.type = errbar_type;
    
            g[cg].p[cset].errbar = errbar;
            g[cg].p[cset].avalue = avalue;
        }
    } 

    if (aac_mode == AAC_ACCEPT) {
        XtUnmanageChild(setapp_dialog);
    }

    set_dirtystate();
    drawgraph();
}


/*
 * freshen up symbol items, generally after a parameter
 * file has been read
 */
static void UpdateSymbols(int gno, int value)
{
    int itmp;
    char val[24];

    if ((cset == value) && (value != -1)) {
    
        SetCharSizeChoice(symsize_item, g[gno].p[value].symsize);
        sprintf(val, "%d", g[gno].p[value].symskip);
        xv_setstr(symskip_item, val);
        sprintf(val, "%d", g[gno].p[value].symchar);
        xv_setstr(symchar_item, val);
        SetChoice(toggle_symbols_item, getsetplotsym(gno, value));

        if (symcolorbug || (getsetplotsymcolor(gno, value) == -1)) {
            setplotsymcolor(gno, value, getsetcolor(gno, value));
        }
        if (getsetplotsymfillcolor(gno, value) == -1) {
            setplotsymfillcolor(gno, value, getsetplotsymcolor(gno, value));
        }
        
        SetChoice(symcolor_item, getsetplotsymcolor(gno, value));
        SetChoice(sympattern_item, getsetplotsympattern(gno, value));
        SetChoice(symfillcolor_item, getsetplotsymfillcolor(gno, value));
        SetChoice(symfillpattern_item, getsetplotsymfillpattern(gno, value));
        SetChoice(symlinew_item, g[gno].p[value].symlinew);
        SetChoice(symlines_item, g[gno].p[value].symlines);
        
        SetChoice(char_font_item, g[cg].p[value].charfont);        
        
        SetChoice(toggle_color_item, getsetcolor(gno, value));
        SetChoice(toggle_pattern_item, getsetpattern(gno, value));
        SetChoice(toggle_width_item, getsetlinew(gno, value));
        SetToggleButtonState(dropline_item, g[gno].p[value].dropline);
        SetChoice(toggle_lines_item, getsetlines(gno, value));
        SetChoice(toggle_linet_item, getsetlinet(gno, value));
        SetChoice(toggle_fill_item, g[gno].p[value].fill);
        SetChoice(toggle_fillcol_item, g[gno].p[value].setfillpen.color);
        SetChoice(toggle_fillpat_item, g[gno].p[value].setfillpen.pattern);
        
        SetToggleButtonState(baseline_item, g[gno].p[value].baseline);
        SetChoice(baselinetype_item, g[gno].p[value].baseline_type);

        xv_setstr(legend_str_panel, g[gno].p[value].lstr);
        
        switch (g[gno].p[value].errbar.type) {
        case PLACE_BOTH:
            itmp = 0;
            break;
        case PLACE_TOP:
        case PLACE_LEFT:
            itmp = 1;
            break;
        case PLACE_BOTTOM:
        case PLACE_RIGHT:
            itmp = 2;
            break;
        default:
            itmp = 0;
            break;
        }
        SetToggleButtonState(errbar_active_item, g[cg].p[value].errbar.active);
        SetChoice(errbar_type_item, itmp);
        SetChoice(errbar_width_item, g[gno].p[value].errbar.linew);
        SetChoice(errbar_lines_item, g[gno].p[value].errbar.lines);
        SetChoice(errbar_riserlinew_item, g[gno].p[value].errbar.riser_linew);
        SetChoice(errbar_riserlines_item, g[gno].p[value].errbar.riser_lines);
        SetCharSizeChoice(errbar_size_item, g[gno].p[value].errbar.length);

        SetToggleButtonState(avalue_active_item, g[cg].p[value].avalue.active);
        SetChoice(avalue_type_item, g[cg].p[value].avalue.type);
        SetCharSizeChoice(avalue_charsize_item, g[cg].p[value].avalue.size);
        SetChoice(avalue_font_item, g[cg].p[value].avalue.font);
        SetChoice(avalue_color_item, g[cg].p[value].avalue.color);
        SetAngleChoice(avalue_angle_item, g[cg].p[value].avalue.angle);
        SetChoice(avalue_format_item, g[cg].p[value].avalue.format);
        SetChoice(avalue_precision_item, g[cg].p[value].avalue.prec);
        
        xv_setstr(avalue_prestr, g[cg].p[value].avalue.prestr);
        xv_setstr(avalue_appstr, g[cg].p[value].avalue.appstr);

        sprintf(val, "%f", g[gno].p[value].avalue.offset.x);
        xv_setstr(avalue_offsetx, val);
        sprintf(val, "%f", g[gno].p[value].avalue.offset.y);
        xv_setstr(avalue_offsety, val);
   }
}


static void set_cset_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int cd;
    int *selsets;
        
    cd = GetSelectedSets(toggle_symset_item, &selsets);
    if (cd != SET_SELECT_ERROR) {
        cset = selsets[0];
        UpdateSymbols(cg, cset);
    }
}

void updatesymbols(int gno, int setno)
{
    int cd;
    
    if (setapp_dialog != NULL) { 
        cd = SetSelectedSet(gno, setno, toggle_symset_item);
        if (cd != SET_SELECT_ERROR) {
            cset = setno;
        }
    }
}

/*
 * legends
 */

/*
 * strip leading pathname from comments
 */
static void strip_leg_proc( Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if ( isactive_set(cg, i) ) {
            strcpy( g[cg].p[i].lstr, mybasename(g[cg].p[i].lstr) );
        }
    }
}

/*
 * load legend strings from set comments
 */
void legend_load_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            strcpy(g[cg].p[i].lstr, g[cg].p[i].comments);
        }
    }
    set_dirtystate();
}



/*
 * define colors incrementally
 */
void setall_colors_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i, c;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            c = (i % (number_of_colors() - 1)) + 1;
            setplotcolor(cg, i, c);
            setplotsymcolor(cg, i, c);
            setplotsymfillcolor(cg, i, c);
        }
    }
    UpdateSymbols(cg, cset);
    drawgraph();
}

/*
 * define symbols incrementally mod 10
 */
static void setall_sym_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            setplotsym(cg, i, (i % 10) + 2);
        }
    }
    UpdateSymbols(cg, cset);
    drawgraph();
}

/*
 * define linewidths incrementally mod 7
 */
static void setall_linew_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            setplotlinew(cg, i, (i % 7) + 1);
        }
    }
    UpdateSymbols(cg, cset);
    drawgraph();
}

/*
 * define line styles incrementally mod 5
 */
static void setall_linesty_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            setplotlines(cg, i, (i % 5) + 1);
        }
    }
    UpdateSymbols(cg, cset);
    drawgraph();
}

/*
 * make all lines black
 */
static void set_bw_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < g[cg].maxplot; i++) {
        if (isactive_set(cg, i)) {
            setplotcolor(cg, i, 1);
            setplotsymcolor(cg, i, 1);
            setplotsymfillcolor(cg, i, 1);
        }
    }
    UpdateSymbols(cg, cset);
    drawgraph();
}
