/*
 * t1fonts.h
 * Type1 fonts for Grace
 */

#ifndef __T1_FONTS_H_
#define __T1_FONTS_H_

#include <config.h>
#include <cmath.h>

#if defined (HAVE_LIBT1)
#  include <t1lib.h>
#else
#  include "T1lib/t1lib.h"
#endif

#include "defines.h"

/* TODO */
#define MAGIC_FONT_SCALE	0.028

#define SSCRIPT_SCALE M_SQRT1_2
#define ENLARGE_SCALE sqrt(M_SQRT2)

#define T1_DEFAULT_ENCODING_FILE "Default.enc"
#define T1_DEFAULT_SLANT 0.0
#define T1_AALEVELS 5

typedef struct {
    char *s;
    double scale;
    double vshift;
    int font;
    int underline;
    int overline;
} CompositeString;

typedef struct {
    char alias[32];
    char encoding[32];
} FontDB;

int init_t1(void);
void update_t1(void);

int number_of_fonts(void);
char *get_fontname(int font);
char *get_fontalias(int font);
char *get_fontfilename(int font);
char *get_encodingscheme(int font);

GLYPH *GetGlyphString(int FontID, double Size, double Angle, int modflag,
                                                            char *theString);
GLYPH *CatGlyphs(GLYPH *dest_glyph, GLYPH *src_glyph, int x_off, int y_off);
void FreeCompositeString(CompositeString *cs);
CompositeString *String2Composite(char *string);
void WriteString(VPoint vp, int rot, int just, char *theString);

#endif /* __T1_FONTS_H_ */
