#ifndef __UTILS_H_
#define __UTILS_H_

#define  PAD(bits, pad)  (((bits)+(pad)-1)&-(pad))

#define MIN2(a, b) (((a) < (b)) ? a : b)
#define MAX2(a, b) (((a) > (b)) ? a : b)
#define MIN3(a, b, c) (((a) < (b)) ? MIN2(a, c) : MIN2(b, c))
#define MAX3(a, b, c) (((a) > (b)) ? MAX2(a, c) : MAX2(b, c))

#define LFORMAT_TYPE_PLAIN      0
#define LFORMAT_TYPE_EXTENDED   1

void cxfree(void *ptr);
void fswap(double *x, double *y);
void iswap(int *x, int *y);
int isoneof(int c, char *s);
int argmatch(char *s1, char *s2, int atleast);
void lowtoupper(char *s);
void convertchar(char *s);
int ilog2(int n);
double comp_area(int n, double *x, double *y);
double comp_perimeter(int n, double *x, double *y);

double julday(int mon, int day, int year, int h, int mi, double se);
void calcdate(double jd, int *m, int *d, int *y, int *h, int *mi, double *sec);
int dayofweek(double j);
int leapyear(int year);
void getmoday(int days, int yr, int *mo, int *da);
int getndays(double j);
char *create_fstring(int form, int prec, double loc, int type);
void stripspecial(char *s, char *cs);
char *escapequotes (char *s);

int sign(double a);

void bailout(void);

void installSignal(void);

int bin_dump(char *value, int i, int pad);
unsigned char reversebits(unsigned char inword);

#endif /* __UTILS_H_*/
