#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "grace_np.h"

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

#ifndef EXIT_FAILURE
#  define EXIT_FAILURE -1
#endif

int
main (int argc, char* argv[])
{
    int i;

    /* Start Grace with a buffer size of 2048 and open the pipe */
    if (GraceOpen(2048) == -1) {
        fprintf (stderr, "Can't run Grace. \n");
        exit (EXIT_FAILURE);
    }
    
    /* Send some initialization commands to Grace */
    GracePrintf ("world xmax 100");
    GracePrintf ("world ymax 10000");
    GracePrintf ("xaxis tick major 20");
    GracePrintf ("xaxis tick minor 10");
    GracePrintf ("yaxis tick major 2000");
    GracePrintf ("yaxis tick minor 1000");
    GracePrintf ("sets symbol 2");
    GracePrintf ("sets symbol fill 1");
    GracePrintf ("sets symbol size 0.3");

    /* Display sample data */
    for (i = 1; i <= 100; i++) {
        GracePrintf ("g0.s0 point %d, %d", i, i);
        GracePrintf ("g0.s1 point %d, %d", i, i * i);
        /* Update the Grace display after every ten steps */
        if (i % 10 == 0) {
            GracePrintf ("redraw");
            /* Wait a second, just to simulate some time needed for
               calculations. Your real application shouldn't wait. */
            sleep (1);
        }
    }

    /* Tell Grace to save the data */
    GracePrintf ("saveall \"sample.gr\"");

    /* Flush the output buffer and close the pipe */
    GraceClose ();

    /* We are done */
    exit (EXIT_SUCCESS);
}

