#include <config.h>

#include <stdlib.h>
#include <string.h>

#include "defines.h"
#include "globals.h"
#include "device.h"

static unsigned int ndevices = 0;
static int curdevice = 0;
static Device_entry *device_table = NULL;

int set_page_geometry(Page_geometry pg)
{
    if (pg.width  > 0 &&
	pg.height > 0 &&
        pg.dpi_x  > 0 &&
        pg.dpi_y  > 0) {
        device_table[curdevice].pg = pg;
	return GRACE_EXIT_SUCCESS;
    } else {
        return GRACE_EXIT_FAILURE;
    }
}

Page_geometry get_page_geometry(void)
{
    return (device_table[curdevice].pg);
}

int register_device(Device_entry device)
{
    int dindex;
    
    ndevices++;
    dindex = ndevices - 1;
    device_table = (Device_entry *) realloc(device_table, ndevices*sizeof(Device_entry));
    device_table[dindex].type = device.type;
    device_table[dindex].name = 
                 (char *) malloc((strlen(device.name) + 1)*sizeof(char));
    strcpy(device_table[dindex].name, device.name);
    device_table[dindex].fext = 
                 (char *) malloc((strlen(device.fext) + 1)*sizeof(char));
    strcpy(device_table[dindex].fext, device.fext);
    device_table[dindex].init = device.init;
    device_table[dindex].setup = device.setup;
    device_table[dindex].devfonts = device.devfonts;
    device_table[dindex].fontaa = device.fontaa;
    device_table[dindex].pg = device.pg;
    
    return dindex;
}

int select_device(int dindex)
{
    if (dindex >= ndevices || dindex < 0) {
        return GRACE_EXIT_FAILURE;
    } else {
        curdevice = dindex;
	return GRACE_EXIT_SUCCESS;
    }
}

/*
 * set the current print device
 */
void set_printer(int device)
{
    hdevice = device;
}

void set_ptofile(int flag)
{
    ptofile = flag;
}

int initgraphics(void)
{
    return ((*device_table[curdevice].init)());
}

Device_entry get_device_props(int device)
{
    return (device_table[device]);
}

Device_entry get_curdevice_props()
{
    return (device_table[curdevice]);
}

void set_device_props(int deviceid, Device_entry device)
{
    device_table[deviceid].type = device.type;
    device_table[deviceid].init = device.init;
    device_table[deviceid].setup = device.setup;
    device_table[deviceid].devfonts = device.devfonts;
    device_table[deviceid].fontaa = device.fontaa;
    device_table[deviceid].pg = device.pg;
}

void set_curdevice_props(Device_entry device)
{
    set_device_props(curdevice, device);
}

int number_of_devices(void)
{
    return (ndevices);
}
