/* 
 *
 * Misc. utilities and support routines
 *
 */

#include <config.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globals.h"
#include "protos.h"

/*
 * stuff results, etc. into a text window
 */
void log_results(char *buf)
{
    char tmpbuf[512];
    if (logwindow) {
        strcpy(tmpbuf, buf);
        if (tmpbuf[strlen(tmpbuf) - 1] != '\n') {
            strcat(tmpbuf, "\n");
        }
        stufftext(tmpbuf, 1);
    }
}


void errmsg(char *buf)
{
#ifdef NONE_GUI
    printf("%s\n", buf);
#else
    if (inwin) {
        errwin(buf);
    } else {
        fprintf(stderr, "%s\n", buf);
    }
#endif
}

int yesnoterm(char *msg)
{
    return 1;
}

int yesno(char *msg, char *s1, char *s2, char *help_anchor)
{
    if (noask) {
	return 1;
    }
#ifdef NONE_GUI
    return (yesnoterm(msg));
#else
    if (inwin) {
        return (yesnowin(msg, s1, s2, help_anchor));
    } else {
        return (yesnoterm(msg));
    }
#endif
}
 

int fexists(char *to)
{
    struct stat stto;
    char tbuf[256];

    if (stat(to, &stto) == 0) {
	sprintf(tbuf, "Overwrite %s?", to);
	if (!yesno(tbuf, NULL, NULL, NULL)) {
	    return (1);
	}
	return (0);
    }
    return (0);
}

void stufftext(char *s, int sp)
{
#ifdef NONE_GUI
    printf("%s", buf);
#else
    stufftextwin(s, sp);
#endif
}


char *mybasename(char *s)
{
	int start, end;
	static char basename[256];
	
	end = strlen( s )-1;
	if( end==0 && *s=='/' ){	/* root is a special case */
		basename[0] = '/';
		return basename;
	}
	
	/* strip trailing white space and slashes */
	while( s[end]=='/' || s[end]==' ' || s[end]=='\t' )
		end--;
	/* find start of basename */
	start = end;
	do{
		start--;
	} while( start>=0 && s[start]!='/' );
	
	strncpy( basename, s+(start+1), end-start );
	basename[end-start] = '\0';
	return basename;
}

int isdir(char *f)
{
    struct stat st;

    stat(f, &st);
    return (S_ISDIR(st.st_mode));
}

int set_workingdir(char *wd)
{
    char buf2[GR_MAXPATHLEN];
    strcpy(buf2, wd);
    if (buf2[0] == '~') {
        expand_tilde(buf2);
    }
    if (chdir(buf2) >= 0) {
        strcpy(workingdir, buf2);
	return 0;
    } else {
        return -1;
    }
}

/* TODO this needs some work */
void expand_tilde(char *buf)
{
    char buf2[GR_MAXPATHLEN];
    char *home;
    if (buf[0] == '~') {
	if (strlen(buf) == 1) {
	    home = getenv("HOME");
	    if (home == NULL) {
		errmsg("Couldn't find $HOME!");
		return;
	    } else {
		strcpy(buf, home);
		strcat(buf, "/");
	    }
	} else if (buf[1] == '/') {
	    home = getenv("HOME");
	    if (home == NULL) {
		errmsg("Couldn't find $HOME!");
		return;
	    }
	    strcpy(buf2, home);
	    strcat(buf2, "/");
	    strcat(buf2, buf + 1);
	    strcpy(buf, buf2);
	} else {
	    char tmp[128], *pp = tmp, *q = buf + 1;
	    struct passwd *pent;

	    while (*q && (*q != '/')) {
		*pp++ = *q++;
	    }
	    *pp = 0;
	    if ((pent = getpwnam(tmp)) != NULL) {
		strcpy(buf2, pent->pw_dir);
		strcat(buf2, "/");
		strcat(buf2, q);
		strcpy(buf, buf2);
	    } else {
		errmsg("No user by that name");
	    }
	}
    }
}

void echomsg(char *msg)
{
    if (inwin) {
#ifndef NONE_GUI
        set_left_footer(msg);
#endif
    } else {
        printf("%s\n", msg);
    }
}

static void update_timestamp(void)
{
    struct tm tm;
    time_t time_value;
    char *str;

    (void) time(&time_value);
    tm = *localtime(&time_value);
    str = asctime(&tm);
    if (str[strlen(str) - 1] == '\n') {
        str[strlen(str) - 1]= '\0';
    }
    set_plotstr_string(&timestamp, str);
}

/*
 * dirtystate routines
 */

static int dirtystate = 0;

void set_dirtystate(void)
{
    if (dirtystate >= 0) {
        dirtystate++;
        update_timestamp();
/*
 * TODO:
 * 	if ( (dirtystate > SOME_LIMIT) || 
 *           (current_time - autosave_time > ANOTHER_LIMIT) ) {
 * 	    autosave();
 * 	}
 */
    }
}

void clear_dirtystate(void)
{
    dirtystate = 0;
}

void lock_dirtystate(void)
{
    dirtystate = -1;
}

int is_dirtystate(void)
{
    return (dirtystate);
}
