/* replacements for some functions */

#ifndef __MISSING_H_
#define __MISSING_H_

#include <config.h>

#include <stdio.h>

#if defined(__VMS)
#  include "vms_unix.h"
#endif

#ifndef HAVE_MEMMOVE
#  define memmove(a, b, c) bcopy((b), (a), (c))
#endif

#ifndef HAVE_MEMCPY
#  define memcpy(a, b, c) bcopy ((b), (a), (c))
#endif

#ifndef HAVE_GETHOSTNAME
#  define gethostname(a, n) (strncpy((a), "localhost", n)?0:1)
#endif


#ifndef HAVE_DRAND48
#  define srand48 srand
#  define lrand48 rand
double drand48(void);
#endif

#ifndef HAVE_GETCWD
#  ifdef OS2
#    define getcwd _getcwd2
#    define chdir _chdir2
#  endif
#endif

#ifndef HAVE_UNLINK
#  ifdef VMS
#    define unlink delete
#  endif
#endif

#ifndef HAVE_POPEN
FILE *popen(char *cmd, char *mode);
int   pclose(FILE *fp);
#endif

#endif /* __MISSING_H_ */
