#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <malloc.h>
#include <unistd.h>
#include <string.h>

#define ESC 27
#define TAB 3
#define LEFT_SPACE 3


int Set(WINDOW *w, int index);
int UnSet(WINDOW *w, int index);
int Up(WINDOW *w, int curr, int items);
int Down(WINDOW *w, int curr, int items);
int SetArgs(int argc, char *argv[], int *Start, int *End, int *items);
int StatusLine(WINDOW *w, int lines, int cols);
inline int min(int a, int b){return ((a < b)?a:b);}

//global variables
int items;
int lines=0;//the lines in the window.
int first_index=0;//the index of the first line displayed
int *selected=NULL;
int Start, End;
char **arguments=NULL;

int newlines=1;

void main(int argc, char *argv[]){
  int i;
  int curr=0;
  int key;

  items = argc;
  arguments=argv;
  selected=(int *)calloc(argc, sizeof(int));//selection indication

  for (i=0; i<argc; i++) printf("%s ", argv[i]);
  printf("\nargs got\n");
  
  printf("mark\n");

  SetArgs(argc, argv, &Start, &End, &items);
  //  printf("start %d end %d items %d\n", Start, End, items);
  //exit(1);

  //initilize curses
  initscr();
  keypad(stdscr, TRUE);
  WINDOW *w=derwin(stdscr, LINES-1, COLS, 0, 0);
  lines=LINES-1;
  scrollok(w, TRUE);

  //waddstr(stdscr, "mark\n");
  StatusLine(stdscr, LINES-1, COLS-1);

  //print list
  for (i=0; i < min(items, lines); i++){
    wmove(w, i, LEFT_SPACE);
    waddstr(w, argv[Start+i]);
  }

  wrefresh(w);
  noecho();
  cbreak();

  //init cursor position
  Set(w, 0);
  wmove(w, 0, LEFT_SPACE);

  while (key != ESC) {
    wrefresh(w);
    key = wgetch(stdscr);
    switch(key){
    case KEY_LEFT:
    case KEY_RIGHT:
      /* do nothing */
      break;

    case KEY_UP:
      curr=Up(w, curr, items);
      break;

    case KEY_DOWN:
      curr=Down(w, curr, items);
      break;
      
    case ' ': //mark with space
      selected[curr] = !(selected[curr]);
      curr=Down(w, curr, items);
      break;

    case '\n':
      int j;
      FILE *outfile=NULL;

      //if the SEL_FILE environment variable is set use it.
      //else use default named file.
      if (getenv("SEL_FILE") == NULL){
        outfile=fopen("$HOME/.select_file", "wt");
      }
      else{
        outfile=fopen( getenv("SEL_FILE"), "wt");
      }

      if (outfile == NULL) return 1;
      
      //for each file 
      for (i=Start; i <= End; i++){
        if (selected[i-Start]){
          if (newlines)
            for (j=1; j < Start - 1; j++) fprintf(outfile, "%s ", argv[j]);
          else 
            for (j=2; j < Start - 2; j++) fprintf(outfile, "%s ", argv[j]);
            
          fprintf(outfile, "%s ", argv[i]);
          for (j=End+2; j < argc; j++) fprintf(outfile, "%s ", argv[j]);
          fprintf(outfile, "\n");
        }
      }

      keypad(stdscr, FALSE);    
      
      //no problems
      return 0;
      break;
    }
  }
  keypad(stdscr, FALSE);    
  return 0;
}
  
int Set(WINDOW *w, int index){
  wmove(w, index - first_index, 2);
  wattr_set(w, A_NORMAL);
  waddch(w, '*');

  wmove(w, index - first_index, LEFT_SPACE);
  wattr_set(w, (selected[index])? A_REVERSE : A_NORMAL);
  waddstr(w, arguments[Start+index]);

  return index - first_index;
}

int UnSet(WINDOW *w, int index){
  wmove(w, index - first_index, 2);
  wattr_set(w, A_NORMAL);
  waddch(w, ' ');
      
  wmove(w, index - first_index, LEFT_SPACE);
  wattr_set(w, (selected[index])? A_REVERSE : A_NORMAL);
  waddstr(w, arguments[Start+index]);

  return index - first_index;
}
 
int Down(WINDOW *w, int curr, int items){
  if (curr < items-1){
    wattr_set(w, A_NORMAL);
    UnSet(w, curr);
    curr++;

    if (curr - first_index >= lines){
      wscrl(w, 1);
      first_index++;
    }
    Set(w, curr);
  }
  else{
    //the last item
    Set(w, curr);
  }
  return curr;
}
    

int Up(WINDOW *w, int curr, int items){
  if (curr > 0){
    wattr_set(w, A_NORMAL);
    UnSet(w, curr);
    curr--;
   
    if (curr < first_index){
      wscrl(w, -1); 
      first_index--;
    }
    Set(w, curr);
  }
  return curr;
}

int SetArgs(int argc, char *argv[], int *Start, int *End, int *items){
  int i;
  int found=0;
  
  //the -n flag means no new lines in the output file.
  if (strcmp(argv[1], "-n") == 0){
    newlines=0;
  }

  *Start=0;
  *End=0;

  for (i=1; i < argc; i++){
    //check for #
    if (strstr(argv[i], "!") && (found == 1)){
      *End=i-1;
      found++;
    }
    if (strstr(argv[i], "!") && (found == 0)){
      *Start=i+1;
      found++;
    }
  }
  *items= *End - *Start + 1;

  return 0;
}

//draw a status line at the buttom of the screen.
int StatusLine(WINDOW *w, int lines, int cols){
  wmove(w, lines, 0);
  wattr_set(w, A_REVERSE);
  waddstr(w, "SPC - select  UP/DOWN - move  ENTER - execute  ESC - quit");
  wattr_set(w, A_NORMAL);
}
