
#include "ptyx.h"
#include "screen.h"
#include "vtdefs.h"

#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Converters.h>

#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
#include <ctype.h>
 
/*
 * write a string str of length len onto the screen at
 * the current cursor position.  update cursor position.
 */
static void WriteText(screen, str, len, flags)
TScreen		*screen;
char		*str;
int		len;
unsigned	flags;
{
	int		 cx, cy;
	GC		currentGC;
	char		tmp[BUFSIZ];

	if(screen->cur_row - screen->topline > screen->max_row)
		goto out;

	if(screen->cursor_state)
		HideCursor();

	/*
	 *	make sure that the correct GC is current
	 */
	switch(flags & (A_BOLD|A_INVERSE)) {
	case A_BOLD:
		currentGC = screen->normalboldGC;	break;
	case A_BOLD|A_INVERSE:
		currentGC = screen->reverseboldGC;	break;
	case A_INVERSE:
		currentGC = screen->reverseGC;		break;
	default:
		currentGC = screen->normalGC;		break;
	}
	if(flags & M_IR)
		InsertChar(screen, len);

	if(!AddToRefresh(screen)) {
		if(screen->scroll_amt)
			FlushScroll(screen);
		cy = CursorY(screen, screen->cur_row)+screen->fnt_norm->ascent;
#ifdef M_DECRL
		cx = CursorX(screen,
			     !(flags&M_DECRL)? screen->cur_col:
			     screen->cur_col - len + 1);
		if(flags & M_DECRL) {
			char *cp, *bp;
			int	n;

			bp = str + len;
			cp = tmp;
			n = len;
			while(n-- > 0)
				*cp++ = *--bp;
			*cp = 0;
			XDrawImageString(screen->display,
					 TextWindow(screen), currentGC,
					 cx, cy, tmp, len);
		} else
			XDrawImageString(screen->display,
					 TextWindow(screen), currentGC,
					 cx, cy, str, len);

#else
		cx = CursorX(screen, screen->cur_col);
		XDrawImageString(screen->display,
				 TextWindow(screen), currentGC,
				 cx, cy, str, len);
#endif

		if((flags & A_BOLD) && screen->enbolden) 
			if(currentGC == screen->normalGC ||
			   screen->reverseGC)
				XDrawString(screen->display,
					    TextWindow(screen),
					    currentGC, cx + 1, cy, str, len);

		if(flags & A_UNDERLINE) 
			XDrawLine(screen->display,
				  TextWindow(screen), currentGC,
				  cx, cy+1,
				  cx + len * FontWidth(screen), cy+1);
	}
 out:
	ScreenWrite(screen, str, flags, len);
#ifdef M_DECRL
	if(flags&M_DECRL)
		cursorMove(screen, C_LEFT, len);
	else
#endif
		cursorMove(screen, C_RIGHT, len);
}
 
/*
 * process a string of characters according to the character set indicated
 * by charset.  worry about end of line conditions (wraparound if selected).
 */
void DoText(screen, flags, charset, buf, ptr)
TScreen		*screen;
unsigned	flags;
char		charset;
char		*buf;		/* start of characters to process */
char		*ptr;		/* end */
{
	char	*s;
	int	len;
	int	n;
	int	next_col;


	switch(charset) {
	case 'A':	/* United Kingdom set			*/
		for(s=buf; s<ptr; ++s)
			if (*s == '#')
				*s = '\036';	/* UK pound sign*/
		break;

	case 'B':	/* ASCII set				*/
		break;

	case '0':	/* special graphics (line drawing)	*/
		for(s=buf; s<ptr; ++s)
			if (*s>=0x5f && *s<=0x7e)
				*s = *s == 0x5f ? 0x7f : *s - 0x5f;
		break;

	default:	/* any character sets we don't recognize*/
		return;
	}

	len = ptr - buf; 
	ptr = buf;
#ifdef M_DECRL

	if(flags & M_DECRL)
	while(len > 0) {
		n = screen->cur_col + 1;
		if(n <= 1) {
			if(screen->do_wrap && (flags & M_DECAW)) {
				/* mark that we had to wrap this line */
				ScrnSetAttributes(screen, screen->cur_row, 0,
						  M_LN, LINEWRAPPED, 1);
				cursorIndex(screen, 1, 0, 0);
				screen->cur_col = screen->max_col;
				screen->do_wrap = 0;
				n = screen->max_col + 1;
			} else
				n = 1;
		}
		if(len < n)
			n = len;
		next_col = screen->cur_col - n;
		WriteText(screen, ptr, n, flags);
		/*
		 * the call to WriteText updates screen->cur_col.
		 * If screen->cur_col != next_col, we must have
		 * hit the left margin, so set the do_wrap flag.
		 */
		screen->do_wrap = (screen->cur_col != next_col);
		len -= n;
		ptr += n;
	}
	else
#endif /* M_DECRL */
	while (len > 0) {
		n = screen->max_col - screen->cur_col +1;
		if (n <= 1) {
			if (screen->do_wrap && (flags & M_DECAW)) {
			    /* mark that we had to wrap this line */
			    ScrnSetAttributes(screen, screen->cur_row, 0,
					      M_LN, LINEWRAPPED, 1);
			    cursorIndex(screen, 1, 0, 0);
			    screen->cur_col = 0;
			    screen->do_wrap = 0;
			    n = screen->max_col+1;
			} else
			    n = 1;
		}
		if (len < n)
			n = len;
		next_col = screen->cur_col + n;
		WriteText(screen, ptr, n, flags);
		/*
		 * the call to WriteText updates screen->cur_col.
		 * If screen->cur_col != next_col, we must have
		 * hit the right margin, so set the do_wrap flag.
		 */
		screen->do_wrap = (screen->cur_col < next_col);
		len -= n;
		ptr += n;
	}
}
