#ifndef lint
static char	*rcsid =
	"$Id: cursor.c,v 1.2 1993/09/09 11:41:15 danny Exp $";
#endif
#include <stdio.h>

#include "ptyx.h"
#include "screen.h"
#include "vtdefs.h"
#include "data.h"

/*
 | Cursor Stuff
 */
static void _CheckSelection(screen)
TScreen *screen;
{
	extern XtermWidget term;	/* %%% gross */

	if(!(screen->cur_row > screen->endHRow ||
	   (screen->cur_row == screen->endHRow &&
	    screen->cur_col >= screen->endHCol)))
		DisownSelection(term);
}
/*
 | Moves the cursor to the specified position, checking for bounds.
 | (this includes scrolling regions)
 | The origin is considered to be 0, 0 for this procedure.
 */
CursorSet(screen, row, col, origen)
TScreen		*screen;
{
	int maxr;

	col = col < 0? 0: col;
	if(col > screen->max_col)
		col = screen->max_col;

	screen->cur_col = col;
	maxr = screen->max_row;
	if(origen) {
		row += screen->top_marg;
		maxr = screen->bot_marg;
	}
	row = row < 0? 0: row;
	screen->cur_row = row <= maxr? row: maxr;
	screen->do_wrap = 0;
	_CheckSelection(screen);
}
/*
 | Moves cursor down/up amount lines, scrolls if necessary.
 | Won't leave scrolling region.
 | cr==0 No carriage return, else do cr
 */
cursorIndex(screen, amount, cr, update)
TScreen	*screen;
{
	int j;

	if(amount > 0) {
		/* 
		 | indexing when below scrolling region is cursor down.
		 | if cursor high enough, no scrolling necessary.
		 */
		if(screen->cur_row > screen->bot_marg
		   || screen->cur_row + amount <= screen->bot_marg) {
			cursorMove(screen, C_DOWN, amount);
			return;
		}
		j = screen->bot_marg - screen->cur_row;
		cursorMove(screen, C_DOWN, j);
			   
		Scroll(screen, amount - j);
	}
	else {
		amount = -amount;
		/*
		 | reverse indexing when above scrolling region is cursor up.
		 | if cursor low enough, no reverse indexing needed
		 */
		if(screen->cur_row < screen->top_marg
		   || screen->cur_row - amount >= screen->top_marg) {
			cursorMove(screen, C_UP, amount);
			return;
		}
		RevScroll(screen, amount - (screen->cur_row-screen->top_marg));
		cursorMove(screen, C_UP, screen->cur_row - screen->top_marg);
	}
	if(cr)
		carriageReturn(screen);
	if(update) {
		if(QLength(screen->display) > 0 ||
		   GetBytesAvailable(ConnectionNumber(screen->display)) > 0)
			xevents();
	}
}

cursorMove(screen, to, cnt)
TScreen	*screen;
{
	switch(to) {
	case 0: /* up */
		if(((screen->cur_row -= cnt) < 0) ||
		   (screen->cur_row < screen->top_marg))
			screen->cur_row = screen->top_marg;
		break;
	case 1: /* down */
		if((screen->cur_row += cnt) > screen->bot_marg)
			screen->cur_row = screen->bot_marg;
		break;
	case 2: /* right */
		if((screen->cur_col += cnt) > screen->max_col)
			screen->cur_col = screen->max_col;
		break;
	case 3: /* left */ {
#define WRAP	(M_DECAW|M_RVSAW)
		int	rev = ((term->vt_mode&WRAP)==WRAP) && screen->do_wrap;
		if(rev)
			cnt--;
		if((screen->cur_col -= cnt) < 0) {
			if(rev) {
				int	i, j;
				j = screen->max_col + 1;
				i = j * screen->cur_row + screen->cur_col;

				if(i < 0) {
					int	k = j * (screen->max_row + 1);

					i += ((-i) / k + 1) * k;
				}
				screen->cur_row = i / j;
				screen->cur_col = i % j;
			} else
				screen->cur_col = 0;
		}}
		break;
	case 4: /* home */
		if(term->vt_mode & M_DECO)
			screen->cur_row = screen->top_marg;
		else
			screen->cur_row = 0;
#ifdef M_DECRL
		if(term->vt_mode & M_DECRL)
			screen->cur_col = screen->max_col;
		else
#endif
			screen->cur_col = 0;
	}

	screen->do_wrap = 0;
	_CheckSelection(screen);
}

/*
 | Carriage return:
 */
carriageReturn(screen)
TScreen	*screen;
{

#ifdef M_DECRL
	screen->cur_col = term->vt_mode & M_DECRL? screen->max_col: 0;
#else
	screen->cur_col = 0;
#endif
	screen->do_wrap = 0;
	_CheckSelection(screen);
}
/*
 | Backspace:
 |	move back cursor one pos. not beyond
 |  the english/left hebrew/right margin
 */
Bs(screen)
TScreen	*screen;
{
#ifdef M_DECRL 
	if(term->vt_mode & M_DECRL)
		cursorMove(screen, C_RIGHT, 1);
	else
#endif
		cursorMove(screen, C_LEFT, 1); /* why does it wrap around? */
}

ReportCursorPosition(p)
char	*p;
{
	TScreen *screen = &term->screen;
	int	cline, ccol;

	cline = screen->cur_row + 1;
	ccol = screen->cur_col + 1;
	if(cline > 9) {
		*p = '0';
		*p++ += cline / 10;
		cline %= 10;
	}
	*p = '0';
	*p++ += cline;
	*p++ = ';';
	if(ccol > 99) {
		*p = '1';
		ccol %= 100;
	}
	if(ccol > 9) {
		*p = '0';
		*p++ += ccol / 10;
		ccol %= 10;
	}
	*p = '0';
	*p++ += ccol;
	*p++ = 'R';
}
/*
 | Save/Restore the cursor position (plus some other stuff)
 */
saveRestoreCursor(flag)
{
	TScreen *screen = &term->screen;
	SavedCursor	*sc = &screen->sc;

	if(flag) {
		sc->row = screen->cur_row;
		sc->col = screen->cur_col;
		sc->flags = term->vt_mode;
		sc->curgl = screen->curgl;
		sc->curgr = screen->curgr;
		bcopy(screen->gsets, sc->gsets, sizeof(screen->gsets));
	}
	else {
		bcopy(sc->gsets, screen->gsets, sizeof(screen->gsets));
		screen->curgl = sc->curgl;
		screen->curgr = sc->curgr;
		term->vt_mode &= ~(ATTRIBUTES|M_DECO);
		term->vt_mode |= sc->flags & (ATTRIBUTES|M_DECO);
		CursorSet(screen, (term->vt_mode & M_DECO)?
			  sc->row - screen->top_marg : sc->row,
			  sc->col, term->vt_mode & M_DECO);
	}
}



#define InSelection(s) \
(!((s)->cur_row > (s)->endHRow ||\
 ((s)->cur_row == (s)->endHRow && (s)->cur_col >= (s)->endHCol) ||\
 (s)->cur_row < (s)->startHRow ||\
 ((s)->cur_row == (s)->startHRow && (s)->cur_col < (s)->startHCol)))
/*
 | Shows cursor at new cursor position in screen.
 */
ShowCursor()
{
	TScreen *screen = &term->screen;
	int x, y, flags;
	Char c;
	GC	currentGC;
	Boolean	in_selection;

	if(eventMode != NORMAL)
		return;
	if(screen->cur_row - screen->topline > screen->max_row)
		return;
	c = screen->buf[y = 2 * (screen->cursor_row = screen->cur_row)]
		[x = screen->cursor_col = screen->cur_col];
	flags = screen->buf[y + 1][x];
	if(c == 0)
		c = ' ';
	in_selection = InSelection(screen)? True: False;

	if(screen->select || screen->always_highlight) {
		if(((flags & A_INVERSE) && !in_selection) ||
		   (!(flags & A_INVERSE) &&  in_selection)) {
			/* text is reverse video */
			if(screen->cursorGC)
				currentGC = screen->cursorGC;
			else
			if(flags & A_BOLD)
				currentGC = screen->normalboldGC;
			else
				currentGC = screen->normalGC;
		}
		else { /* normal video */
			if(screen->reversecursorGC) {
				currentGC = screen->reversecursorGC;
			} else
			if(flags & A_BOLD)
				currentGC = screen->reverseboldGC;
			else
				currentGC = screen->reverseGC;
		}
	}
	else { /* not selected */
		if(((flags & A_INVERSE) && !in_selection) ||
		    (!(flags & A_INVERSE) &&  in_selection)) {
			/* text is reverse video */
			currentGC = screen->reverseGC;
		} else  /* normal video */
			currentGC = screen->normalGC;
	}
	x = CursorX (screen, screen->cur_col);
	y = CursorY(screen, screen->cur_row) + screen->fnt_norm->ascent;
	XDrawImageString(screen->display, TextWindow(screen), currentGC,
			 x, y, (char *) &c, 1);

	if((flags & A_BOLD) && screen->enbolden) /* no bold font */
		XDrawString(screen->display, TextWindow(screen), currentGC,
			    x + 1, y, (char *)&c, 1);
	if(flags & A_UNDERLINE) 
		XDrawLine(screen->display, TextWindow(screen), currentGC,
			  x, y+1, x + FontWidth(screen), y+1);
	if(!screen->select && !screen->always_highlight) {
		screen->box->x = x;
		screen->box->y = y - screen->fnt_norm->ascent;
		XDrawLines (screen->display, TextWindow(screen), 
			    screen->cursoroutlineGC?
			    screen->cursoroutlineGC: currentGC,
			    screen->box, NBOX, CoordModePrevious);
	}
	screen->cursor_state = ON;
}
/*
 * hide cursor at previous cursor position in screen.
 */
HideCursor()
{
	TScreen *screen = &term->screen;
	GC	currentGC;
	int x, y, flags;
	char c;
	Boolean	in_selection;

	if(screen->cursor_row - screen->topline > screen->max_row)
		return;
	c = screen->buf[y = 2 * screen->cursor_row][x = screen->cursor_col];
	flags = screen->buf[y + 1][x];

	in_selection = InSelection(screen)? True: False;

	if(((flags & A_INVERSE) && !in_selection) ||
	   (!(flags & A_INVERSE) &&  in_selection)) {
		if(flags & A_BOLD)
			currentGC = screen->reverseboldGC;
		else
			currentGC = screen->reverseGC;
	}
	else {
		if(flags & A_BOLD)
			currentGC = screen->normalboldGC;
		else
			currentGC = screen->normalGC;
	}


	if(c == 0)
		c = ' ';
	x = CursorX (screen, screen->cursor_col);
	y = (((screen->cursor_row - screen->topline) * FontHeight(screen))) +
		screen->border;
	y = y+screen->fnt_norm->ascent;
	XDrawImageString(screen->display, TextWindow(screen), currentGC,
			 x, y, &c, 1);
	if((flags & A_BOLD) && screen->enbolden)
		XDrawString(screen->display, TextWindow(screen), currentGC,
			    x + 1, y, &c, 1);
	if(flags & A_UNDERLINE) 
		XDrawLine(screen->display, TextWindow(screen), currentGC,
			  x, y+1, x + FontWidth(screen), y+1);
	screen->cursor_state = OFF;
}

