#ifndef lint
static char *rcsid =
	"$Id: init.c,v 1.3 1993/09/09 11:41:15 danny Exp $";
#endif

#include "ptyx.h"
#include "screen.h"
#include "data.h"
#include "error.h"
#include "vtdefs.h"
#include "menu.h"
#include "main.h"

#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Converters.h>
#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
#include <ctype.h>

#define	DEFAULT		-1
#define	TEXT_BUF_SIZE	256
#define TRACKTIMESEC	4L
#define TRACKTIMEUSEC	0L
#define BELLSUPPRESSMSEC 200

#define XtNalwaysHighlight "alwaysHighlight"
#define XtNappcursorDefault "appcursorDefault"
#define XtNappkeypadDefault "appkeypadDefault"
#define XtNbellSuppressTime "bellSuppressTime"
#define XtNboldFont "boldFont"
#define XtNc132 "c132"
#define XtNcharClass "charClass"
#define XtNcurses "curses"
#define XtNcursorColor "cursorColor"
#define XtNcutNewline "cutNewline"
#define XtNcutToBeginningOfLine "cutToBeginningOfLine"
#define XtNeightBitInput "eightBitInput"
#define XtNeightBitOutput "eightBitOutput"
#define XtNgeometry "geometry"
#define XtNtekGeometry "tekGeometry"
#define XtNinternalBorder "internalBorder"
#define XtNjumpScroll "jumpScroll"
#define XtNlogFile "logFile"
#define XtNlogging "logging"
#define XtNlogInhibit "logInhibit"
#define XtNloginShell "loginShell"
#define XtNmarginBell "marginBell"
#define XtNpointerColor "pointerColor"
#define XtNpointerColorBackground "pointerColorBackground"
#define XtNpointerShape "pointerShape"
#define XtNmultiClickTime "multiClickTime"
#define XtNmultiScroll "multiScroll"
#define XtNnMarginBell "nMarginBell"
#define XtNresizeGravity "resizeGravity"
#define XtNreverseWrap "reverseWrap"
#define XtNautoWrap "autoWrap"
#define XtNsaveLines "saveLines"
#define XtNscrollBar "scrollBar"
#define XtNscrollTtyOutput "scrollTtyOutput"
#define XtNscrollKey "scrollKey"
#define XtNscrollLines "scrollLines"
#define XtNscrollPos "scrollPos"
#define XtNsignalInhibit "signalInhibit"
#define XtNtekInhibit "tekInhibit"
#define XtNtekSmall "tekSmall"
#define XtNtekStartup "tekStartup"
#define XtNtiteInhibit "titeInhibit"
#define XtNvisualBell "visualBell"
#define XtNallowSendEvents "allowSendEvents"

#define XtCAlwaysHighlight "AlwaysHighlight"
#define XtCAppcursorDefault "AppcursorDefault"
#define XtCAppkeypadDefault "AppkeypadDefault"
#define XtCBellSuppressTime "BellSuppressTime"
#define XtCBoldFont "BoldFont"
#define XtCC132 "C132"
#define XtCCharClass "CharClass"
#define XtCCurses "Curses"
#define XtCCutNewline "CutNewline"
#define XtCCutToBeginningOfLine "CutToBeginningOfLine"
#define XtCEightBitInput "EightBitInput"
#define XtCEightBitOutput "EightBitOutput"
#define XtCGeometry "Geometry"
#define XtCJumpScroll "JumpScroll"
#define XtCLogfile "Logfile"
#define XtCLogging "Logging"
#define XtCLogInhibit "LogInhibit"
#define XtCLoginShell "LoginShell"
#define XtCMarginBell "MarginBell"
#define XtCMultiClickTime "MultiClickTime"
#define XtCMultiScroll "MultiScroll"
#define XtCColumn "Column"
#define XtCResizeGravity "ResizeGravity"
#define XtCReverseWrap "ReverseWrap"
#define XtCAutoWrap "AutoWrap"
#define XtCSaveLines "SaveLines"
#define XtCScrollBar "ScrollBar"
#define XtCScrollLines "ScrollLines"
#define XtCScrollPos "ScrollPos"
#define XtCScrollCond "ScrollCond"
#define XtCSignalInhibit "SignalInhibit"
#define XtCTekInhibit "TekInhibit"
#define XtCTekSmall "TekSmall"
#define XtCTekStartup "TekStartup"
#define XtCTiteInhibit "TiteInhibit"
#define XtCVisualBell "VisualBell"
#define XtCAllowSendEvents "AllowSendEvents"

/* event handlers */
extern void HandleKeyPressed(), HandleEightBitKeyPressed();
extern void HandleStringEvent();
extern void HandleEnterWindow();
extern void HandleLeaveWindow();
extern void HandleBellPropertyChange();
extern void HandleFocusChange();
static void HandleKeymapChange();
extern void HandleInsertSelection();
extern void HandleSelectStart(), HandleKeyboardSelectStart();
extern void HandleSelectExtend(), HandleSelectSet();
extern void HandleSelectEnd(), HandleKeyboardSelectEnd();
extern void HandleStartExtend(), HandleKeyboardStartExtend();
static void HandleBell();
static void HandleVisualBell();
static void HandleIgnore();
extern void HandleSecure();
extern void HandleScrollForward();
extern void HandleScrollBack();
extern void HandleCreateMenu(), HandlePopupMenu();
extern void HandleSetFont();
extern void SetVTFont();

#ifdef HEBREW
extern void HandleDirection();
extern void HandleMirror();
extern void HandleKeyboard();
#endif

extern Boolean SendMousePosition();
extern void ScrnSetAttributes();

/*
 * NOTE: VTInitialize zeros out the entire ".screen" component of the 
 * XtermWidget, so make sure to add an assignment statement in VTInitialize() 
 * for each new ".screen" field added to this resource list.
 */

/* Defaults */
static  Boolean	defaultFALSE	   = FALSE;
static  Boolean	defaultTRUE	   = TRUE;
static  int	defaultBorderWidth = DEFBORDERWIDTH;
static  int	defaultIntBorder   = DEFBORDER;
static  int	defaultSaveLines   = SAVELINES;
static	int	defaultScrollLines = SCROLLLINES;
static  int	defaultNMarginBell = N_MARGINBELL;
static  int	defaultMultiClickTime = MULTICLICKTIME;
static  int	defaultBellSuppressTime = BELLSUPPRESSMSEC;

/*
 * Warning, the following must be kept under 1024 bytes or else some 
 * compilers (particularly AT&T 6386 SVR3.2) will barf).  Workaround is to
 * declare a static buffer and copy in at run time (the the Athena text widget
 * does).  Yuck.
 */
static char defaultTranslations[] =
"\
 Shift <KeyPress> Prior:scroll-back(1,halfpage) \n\
  Shift <KeyPress> Next:scroll-forw(1,halfpage) \n\
Shift <KeyPress> Select:select-cursor-start() select-cursor-end(PRIMARY, CUT_BUFFER0) \n\
Shift <KeyPress> Insert:insert-selection(PRIMARY, CUT_BUFFER0) \n\
       ~Meta <KeyPress>:insert-seven-bit() \n\
        Meta <KeyPress>:insert-eight-bit() \n\
       !Ctrl <Btn1Down>:popup-menu(mainMenu) \n\
  !Lock Ctrl <Btn1Down>:popup-menu(mainMenu) \n\
       ~Meta <Btn1Down>:select-start() \n\
     ~Meta <Btn1Motion>:select-extend() \n\
       !Ctrl <Btn2Down>:popup-menu(vtMenu) \n\
  !Lock Ctrl <Btn2Down>:popup-menu(vtMenu) \n\
 ~Ctrl ~Meta <Btn2Down>:ignore() \n\
   ~Ctrl ~Meta <Btn2Up>:insert-selection(PRIMARY, CUT_BUFFER0) \n\
       !Ctrl <Btn3Down>:popup-menu(fontMenu) \n\
  !Lock Ctrl <Btn3Down>:popup-menu(fontMenu) \n\
 ~Ctrl ~Meta <Btn3Down>:start-extend() \n\
     ~Meta <Btn3Motion>:select-extend()	\n\
                <BtnUp>:select-end(PRIMARY, CUT_BUFFER0) \n\
	      <BtnDown>:bell(0) \
";

static XtActionsRec actionsList[] = { 
    { "bell",		  HandleBell },
    { "create-menu",	  HandleCreateMenu },
    { "ignore",		  HandleIgnore },
    { "insert",		  HandleKeyPressed },  /* alias for insert-seven-bit */
    { "insert-seven-bit", HandleKeyPressed },
    { "insert-eight-bit", HandleEightBitKeyPressed },
    { "insert-selection", HandleInsertSelection },
    { "keymap", 	  HandleKeymapChange },
    { "popup-menu",	  HandlePopupMenu },
    { "secure",		  HandleSecure },
    { "select-start",	  HandleSelectStart },
    { "select-extend",	  HandleSelectExtend },
    { "select-end",	  HandleSelectEnd },
    { "select-set",	  HandleSelectSet },
    { "select-cursor-start",	  HandleKeyboardSelectStart },
    { "select-cursor-end",	  HandleKeyboardSelectEnd },
    { "set-vt-font",	  HandleSetFont },
    { "start-extend",	  HandleStartExtend },
    { "start-cursor-extend",	  HandleKeyboardStartExtend },
    { "string",		  HandleStringEvent },
    { "scroll-forw",	  HandleScrollForward },
    { "scroll-back",	  HandleScrollBack },
/* menu actions */
    { "allow-send-events",	HandleAllowSends },
    { "set-visual-bell",	HandleSetVisualBell },
    { "set-logging",		HandleLogging },
    { "redraw",			HandleRedraw },
    { "send-signal",		HandleSendSignal },
    { "quit",			HandleQuit },
    { "set-scrollbar",		HandleScrollbar },
    { "set-jumpscroll",		HandleJumpscroll },
    { "set-reverse-video",	HandleReverseVideo },
    { "set-autowrap",		HandleAutoWrap },
    { "set-reversewrap",	HandleReverseWrap },
    { "set-autolinefeed",	HandleAutoLineFeed },
    { "set-appcursor",		HandleAppCursor },
    { "set-appkeypad",		HandleAppKeypad },
    { "set-scroll-on-key",	HandleScrollKey },
    { "set-scroll-on-tty-output",	HandleScrollTtyOutput },
    { "set-allow132",		HandleAllow132 },
    { "set-cursesemul",		HandleCursesEmul },
    { "set-marginbell",		HandleMarginBell },
    { "set-altscreen",		HandleAltScreen },
    { "soft-reset",		HandleSoftReset },
    { "hard-reset",		HandleHardReset },
    { "clear-saved-lines",	HandleClearSavedLines },
    { "set-terminal-type",	HandleSetTerminalType },
    { "set-visibility",		HandleVisibility },
    { "set-tek-text",		HandleSetTekText },
    { "tek-page",		HandleTekPage },
    { "tek-reset",		HandleTekReset },
    { "tek-copy",		HandleTekCopy },
    { "visual-bell",		HandleVisualBell },
#ifdef HEBREW
    { "set-direction",		HandleDirection },
    { "set-mirror",		HandleMirror },
    { "set-keyboard",		HandleKeyboard },
#endif
};

static XtResource resources[] = {
{XtNfont, XtCFont, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, misc.f_n), XtRString,
	DEFFONT},
{XtNboldFont, XtCBoldFont, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, misc.f_b), XtRString,
	DEFBOLDFONT},
{XtNc132, XtCC132, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.c132),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNcharClass, XtCCharClass, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, screen.charClass),
	XtRString, (caddr_t) NULL},
{XtNcurses, XtCCurses, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.curses),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNcutNewline, XtCCutNewline, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.cutNewline),
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNcutToBeginningOfLine, XtCCutToBeginningOfLine, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.cutToBeginningOfLine),
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
	XtOffsetOf(XtermWidgetRec, core.background_pixel),
	XtRString, "XtDefaultBackground"},
{XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	XtOffsetOf(XtermWidgetRec, screen.foreground),
	XtRString, "XtDefaultForeground"},
{XtNcursorColor, XtCForeground, XtRPixel, sizeof(Pixel),
	XtOffsetOf(XtermWidgetRec, screen.cursorcolor),
	XtRString, "XtDefaultForeground"},
{XtNeightBitInput, XtCEightBitInput, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.input_eight_bits), 
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNeightBitOutput, XtCEightBitOutput, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.output_eight_bits), 
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNgeometry,XtCGeometry, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, misc.geo_metry),
	XtRString, (caddr_t) NULL},
{XtNalwaysHighlight,XtCAlwaysHighlight,XtRBoolean,
        sizeof(Boolean),XtOffsetOf(XtermWidgetRec, screen.always_highlight),
        XtRBoolean, (caddr_t) &defaultFALSE},
{XtNappcursorDefault,XtCAppcursorDefault,XtRBoolean,
        sizeof(Boolean),XtOffsetOf(XtermWidgetRec, misc.appcursorDefault),
        XtRBoolean, (XtPointer) &defaultFALSE},
{XtNappkeypadDefault,XtCAppkeypadDefault,XtRBoolean,
        sizeof(Boolean),XtOffsetOf(XtermWidgetRec, misc.appkeypadDefault),
        XtRBoolean, (XtPointer) &defaultFALSE},
{XtNbellSuppressTime, XtCBellSuppressTime, XtRInt, sizeof(int),
        XtOffsetOf(XtermWidgetRec, screen.bellSuppressTime),
        XtRInt, (XtPointer) &defaultBellSuppressTime},
{XtNtekGeometry,XtCGeometry, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, misc.T_geometry),
	XtRString, (caddr_t) NULL},
{XtNinternalBorder,XtCBorderWidth,XtRInt, sizeof(int),
	XtOffsetOf(XtermWidgetRec, screen.border),
	XtRInt, (caddr_t) &defaultIntBorder},
{XtNjumpScroll, XtCJumpScroll, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.jumpscroll),
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNlogFile, XtCLogfile, XtRString, sizeof(char *),
	XtOffsetOf(XtermWidgetRec, screen.logfile),
	XtRString, (caddr_t) NULL},
{XtNlogging, XtCLogging, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.log_on),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNlogInhibit, XtCLogInhibit, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.logInhibit),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNloginShell, XtCLoginShell, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.login_shell),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNmarginBell, XtCMarginBell, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.marginbell),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNpointerColor, XtCForeground, XtRPixel, sizeof(Pixel),
	XtOffsetOf(XtermWidgetRec, screen.mousecolor),
	XtRString, "XtDefaultForeground"},
{XtNpointerColorBackground, XtCBackground, XtRPixel, sizeof(Pixel),
	XtOffsetOf(XtermWidgetRec, screen.mousecolorback),
	XtRString, "XtDefaultBackground"},
{XtNpointerShape,XtCCursor, XtRCursor, sizeof(Cursor),
	XtOffsetOf(XtermWidgetRec, screen.pointer_cursor),
	XtRString, (caddr_t) "xterm"},
{XtNmultiClickTime,XtCMultiClickTime, XtRInt, sizeof(int),
	XtOffsetOf(XtermWidgetRec, screen.multiClickTime),
	XtRInt, (caddr_t) &defaultMultiClickTime},
{XtNmultiScroll,XtCMultiScroll, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.multiscroll),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNnMarginBell,XtCColumn, XtRInt, sizeof(int),
	XtOffsetOf(XtermWidgetRec, screen.nmarginbell),
	XtRInt, (caddr_t) &defaultNMarginBell},
{XtNreverseVideo,XtCReverseVideo,XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.re_verse),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNresizeGravity, XtCResizeGravity, XtRGravity, sizeof(XtGravity),
	XtOffsetOf(XtermWidgetRec, misc.resizeGravity),
	XtRImmediate, (XtPointer) SouthWestGravity},
{XtNreverseWrap,XtCReverseWrap, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.reverseWrap),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNautoWrap,XtCAutoWrap, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.autoWrap),
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNsaveLines, XtCSaveLines, XtRInt, sizeof(int),
	XtOffsetOf(XtermWidgetRec, screen.savelines),
	XtRInt, (caddr_t) &defaultSaveLines},
{XtNscrollBar, XtCScrollBar, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.scrollbar),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNscrollTtyOutput,XtCScrollCond, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.scrollttyoutput),
	XtRBoolean, (caddr_t) &defaultTRUE},
{XtNscrollKey, XtCScrollCond, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.scrollkey),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNscrollLines, XtCScrollLines, XtRInt, sizeof(int),
	XtOffsetOf(XtermWidgetRec, screen.scrolllines),
	XtRInt, (caddr_t) &defaultScrollLines},
{XtNsignalInhibit,XtCSignalInhibit,XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.signalInhibit),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNtekInhibit, XtCTekInhibit, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.tekInhibit),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNtekSmall, XtCTekSmall, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.tekSmall),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNtekStartup, XtCTekStartup, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.TekEmu),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNtiteInhibit, XtCTiteInhibit, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, misc.titeInhibit),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNvisualBell, XtCVisualBell, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.visualbell),
	XtRBoolean, (caddr_t) &defaultFALSE},
{XtNallowSendEvents, XtCAllowSendEvents, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XtermWidgetRec, screen.allowSendEvents),
	XtRBoolean, (caddr_t) &defaultFALSE},
{"font1", "Font1", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font1]),
	XtRString, (caddr_t) NULL},
{"font2", "Font2", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font2]),
	XtRString, (caddr_t) NULL},
{"font3", "Font3", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font3]),
	XtRString, (caddr_t) NULL},
{"font4", "Font4", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font4]),
	XtRString, (caddr_t) NULL},
{"font5", "Font5", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font5]),
	XtRString, (caddr_t) NULL},
{"font6", "Font6", XtRString, sizeof(String),
	XtOffsetOf(XtermWidgetRec, screen.menu_font_names[fontMenu_font6]),
	XtRString, (caddr_t) NULL},
#ifdef HEBREW
{"displayDirection", "DisplayDirection", XtRBoolean, sizeof(Boolean),
	 XtOffsetOf(XtermWidgetRec, screen.direction),
	 XtRBoolean, (caddr_t)&defaultTRUE },
{"screenMirror", "ScreenMirror",  XtRBoolean, sizeof(Boolean),
	 XtOffsetOf(XtermWidgetRec, screen.mirror),
	 XtRBoolean, (caddr_t)&defaultTRUE },
{"keyboardMap", "KeyboardMap", XtRString, sizeof(char *),
	 XtOffsetOf(XtermWidgetRec, misc.hebKeyMap), XtRString,
	 DEFKEYBOARDMAP},
#endif
};

static void VTClassInit();
static void VTInitialize();
static void VTRealize();
static void VTExpose();
static void VTResize();
static void VTNonMaskableEvent();
static void VTDestroy();
static Boolean VTSetValues();
static set_character_class();

static WidgetClassRec xtermClassRec = {
  {
/* core_class fields */	
    /* superclass	  */	(WidgetClass) &widgetClassRec,
    /* class_name	  */	"VT100",
    /* widget_size	  */	sizeof(XtermWidgetRec),
    /* class_initialize   */    VTClassInit,
    /* class_part_initialize */ NULL,
    /* class_inited       */	FALSE,
    /* initialize	  */	VTInitialize,
    /* initialize_hook    */    NULL,				
    /* realize		  */	VTRealize,
    /* actions		  */	actionsList,
    /* num_actions	  */	XtNumber(actionsList),
    /* resources	  */	resources,
    /* num_resources	  */	XtNumber(resources),
    /* xrm_class	  */	NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	FALSE,
    /* compress_enterleave */   TRUE,
    /* visible_interest	  */	FALSE,
    /* destroy		  */	VTDestroy,
    /* resize		  */	VTResize,
    /* expose		  */	VTExpose,
    /* set_values	  */	VTSetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    NULL,
    /* get_values_hook    */    NULL,
    /* accept_focus	  */	NULL,
    /* version            */    XtVersion,
    /* callback_offsets   */    NULL,
    /* tm_table           */    defaultTranslations,
    /* query_geometry     */    XtInheritQueryGeometry,
    /* display_accelerator*/    XtInheritDisplayAccelerator,
    /* extension          */    NULL
  }
};

extern Atom wm_delete_window;	/* for ICCCM delete window */

static String xterm_trans =
    "<ClientMessage>WM_PROTOCOLS: DeleteWindow()\n\
     <MappingNotify>: KeyboardMapping()\n";

WidgetClass xtermWidgetClass = (WidgetClass)&xtermClassRec;


int VTInit()
{
	register TScreen *screen = &term->screen;
	Widget vtparent = term->core.parent;

	XtRealizeWidget (vtparent);
	XtOverrideTranslations(vtparent, XtParseTranslationTable(xterm_trans));
	(void)XSetWMProtocols(XtDisplay(vtparent), XtWindow(vtparent),
			      &wm_delete_window, 1);

	if(screen->allbuf == NULL)
		VTallocbuf();
	return 1;
}

VTallocbuf()
{
	register TScreen *screen = &term->screen;
	int nrows = screen->max_row + 1;
	extern ScrnBuf Allocate();

	/* allocate screen buffer now, if necessary. */
	if (screen->scrollWidget)
		nrows += screen->savelines;
	screen->allbuf = Allocate (nrows, screen->max_col + 1,
				   &screen->sbuf_address);
	if (screen->scrollWidget)
		screen->buf = &screen->allbuf[2 * screen->savelines];
	else
		screen->buf = screen->allbuf;
	return;
}

static void VTClassInit ()
{
	XtAddConverter(XtRString, XtRGravity, XmuCvtStringToGravity,
		       (XtConvertArgList) NULL, (Cardinal) 0);
}


/* ARGSUSED */
static void VTInitialize(wrequest, wnew, args, num_args)
Widget		wrequest, wnew;
ArgList		args;
Cardinal	*num_args;
{
	XtermWidget request = (XtermWidget)wrequest;
	XtermWidget new     = (XtermWidget)wnew;
	TScreen		*news = &new->screen;
	TScreen		*reqs = &request->screen;

	int i;

	/* Zero out the entire "screen" component of "new" widget,
	   then do field-by-field assigment of "screen" fields
	   that are named in the resource list.
	   */

	bzero((char *)news, sizeof(new->screen));

	news->c132 =  reqs->c132;
	news->curses =  reqs->curses;
	news->foreground =  reqs->foreground;
	news->cursorcolor =  reqs->cursorcolor;
	news->border =  reqs->border;
	news->jumpscroll =  reqs->jumpscroll;
	news->logfile =  reqs->logfile;
	news->marginbell =  reqs->marginbell;
	news->mousecolor =  reqs->mousecolor;
	news->mousecolorback =  reqs->mousecolorback;
	news->multiscroll =  reqs->multiscroll;
	news->nmarginbell =  reqs->nmarginbell;
	news->savelines =  reqs->savelines;
	news->scrolllines =  reqs->scrolllines;
	news->scrollttyoutput =  reqs->scrollttyoutput;
	news->scrollkey =  reqs->scrollkey;
	news->visualbell =  reqs->visualbell;
	news->TekEmu =  reqs->TekEmu;
	new->misc.re_verse = request->misc.re_verse;
	news->multiClickTime =  reqs->multiClickTime;
	news->bellSuppressTime =  reqs->bellSuppressTime;
	news->charClass =  reqs->charClass;
	news->cutNewline =  reqs->cutNewline;
	news->cutToBeginningOfLine =  reqs->cutToBeginningOfLine;
	news->always_highlight =  reqs->always_highlight;
	news->pointer_cursor =  reqs->pointer_cursor;
	news->input_eight_bits =  reqs->input_eight_bits;
	news->output_eight_bits =  reqs->output_eight_bits;
	news->allowSendEvents =  reqs->allowSendEvents;
	new->misc.titeInhibit = request->misc.titeInhibit;
	for(i = fontMenu_font1; i <= fontMenu_lastBuiltin; i++)
		news->menu_font_names[i] =  reqs->menu_font_names[i];
	/* set default in realize proc */
	news->menu_font_names[fontMenu_fontdefault] = NULL;
	news->menu_font_names[fontMenu_fontescape] = NULL;
	news->menu_font_names[fontMenu_fontsel] = NULL;
	news->menu_font_number = fontMenu_fontdefault;
#ifdef HEBREW
	news->direction = reqs->direction;
	news->mirror = reqs->mirror;
	new->misc.hebKeyMap = request->misc.hebKeyMap;
#endif
	/*
	 * The definition of -rv now is that it changes the definition of 
	 * XtDefaultForeground and XtDefaultBackground.  So, we no longer
	 * need to do anything special.
	 */
	new->keyboard.flags = 0;
	news->display = new->core.screen->display;
	new->core.height = new->core.width = 1;
	/* dummy values so that we don't try to Realize the parent shell 
	   with height or width of 0, which is illegal in X.  The real
	   size is computed in the xtermWidget's Realize proc,
	   but the shell's Realize proc is called first, and must see
	   a valid size. */

	/* look for focus related events on the shell, because we need
	 * to care about the shell's border being part of our focus.
	 */
	XtAddEventHandler(XtParent(new), EnterWindowMask, FALSE,
			  HandleEnterWindow, (Opaque)NULL);
	XtAddEventHandler(XtParent(new), LeaveWindowMask, FALSE,
			  HandleLeaveWindow, (Opaque)NULL);
	XtAddEventHandler(XtParent(new), FocusChangeMask, FALSE,
			  HandleFocusChange, (Opaque)NULL);
	XtAddEventHandler((Widget)new, 0L, TRUE,
			  VTNonMaskableEvent, (Opaque)NULL);
	XtAddEventHandler((Widget)new, PropertyChangeMask, FALSE,
			  HandleBellPropertyChange, (Opaque)NULL);
	news->bellInProgress = FALSE;

	set_character_class (news->charClass);

	/* create it, but don't realize it */
	ScrollBarOn (new, TRUE, FALSE);

	/* make sure that the resize gravity acceptable */
	if(new->misc.resizeGravity != NorthWestGravity &&
	   new->misc.resizeGravity != SouthWestGravity) {
		extern XtAppContext app_con;
		Cardinal nparams = 1;

		XtAppWarningMsg(app_con,
				"rangeError", "resizeGravity", "XTermError",
				"unsupported resizeGravity resource value (%d)",
				(String *)&(new->misc.resizeGravity), &nparams);
		new->misc.resizeGravity = SouthWestGravity;
	}
}

static void VTDestroy(w)
Widget w;
{
	XtFree(((XtermWidget)w)->screen.selection);
}

static void VTRealize(w, valuemask, values)
Widget			w;
XtValueMask		*valuemask;
XSetWindowAttributes	*values;
{
	unsigned int width, height;
	TScreen *screen = &term->screen;
	int xpos, ypos, pr;
	XSizeHints		sizehints;
	int scrollbar_width;

	TabReset (term->tabs);

	screen->menu_font_names[fontMenu_fontdefault] = term->misc.f_n;
	screen->fnt_norm = screen->fnt_bold = NULL;
	if(!LoadNewFont(screen, term->misc.f_n, term->misc.f_b, False, 0)) {
		if(XmuCompareISOLatin1(term->misc.f_n, "fixed") != 0) {
			fprintf(stderr, 
				 "%s:  unable to open font \"%s\", trying \"fixed\"....\n",
				xterm_name, term->misc.f_n);
			(void) LoadNewFont(screen, "fixed", NULL, False, 0);
			screen->menu_font_names[fontMenu_fontdefault] = "fixed";
		}
	}

	/* really screwed if we couldn't open default font */
	if(!screen->fnt_norm) {
		fprintf(stderr, "%s:  unable to locate a suitable font\n",
			 xterm_name);
		Exit(1);
	}

	/* making cursor */
	if(!screen->pointer_cursor) 
		screen->pointer_cursor =
			make_colored_cursor(XC_xterm, 
					    screen->mousecolor,
					    screen->mousecolorback);
	else 
		recolor_cursor(screen->pointer_cursor, 
			       screen->mousecolor, screen->mousecolorback);

	scrollbar_width = (term->misc.scrollbar ?
			   screen->scrollWidget->core.width
			   /* + screen->scrollWidget->core.border_width */: 0);

	/* set defaults */
	xpos = ypos = 1;
	width = 80; height = 24;
	pr = XParseGeometry(term->misc.geo_metry, &xpos, &ypos,
			    &width, &height);
	screen->max_col = (width - 1);	/* units in character cells */
	screen->max_row = (height - 1);	/* units in character cells */
	update_font_info(&term->screen, False);

	width = screen->fullVwin.fullwidth;
	height = screen->fullVwin.fullheight;

	if((pr & XValue) && (XNegative&pr)) 
		xpos += DisplayWidth(screen->display,
				     DefaultScreen(screen->display))
			- width - (term->core.parent->core.border_width * 2);
	if((pr & YValue) && (YNegative&pr))
		ypos += DisplayHeight(screen->display,
				      DefaultScreen(screen->display))
			- height - (term->core.parent->core.border_width * 2);

	/* set up size hints for window manager; min 1 char by 1 char */
	sizehints.base_width = 2 * screen->border + scrollbar_width;
	sizehints.base_height = 2 * screen->border;
	sizehints.width_inc = FontWidth(screen);
	sizehints.height_inc = FontHeight(screen);
	sizehints.min_width = sizehints.base_width + sizehints.width_inc;
	sizehints.min_height = sizehints.base_height + sizehints.height_inc;
	sizehints.flags = (PBaseSize|PMinSize|PResizeInc);
	sizehints.x = xpos;
	sizehints.y = ypos;
	if((XValue&pr) || (YValue&pr)) {
		sizehints.flags |= USSize|USPosition;
		sizehints.flags |= PWinGravity;
		switch(pr & (XNegative | YNegative)) {
		case 0:
			sizehints.win_gravity = NorthWestGravity;
			break;
		case XNegative:
			sizehints.win_gravity = NorthEastGravity;
			break;
		case YNegative:
			sizehints.win_gravity = SouthWestGravity;
			break;
		default:
			sizehints.win_gravity = SouthEastGravity;
			break;
		}
	}
	else {
		/* set a default size, but do *not* set position */
		sizehints.flags |= PSize;
	}
	sizehints.width = width;
	sizehints.height = height;
	if((WidthValue&pr) || (HeightValue&pr)) 
		sizehints.flags |= USSize;
	else
		sizehints.flags |= PSize;

	(void) XtMakeResizeRequest((Widget) term,
				   (Dimension)width, (Dimension)height,
				   &term->core.width, &term->core.height);

	/* XXX This is bogus.  We are parsing geometries too late.  This
	 * is information that the shell widget ought to have before we get
	 * realized, so that it can do the right thing.
	 */
        if(sizehints.flags & USPosition)
		XMoveWindow(XtDisplay(term), term->core.parent->core.window,
			    sizehints.x, sizehints.y);

	XSetWMNormalHints(XtDisplay(term), term->core.parent->core.window,
			  &sizehints);
	XFlush(XtDisplay(term));	/* get it out to window manager */

	/*
	 | use ForgetGravity instead of SouthWestGravity because translating
	 | the Expose events for ConfigureNotifys is too hard
	 */
	values->bit_gravity = term->misc.resizeGravity == NorthWestGravity ?
		NorthWestGravity : ForgetGravity;
	term->screen.fullVwin.window = term->core.window =
		XCreateWindow(XtDisplay(term), XtWindow(term->core.parent),
			      term->core.x, term->core.y,
			      term->core.width, term->core.height,
			      term->core.border_width,
			      (int) term->core.depth,
			      InputOutput, CopyFromParent,	
			      *valuemask|CWBitGravity, values);

	set_cursor_gcs(screen);

	/* Reset variables used by ANSI emulation. */

	screen->gsets[0] = 'B';			/* ASCII_G		*/
	screen->gsets[1] = 'B';
	screen->gsets[2] = 'B';			/* DEC supplemental.	*/
	screen->gsets[3] = 'B';
	screen->curgl = 0;			/* G0 => GL.		*/
	screen->curgr = 2;			/* G2 => GR.		*/
	screen->curss = 0;			/* No single shift.	*/

	XDefineCursor(screen->display, VShellWindow, screen->pointer_cursor);
	screen->max_col = Width(screen)/screen->fullVwin.f_width - 1;
	screen->cur_row = screen->sc.row = 0;
#ifdef HEBREW
        screen->cur_col = screen->sc.col = screen->max_col;
#else
	screen->cur_col = screen->sc.col = 0;
#endif
	screen->top_marg = 0;
	screen->bot_marg = screen->max_row =
		Height(screen) / screen->fullVwin.f_height - 1;

	screen->sc.flags = 0;

	/* Mark screen buffer as unallocated.  We wait until the run loop so
	   that the child process does not fork and exec with all the dynamic
	   memory it will never use.  If we were to do it here, the
	   swap space for new process would be huge for huge savelines. */
	if (!tekWidget)
		/* if not called after fork */
		screen->buf = screen->allbuf = NULL;

	screen->do_wrap = 0;
	screen->scrolls = screen->incopy = 0;
	set_vt_box (screen);

	screen->savedlines = 0;

	if(term->misc.scrollbar) {
		screen->scrollbar = 0;
		ScrollBarOn(term, FALSE, TRUE);
	}
	saveRestoreCursor(TRUE);

	vtInitModes();

	return;
}

static Boolean VTSetValues(cur, request, new, args, num_args)
Widget cur, request, new;
ArgList args;
Cardinal *num_args;
{
	XtermWidget curvt = (XtermWidget) cur;
	XtermWidget newvt = (XtermWidget) new; 
	Boolean refresh_needed = FALSE;
	Boolean fonts_redone = FALSE;

	if(curvt->core.background_pixel != newvt->core.background_pixel ||
	   curvt->screen.foreground != newvt->screen.foreground ||
	   curvt->screen.menu_font_names[curvt->screen.menu_font_number] !=
	   newvt->screen.menu_font_names[newvt->screen.menu_font_number] ||
	   curvt->misc.f_n != newvt->misc.f_n) {
		if(curvt->misc.f_n != newvt->misc.f_n)
			newvt->screen.menu_font_names[fontMenu_fontdefault] =
				newvt->misc.f_n;
		if(LoadNewFont(&newvt->screen,
			       newvt->screen.menu_font_names[curvt->screen.menu_font_number],
			       newvt->screen.menu_font_names[curvt->screen.menu_font_number],
			       TRUE, newvt->screen.menu_font_number)) {
			/* resizing does the redisplay, so don't ask for it here */
			refresh_needed = TRUE;
			fonts_redone = TRUE;
		} else
		if(curvt->misc.f_n != newvt->misc.f_n)
			newvt->screen.menu_font_names[fontMenu_fontdefault] =
				curvt->misc.f_n;
	}
	if(!fonts_redone &&
	   curvt->screen.cursorcolor != newvt->screen.cursorcolor) {
		set_cursor_gcs(&newvt->screen);
		refresh_needed = TRUE;
	}
	if(curvt->misc.re_verse != newvt->misc.re_verse) {
		newvt->vt_mode ^= M_DECSCN;
		ReverseVideo(newvt);
		/* ReverseVideo toggles */
		newvt->misc.re_verse = !newvt->misc.re_verse;
		refresh_needed = TRUE;
	}
	if(curvt->screen.mousecolor != newvt->screen.mousecolor ||
	   curvt->screen.mousecolorback != newvt->screen.mousecolorback) {
		recolor_cursor (newvt->screen.pointer_cursor, 
				newvt->screen.mousecolor,
				newvt->screen.mousecolorback);
		refresh_needed = TRUE;
	}
	if(curvt->misc.scrollbar != newvt->misc.scrollbar) {
		if(newvt->misc.scrollbar)
			ScrollBarOn(newvt, FALSE, FALSE);
		else
			ScrollBarOff(&newvt->screen);
		update_scrollbar();
	}

	return refresh_needed;
}

/*
 * set_character_class - takes a string of the form
 * 
 *                 low[-high]:val[,low[-high]:val[...]]
 * 
 * and sets the indicated ranges to the indicated values.
 */
static set_character_class(str)
char	*str;
{
	int	acc;		/* accumulator */
	int	low, high;	/* bounds of range [0..127] */
	int	numbers;	/* count of numbers per range */
	int	digits;		/* count of digits in a number */
	char	*p, c;
	static char *errfmt = "%s:  %s in range string \"%s\" (position %d)\n";
	extern char *ProgramName;

	if((p = str) == 0)
		return -1;
restart:
	low = high = -1;	/* out of range */
	acc = numbers = digits = 0;

	for(;;) {
		if(isspace(c = *p++))
			continue;
		switch(c) {
		default:
			if(isdigit(c)) {
				acc = acc * 10 + (c - '0');
				digits++;
				break;
			}
			fprintf(stderr, errfmt, ProgramName,
				"bad character", str, p - str);
			return -1;

		case '-':
			low = acc;
			acc = 0;
			if(digits == 0) {
				fprintf(stderr, errfmt, ProgramName,
					"missing number", str, p - str);
				return -1;
			}
			digits = 0;
			numbers++;
			break;
		case ':':
			if(numbers == 0)
				low = acc;
			else
			if(numbers == 1)
				high = acc;
			else {
				fprintf(stderr, errfmt, ProgramName,
					"too many numbers", str, p - str);
				return -1;
			}
			digits = acc = 0;
			numbers++;
			break;
		case 0:
		case ',':
			/*
			 | now, process it
			 */
			if(high < 0) {
				high = low;
				numbers++;
			}
			if(numbers != 2) {
				fprintf(stderr, errfmt, ProgramName,
					"bad value number", str, p - str);
			} else
			if(SetCharacterClassRange(low, high, acc) != 0)
				fprintf(stderr, errfmt, ProgramName,
					"bad range", str, p - str);
			if(c != 0)
				goto restart;
			else
				return 0;
		}

	}
}

/* ARGSUSED */
static void HandleBell(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* [0] = volume */
Cardinal *param_count;	/* 0 or 1 */
{
	int percent = (*param_count) ? atoi(params[0]) : 0;

	XBell(XtDisplay(w), percent);
}

/* ARGSUSED */
static void HandleVisualBell(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
	VisualBell();
}

/* ARGSUSED */
static void HandleIgnore(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
	/* do nothing, but check for funny escape sequences */
	(void) SendMousePosition(w, event);
}



/*ARGSUSED*/
static void VTExpose(w, event, region)
Widget w;
XEvent *event;
Region region;
{
	TScreen *screen = &term->screen;

#ifdef DEBUG
	if(debug)
		fputs("Expose\n", stderr);
#endif	/* DEBUG */
	if (event->type == Expose)
		HandleExposure (screen, event);
}

static void VTGraphicsOrNoExpose (event)
XEvent *event;
{
	TScreen *screen = &term->screen;

	if(screen->incopy <= 0) {
		screen->incopy = 1;
		if(screen->scrolls > 0)
			screen->scrolls--;
	}
	if(event->type == GraphicsExpose)
		if(HandleExposure (screen, event))
			screen->cursor_state = OFF;
	if((event->type == NoExpose) ||
	   ((XGraphicsExposeEvent *)event)->count == 0) {
		if(screen->incopy <= 0 && screen->scrolls > 0)
			screen->scrolls--;
		if(screen->scrolls)
			screen->incopy = -1;
		else
			screen->incopy = 0;
	}
}

static void VTResize(w)
Widget w;
{
	if(XtIsRealized(w))
		ScreenResize(&term->screen, term->core.width,
			     term->core.height, &term->vt_mode);
}

/*ARGSUSED*/
static void VTNonMaskableEvent (w, closure, event, cont)
Widget w;			/* unused */
XtPointer closure;		/* unused */
XEvent *event;
Boolean *cont;			/* unused */
{
	switch (event->type) {
	case GraphicsExpose:
	case NoExpose:
		VTGraphicsOrNoExpose(event);
		break;
	}
}


/* ARGSUSED */
static void HandleKeymapChange(w, event, params, param_count)
Widget w;
XEvent *event;
String *params;
Cardinal *param_count;
{
	static XtTranslations keymap, original;
	static XtResource key_resources[] = {
		{ XtNtranslations, XtCTranslations, XtRTranslationTable,
			  sizeof(XtTranslations), 0, XtRTranslationTable,
			  (caddr_t)NULL}
	};
	char mapName[1000];
	char mapClass[1000];

	if(*param_count != 1)
		return;
	if(original == NULL)
		original = w->core.tm.translations;

	if(strcmp(params[0], "None") == 0) {
		XtOverrideTranslations(w, original);
		return;
	}
	(void) sprintf( mapName, "%sKeymap", params[0] );
	(void) strcpy( mapClass, mapName );
	if(islower(mapClass[0])) mapClass[0] = toupper(mapClass[0]);
	XtGetSubresources( w, (XtPointer)&keymap, mapName, mapClass,
			  key_resources, (Cardinal)1, NULL, (Cardinal)0 );
	if(keymap != NULL)
		XtOverrideTranslations(w, keymap);
}
