/*
 *	$XConsortium: input.c,v 1.16 91/05/10 16:57:16 gildea Exp $
 */

/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.
 *
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* input.c */

#include "ptyx.h"		/* gets Xt headers, too */
#include "screen.h"
#include "vtdefs.h"
#ifdef HEBREW
#define XK_HEBREW
#endif
#include <X11/keysym.h>
#include <X11/DECkeysym.h>
#include <X11/Xutil.h>
#include <stdio.h>

static XComposeStatus compose_status = {NULL, 0};
static char *kypd_num = " XXXXXXXX\tXXX\rXXXxxxxXXXXXXXXXXXXXXXXXXXXX*+,-./0123456789XXX=";
static char *kypd_apl = " ABCDEFGHIJKLMNOPQRSTUVWXYZ??????abcdefghijklmnopqrstuvwxyzXXX";
static char *cur = "DACB";
#ifdef HEBREW
static char *hcur= "CADB";
#endif
static int funcvalue(), sunfuncvalue();
extern Boolean sunFunctionKeys;

typedef struct {
	unsigned char	a_type;
	unsigned char	a_pintro;
	unsigned char	a_final;
	unsigned char	a_inters;
	char	a_nparam;		/* # of parameters		*/
	char	a_dflt[NPARAM];		/* Default value flags		*/
	short	a_param[NPARAM];	/* Parameters			*/
	char	a_nastyf;		/* Error flag			*/
} ANSI;

static unparseseq();
static unparseputn();
static unparseputc();
static hebKmap();

static void AdjustAfterInput (screen)
TScreen *screen;
{
	if(screen->scrollkey && screen->topline != 0)
		WindowScroll(screen, 0);
	if(screen->marginbell) {
		int col = screen->max_col - screen->nmarginbell;
		if(screen->bellarmed >= 0) {
			if(screen->bellarmed == screen->cur_row) {
				if(screen->cur_col >= col) {
					Bell();
					screen->bellarmed = -1;
				}
			} else
				screen->bellarmed = screen->cur_col < col?
					screen->cur_row: -1;
		} else
		if(screen->cur_col < col)
			screen->bellarmed = screen->cur_row;
	}
}

#ifdef HEBREW
#define IsHebrewKey(k) (((k) < 0xcff) && ((k) > 0xc00))
#endif

Input(keyboard, screen, event, eightbit)
TKeyboard	*keyboard;
TScreen		*screen;
XKeyEvent	*event;
Bool		eightbit;
{
#define STRBUFSIZE 100

	char	strbuf[STRBUFSIZE];
	char	*bp = strbuf;
	int	key = TRUE;
	int	pty = screen->respond;
	int	nbytes, free;
	KeySym  keysym;
	ANSI	reply;
	XEvent	ev;

	free = sizeof(strbuf);
	nbytes = XLookupString(event, bp, free, &keysym, &compose_status);
	/*
	 | Make sure we get every keystroke available before we start doing
	 | the update, so can issue a single DrawString instead of several.
	 */
	bp += nbytes;
	while(free && XCheckMaskEvent(screen->display, KeyPressMask, &ev)) {
		int	count = XLookupString((XKeyEvent *)&ev, bp, free,
					      &keysym, &compose_status);
		bp += count;
		nbytes += count;
		free -= count;
	}
	bp = strbuf;
	bzero(&reply, sizeof(reply));

	if(IsPFKey(keysym)) {
		reply.a_type = SS3;
		unparseseq(&reply, pty);
		unparseputc((char)(keysym-XK_KP_F1+'P'), pty);
	} else
	if(IsKeypadKey(keysym)) {
	  	if(keyboard->flags & KYPD_APL)	{
			reply.a_type   = SS3;
			unparseseq(&reply, pty);
			unparseputc(kypd_apl[keysym-XK_KP_Space], pty);
		} else
			unparseputc(kypd_num[keysym-XK_KP_Space], pty);
        } else
	if(IsCursorKey(keysym) && keysym != XK_Prior && keysym != XK_Next) {
		char c;
		extern XtermWidget	term;

#ifdef HEBREW
		if(term->vt_mode & M_DECMIRROR)
			c = hcur[keysym-XK_Left];
		else
#endif
			c = cur[keysym-XK_Left];
       		if(keyboard->flags & CURSOR_APL) {
			reply.a_type = SS3;
			unparseseq(&reply, pty);
			unparseputc(c, pty);
		}
		else {
			reply.a_type = CSI;
			reply.a_final = c;
			unparseseq(&reply, pty);
		}
	} else
	if(IsFunctionKey(keysym) || IsMiscFunctionKey(keysym) ||
	   keysym == XK_Prior || keysym == XK_Next || keysym == DXK_Remove) {
		reply.a_type = CSI;
		reply.a_nparam = 1;
		if(sunFunctionKeys) {
			reply.a_param[0] = sunfuncvalue(keysym);
			reply.a_final = 'z';
		}
		else {
			reply.a_param[0] = funcvalue(keysym);
			reply.a_final = '~';
		}
		if(reply.a_param[0] > 0)
			unparseseq(&reply, pty);
	} else
	if(nbytes > 0) {
		if(screen->TekGIN) {
			TekEnqMouse(*bp++);
			TekGINoff();
			nbytes--;
		}
		if((nbytes == 1) && eightbit) {
			if(screen->input_eight_bits)
				*bp |= 0x80;/* turn on eighth bit */
			else
				unparseputc(033, pty);  /* escape */
		}
		while(nbytes-- > 0)
			unparseputc(*bp++, pty);
	} else
		key = FALSE;

	if(key && !screen->TekEmu)
	        AdjustAfterInput(screen);
#ifdef ENABLE_PRINT
	if(keysym == XK_F2)
		TekPrint();
#endif
	return;
}

StringInput(screen, string, nbytes)
TScreen	*screen;
char *string;
int nbytes;
{
	int	pty = screen->respond;

	if(nbytes && screen->TekGIN) {
		TekEnqMouse(*string++);
		TekGINoff();
		nbytes--;
	}
	while(nbytes-- > 0)
		unparseputc(*string++, pty);
	if(!screen->TekEmu)
	        AdjustAfterInput(screen);
}

static unparseseq(ap, fd)
ANSI	*ap;
int	fd;
{
	int	c;
	int	i;
	int	inters;

	c = ap->a_type;
	if(c>=0x80 && c<=0x9F) {
		unparseputc(ESC, fd);
		c -= 0x40;
	}
	unparseputc(c, fd);
	c = ap->a_type;
	if(c==ESC || c==DCS || c==CSI || c==OSC || c==PM || c==APC) {
		if(ap->a_pintro != 0)
			unparseputc((char) ap->a_pintro, fd);
		for(i=0; i<ap->a_nparam; ++i) {
			if (i != 0)
				unparseputc(';', fd);
			unparseputn((unsigned int) ap->a_param[i], fd);
		}
		inters = ap->a_inters;
		for(i=3; i>=0; --i) {
			c = (inters >> (8*i)) & 0xff;
			if(c != 0)
				unparseputc(c, fd);
		}
		unparseputc((char) ap->a_final, fd);
	}
}

static unparseputn(n, fd)
unsigned int	n;
int fd;
{
	unsigned int	q;

	q = n/10;
	if (q != 0)
		unparseputn(q, fd);
	unparseputc((char)('0' + (n%10)), fd);
}

#ifdef HEBREW
static u_char hebKeyMapSTD[] = {
	XK_hebrew_shin,		/* a */
	XK_hebrew_nun,		/* b */
	XK_hebrew_bet,		/* c */
	XK_hebrew_gimel,	/* d */
	XK_hebrew_qoph,		/* e */
	XK_hebrew_kaph,		/* f */
	XK_hebrew_ayin,		/* g */
	XK_hebrew_yod,		/* h */
	XK_hebrew_finalnun,	/* i */
	XK_hebrew_chet,		/* j */
	XK_hebrew_lamed,	/* k */
	XK_hebrew_finalkaph,	/* l */
	XK_hebrew_zade,		/* m */
	XK_hebrew_mem,		/* n */
	XK_hebrew_finalmem,	/* o */
	XK_hebrew_pe,		/* p */
	0,			/* q */
	XK_hebrew_resh,		/* r */
	XK_hebrew_dalet,	/* s */
	XK_hebrew_aleph,	/* t */
	XK_hebrew_waw,		/* u */
	XK_hebrew_he,		/* v */
	0,			/* w */
	XK_hebrew_samech,	/* x */
	XK_hebrew_tet,		/* y */
	XK_hebrew_zain,		/* z */
};

static u_char hebKeyMap[256];

initHebKeyMap()
{
	u_char	*p;
	extern XtermWidget	term;

	bzero(hebKeyMap, sizeof(hebKeyMap));
	/*
	 | first copy the 'standard' part of the keyboard
	 */
	bcopy(hebKeyMapSTD, &hebKeyMap['a'], 'z' - 'a' + 1);

	hebKeyMap[','] = XK_hebrew_taw;
	hebKeyMap['.'] = XK_hebrew_finalzade;
	hebKeyMap[';'] = XK_hebrew_finalpe;

	for(p = term->misc.hebKeyMap; *p && p[1]; p += 2)
		hebKeyMap[*p] = p[1];
}

#define IsHebChar(c)	(((c) >= '`') && ((c) <= 'z'))

#endif

static unparseputc(c, fd)
char c;
int fd;
{
	char	buf[2];
	int	i = 1;
	extern XtermWidget term;

	if((buf[0] = c) == '\r' && (term->vt_mode & M_LN)) {
		buf[1] = '\n';
		i++;
	}
#ifdef HEBREW
	else
	if(term->vt_mode & M_DECHEB) {
		char	hc;

		if(term->screen.globalKeyMap == 0) {
			if(hc = hebKeyMap[c])
				*buf = hc;
		} else
		if(IsHebChar(*buf))
			*buf |= 0x80;
	}
#endif
	v_write(fd, buf, i);
}

static int funcvalue(keycode)
int keycode;
{
	switch(keycode) {
	case XK_F1:	return 11;
	case XK_F2:	return 12;
	case XK_F3:	return 13;
	case XK_F4:	return 14;
	case XK_F5:	return 15;
	case XK_F6:	return 17;
	case XK_F7:	return 18;
	case XK_F8:	return 19;
	case XK_F9:	return 20;
	case XK_F10:	return 21;
	case XK_F11:	return 23;
	case XK_F12:	return 24;
	case XK_F13:	return 25;
	case XK_F14:	return 26;
	case XK_F15:	return 28;
	case XK_Help:	return 28;
	case XK_F16:	return 29;
	case XK_Menu:	return 29;
	case XK_F17:	return 31;
	case XK_F18:	return 32;
	case XK_F19:	return 33;
	case XK_F20:	return 34;

	case XK_Find :	return 1;
	case XK_Insert:	return 2;
	case XK_Delete:	return 3;
	case DXK_Remove: return 3;
	case XK_Select:	return 4;
	case XK_Prior:	return 5;
	case XK_Next:	return 6;
	default:	return -1;
	}
}


static int sunfuncvalue(keycode)
int keycode;
{
  	switch(keycode) {
	case XK_F1:	return 224;
	case XK_F2:	return 225;
	case XK_F3:	return 226;
	case XK_F4:	return 227;
	case XK_F5:	return 228;
	case XK_F6:	return 229;
	case XK_F7:	return 230;
	case XK_F8:	return 231;
	case XK_F9:	return 232;
	case XK_F10:	return 233;
	case XK_F11:	return 192;
	case XK_F12:	return 193;
	case XK_F13:	return 194;
	case XK_F14:	return 195;
	case XK_F15:	return 196;
	case XK_Help:	return 196;
	case XK_F16:	return 197;
	case XK_Menu:	return 197;
	case XK_F17:	return 198;
	case XK_F18:	return 199;
	case XK_F19:	return 200;
	case XK_F20:	return 201;

	case XK_R1:	return 208;
	case XK_R2:	return 209;
	case XK_R3:	return 210;
	case XK_R4:	return 211;
	case XK_R5:	return 212;
	case XK_R6:	return 213;
	case XK_R7:	return 214;
	case XK_R8:	return 215;
	case XK_R9:	return 216;
	case XK_R10:	return 217;
	case XK_R11:	return 218;
	case XK_R12:	return 219;
	case XK_R13:	return 220;
	case XK_R14:	return 221;
	case XK_R15:	return 222;
  
	case XK_Find :	return 1;
	case XK_Insert:	return 2;
	case XK_Delete:	return 3;
	case DXK_Remove: return 3;
	case XK_Select:	return 4;
	case XK_Prior:	return 5;
	case XK_Next:	return 6;

	default:	return -1;
	}
}


/* helen */
SendToHost(text)
char *text;
{
	extern	XtermWidget term;
	TScreen	*screen = &term->screen;
	int	pty = screen->respond;

	while(*text)
		unparseputc(*text++, pty);
}
