#ifndef lint
static char *rcsid=
	"$Id";
#endif
/*
 * 				 W A R N I N G
 * 
 * If you think you know what all of this code is doing, you are
 * probably very mistaken.  There be serious and nasty dragons here.
 *
 */

#define ttyslot() 1
#include "ptyx.h"
#include "screen.h"
#include "data.h"
#include "error.h"
#include "menu.h"
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/SimpleMenu.h>
#include <pwd.h>
#include <ctype.h>

#include "pty.h"

extern char *strindex();

extern char	*ProgramName;
extern Atom	wm_delete_window;    /* for ICCCM delete window */

#ifdef HEBREW
Atom	KEYMAP;
#endif

extern Widget	toplevel;

int switchfb[] = {0, 2, 1, 3};

SIGNAL_T reapchild();

static Bool added_utmp_entry = False;

static int parse_tty_modes();
static doChildHandShake();
static doUtmp();
static doExec();

/*
 * SYSV has the termio.c_cc[V] and ltchars; BSD has tchars and ltchars;
 * SVR4 has only termio.c_cc, but it includes everything from ltchars.
 */
static int override_tty_modes = 0;
struct _xttymodes {
	char *name;
	int len;
	int set;
	char value;
} ttymodelist[] = {
	{ "intr", 4, 0, '\0' },		/* tchars.t_intrc ; VINTR */
#define XTTYMODE_intr 0
	{ "quit", 4, 0, '\0' },		/* tchars.t_quitc ; VQUIT */
#define XTTYMODE_quit 1
	{ "erase", 5, 0, '\0' },	/* sgttyb.sg_erase ; VERASE */
#define XTTYMODE_erase 2
	{ "kill", 4, 0, '\0' },		/* sgttyb.sg_kill ; VKILL */
#define XTTYMODE_kill 3
	{ "eof", 3, 0, '\0' },		/* tchars.t_eofc ; VEOF */
#define XTTYMODE_eof 4
	{ "eol", 3, 0, '\0' },		/* VEOL */
#define XTTYMODE_eol 5
	{ "swtch", 5, 0, '\0' },	/* VSWTCH */
#define XTTYMODE_swtch 6
	{ "start", 5, 0, '\0' },	/* tchars.t_startc */
#define XTTYMODE_start 7
	{ "stop", 4, 0, '\0' },		/* tchars.t_stopc */
#define XTTYMODE_stop 8
	{ "brk", 3, 0, '\0' },		/* tchars.t_brkc */
#define XTTYMODE_brk 9
	{ "susp", 4, 0, '\0' },		/* ltchars.t_suspc ; VSUSP */
#define XTTYMODE_susp 10
	{ "dsusp", 5, 0, '\0' },	/* ltchars.t_dsuspc ; VDSUSP */
#define XTTYMODE_dsusp 11
	{ "rprnt", 5, 0, '\0' },	/* ltchars.t_rprntc ; VREPRINT */
#define XTTYMODE_rprnt 12
	{ "flush", 5, 0, '\0' },	/* ltchars.t_flushc ; VDISCARD */
#define XTTYMODE_flush 13
	{ "weras", 5, 0, '\0' },	/* ltchars.t_werasc ; VWERASE */
#define XTTYMODE_weras 14
	{ "lnext", 5, 0, '\0' },	/* ltchars.t_lnextc ; VLNEXT */
#ifdef HEBREW
#define XTTYMODE_pass8 15
	{ "pass8", 5, 0, 0 },
#define XTTYMODE_lnext 16
#else
#define XTTYMODE_lnext 15
#endif
	{ NULL, 0, 0, '\0' },		/* end of data */
};

static jmp_buf env;

#ifdef USE_SYSV_TERMIO
/* The following structures are initialized in main() in order
** to eliminate any assumptions about the internal order of their
** contents.
*/
static struct termio d_tio;
#ifdef TIOCSLTC
static struct ltchars d_ltc;
#endif
#ifdef TIOCLSET
static unsigned int d_lmode;
#endif
#else /* not USE_SYSV_TERMIO */
static struct  sgttyb d_sg = {
        0, 0, 0177, CKILL, EVENP|ODDP|ECHO|XTABS|CRMOD
};
static struct  tchars d_tc = {
        CINTR, CQUIT, CSTART, CSTOP, CEOF, CBRK,
};
static struct  ltchars d_ltc = {
        CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};
static int	d_disipline = NTTYDISC;
static long int d_lmode = LCRTBS|LCRTERA|LCRTKIL|LCTLECH;
#ifdef sony
static long int d_jmode = KM_SYSSJIS|KM_ASCII;
static struct jtchars d_jtc = {
	'J', 'B'
};
#endif /* sony */
#endif /* USE_SYSV_TERMIO */

#ifdef USE_SYSV_UTMP

#ifndef SVR4			/* otherwise declared in utmp.h */
extern struct utmp *getutent();
extern struct utmp *getutid();
extern struct utmp *getutline();
extern void pututline();
extern void setutent();
extern void endutent();
extern void utmpname();
#endif /* !SVR4 */

#ifndef SYSV386			/* could remove paragraph unconditionally? */
extern struct passwd *getpwent();
extern struct passwd *getpwuid();
extern struct passwd *getpwnam();
extern void setpwent();
extern void endpwent();
static Bool IsPts = False;
#endif
extern struct passwd *fgetpwent();
#else	/* not USE_SYSV_UTMP */

static char etc_utmp[] = UTMP_FILENAME;
#ifdef LASTLOG
static char etc_lastlog[] = LASTLOG_FILENAME;
#endif 
#endif	/* USE_SYSV_UTMP */

#ifdef WTMP
static char etc_wtmp[] = WTMP_FILENAME;
#endif

/*
 * Some people with 4.3bsd /bin/login seem to like to use login -p -f user
 * to implement xterm -ls.  They can turn on USE_LOGIN_DASH_P and turn off
 * WTMP and LASTLOG.
 */
#ifdef USE_LOGIN_DASH_P
#ifndef LOGIN_FILENAME
#define LOGIN_FILENAME "/bin/login"
#endif
static char bin_login[] = LOGIN_FILENAME;
#endif

#ifdef TIOCCONS
static int Console;
#include <X11/Xmu/SysUtil.h>	/* XmuGetHostname */
#define MIT_CONSOLE_LEN	12
#define MIT_CONSOLE "MIT_CONSOLE_"
static char mit_console_name[255 + MIT_CONSOLE_LEN + 1] = MIT_CONSOLE;
static Atom mit_console;
#endif	/* TIOCCONS */

#ifndef USE_SYSV_UTMP
static int tslot;
#endif

#ifdef USE_HANDSHAKE
extern Bool waiting_for_initial_map;
static int pc_pipe[2];	/* this pipe is used for parent to child transfer */
static int cp_pipe[2];	/* this pipe is used for child to parent transfer */

typedef enum {		/* c == child, p == parent                        */
	PTY_BAD,	/* c->p: can't open pty slave for some reason     */
	PTY_FATALERROR,	/* c->p: we had a fatal error with the pty        */
	PTY_GOOD,	/* c->p: we have a good pty, let's go on          */
	PTY_NEW,	/* p->c: here is a new pty slave, try this        */
	PTY_NOMORE,	/* p->c; no more pty's, terminate                 */
	UTMP_ADDED,	/* c->p: utmp entry has been added                */
	UTMP_TTYSLOT,	/* c->p: here is my ttyslot                       */
	PTY_EXEC	/* p->c: window has been mapped the first time    */
} status_t;

typedef struct {
	status_t status;
	int error;
	int fatal_error;
	int tty_slot;
	int rows;
	int cols;
	char buffer[1024];
} handshake_t;
#endif /* USE_HANDSHAKE */

/*
 | this were local to spawn
 */
static int	discipline;
static char	**envnew;	/* new environment */
static int	envsize;	/* elements in new environment */
static char	termcap[1024];
static char	newtc[1024];
static char	*TermName;
static int	ldisc;
static struct passwd	*pw;

#ifdef USE_SYSV_TERMIO
static	struct termio	tio;
static	struct termio	dummy_tio;
static	char		*dev_tty_name;

#ifdef TIOCLSET
static	unsigned	lmode;
#endif
#ifdef TIOCSLTC
static	struct ltchars	ltc;
#endif
#else /* ! USE_SYSV_TERMIO */
static	unsigned	lmode;
static	struct tchars	tc;
static	struct ltchars	ltc;
static	struct sgttyb	sg;
#ifdef sony
static	int		jmode;
static	struct jtchars	jtc;
#endif
#endif	/* USE_SYSV_TERMIO */

#ifdef sun
#ifdef TIOCSSIZE
static	struct ttysize	ts;
#endif
#else /* ! sun */
#ifdef TIOCSWINSZ
static	struct winsize	ws;
#endif
#endif /* sun */

#ifdef UTMP
static	struct utmp	utmp;
#ifdef LASTLOG
static	struct lastlog	lastlog;
#endif
#endif /* UTMP */
/*
 | End of local to spawn
 */
SIGNAL_T Exit(n)
int n;
{
	TScreen *screen = &term->screen;
        int pty = term->screen.respond;  /* file descriptor of pty */
#ifdef UTMP
#ifdef USE_SYSV_UTMP
	struct utmp utmp;
	struct utmp *utptr;
	char *ptyname;
#ifdef WTMP
	int fd;			/* for /etc/wtmp */
	int i;
#endif
	/* cleanup the utmp entry we forged earlier */
	if (!resource.utmpInhibit
#ifdef USE_HANDSHAKE		/* without handshake, no way to know */
	    && added_utmp_entry
#endif /* USE_HANDSHAKE */
	    ) {
		ptyname = ttydev;
		utmp.ut_type = USER_PROCESS;
		strncpy(utmp.ut_id, ptyname + strlen(ptyname) - PTYCHARLEN,
			       sizeof(utmp.ut_id));
		setutent();
		utptr = getutid(&utmp);
		/* write it out only if it exists, and the pid's match */
		if (utptr && (utptr->ut_pid == screen->pid)) {
			utptr->ut_type = DEAD_PROCESS;
			utptr->ut_time = time((long *) 0);
			pututline(utptr);
#ifdef WTMP
			/* set wtmp entry if wtmp file exists */
			if ((fd = open(etc_wtmp, O_WRONLY | O_APPEND)) >= 0) {
				i = write(fd, utptr, sizeof(utmp));
				i = close(fd);
			}
#endif
		}
		endutent();
	}
#else	/* not USE_SYSV_UTMP */
	register int wfd;
	register int i;
	struct utmp utmp;

	if (!resource.utmpInhibit && added_utmp_entry &&
	    (!am_slave && tslot > 0 && (wfd = open(etc_utmp, O_WRONLY)) >= 0)){
		bzero((char *)&utmp, sizeof(struct utmp));
		lseek(wfd, (long)(tslot * sizeof(struct utmp)), 0);
		write(wfd, (char *)&utmp, sizeof(struct utmp));
		close(wfd);
#ifdef WTMP
		if (term->misc.login_shell &&
		    (wfd = open(etc_wtmp, O_WRONLY | O_APPEND)) >= 0) {
			strncpy(utmp.ut_line, ttydev +
			    sizeof("/dev"), sizeof (utmp.ut_line));
			time(&utmp.ut_time);
			i = write(wfd, (char *)&utmp, sizeof(struct utmp));
			i = close(wfd);
		}
#endif /* WTMP */
	}
#endif	/* USE_SYSV_UTMP */
#endif	/* UTMP */

        close(pty); /* close explicitly to avoid race with slave side */
	if(screen->logging)
		CloseLog(screen);

	if (!am_slave) {
		/* restore ownership of tty and pty */
		chown (ttydev, 0, 0);
#ifndef sgi
		chown (ptydev, 0, 0);
#endif /* !sgi */

		/* restore modes of tty and pty */
		chmod (ttydev, 0666);
#ifndef sgi
		chmod (ptydev, 0666);
#endif /* !sgi */
	}
	exit(n);
	SIGNAL_RETURN;
}

/* ARGSUSED */
static resize(screen, TermName, oldtc, newtc)
TScreen *screen;
char *TermName;
register char *oldtc, *newtc;
{
#ifndef USE_SYSV_ENVVARS
	register char *ptr1, *ptr2;
	register int i;
	register int li_first = 0;
	register char *temp;

	if ((ptr1 = strindex (oldtc, "co#")) == NULL){
		strcat (oldtc, "co#80:");
		ptr1 = strindex (oldtc, "co#");
	}
	if ((ptr2 = strindex (oldtc, "li#")) == NULL){
		strcat (oldtc, "li#24:");
		ptr2 = strindex (oldtc, "li#");
	}
	if(ptr1 > ptr2) {
		li_first++;
		temp = ptr1;
		ptr1 = ptr2;
		ptr2 = temp;
	}
	ptr1 += 3;
	ptr2 += 3;
	strncpy (newtc, oldtc, i = ptr1 - oldtc);
	newtc += i;
	sprintf (newtc, "%d", li_first ? screen->max_row + 1 :
		 screen->max_col + 1);
	newtc += strlen(newtc);
	ptr1 = index (ptr1, ':');
	strncpy (newtc, ptr1, i = ptr2 - ptr1);
	newtc += i;
	sprintf (newtc, "%d", li_first ? screen->max_col + 1 :
		 screen->max_row + 1);
	ptr2 = index (ptr2, ':');
	strcat (newtc, ptr2);
#endif /* USE_SYSV_ENVVARS */
}

/* ARGSUSED */
SIGNAL_T reapchild(n)
int n;
{
#ifdef USE_POSIX_WAIT
        pid_t pid;

	pid = waitpid(-1, NULL, WNOHANG);
	if (pid <= 0) {
#ifdef USE_SYSV_SIGNALS
		signal(SIGCHLD, reapchild);
#endif
		SIGNAL_RETURN;
	}
#else /* USE_POSIX_WAIT */
#if defined(USE_SYSV_SIGNALS) && (defined(CRAY) || !defined(SIGTSTP))
	int status, pid;

	pid = wait(&status);
	if (pid == -1) {
		signal(SIGCHLD, reapchild);
		SIGNAL_RETURN;
	}
#else
	union wait status;
	register int pid;
	
#ifdef DEBUG
	if (debug) fputs ("Exiting\n", stderr);
#endif
	pid  = wait3 (&status, WNOHANG, (struct rusage *)NULL);
	if (!pid) {
#ifdef USE_SYSV_SIGNALS
		signal(SIGCHLD, reapchild);
#endif
		SIGNAL_RETURN;
	}
#endif /* defined(USE_SYSV_SIGNALS) && !defined(SIGTSTP) */
#endif /* USE_POSIX_WAIT else */

#ifdef PUCC_PTYD
	closepty(ttydev, ptydev, (resource.utmpInhibit ?  OPTY_NOP : OPTY_LOGIN), Ptyfd);
#endif

	if (pid != term->screen.pid) {
#ifdef USE_SYSV_SIGNALS
		signal(SIGCHLD, reapchild);
#endif
		SIGNAL_RETURN;
	}
	
	/*
	 * Use pid instead of process group (which would have to get before
	 * the wait call above) so that we don't accidentally hose other
	 * applications.  Otherwise, somebody could write a program which put
	 * itself in somebody else's process group.  Also, we call Exit instead
	 * of Cleanup so that we don't do a killpg on -1 by accident.  Some
	 * operating systems seem to do very nasty things with that.
	 */
	if (pid > 1)
		kill_process_group (pid, SIGHUP);
	Exit (0);
	SIGNAL_RETURN;
}

static remove_termcap_entry (buf, str)
char *buf;
char *str;
{
	char *strinbuf;

	strinbuf = strindex (buf, str);
	if(strinbuf) {
		char *colonPtr = index (strinbuf+1, ':');
		if(colonPtr) {
			while (*colonPtr)
				*strinbuf++ = *colonPtr++;      /* copy down */
			*strinbuf = '\0';
		} else
			strinbuf[1] = '\0';
	}
	return;
}


/*
 * The only difference in /etc/termcap between 4014 and 4015 is that 
 * the latter has support for switching character sets.  We support the
 * 4015 protocol, but ignore the character switches.  Therefore, we 
 * choose 4014 over 4015.
 *
 * Features of the 4014 over the 4012: larger (19") screen, 12-bit
 * graphics addressing (compatible with 4012 10-bit addressing),
 * special point plot mode, incremental plot mode (not implemented in
 * later Tektronix terminals), and 4 character sizes.
 * All of these are supported by xterm.
 */

static char *tekterm[] = {
	"tek4014",
	"tek4015",		/* 4014 with APL character set support */
	"tek4012",		/* 4010 with lower case */
	"tek4013",		/* 4012 with APL character set support */
	"tek4010",		/* small screen, upper-case only */
	"dumb",
	0
};

/* The VT102 is a VT100 with the Advanced Video Option included standard.
 * It also adds Escape sequences for insert/delete character/line.
 * The VT220 adds 8-bit character sets, selective erase.
 * The VT320 adds a 25th status line, terminal state interrogation.
 * The VT420 has up to 48 lines on the screen.
 */

static char *vtterm[] = {
#ifdef USE_X11TERM
	"x11term",		/* for people who want special term name */
#endif
	"xterm",		/* the prefered name, should be fastest */
	"vt102",
	"vt100",
	"ansi",
	"dumb",
	0
};

/* ARGSUSED */
SIGNAL_T hungtty(i)
	int i;
{
	longjmp(env, 1);
	SIGNAL_RETURN;
}
#ifdef USE_HANDSHAKE
/* HsSysError()
 *
 * This routine does the equivalent of a SysError but it handshakes
 * over the errno and error exit to the master process so that it can
 * display our error message and exit with our exit code so that the
 * user can see it.
 */
#define HsSysError(p, e)	_HsSysError(__LINE__, p, e)
void _HsSysError(lineno, pf, error)
int pf;
int error;
{
	handshake_t handshake;

	handshake.status = PTY_FATALERROR;
	handshake.error = errno;
	handshake.fatal_error = error*10000+lineno;
	strcpy(handshake.buffer, ttydev);
	write(pf, (char *) &handshake, sizeof(handshake));

	exit(error);
}

void first_map_occurred ()
{
	handshake_t handshake;
	TScreen *screen = &term->screen;

	handshake.status = PTY_EXEC;
	handshake.rows = screen->max_row;
	handshake.cols = screen->max_col;
	write(pc_pipe[1], (char *) &handshake, sizeof(handshake));
	close(cp_pipe[0]);
	close(pc_pipe[1]);
	waiting_for_initial_map = False;
}
#else
/*
 * temporary hack to get xterm working on att ptys
 */
void first_map_occurred ()
{
	return;
}

#define HsSysError(a,b)
#endif /* USE_HANDSHAKE else !USE_HANDSHAKE */

/*
 * parse_tty_modes accepts lines of the following form:
 *
 *         [SETTING] ...
 *
 * where setting consists of the words in the modelist followed by a character
 * or ^char.
 */
static int parse_tty_modes(s, modelist)
char *s;
struct _xttymodes *modelist;
{
	struct _xttymodes *mp;
	int c;
	int count = 0;

	while(1) {
		while(*s && isascii(*s) && isspace(*s))
			s++;
		if(!*s)
			return count;

		for(mp = modelist; mp->name; mp++) {
			if (strncmp(s, mp->name, mp->len) == 0)
				break;
		}
		if(!mp->name)
			return -1;

		s += mp->len;
		while(*s && isascii(*s) && isspace(*s))
			s++;
		if(!*s)
			return -1;

		if(*s == '^') {
			s++;
			/* keep control bits */
			c = ((*s == '?') ? 0177 : *s & 31);
		} else
			c = *s;
		mp->value = c;
		mp->set = 1;
		count++;
		s++;
	}
}


int GetBytesAvailable(fd)
int fd;
{
#ifdef FIONREAD
	static long arg;

	ioctl(fd, FIONREAD, (char *) &arg);
	return (int)arg;
#else
	struct pollfd pollfds[1];

	pollfds[0].fd = fd;
	pollfds[0].events = POLLIN;
	return poll(pollfds, 1, 0);
#endif
}

/* Utility function to try to hide system differences from
   everybody who used to call killpg() */

int kill_process_group(pid, sig)
int pid;
int sig;
{
#ifndef X_NOT_POSIX
	return kill(-pid, sig);
#else
#if defined(SVR4) || defined(SYSV)
	return kill(-pid, sig);
#else
	return killpg(pid, sig);
#endif
#endif
}

#ifdef TIOCCONS
static Boolean 
ConvertConsoleSelection(w, selection, target, type, value, length, format)
Widget w;
Atom *selection, *target, *type;
XtPointer *value;
unsigned long *length;
int *format;
{
	/* we don't save console output, so can't offer it */
	return False;
}
#endif /* TIOCCONS */

initTty()
{
	ttydev = (char *)malloc(strlen(TTYDEV) + 1);
	ptydev = (char *)malloc(strlen(PTYDEV) + 1);
	if(!ttydev || !ptydev) {
		fprintf(stderr, 
			"%s:  unable to allocate memory for ttydev or ptydev\n",
			 ProgramName);
	    exit (1);
	}
	strcpy (ttydev, TTYDEV);
	strcpy (ptydev, PTYDEV);

#ifdef USE_SYSV_TERMIO
	/* Initialization is done here rather than above in order
	** to prevent any assumptions about the order of the contents
	** of the various terminal structures (which may change from
	** implementation to implementation).
	*/
#if defined(macII) || defined(ATT) || defined(CRAY)
	d_tio.c_iflag = ICRNL|IXON;
	d_tio.c_oflag = OPOST|ONLCR|TAB3;
    	d_tio.c_cflag = B9600|CS8|CREAD|PARENB|HUPCL;
    	d_tio.c_lflag = ISIG|ICANON|ECHO|ECHOE|ECHOK;

#ifndef USE_TERMIOS
	d_tio.c_line = 0;
#endif

	d_tio.c_cc[VINTR] = CINTR;
	d_tio.c_cc[VQUIT] = CQUIT;
	d_tio.c_cc[VERASE] = CERASE;
	d_tio.c_cc[VKILL] = CKILL;
    	d_tio.c_cc[VEOF] = CEOF;
	d_tio.c_cc[VEOL] = CNUL;
	d_tio.c_cc[VEOL2] = CNUL;
	d_tio.c_cc[VSWTCH] = CNUL;

#ifdef USE_TERMIOS
	d_tio.c_cc[VSUSP] = CSUSP;
	d_tio.c_cc[VDSUSP] = CDSUSP;
	d_tio.c_cc[VREPRINT] = CNUL;
	d_tio.c_cc[VDISCARD] = CNUL;
	d_tio.c_cc[VWERASE] = CNUL;
	d_tio.c_cc[VLNEXT] = CNUL;
#endif
#ifdef TIOCSLTC
        d_ltc.t_suspc = CSUSP;		/* t_suspc */
        d_ltc.t_dsuspc = CDSUSP;	/* t_dsuspc */
        d_ltc.t_rprntc = 0;		/* reserved...*/
        d_ltc.t_flushc = 0;
        d_ltc.t_werasc = 0;
        d_ltc.t_lnextc = 0;
#endif
#ifdef TIOCLSET
	d_lmode = 0;
#endif
#else  /* else !macII */
	d_tio.c_iflag = ICRNL|IXON;
	d_tio.c_oflag = OPOST|ONLCR|TAB3;
#ifdef BAUD_0
    	d_tio.c_cflag = CS8|CREAD|PARENB|HUPCL;
#else
    	d_tio.c_cflag = B9600|CS8|CREAD|PARENB|HUPCL;
#endif /* !BAUD_0 */

    	d_tio.c_lflag = ISIG|ICANON|ECHO|ECHOE|ECHOK;
	d_tio.c_line = 0;
	d_tio.c_cc[VINTR] = 0x7f;		/* DEL  */
	d_tio.c_cc[VQUIT] = '\\' & 0x3f;	/* '^\'	*/
	d_tio.c_cc[VERASE] = '#';		/* '#'	*/
	d_tio.c_cc[VKILL] = '@';		/* '@'	*/
    	d_tio.c_cc[VEOF] = 'D' & 0x3f;		/* '^D'	*/
	d_tio.c_cc[VEOL] = '@' & 0x3f;		/* '^@'	*/
#ifdef VSWTCH
	d_tio.c_cc[VSWTCH] = '@' & 0x3f;	/* '^@'	*/
#endif
	/* now, try to inherit tty settings */
	{
	    int i;

	    for (i = 0; i <= 2; i++) {
		struct termio deftio;
		if (ioctl (i, TCGETA, &deftio) == 0) {
		    d_tio.c_cc[VINTR] = deftio.c_cc[VINTR];
		    d_tio.c_cc[VQUIT] = deftio.c_cc[VQUIT];
		    d_tio.c_cc[VERASE] = deftio.c_cc[VERASE];
		    d_tio.c_cc[VKILL] = deftio.c_cc[VKILL];
		    d_tio.c_cc[VEOF] = deftio.c_cc[VEOF];
		    d_tio.c_cc[VEOL] = deftio.c_cc[VEOL];
#ifdef VSWTCH
		    d_tio.c_cc[VSWTCH] = deftio.c_cc[VSWTCH];
#endif
		    break;
		}
	    }
	}
#ifdef TIOCSLTC
        d_ltc.t_suspc = '\000';		/* t_suspc */
        d_ltc.t_dsuspc = '\000';	/* t_dsuspc */
        d_ltc.t_rprntc = '\377';	/* reserved...*/
        d_ltc.t_flushc = '\377';
        d_ltc.t_werasc = '\377';
        d_ltc.t_lnextc = '\377';
#endif
#ifdef USE_TERMIOS
	d_tio.c_cc[VSUSP] = '\000';
	d_tio.c_cc[VDSUSP] = '\000';
	d_tio.c_cc[VREPRINT] = '\377';
	d_tio.c_cc[VDISCARD] = '\377';
	d_tio.c_cc[VWERASE] = '\377';
	d_tio.c_cc[VLNEXT] = '\377';
#endif
#ifdef TIOCLSET
	d_lmode = 0;
#endif
#endif  /* macII */
#endif	/* USE_SYSV_TERMIO */

	/*
	 | fill in terminal modes
	 */
	if(resource.tty_modes) {
		int n = parse_tty_modes(resource.tty_modes, ttymodelist);
		if(n < 0) {
			fprintf(stderr, "%s:  bad tty modes \"%s\"\n",
				 ProgramName, resource.tty_modes);
		} else
		if(n > 0)
			override_tty_modes = 1;
	}
}


/* This function opens up a pty master and stuffs its value into pty.
 * If it finds one, it returns a value of 0.  If it does not find one,
 * it returns a value of !0.  This routine is designed to be re-entrant,
 * so that if a pty master is found and later, we find that the slave
 * has problems, we can re-enter this function and get another one.
 */

get_pty (pty)
int *pty;
{
#if defined(SYSV) && defined(SYSV386)
        /*
	  The order of this code is *important*.  On SYSV/386 we want to open
	  a /dev/ttyp? first if at all possible.  If none are available, then
	  we'll try to open a /dev/pts??? device.
	  
	  The reason for this is because /dev/ttyp? works correctly, where
	  as /dev/pts??? devices have a number of bugs, (won't update
	  screen correcly, will hang -- it more or less works, but you
	  really don't want to use it).
	  
	  Most importantly, for boxes of this nature, one of the major
	  "features" is that you can emulate a 8086 by spawning off a UNIX
	  program on 80386/80486 in v86 mode.  In other words, you can spawn
	  off multiple MS-DOS environments.  On ISC the program that does
	  this is named "vpix."  The catcher is that "vpix" will *not* work
	  with a /dev/pts??? device, will only work with a /dev/ttyp? device.
	  
	  Since we can open either a /dev/ttyp? or a /dev/pts??? device,
	  the flag "IsPts" is set here so that we know which type of
	  device we're dealing with in routine spawn().  That's the reason
	  for the "if (IsPts)" statement in spawn(); we have two different
	  device types which need to be handled differently.
	  */
        if (pty_search(pty) == 0)
	    return 0;
#endif /* SYSV && SYSV386 */
#ifdef ATT
	if ((*pty = open ("/dev/ptmx", O_RDWR)) < 0) {
	    return 1;
	}
#if defined(SVR4) || defined(SYSV386)
	strcpy(ttydev, ptsname(*pty));
#if defined (SYSV) && defined(SYSV386)
	IsPts = True;
#endif
#endif
	return 0;
#else /* ATT else */
#ifdef AIXV3
	if ((*pty = open ("/dev/ptc", O_RDWR)) < 0) {
	    return 1;
	}
	strcpy(ttydev, ttyname(*pty));
	return 0;
#endif
#if defined(sgi) && OSMAJORVERSION >= 4
	{
	    char    *tty_name;

	    tty_name = _getpty (pty, O_RDWR, 0622, 0);
	    if (tty_name == 0)
		return 1;
	    strcpy (ttydev, tty_name);
	    return 0;
	}
#endif
#ifdef __convex__
        {
	    char *pty_name, *getpty();

	    while ((pty_name = getpty()) != NULL) {
		if ((*pty = open (pty_name, O_RDWR)) >= 0) {
		    strcpy(ptydev, pty_name);
		    strcpy(ttydev, pty_name);
		    ttydev[5] = 't';
		    return 0;
		}
	    }
	    return 1;
	}
#endif /* __convex__ */
#ifdef USE_GET_PSEUDOTTY
	return ((*pty = getpseudotty (&ttydev, &ptydev)) >= 0 ? 0 : 1);
#else
#if (defined(sgi) && OSMAJORVERSION < 4) || (defined(umips) && defined (SYSTYPE_SYSV))
	struct stat fstat_buf;

	*pty = open ("/dev/ptc", O_RDWR);
	if (*pty < 0 || (fstat (*pty, &fstat_buf)) < 0) {
	  return(1);
	}
	sprintf (ttydev, "/dev/ttyq%d", minor(fstat_buf.st_rdev));
#ifndef sgi
	sprintf (ptydev, "/dev/ptyq%d", minor(fstat_buf.st_rdev));
	if ((*tty = open (ttydev, O_RDWR)) < 0) {
	  close (*pty);
	  return(1);
	}
#endif /* !sgi */
	/* got one! */
	return(0);
#else /* sgi or umips */

	return pty_search(pty);

#endif /* sgi or umips else */
#endif /* USE_GET_PSEUDOTTY else */
#endif /* ATT else */
}

/*
 * Called from get_pty to iterate over likely pseudo terminals
 * we might allocate.  Used on those systems that do not have
 * a functional interface for allocating a pty.
 * Returns 0 if found a pty, 1 if fails.
 */
int pty_search(pty)
int *pty;
{
    static int devindex, letter = 0;

#ifdef CRAY
    for (; devindex < 256; devindex++) {
	sprintf (ttydev, "/dev/ttyp%03d", devindex);
	sprintf (ptydev, "/dev/pty/%03d", devindex);

	if ((*pty = open (ptydev, O_RDWR)) >= 0) {
	    /* We need to set things up for our next entry
	     * into this function!
	     */
	    devindex++;
	    return 0;
	}
    }
#else /* CRAY */
    while (PTYCHAR1[letter]) {
	ttydev [strlen(ttydev) - 2]  = ptydev [strlen(ptydev) - 2] =
	    PTYCHAR1 [letter];

	while (PTYCHAR2[devindex]) {
	    ttydev [strlen(ttydev) - 1] = ptydev [strlen(ptydev) - 1] =
		PTYCHAR2 [devindex];
	    if ((*pty = open (ptydev, O_RDWR)) >= 0) {
		/* We need to set things up for our next entry
		 * into this function!
		 */
		devindex++;
		return 0;
	    }
	    devindex++;
	}
	devindex = 0;
	letter++;
    }
#endif /* CRAY else */
    /*
     * We were unable to allocate a pty master!  Return an error
     * condition and let our caller terminate cleanly.
     */
    return 1;
}

takeConsole()
{
#ifdef TIOCCONS
	struct stat sbuf;
	
	/*
	 | Must be owner and have read/write permission
	 | xdm cooperates to give the console
	 | the right user.
	 */
	if(!stat("/dev/console", &sbuf) &&
	   (sbuf.st_uid == getuid()) &&
	   !access("/dev/console", R_OK|W_OK))
		Console = TRUE;
	else
		Console = FALSE;
#endif
}


setUpPtyMasks(pty, Xsocket)
{
	int	mode;
#ifdef AIXV3
	/* In AIXV3, xterms started from /dev/console have CLOCAL set.
	 * This means we need to clear CLOCAL so that SIGHUP gets sent
	 * to the slave-pty process when xterm exits. 
	 */

	{
	    struct termio tio;

	    if(ioctl(pty, TCGETA, &tio) == -1)
		    SysError(ERROR_TIOCGETP);

	    tio.c_cflag &= ~(CLOCAL);

	    if(ioctl(pty, TCSETA, &tio) == -1)
		    SysError(ERROR_TIOCSETP);
	}
#endif

#ifdef USE_SYSV_TERMIO
	if(0 > (mode = fcntl(pty, F_GETFL, 0)))
		Error();
#ifdef O_NDELAY
	mode |= O_NDELAY;
#else
	mode |= O_NONBLOCK;
#endif
	if(fcntl(pty, F_SETFL, mode))
		Error();
#else	/* USE_SYSV_TERMIO */
	mode = 1;
	if(ioctl(pty, FIONBIO, (char *)&mode) == -1)
		SysError (ERROR_FIONBIO);
#endif	/* USE_SYSV_TERMIO */
	
	pty_mask = 1 << pty;
	X_mask = 1 << Xsocket;
	Select_mask = pty_mask | X_mask;
	max_plus1 = (pty < Xsocket) ? (1 + Xsocket) : (1 + pty);

}

#ifdef USE_TTY_GROUP
#include <grp.h>
#endif

static void changeGroup()
{
	TScreen *screen = &term->screen;
#ifdef USE_TTY_GROUP
	struct group *ttygrp;

	if (ttygrp = getgrnam("tty")) {
		/* change ownership of tty to real uid, "tty" gid */
		chown(ttydev, screen->uid, ttygrp->gr_gid);
		chmod(ttydev, 0620);
	}
	else {
		/* change ownership of tty to real group and user id */
		chown(ttydev, screen->uid, screen->gid);
		chmod(ttydev, 0622);
	}
	endgrent();
#else
	/* change ownership of tty to real group and user id */
	chown(ttydev, screen->uid, screen->gid);
	
	/* change protection of tty */
	chmod(ttydev, 0622);
#endif /* USE_TTY_GROUP */
}

setUpTtyModes(tty)
{
	TScreen	*screen = &term->screen;

#ifdef USE_SYSV_TERMIO
#if defined(umips) || defined(CRAY)
	/*
	  If the control tty had its modes screwed around with,
	  eg. by lineedit in the shell, or emacs, etc. then tio
	  will have bad values.  Let's just get termio from the
	  new tty and tailor it.
	  */
	if(ioctl(tty, TCGETA, &tio) == -1)
		SysError(ERROR_TIOCGETP);
	tio.c_lflag |= ECHOE;
#endif /* umips */
	/* Now is also the time to change the modes of the
	 * child pty.
	 */
	/* input: nl->nl, don't ignore cr, cr->nl */
	tio.c_iflag &= ~(INLCR|IGNCR);
	tio.c_iflag |= ICRNL;
	/* ouput: cr->cr, nl is not return, no delays, ln->cr/nl */
	tio.c_oflag &=
		     ~(OCRNL|ONLRET|NLDLY|CRDLY|TABDLY|BSDLY|VTDLY|FFDLY);
	tio.c_oflag |= ONLCR;
#ifdef OPOST
	tio.c_oflag |= OPOST;
#endif
	tio.c_cflag &= ~(CBAUD);
#ifndef BAUD_0
	/* baud rate is 9600 (nice default) */
	tio.c_cflag |= B9600;
#endif
	/* enable signals, canonical processing (erase, kill, etc),
	 ** echo
	 */
	tio.c_lflag |= ISIG|ICANON|ECHO;
	/* reset EOL to defalult value */
	tio.c_cc[VEOL] = '@' & 0x3f;		/* '^@'	*/
	/* certain shells (ksh & csh) change EOF as well */
	tio.c_cc[VEOF] = 'D' & 0x3f;		/* '^D'	*/

#define TMODE(ind,var) if (ttymodelist[ind].set) var = ttymodelist[ind].value;
	if(override_tty_modes) {
		/* sysv-specific */
		TMODE(XTTYMODE_intr, tio.c_cc[VINTR]);
		TMODE(XTTYMODE_quit, tio.c_cc[VQUIT]);
		TMODE(XTTYMODE_erase, tio.c_cc[VERASE]);
		TMODE(XTTYMODE_kill, tio.c_cc[VKILL]);
		TMODE(XTTYMODE_eof, tio.c_cc[VEOF]);
		TMODE(XTTYMODE_eol, tio.c_cc[VEOL]);
#ifdef VSWTCH
		TMODE(XTTYMODE_swtch, d_tio.c_cc[VSWTCH]);
#endif
#ifdef TIOCSLTC
		/* both SYSV and BSD have ltchars */
		TMODE(XTTYMODE_susp, ltc.t_suspc);
		TMODE(XTTYMODE_dsusp, ltc.t_dsuspc);
		TMODE(XTTYMODE_rprnt, ltc.t_rprntc);
		TMODE(XTTYMODE_flush, ltc.t_flushc);
		TMODE(XTTYMODE_weras, ltc.t_werasc);
		TMODE(XTTYMODE_lnext, ltc.t_lnextc);
#endif /* TIOCSLTC */
	}
#undef TMODE

	if(ioctl(tty, TCSETA, &tio) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCSETP);
#ifdef TIOCSLTC
	if(ioctl(tty, TIOCSLTC, &ltc) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCSETC);
#endif
#ifdef TIOCLSET
	if(ioctl(tty, TIOCLSET, (char *)&lmode) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCLSET);
#endif

#else	/* !USE_SYSV_TERMIO */

	sg.sg_flags &= ~(ALLDELAY | XTABS | CBREAK | RAW);
	sg.sg_flags |= ECHO | CRMOD;
	/* make sure speed is set on pty so that editors work right*/
	sg.sg_ispeed = B9600;
	sg.sg_ospeed = B9600;
	/* reset t_brkc to default value */
	tc.t_brkc = -1;
	if(screen->input_eight_bits)
		lmode |= LPASS8;
	else
		lmode &= ~(LPASS8);
#ifdef sonny
	jmode &= ~KM_KANJI;
#endif /* sony */

#define TMODE(ind,var) if (ttymodelist[ind].set) var = ttymodelist[ind].value;
	if(override_tty_modes) {
		TMODE(XTTYMODE_intr, tc.t_intrc);
		TMODE(XTTYMODE_quit, tc.t_quitc);
		TMODE(XTTYMODE_erase, sg.sg_erase);
		TMODE(XTTYMODE_kill, sg.sg_kill);
		TMODE(XTTYMODE_eof, tc.t_eofc);
		TMODE(XTTYMODE_start, tc.t_startc);
		TMODE(XTTYMODE_stop, tc.t_stopc);
		TMODE(XTTYMODE_brk, tc.t_brkc);
		/* both SYSV and BSD have ltchars */
		TMODE(XTTYMODE_susp, ltc.t_suspc);
		TMODE(XTTYMODE_dsusp, ltc.t_dsuspc);
		TMODE(XTTYMODE_rprnt, ltc.t_rprntc);
		TMODE(XTTYMODE_flush, ltc.t_flushc);
		TMODE(XTTYMODE_weras, ltc.t_werasc);
		TMODE(XTTYMODE_lnext, ltc.t_lnextc);
	}
#undef TMODE

	if(ioctl(tty, TIOCSETP, (char *)&sg) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCSETP);
	if(ioctl(tty, TIOCSETC, (char *)&tc) == -1)
		HsSysError (cp_pipe[1], ERROR_TIOCSETC);
	if(ioctl(tty, TIOCSETD, (char *)&discipline) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCSETD);
	if(ioctl(tty, TIOCSLTC, (char *)&ltc) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCSLTC);
	if(ioctl(tty, TIOCLSET, (char *)&lmode) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCLSET);
#ifdef sony
	if(ioctl(tty, TIOCKSET, (char *)&jmode) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCKSET);
	if(ioctl(tty, TIOCKSETC, (char *)&jtc) == -1)
		HsSysError(cp_pipe[1], ERROR_TIOCKSETC);
#endif /* sony */
#endif	/* !USE_SYSV_TERMIO */
}


/* 
 *  Inits pty and tty and forks a login process.
 *  Does not close fd Xsocket.
 *  If slave, the pty named in passedPty is already open for use
 */
spawn(passedPty, command_to_exec)
char	*passedPty;
char	**command_to_exec;
{
	extern char	*SysErrorMsg();
	TScreen		*screen = &term->screen;
	int		Xsocket = ConnectionNumber(screen->display);
	int		tty = -1;
	int		i, no_dev_tty = FALSE;

	char		buf[64], *ptr;

#ifdef USE_HANDSHAKE
	handshake_t	handshake;
#else
	int		fds[2];
#endif

	screen->uid = getuid();
	screen->gid = getgid();

#ifdef SIGTTOU
	/* so that TIOCSWINSZ || TIOCSIZE doesn't block */
	signal(SIGTTOU,SIG_IGN);
#endif

	if(am_slave) {
		screen->respond = am_slave;
		ptydev[strlen(ptydev) - 2] = ttydev[strlen(ttydev) - 2] =
			passedPty[0];
		ptydev[strlen(ptydev) - 1] = ttydev[strlen(ttydev) - 1] =
			passedPty[1];

		setgid (screen->gid);
		setuid (screen->uid);
	}
	else {
		Bool tty_got_hung = False;

 		/*
 		 * Sometimes /dev/tty hangs on open (as in the case of a pty
 		 * that has gone away).  Simply make up some reasonable
 		 * defaults.
 		 */
 		signal(SIGALRM, hungtty);
 		alarm(2);		/* alarm(1) might return too soon */
 		if (! setjmp(env)) {
 			tty = open ("/dev/tty", O_RDWR, 0);
 			alarm(0);
 		} else {
			tty_got_hung = True;
 			tty = -1;
 			errno = ENXIO;
 		}
 		signal(SIGALRM, SIG_DFL);
 
		/*
		 * Check results and ignore current control terminal if
		 * necessary.  ENXIO is what is normally returned if there is
		 * no controlling terminal, but some systems (e.g. SunOS 4.0)
		 * seem to return EIO.
		 */
 		if(tty < 0) {
			if(tty_got_hung || errno == ENXIO || errno == EIO ||
			   errno == ENOTTY) {
				no_dev_tty = TRUE;
#ifdef TIOCSLTC
				ltc = d_ltc;
#endif
#ifdef TIOCLSET
				lmode = d_lmode;
#endif
#ifdef USE_SYSV_TERMIO
				tio = d_tio;
#else
				sg = d_sg;
				tc = d_tc;
				discipline = d_disipline;
#ifdef sony
				jmode = d_jmode;
				jtc = d_jtc;
#endif
#endif /* USE_SYSV_TERMIO */
			} else
				SysError(ERROR_OPDEVTTY);
		}
		else {
			/* Get a copy of the current terminal's state,
			 * if we can.  Some systems (e.g., SVR4 and MacII)
			 * may not have a controlling terminal at this point
			 * if started directly from xdm or xinit,     
			 * in which case we just use the defaults as above.
			 */
#ifdef TIOCSLTC
			if(ioctl(tty, TIOCGLTC, &ltc) == -1)
				ltc = d_ltc;
#endif
#ifdef TIOCLSET
			if(ioctl(tty, TIOCLGET, &lmode) == -1)
				lmode = d_lmode;
#endif
#ifdef USE_SYSV_TERMIO
		        if(ioctl(tty, TCGETA, &tio) == -1)
			        tio = d_tio;

#else /* !USE_SYSV_TERMIO */
			if(ioctl(tty, TIOCGETP, (char *)&sg) == -1)
			        sg = d_sg;
			if(ioctl(tty, TIOCGETC, (char *)&tc) == -1)
			        tc = d_tc;
			if(ioctl(tty, TIOCGETD, (char *)&discipline) == -1)
			        discipline = d_disipline;
#ifdef sony
			if(ioctl(tty, TIOCKGET, (char *)&jmode) == -1)
			        jmode = d_jmode;
			if(ioctl(tty, TIOCKGETC, (char *)&jtc) == -1)
				jtc = d_jtc;
#endif
#endif /* USE_SYSV_TERMIO */
			close (tty);
			/* tty is no longer an open fd! */
			tty = -1;
		}

#ifdef PUCC_PTYD
		if(-1 == (screen->respond = openrpty(ttydev, ptydev,
				(resource.utmpInhibit ?  OPTY_NOP : OPTY_LOGIN),
				getuid(), XDisplayString(screen->display)))) {
#else
		if(get_pty (&screen->respond)) {
#endif /* PUCC_PTYD */
			/*  no ptys! */
			fprintf(stderr, "%s: no available ptys\n",
				       xterm_name);
			exit (ERROR_PTYS);
#ifdef PUCC_PTYD
		}
#else
		}	/* just to keep emacs happy */
#endif
#ifdef PUCC_PTYD
		else {
			/*
			 *  set the fd of the master in a global var so
			 *  we can undo all this on exit
			 *
			 */
			Ptyfd = screen->respond;
		}
#endif /* PUCC_PTYD */
	} /* !am_slave? */

	/* avoid double MapWindow requests */
	XtSetMappedWhenManaged(screen->TekEmu? XtParent(tekWidget):
			        XtParent(term), False );
	wm_delete_window = XInternAtom(XtDisplay(toplevel), "WM_DELETE_WINDOW",
				       False);
#ifdef HEBREW
	KEYMAP = XInternAtom(XtDisplay(toplevel), "KeyMap", False);
#endif
	if(!screen->TekEmu)
		/*
		 | realize now so know window size for tty driver
		 */
		VTInit();

#ifdef TIOCCONS
	if(Console) {
		/*
		 * Inform any running xconsole program
		 * that we are going to steal the console.
		 */
		XmuGetHostname (mit_console_name + MIT_CONSOLE_LEN, 255);
		mit_console = XInternAtom(screen->display,
					  mit_console_name, False);
		/*
		 * the user told us to be the console,
		 *  so we can use CurrentTime
		 */
		XtOwnSelection(screen->TekEmu?
			       XtParent(tekWidget): XtParent(term),
			       mit_console, CurrentTime,
			       ConvertConsoleSelection, NULL, NULL);
	}
#endif /* TIOCCONS */

	if(screen->TekEmu) {
		envnew = tekterm;
		ptr = newtc;
	}
	else {
		envnew = vtterm;
		ptr = termcap;
	}
	TermName = NULL;
	if(resource.term_name) {
		if(tgetent(ptr, resource.term_name) == 1) {
			TermName = resource.term_name;
			if(!screen->TekEmu)
				resize(screen, TermName, termcap, newtc);
		} else
			fprintf(stderr, "%s:  invalid termcap entry \"%s\".\n",
				ProgramName, resource.term_name);
	}
	if(!TermName) {
		while(*envnew != NULL) {
			if(tgetent(ptr, *envnew) == 1) {
				TermName = *envnew;
				if(!screen->TekEmu)
					resize(screen, TermName, termcap, newtc);
				break;
			}
			envnew++;
		}
		if(TermName == NULL) {
			fprintf(stderr,
				"%s:  unable to find usable termcap entry.\n",
				ProgramName);
			Exit (1);
		}
	}

#ifdef sun
#ifdef TIOCSSIZE
	/* tell tty how big window is */
	if(screen->TekEmu) {
		ts.ts_lines = 38;
		ts.ts_cols = 81;
	}
	else {
		ts.ts_lines = screen->max_row + 1;
		ts.ts_cols = screen->max_col + 1;
	}
#endif
#else /* not sun */
#ifdef TIOCSWINSZ
	/* tell tty how big window is */
	if(screen->TekEmu) {
		ws.ws_row = 38;
		ws.ws_col = 81;
		ws.ws_xpixel = TFullWidth(screen);
		ws.ws_ypixel = TFullHeight(screen);
	}
	else {
		ws.ws_row = screen->max_row + 1;
		ws.ws_col = screen->max_col + 1;
		ws.ws_xpixel = FullWidth(screen);
		ws.ws_ypixel = FullHeight(screen);
	}
#endif
#endif	/* sun */

	if(!am_slave) {
#ifdef USE_HANDSHAKE
	    if(pipe(pc_pipe) || pipe(cp_pipe))
		    SysError(ERROR_FORK);
#endif
	    if((screen->pid = fork()) == -1)
		    SysError(ERROR_FORK);
	    if(screen->pid == 0)
		    doChild(tty, command_to_exec); /* does not return */

#ifdef USE_HANDSHAKE
	    doHandShake(cp_pipe, pc_pipe);
#endif
	    /*
	     * still in parent (xterm process)
	     */
	    setUpSignals();
	}
}

/*
 * now in child process
 */
doChild(no_dev_tty, command_to_exec)
char	**command_to_exec;
{
	extern char	**environ;
	TScreen	*screen = &term->screen;
	char	buf[BUFSIZ];
	int	i, tty, pty;
#ifdef HEBREW
	char	*lc_ctype;
#endif
#if defined(_POSIX_SOURCE) || defined(SVR4) || defined(__convex__)
	int	pgrp = setsid();
#else
	int	pgrp = getpid();
#endif
#ifdef USE_SYSV_TERMIO
	char numbuf[12];
#if defined(UTMP) && defined(USE_SYSV_UTMP)
	char *ptyname;
#endif
#endif
#ifdef USE_HANDSHAKE
	handshake_t	handshake;
#endif

#ifdef USE_USG_PTYS
#if defined(SYSV) && defined(SYSV386)
	if (IsPts) {	/* SYSV386 supports both, which did we open? */
#endif
		int ptyfd;

		setpgrp();
		grantpt(screen->respond);
		unlockpt(screen->respond);
		if((ptyfd = open(ptsname(screen->respond), O_RDWR)) < 0)
			SysError (1);
		if(ioctl (ptyfd, I_PUSH, "ptem") < 0)
			SysError(2);
#if !defined(SVR4) && !defined(SYSV386)
		if(!getenv("CONSEM") && ioctl(ptyfd, I_PUSH, "consem") < 0)
			SysError(3);
#endif
		if(ioctl(ptyfd, I_PUSH, "ldterm") < 0)
			SysError(4);
#ifdef SVR4			/* from Sony */
		if(ioctl(ptyfd, I_PUSH, "ttcompat") < 0)
			SysError(5);
#endif
		tty = ptyfd;
		close (screen->respond);
#ifdef TIOCSWINSZ
                /* tell tty how big window is */
                if(screen->TekEmu) {
                        ws.ws_row = 24;
                        ws.ws_col = 80;
                        ws.ws_xpixel = TFullWidth(screen);
                        ws.ws_ypixel = TFullHeight(screen);
                }
		else {
                        ws.ws_row = screen->max_row + 1;
                        ws.ws_col = screen->max_col + 1;
                        ws.ws_xpixel = FullWidth(screen);
                        ws.ws_ypixel = FullHeight(screen);
                }
#endif
#if defined(SYSV) && defined(SYSV386)
	}
	else {	/* else pty, not pts */
#endif
#endif /* USE_USG_PTYS */

#ifdef USE_HANDSHAKE
		tty = doChildHandShake(no_dev_tty);
#if defined(SYSV) && defined(SYSV386)
	} /* end of IsPts else clause */
#endif

#endif /* USE_HANDSHAKE */
	/*
	  |
	  */
	changeGroup();

	/*
	  | set up the tty modes
	  */
	setUpTtyModes(tty);

#ifdef TIOCCONS
	if(Console) {
		int on = 1;
		if(ioctl(tty, TIOCCONS, (char *)&on) == -1)
			fprintf(stderr, "%s: cannot open console\n",
				xterm_name);
	}
#endif /* TIOCCONS */

	signal(SIGCHLD, SIG_DFL);
#ifdef USE_SYSV_SIGHUP
	/* watch out for extra shells (I don't understand either) */
	signal(SIGHUP, SIG_DFL);
#else
	signal(SIGHUP, SIG_IGN);
#endif
	/* restore various signals to their defaults */
	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
		signal(SIGTERM, SIG_DFL);

	/* copy the environment before Setenving */
	for(i = 0 ; environ [i] != NULL ; i++)
		;
	/* compute number of Setenv() calls below */
	envsize = 1;	/* (NULL terminating entry) */
	envsize += 3;	/* TERM, WINDOWID, DISPLAY */
#ifdef UTMP
	envsize += 1;   /* LOGNAME */
#endif
#ifdef USE_SYSV_ENVVARS
#ifndef TIOCSWINSZ		/* window size not stored in driver? */
	envsize += 2;	/* COLUMNS, LINES */
#endif
#ifdef UTMP
	envsize += 2;   /* HOME, SHELL */
#endif
#else /* USE_SYSV_ENVVARS */
	envsize += 1;	/* TERMCAP */
#endif /* USE_SYSV_ENVVARS */

#ifdef HEBREW
	if((lc_ctype = getenv("LC_TYPE")) == NULL)
		envsize++;
#endif
	envnew = (char **)calloc((unsigned)i+envsize, sizeof(char *));
	bcopy((char *)environ, (char *)envnew, i * sizeof(char *));
	environ = envnew;
	Setenv("TERM=", TermName);
	if(!TermName)
		*newtc = 0;

	sprintf(buf, "%lu", screen->TekEmu ? 
		((unsigned long)XtWindow(XtParent(tekWidget))) :
		((unsigned long)XtWindow(XtParent(term))));
	Setenv("WINDOWID=", buf);
	/*
	 | put the display into the environment of the shell
	 */
	Setenv("DISPLAY=", XDisplayString(screen->display));
#ifdef HEBREW
	if(lc_ctype == NULL)
		Setenv("LC_CTYPE=", "iso_8859_1");
#endif
	signal(SIGTERM, SIG_DFL);

	/* this is the time to go and set up stdin, out, and err
	 */
#if defined(CRAY) && (OSMAJORVERSION >= 6)
	close(tty);
	close(0);

	if(open("/dev/tty", O_RDWR)) {
		fprintf(stderr, "cannot open /dev/tty\n");
		exit(1);
	}
	close(1);
	close(2);
	dup(0);
	dup(0);
#else
	/* dup the tty */
	for(i = 0; i <= 2; i++)
		if(i != tty) {
			close(i);
			dup(tty);
		}

#ifndef ATT
	/* and close the tty */
	if(tty > 2)
		close(tty);
#endif
#endif /* CRAY */

#ifndef	USE_SYSV_PGRP
#ifdef TIOCSCTTY
	setsid();
	ioctl(0, TIOCSCTTY, 0);
#endif
	ioctl(0, TIOCSPGRP, (char *)&pgrp);
	setpgid(0,0);
	close(open(ttydev, O_WRONLY, 0));
	setpgid (0, pgrp);
#endif /* !USE_SYSV_PGRP */

	doUtmp();

	setgid (screen->gid);
#ifdef HAS_BSD_GROUPS
	if(geteuid() == 0 && pw)
		initgroups(pw->pw_name, pw->pw_gid);
#endif
	setuid(screen->uid);

#ifdef USE_HANDSHAKE
	/* mark the pipes as close on exec */
	fcntl(cp_pipe[1], F_SETFD, 1);
	fcntl(pc_pipe[0], F_SETFD, 1);

	/* We are at the point where we are going to
	 * exec our shell (or whatever).  Let our parent
	 * know we arrived safely.
	 */
	handshake.status = PTY_GOOD;
	handshake.error = 0;
	strcpy(handshake.buffer, ttydev);
	write(cp_pipe[1], (char *)&handshake, sizeof(handshake));
		
	if(waiting_for_initial_map) {
		i = read(pc_pipe[0], (char *)&handshake, sizeof(handshake));
		if(i != sizeof(handshake) || handshake.status != PTY_EXEC)
			/* some very bad problem occurred */
			exit(ERROR_PTY_EXEC);
		if(handshake.rows > 0 && handshake.cols > 0) {
			screen->max_row = handshake.rows;
			screen->max_col = handshake.cols;
#ifdef sun
#ifdef TIOCSSIZE
			ts.ts_lines = screen->max_row + 1;
			ts.ts_cols = screen->max_col + 1;
#endif
#else /* !sun */
#ifdef TIOCSWINSZ
			ws.ws_row = screen->max_row + 1;
			ws.ws_col = screen->max_col + 1;
			ws.ws_xpixel = FullWidth(screen);
			ws.ws_ypixel = FullHeight(screen);
#endif
#endif /* sun else !sun */
		}
	}
#endif /* USE_HANDSHAKE */

#ifdef USE_SYSV_ENVVARS
#ifndef TIOCSWINSZ		/* window size not stored in driver? */
	sprintf (numbuf, "%d", screen->max_col + 1);
	Setenv("COLUMNS=", numbuf);
	sprintf (numbuf, "%d", screen->max_row + 1);
	Setenv("LINES=", numbuf);
#endif

#ifdef UTMP
	if(pw) {	/* SVR4 doesn't provide these */
		if(!getenv("HOME"))
			Setenv("HOME=", pw->pw_dir);
		if(!getenv("SHELL"))
			Setenv("SHELL=", pw->pw_shell);
	}
#endif /* UTMP */
#else /* USE_SYSV_ENVVAR */
	if(!screen->TekEmu) {
		strcpy(termcap, newtc);
		resize(screen, TermName, termcap, newtc);
	}
	if(term->misc.titeInhibit) {
		remove_termcap_entry (newtc, ":ti=");
		remove_termcap_entry (newtc, ":te=");
	}
	/*
	 * work around broken termcap entries */
	if(resource.useInsertMode)	{
		remove_termcap_entry (newtc, ":ic=");
		/* don't get duplicates */
		remove_termcap_entry (newtc, ":im=");
		remove_termcap_entry (newtc, ":ei=");
		remove_termcap_entry (newtc, ":mi");
		strcat (newtc, ":im=\\E[4h:ei=\\E[4l:mi:");
	}
	Setenv ("TERMCAP=", newtc);
#endif /* USE_SYSV_ENVVAR */
	/*
	 | need to reset after all the ioctl bashing we did above
	 */
#ifdef sun
#ifdef TIOCSSIZE
	ioctl(0, TIOCSSIZE, &ts);
#endif
#else
#ifdef TIOCSWINSZ
	ioctl(0, TIOCSWINSZ, (char *)&ws);
#endif
#endif /* sun */

	signal(SIGHUP, SIG_DFL);
	if(command_to_exec) {
		execvp(*command_to_exec, command_to_exec);
		/* print error message on screen */
		fprintf(stderr, "%s: Can't execvp %s\n", xterm_name,
			*command_to_exec);
	}

#ifdef USE_SYSV_SIGHUP
	/* fix pts sh hanging around */
	signal(SIGHUP, SIG_DFL);
#endif
	doExec();
	exit(ERROR_EXEC);
}


#ifdef USE_HANDSHAKE
doHandShake(cp, pc)
int	*cp, *pc;
{
	TScreen		*screen = &term->screen;
	handshake_t	handshake;
	int		done;
	/* Parent process.  Let's handle handshaked requests to our
	 * child process.
	 */

	/* close childs's sides of the pipes */
	close(cp[1]);
	close(pc[0]);
	
	for(done = 0; !done;) {
		if(read(cp[0], (char *)&handshake, sizeof(handshake)) <= 0) {
			/* Our child is done talking to us.  If it terminated
			 * due to an error, we will catch the death of child
			 * and clean up.
			 */
			break;
		}

		switch(handshake.status) {
		case PTY_GOOD:
			/* Success!  Let's free up resources and
			 * continue.
			 */
			done = 1;
			break;

		case PTY_BAD:
			/* The open of the pty failed!  Let's get
			 * another one.
			 */
			close(screen->respond);
			if(get_pty(&screen->respond)) {
				/* no more ptys! */
				fprintf(stderr,
					"%s: child process can find no available ptys\n",
					      xterm_name);
				handshake.status = PTY_NOMORE;
				write(pc[1], (char *)&handshake, sizeof(handshake));
				exit(ERROR_PTYS);
			}
			handshake.status = PTY_NEW;
			 strcpy(handshake.buffer, ttydev);
			write(pc[1], (char *)&handshake, sizeof(handshake));
			break;

		case PTY_FATALERROR:
			errno = handshake.error;
			close(cp[0]);
			close(pc[1]);
			SysError(handshake.fatal_error);

		case UTMP_ADDED:
			/* The utmp entry was set by our slave.  Remember
			 * this so that we can reset it later.
			 */
			added_utmp_entry = True;
#ifndef	USE_SYSV_UTMP
			tslot = handshake.tty_slot;
#endif	/* USE_SYSV_UTMP */
			free(ttydev);
			ttydev = malloc((unsigned) strlen(handshake.buffer) + 1);
			strcpy(ttydev, handshake.buffer);
			break;
		default:
			fprintf(stderr, "%s: unexpected handshake status %d\n",
			        xterm_name, handshake.status);
		}
	}

	/* close our sides of the pipes */
	if(!waiting_for_initial_map) {
		close(cp[0]);
		close(pc[1]);
	}
}

static doChildHandShake(no_dev_tty)
{
	TScreen	*screen = &term->screen;
	int	Xsocket = ConnectionNumber(screen->display);
	int	i, tty;
	char	buf[BUFSIZ];
	char	*ptr;
	handshake_t	handshake;

	/* close parent's sides of the pipes */
	close(cp_pipe[0]);
	close(pc_pipe[1]);
	
	/* Make sure that our sides of the pipes are not in the
	 * 0, 1, 2 range so that we don't fight with stdin, out
	 * or err.
	 */
	if(cp_pipe[1] <= 2) {
		if((i = fcntl(cp_pipe[1], F_DUPFD, 3)) >= 0) {
			close(cp_pipe[1]);
			cp_pipe[1] = i;
		}
	}
	if(pc_pipe[0] <= 2) {
		if((i = fcntl(pc_pipe[0], F_DUPFD, 3)) >= 0) {
			close(pc_pipe[0]);
			pc_pipe[0] = i;
		}
	}

	/* we don't need the socket, or the pty master anymore */
	close(Xsocket);
	close(screen->respond);
	
	/* Now is the time to set up our process group and
	 * open up the pty slave.
	 */
#ifdef USE_SYSV_PGRP
#if defined(CRAY) && (OSMAJORVERSION > 5)
	setsid();
#else
	setpgrp();
#endif
#endif

	while(1) {
#ifdef TIOCNOTTY
		if(!no_dev_tty &&
		   (tty = open ("/dev/tty", O_RDWR)) >= 0) {
			ioctl(tty, TIOCNOTTY, (char *) NULL);
			close(tty);
		}
#endif
		if((tty = open(ttydev, O_RDWR, 0)) >= 0) {
#if defined(CRAY) && defined(TCSETCTTY)
			/* make /dev/tty work */
			ioctl(tty, TCSETCTTY, 0);
#endif
#ifdef USE_SYSV_PGRP
			/* We need to make sure that we are acutally
			 * the process group leader for the pty.  If
			 * we are, then we should now be able to open
			 * /dev/tty.
			 */
			if((i = open("/dev/tty", O_RDWR, 0)) >= 0) {
				/* success! */
				close(i);
				break;
			}
#else
			break;
#endif /* USE_SYSV_PGRP */
		}

#ifdef TIOCSCTTY
		ioctl(tty, TIOCSCTTY, 0);
#endif
		/* let our master know that the open failed */
		handshake.status = PTY_BAD;
		handshake.error = errno;
		strcpy(handshake.buffer, ttydev);
		write(cp_pipe[1], (char *)&handshake, sizeof(handshake));
		
		/* get reply from parent */
		i = read(pc_pipe[0], (char *)&handshake, sizeof(handshake));
		if(i <= 0)
			/* parent terminated */
			exit(1);
		
		if(handshake.status == PTY_NOMORE)
			/* No more ptys, let's shutdown. */
			exit(1);
		
		/* We have a new pty to try */
		free(ttydev);
		ttydev = malloc((unsigned)(strlen(handshake.buffer) + 1));
		strcpy(ttydev, handshake.buffer);
	}
	
	/* use the same tty name that everyone else will use
	 ** (from ttyname)
	 */
	if(ptr = ttyname(tty)) {
		/* it may be bigger */
		ttydev = realloc(ttydev, (unsigned)(strlen(ptr) + 1));
		strcpy(ttydev, ptr);
	}
	return tty;
#endif /* USE_HANDSHAKE */
}

static doUtmp()
{
#ifdef UTMP
	TScreen		*screen = &term->screen;
	struct passwd	*pw = getpwuid(screen->uid);
	int		i;
#ifdef USE_HANDSHAKE
	handshake_t	handshake;
#endif
	if(pw && pw->pw_name)
		Setenv("LOGNAME=", pw->pw_name); /* for POSIX */
#ifdef USE_SYSV_UTMP
	/* Set up our utmp entry now.  We need to do it here
	 ** for the following reasons:
	 **   - It needs to have our correct process id (for
	 **     login).
	 **   - If our parent was to set it after the fork(),
	 **     it might make it out before we need it.
	 **   - We need to do it before we go and change our
	 **     user and group id's.
	 */
#ifdef CRAY
#define PTYCHARLEN 4
#else
#define PTYCHARLEN 2
#endif

	setutent ();
	/* set up entry to search for */
	ptyname = ttydev;
	strncpy(utmp.ut_id,ptyname + strlen(ptyname)-PTYCHARLEN,
		sizeof (utmp.ut_id));
	utmp.ut_type = DEAD_PROCESS;
	
	/* position to entry in utmp file */
	getutid(&utmp);
	
	/* set up the new entry */
	utmp.ut_type = USER_PROCESS;
	utmp.ut_exit.e_exit = 2;
	strncpy(utmp.ut_user, (pw && pw->pw_name) ? pw->pw_name : "????",
		sizeof(utmp.ut_user));
	
	strncpy(utmp.ut_id, ptyname + strlen(ptyname)-PTYCHARLEN,
		sizeof(utmp.ut_id));
	strncpy(utmp.ut_line, ptyname + strlen("/dev/"), sizeof(utmp.ut_line));
	
#ifdef HAS_UTMP_UT_HOST
	strncpy(buf, DisplayString(screen->display),
		sizeof(buf));
	{
		char *disfin = rindex(buf, ':');
		if(disfin)
			*disfin = '\0';
	}
	strncpy(utmp.ut_host, buf, sizeof(utmp.ut_host));
#endif
	strncpy(utmp.ut_name, pw->pw_name, sizeof(utmp.ut_name));
	
	utmp.ut_pid = getpid();
	utmp.ut_time = time((long *) 0);

	/* write out the entry */
	if(!resource.utmpInhibit)
		pututline(&utmp);
#ifdef WTMP
	if(term->misc.login_shell &&
	   (i = open(etc_wtmp, O_WRONLY|O_APPEND)) >= 0) {
		write(i, (char *)&utmp, sizeof(struct utmp));
		close(i);
	}
#endif
	/* close the file */
	endutent();

#else	/* USE_SYSV_UTMP */
	/* We can now get our ttyslot!  We can also set the initial
	 * UTMP entry.
	 */
	tslot = ttyslot();
	added_utmp_entry = False;

	if(pw && !resource.utmpInhibit && (i = open(etc_utmp, O_WRONLY)) >= 0) {
		bzero((char *)&utmp, sizeof(struct utmp));
		strncpy(utmp.ut_line, ttydev + strlen("/dev/"), sizeof(utmp.ut_line));
		strncpy(utmp.ut_name, pw->pw_name, sizeof(utmp.ut_name));
#ifdef HAS_UTMP_UT_HOST
		strncpy(utmp.ut_host, XDisplayString (screen->display),
			sizeof(utmp.ut_host));
#endif
		time(&utmp.ut_time);
		lseek(i, (long)(tslot * sizeof(struct utmp)), 0);
		write(i, (char *)&utmp, sizeof(struct utmp));
		close(i);
		added_utmp_entry = True;
#ifdef WTMP
		if(term->misc.login_shell &&
		   (i = open(etc_wtmp, O_WRONLY|O_APPEND)) >= 0) {
			int status;
			status = write(i, (char *)&utmp, sizeof(struct utmp));
			status = close(i);
		}
#endif /* WTMP */
#ifdef LASTLOG
		if(term->misc.login_shell &&
		   (i = open(etc_lastlog, O_WRONLY)) >= 0) {
			bzero((char *)&lastlog, sizeof (struct lastlog));
			strncpy(lastlog.ll_line, ttydev + sizeof("/dev"),
				sizeof(lastlog.ll_line));
			strncpy(lastlog.ll_host, 
				XDisplayString(screen->display),
				sizeof(lastlog.ll_host));
			time(&lastlog.ll_time);
			lseek(i, (long)(screen->uid*sizeof(struct lastlog)), 0);
			write(i, (char *)&lastlog, sizeof (struct lastlog));
			close(i);
		}
#endif /* LASTLOG */
	} else
		tslot = -tslot;
	
	/* Let's pass our ttyslot to our parent so that it can
	 * clean up after us.
	 */
#ifdef USE_HANDSHAKE
	handshake.tty_slot = tslot;
#endif
#endif /* USE_SYSV_UTMP */

#ifdef USE_HANDSHAKE
	/*
	 * Let our parent know that we set up our utmp entry
	 * so that it can clean up after us.
	 */
	handshake.status = UTMP_ADDED;
	handshake.error = 0;
	strcpy(handshake.buffer, ttydev);
	write(cp_pipe[1], (char *)&handshake, sizeof(handshake));
#endif
#endif/* UTMP */
}

setUpSignals()
{

#ifdef USE_SYSV_SIGHUP
	/* hung sh problem? */
	signal(SIGHUP, SIG_DFL);
#else
	signal(SIGHUP,SIG_IGN);
#endif
	/*
	 * Unfortunately, System V seems to have trouble divorcing the
	 * child process from the process group of xterm.
	 * This is a problem because hitting the INTR or QUIT characters
	 * on the keyboard will cause xterm to go away if we don't ignore
	 * the signals.  This is annoying.
	 */
#if defined(USE_SYSV_SIGNALS) && !defined(SIGTSTP)
	signal(SIGINT, SIG_IGN);
#ifndef SYSV
	/* hung shell problem */
	signal(SIGQUIT, SIG_IGN);
#endif
	signal(SIGTERM, SIG_IGN);
#else
	/*
	 | else is bsd or has job control
	 */
#ifdef SYSV
	/*
	 * if we were spawned by a jobcontrol smart shell
	 * (like ksh or csh), then our pgrp and pid will be the same.
	 * If we were spawned by a jobcontrol dump shell (like /bin/sh),
	 * then we will be in out parents pgrp, and we must ignore keyboard
	 * signals, or will will tank on everything.
	 */
	if(getpid() == getpgrp()) {
		signal(SIGINT, Exit);
		signal(SIGQUIT, Exit);
		signal(SIGTERM, Exit);
	}
	else {
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		signal(SIGTERM, SIG_IGN);
	}
	signal(SIGPIPE, Exit);
#else
	signal(SIGINT, Exit);
	signal(SIGQUIT, Exit);
	signal(SIGTERM, Exit);
	signal(SIGPIPE, Exit);
#endif	/* SYSV */
#endif /* USE_SYSV_SIGNALS and not SIGTSTP */
}

static doExec(pw)
struct passwd *pw;
{
	TScreen	*screen = &term->screen;
	char	*ptr;
	char	*shname, *shname_minus;

#ifdef UTMP
	if(((ptr = getenv("SHELL")) == NULL || *ptr == 0) &&
	   ((pw == NULL && (pw = getpwuid(screen->uid)) == NULL) ||
	    *(ptr = pw->pw_shell) == 0))
#else
	if(((ptr = getenv("SHELL")) == NULL || *ptr == 0) &&
	   ((pw = getpwuid(screen->uid)) == NULL ||
	    *(ptr = pw->pw_shell) == 0))
#endif	/* UTMP */
		ptr = "/bin/sh";
	if(shname = rindex(ptr, '/'))
		shname++;
	else
		shname = ptr;
	shname_minus = malloc(strlen(shname) + 2);
	strcpy(shname_minus, "-");
	strcat(shname_minus, shname);
#ifndef USE_SYSV_TERMIO
	ldisc = XStrCmp("csh", shname + strlen(shname) - 3) == 0 ?
		NTTYDISC : 0;
	ioctl(0, TIOCSETD, (char *)&ldisc);
#endif

#ifdef USE_LOGIN_DASH_P
	if(term->misc.login_shell && pw && added_utmp_entry)
		execl(bin_login, "login", "-p", "-f", pw->pw_name, 0);
#endif

	execlp(ptr, (term->misc.login_shell? shname_minus: shname), 0);
	/*
	 | Exec failed.
	 */
	fprintf(stderr, "%s: Could not exec %s!\n", xterm_name, ptr);
	sleep(5);
}
