#ifndef lint
static char *rcsid = 
	"$Id: VTproc.c,v 1.5 1993/09/09 12:01:09 danny Exp $";
#endif

#include <setjmp.h>
#include <stdio.h>

#include "ptyx.h"
#include "screen.h"
#include "vtdefs.h"
#include "menu.h"

typedef u_short	ps_t;

#define MAXPS	15
static ps_t	Ps[MAXPS];	/* hold escape seq. parameters */
static int	nps;		/* count of the above */

static void	bitset(), bitclr();
static XtGeometryResult fixSize();

static jmp_buf	vtjmpbuf, vtjmpbuf1;

extern Char	*bptr;
extern int	bcnt;
#ifndef DEBUG1
#define getChar()	(bcnt-- > 0 ? *bptr++ : in_put())
#endif
static csi();
static dpModes();
static do132();
static void showIt();
static Erase();
static SetPrintMode();
static SetLogAttr();
static Udcs();
static DefFuncKeys();
static HardReset();
static SoftReset();


extern XtermWidget	term;
jmp_buf	VTend;

#ifdef DEBUG1
getChar()
{
   char c;
       
   c=(bcnt-- > 0 ? *bptr++ : in_put());
   fprintf(stderr, "%x-%c ",c,c);
   if(c=='\n')fprintf(stderr,"\n");
   return c;
}
#endif


vtInitModes()
{
	TScreen		*screen = &term->screen;

	term->vt_mode = 0;
	if(!screen->jumpscroll) {
		term->vt_mode |= M_DECSCL;
		update_jumpscroll();
	}
	if(term->misc.reverseWrap) {
		term->vt_mode |= M_RVSAW;
		update_reversewrap();
	}
	if(term->misc.autoWrap) {
	    term->vt_mode |= M_DECAW;
	    update_autowrap();
	}
	if(term->misc.re_verse) {
		term->vt_mode |= M_DECSCN;
		update_reversevideo();
	}
#ifdef HEBREW
	if(screen->direction) {
		term->vt_mode |= M_DECRL;
		update_direction();
	}
	if(screen->mirror) {
		term->vt_mode |= M_DECMIRROR;
		update_mirror();
	}
#endif
	term->initflags = term->vt_mode;
}
/*
 | shoul not be hear?
 */
KbInit()
{
	if(term->misc.appcursorDefault) {
		term->keyboard.flags |= CURSOR_APL;
		update_appcursor();
	}

	if(term->misc.appkeypadDefault) {
		term->keyboard.flags |= KYPD_APL;
		update_appkeypad();
	}
#ifdef HEBREW
	initHebKeyMap();
#endif
}

VTRun()
{
	TScreen *screen = &term->screen;
	int i;
	
	if(!screen->Vshow)
		set_vt_visibility(TRUE);

	update_vttekmode();
	update_vtshow();
	update_tekshow();
	set_vthide_sensitivity();

	if(screen->allbuf == NULL)
		VTallocbuf ();

	screen->cursor_state = OFF;
	screen->cursor_set = ON;

	resetInputBufp();

	if(!setjmp(VTend))
		VTparse();

	HideCursor();
	screen->cursor_set = OFF;
}

VTparse()
{
	TScreen		*screen = &term->screen;
	int	c, cc;
	int	Sbit;

	if(setjmp(vtjmpbuf)) {
		if(screen->TekEmu)
			return;
	}
	for(;;) {
		cc = getChar();
	        setjmp(vtjmpbuf1);
		Sbit = 0;
		if((c = cc) & 0x80) {
			if(screen->input_eight_bits)
				Sbit++;
			c &= 0x7f;
		}
		if(c == 0 || c == DEL)
			continue;
		if(c >= ' ') {
			showIt(cc);
			continue;
		}
		/*
		 | It's a 'control character'
		 */
		switch(cc) {
		case ENQ:	/* answerback */
#if 0
			if(*vt->v_answerback)
				SendToHost(vt->v_answerback);
#endif
			break;
		case BEL: 	Bell();			break;
		case BS:	Bs(screen);		break;
		case HT:	Tab(screen);		break;
		case LF: case VT: case FF:
			cursorIndex(screen, 1, term->vt_mode & M_LN, 1);
			break;
		case CR:	carriageReturn(screen);	break;

/*		case SO:
		case SI:
			screen->curgl = SI - cc;	break;*/

		case SO:
			screen->curgl = 2;
			break;
		case SI:
			screen->curgl = 1;
			break;			

#if 0
		case XON:	transon = TRUE;		break;
		case XOFF:	transon = FALSE;	break;
#endif
		case ESC:
			if(cc = GetEchar(0))
				ansi_parse(cc);
			break;
		default:
			if(Sbit == 0)
				break;
			switch(cc) {
			case IND:	cc = 'D';	break;
			case NEL:	cc = 'E';	break;
			case HTS:	cc = 'H';	break;
			case RI:	cc = 'M';	break;
			case SS2:	cc = 'N';	break;
			case SS3:	cc = 'O';	break;
			case DCS:	cc = 'P';	break;
			case CSI:	cc = '[';	break;
			case ST:	cc = '\\';	break;
			default:
				continue;
			}
			ansi_parse(cc);
		}
	}
}

static finput()
{
	return getChar();
}

/*
 | ESC c ...
 */
ansi_parse(c)
char c;
{
	TScreen	*screen = &term->screen;
	int	c1;

	switch(c) {
	/*
	 | Inmediate:
	 |	<esc> one-char
	 */
	case '7':
	case '8':
		saveRestoreCursor(c == '7');
		break;
	case '=':
	case '>':
		KeyPad(term, c == '=');
		break;
	case 'D':	/* IND */
	case 'E':	/* NEL */
		cursorIndex(screen, 1, c == 'E', 0);
		break;
		
	case 'H':	/* HTS */
		TabSet(term->tabs, screen->cur_col);
		break;
	case 'M':	/* RI */
		cursorIndex(screen, -1, 0, 0);
		break;
	case 'N':	/* SS2 */
	case 'O':	/* SS3 */
		screen->curss = c - 'N' + 2;
		break;
	case 'Z':
		decIDP(0);
		break;
	case 'c':
		HardReset();
		break;
	case '~': /* G1 -> GR */
	case '}': /* G2 -> GR */
	case '|': /* G3 -> GR */
	case 'n': /* G2 -> GL */
	case 'o': /* G3 -> GL */
#ifdef notyet
		if(!EMUL(VT100))
			LockShift(c);
#endif
		break;
	default:
		/*
		 | now for the more complicated ones
		 */
		c1 = GetEchar(0);
		switch(c) {
		case '#':
			decHASH(c1 - '0');
			break;
		case '*':
		case '+':
		case '(':
		case ')':
			/*
			 | Character Set Selection
			 */
			css(c, c1);
			break;
		case ']':
			do_osc(finput,c1);
			break;
		case '[':
			csi(c1);
			break;
		default:
			switch(c) {
			case ' ':
				SetCBit(c1);
				break;
			case '!':
				if(c1 == 'p')
					SoftReset();
				break;
			case 'P':
				dcs(c1);
				break;
			}
		}
	}
}
/*
 | get a Ps;...;Ps sequence
 */
static getPs(c)
char	c;
{
	ps_t	*ps = Ps;
	int	n;

	if(c == ';') {
		c = GetEchar(0);
		*ps++ = 0;
	}
	ps[0] = ps[1] = n = 0;
	while(c >= '0' && c <= '9') {
		n++;
		*ps = *ps * 10 + c - '0';
		c = GetEchar(0);
		while(c == ';') {
			c = GetEchar(0);
			if((++ps - Ps ) == MAXPS)
				return 0; /* Abort */
			*ps = n = 0;
		}
	}
	if(n)
		ps++;
	nps = ps - Ps;
	return c;
}

/*
 | Control Sequence Introducer
 */
static csi(c1)
char	c1;
{
	TScreen	*screen = &term->screen;
	char	c = c1;
	char	c2;

	if(c1 == '?' || c1 == '>') {
		if((c = GetEchar(0)) == 0)
			return;
	}
	if((c2 = getPs(c)) == 0)
		return;
	if(c1 == '?') {
		csiQ(c2);
		return;
	}

	switch(c2) {
	case '"':	/* dec -- Compatability Level */
		if((c = GetEchar(0)) == 'p')
			decSCL();
		else
		if(c == 'q') /* && !EMUL(VT100)) */
			SetLogAttr(*Ps);
		break;
	case 'A':	/* CUU Cursor Up */
	case 'B':	/* CUD Cursor Down */
	case 'C':	/* CUF Cursor Forward */
	case 'D':	/* CUB Cursor Backward */
		if(nps < 2) {
			if(*Ps == 0)
				*Ps = 1;
#ifdef M_DECMIRROR
			if(term->vt_mode & M_DECMIRROR)
				c2 = "ABDC"[c2 - 'A'];
#endif
			cursorMove(screen, c2 - 'A', *Ps);
		}
		break;
	case 'H':	/* cursor position */
	case 'f': {
		int row = Ps[0];
		int col = Ps[1];
		if(row == 0)
			row = 1;
		if(col == 0)
			col == 1;
#ifdef M_DECMIRROR
		if(term->vt_mode & M_DECMIRROR)
			col = screen->max_col - col + 2;
#endif
		CursorSet(screen, row-1, col-1, term->vt_mode & M_DECO);
	}
		break;
	case 'J':	/* erase display  ED */
	case 'K':	/* erase in line  EL */
		Erase(c2 == 'K', *Ps, 0);
		break;
	case 'h':
		dpModes(term, bitset, _H);
		break;
	case 'l':
		dpModes(term, bitclr, _H);
		break;
	case '@':	/* Insert ICH */
		InsertChar(screen, *Ps? *Ps: 1);
		break;
	case 'L':	/* Insert line/s IL */
		InsertLine(screen, *Ps? *Ps: 1);
		break;
	case 'M':	/* Delete line/s */
		DeleteLine(screen, *Ps? *Ps: 1);
		break;
	case 'P':	/* Delete character/s */
		DeleteChar(screen, *Ps? *Ps: 1);
		break;
#if 0
	case 'X':
		if(nps == 1)
			EraseChars(*Ps);
		break;
#endif
	case 'c':
		if(nps == 0 || (nps == 1 && *Ps == 0))
			decIDP(0);
		else
		if((c1 == '>') && (nps == 0 || (nps == 1 && *Ps == 0)))
			decIDP(1);
		break;
	case 'g':
		if(nps <= 1)
			TabClear(term->tabs, screen->cur_col);
		else
		if(*Ps == 3)
			TabZonk(term->tabs);
		break;
	case 'i':
		SetPrintMode(0, Ps, nps);
		break;
	case 'm':
		videoAttributes(nps, Ps);
		break;
	case 'n':
		ReportSomething(*Ps);
		break;
	case 'r':
		scrollRegion(Ps[0], Ps[1]);
		break;
	}
}
scrollRegion(top, bot)
{
	TScreen		*screen = &term->screen;

	if(top == 0)
		top = 1;
	if(bot == 0 || (bot > screen->max_row + 1))
		bot = screen->max_row + 1;
	if(bot > top) {
		if(screen->scroll_amt)
			FlushScroll(screen);
		screen->top_marg = top - 1;
		screen->bot_marg = bot - 1;
		CursorSet(screen, 0, 0, term->vt_mode & M_DECO);
	}
}

/*
 | got ^[[?...
 */
csiQ(c2)
{
	switch(c2) {
	case 'J':	/* erase in display ED */
	case 'K':	/* erase in line    EL */
		Erase(c2 == 'K', *Ps, 1);
		break;
	case 'h':	/* decSET */
		dpModes(term, bitset, 0);
		break;
	case 'l':	/* decRST */
		dpModes(term, bitclr, 0);
		break;
	case 'i': /* is this vt100 too? */
		SetPrintMode(_H, Ps, nps);
		break;
	case 'n': /* device status report */
		ReportSomething(*Ps);
		break;
	case 'r':	/* Xterm Private */
		restoreModes(term);
		break;
	case 's':	/* Xterm Private */
		saveModes(term);
		break;
	}
}

/*
 | Device Control String
 */
dcs(c)
{
	char	params[6];
	int	i;

	for(i = 0; i<6; params[i++] = 0);
	i = 0;
	do {
		switch(c) {
		case 0:
			return;
		case '|':
			return DefFuncKeys(i, params);
		case '{':
			return Udcs(i, params);
		case ';':
			if(++i == sizeof(params))
				return;
			break;
		default:
			if((c >= '0') && (c <= '9')) {
				params[i] *= 10;
				params[i] += c - '0';
				break;
			}
			return;
		}
	} while(c = GetEchar(0));
}

decHASH(c)
{
	int	attr;
	int	cline, ccol;

	switch(c) {

	case 3:	/* Double Height line - Top half */
	case 4:	/* Double Height line - Bottom half */
	case 5:	/* Single Height, Single Width line */
	case 6:	/* Single Height, Double Width line */
		/*
		 | IGNORED
		 */
		break;
	case 8:	/*
		 | Screen Alignment, fill screen with E's
		 */
#if 0
		SetCursorPos(0, 0);
		WriteCharAttr('E', A_NORMAL, scr.s_lines * scr.s_cols);
#endif
		break;
	}
}

SetCBit(c)
{
#if 0
	if(c == 'F')
		vt->v_mode1 &= ~M_8bits;
	else
		vt->v_mode1 |= M_8bits;
#endif
}

KeyPad(term, flag)
XtermWidget	term;
{
	if(flag)
		term->keyboard.flags |= KYPD_APL;
	else
		term->keyboard.flags &= ~KYPD_APL;

	update_appkeypad();
}

decIDP(flag)
{
	char	txt[20], *msg = txt;

	bzero(msg, sizeof txt);

#ifdef helen	/* helen */
	*msg++ = ESC;
	*msg++ = '[';
	strcpy(msg,"?1;2c");
	SendToHost(txt);
#endif	/* helen */

#ifdef notyet
	if(EMUL(VT200_8))
		*msg++ = CSI;
	else {
		*msg++ = ESC;
		*msg++ = '[';
	}
#else
	*msg++ = ESC;
	*msg++ = '[';
#endif
	if(flag == 0) {
		/*
		 | also called 'Device Attribute' responce
		 */
		*msg++ = '?';
		strcpy(msg, "6c");
	}
	else {
		extern	int Version;
		*msg++ = '>';
		*msg++ = '1';
		*msg++ = ';';
		*msg++ = ((Version/10) % 10) + '0';
		*msg++ = (Version % 10) + '0';
	}

	SendToHost(txt);
}

/*
 * set a bit in a word given a pointer to the word and a mask.
 */
static void bitset(p, mask)
unsigned *p;
int mask;
{
	*p |= mask;
}

/*
 * clear a bit in a word given a pointer to the word and a mask.
 */
static void bitclr(p, mask)
unsigned *p;
int mask;
{
	*p &= ~mask;
}
/*
 | process DEC private modes set/reset
 */
static dpModes(termw, func, type)
XtermWidget	termw;
void		(*func)();
{
	TScreen	*screen	= &termw->screen;
	int	i, j;
	ps_t	*ps = Ps;

	for(i=0; i<nps; i++, ps++)
	switch(*ps | type) {
	case 1:	/* DECCKM */
		(*func)(&termw->keyboard.flags, CURSOR_APL);
		update_appcursor();
		break;
	case 2:	/* ANSI/VT52 mode <*> Des. USASCII ... */
		if(func == bitset) {
			for(i = 0; i < 4; i++)
				screen->gsets[i] = 'B';
			screen->curgl = 0;
			screen->curgr = 2;
		}
		break;
	case 3:	/* DECCOLM */
		if(screen->c132)
			do132(termw, func);
		break;
	case 4:	/* DECSCLM (slow scroll) */
		if(func == bitset) {
			screen->jumpscroll = 0;
			if(screen->scroll_amt)
				FlushScroll(screen);
		} else
			screen->jumpscroll = 1;
		(*func)(&termw->vt_mode, M_DECSCL);
		update_jumpscroll();
		break;
	case 5:	/* screen reverse video DECSCNM */
		j = termw->vt_mode;
		(*func)(&termw->vt_mode, M_DECSCN);
		if((termw->vt_mode ^ j) & M_DECSCN)
			ReverseVideo(termw);
		/* update_reversevideo done in RevVid */
		break;

	case 6:	/* origin DECOM */
		(*func)(&termw->vt_mode, M_DECO);
		CursorSet(screen, 0, 0, termw->vt_mode & M_DECO);
		break;

	case 7:	/* auto wraparound DECAWM */
		(*func)(&termw->vt_mode, M_DECAW);
		update_autowrap();
		break;
	case 8:	/* DECARM */
		/* ignore autorepeat */
		break;
	case 9:	/* MIT bogus sequence */
		screen->send_mouse_pos = func == bitset;
		break;
#ifdef HEBREW
	case 34:/* DECRLM */
		(*func)(&termw->vt_mode, M_DECRL);
		break;
	case 35:/* DECHEBM */
		(*func)(&termw->vt_mode, M_DECHEB);
		break;
	case 36:/* DECHEM */
		(*func)(&termw->vt_mode, M_DECHE);
		break;
	case 37:/* DECHEM */
		(*func)(&termw->vt_mode, M_DECMIRROR);
		break;
#endif
	case 38:/* DECTEK */
		if(func == bitset && !(screen->inhibit & I_TEK)) {
			extern Char *Tbuffer;
			if(screen->logging) {
				FlushLog(screen);
				screen->logstart = Tbuffer;
			}
			screen->TekEmu = TRUE;
		}
		break;
	case 40:/* 132 column mode */
		screen->c132 = (func == bitset);
		update_allow132();
		break;
	case 41:/* curses hack */
		screen->curses = (func == bitset);
		update_cursesemul();
		break;
	case 44:/* margin bell */
		screen->marginbell = (func == bitset);
		if(!screen->marginbell)
			screen->bellarmed = -1;
		update_marginbell();
		break;
	case 45:/* reverse wraparound */
		(*func)(&termw->vt_mode, M_RVSAW);
		update_reversewrap();
		break;
	case 46:		/* logging */
#ifdef ALLOWLOGFILEONOFF
		/*
		 * if this feature is enabled, logging may be 
		 * enabled and disabled via escape sequences.
		 */
		if(func == bitset)
			StartLog(screen);
		else
			CloseLog(screen);
#else
		Bell();
		Bell();
#endif /* ALLOWLOGFILEONOFF */
		break;
	case 47:/* alternate buffer */
		if(!termw->misc.titeInhibit)
			Alternate(screen, func == bitset);
		break;
	case 1000:		/* xterm bogus sequence		*/
		screen->send_mouse_pos = func == bitset? 2: 0;
		break;

	case 1001:		/* xterm sequence w/hilite tracking */
		screen->send_mouse_pos = func == bitset? 3: 0;
		break;
	}
}

/*
 * process xterm private modes save
 */
saveModes(termw)
XtermWidget termw;
{
	TScreen	*screen	= &termw->screen;
	int i;
	ps_t	*ps = Ps;

	for(i = 0; i < nps; i++, ps++)
	switch(*ps) {
	case 1:	/* DECCKM */
		screen->save_modes[0] = termw->keyboard.flags & CURSOR_APL;
		break;
	case 3:	/* DECCOLM */
		if(screen->c132)
			screen->save_modes[1] = termw->vt_mode & M_DECCOL;
		break;
	case 4:	/* DECSCLM */
		screen->save_modes[2] = termw->vt_mode & M_DECSCL;
		break;
	case 5:	/* DECSCNM */
		screen->save_modes[3] = termw->vt_mode & M_DECSCN;
		break;
	case 6:	/* DECOM */
		screen->save_modes[4] = termw->vt_mode & M_DECO;
		break;
	case 7:	/* DECAWM */
		screen->save_modes[5] = termw->vt_mode & M_DECAW;
		break;
	case 8:	/* DECARM */ /* ignore autorepeat */
		break;

	case 9:	/* mouse bogus sequence */
		screen->save_modes[7] = screen->send_mouse_pos;
		break;
	case 40:/* 132 column mode */
		screen->save_modes[8] = screen->c132;
		break;
	case 41:/* curses hack */
		screen->save_modes[9] = screen->curses;
		break;
	case 44:/* margin bell */
		screen->save_modes[12] = screen->marginbell;
		break;
	case 45:/* reverse wraparound */
		screen->save_modes[13] = termw->vt_mode & M_RVSAW;
		break;
	case 46:/* logging */
		screen->save_modes[14] = screen->logging;
		break;
	case 47:/* alternate buffer */
		screen->save_modes[15] = screen->alternate;
		break;
	case 1000:/* mouse bogus sequence */
	case 1001:
		screen->save_modes[7] = screen->send_mouse_pos;
		break;
	}
}

/*
 | process xterm private modes restore
 */
restoreModes(termw)
XtermWidget termw;
{
	TScreen	*screen	= &termw->screen;
	int i, j;
	ps_t	*ps = Ps;

	for(i = 0; i < nps; i++, ps++)
	switch(*ps) {
	case 1:	/* DECCKM */
		termw->keyboard.flags &= ~CURSOR_APL;
		termw->keyboard.flags |= screen->save_modes[0] & CURSOR_APL;
		update_appcursor();
		break;
	case 3:	/* DECCOLM */
		if(screen->c132) {
			ClearScreen(screen);
			CursorSet(screen, 0, 0, termw->vt_mode & M_DECO);
			if((j = (screen->save_modes[1] & M_DECCOL)
			    ? 132 : 80) != ((termw->vt_mode & M_DECCOL)
					    ? 132 : 80) || j != screen->max_col + 1) {
				Dimension replyWidth, replyHeight;
				XtGeometryResult status;
				status = fixSize(termw, j,
						 &replyWidth, &replyHeight);

				if(status == XtGeometryYes ||
				   status == XtGeometryDone) {
					ScreenResize (&termw->screen,
						      replyWidth,
						      replyHeight,
						      &termw->vt_mode);
				}
			}
			termw->vt_mode &= ~M_DECCOL;
			termw->vt_mode |= screen->save_modes[1] & M_DECCOL;
		}
		break;
	case 4:	/* DECSCLM (slow scroll) */
		if (screen->save_modes[2] & M_DECSCL) {
			screen->jumpscroll = 0;
			if (screen->scroll_amt)
				FlushScroll(screen);
		} else
			screen->jumpscroll = 1;
		termw->vt_mode &= ~M_DECSCL;
		termw->vt_mode |= screen->save_modes[2] & M_DECSCL;
		update_jumpscroll();
		break;
	case 5:	/* DECSCNM */
		if((screen->save_modes[3] ^ termw->vt_mode) & M_DECSCN) {
			termw->vt_mode &= ~M_DECSCN;
			termw->vt_mode |= screen->save_modes[3] & M_DECSCN;
			ReverseVideo(termw);
			/* update_reversevideo done in RevVid */
		}
		break;
	case 6:	/* DECOM */
		termw->vt_mode &= ~M_DECO;
		termw->vt_mode |= screen->save_modes[4] & M_DECO;
		CursorSet(screen, 0, 0, termw->vt_mode & M_DECO );
		break;

	case 7:	/* DECAWM */
		termw->vt_mode &= ~M_DECAW;
		termw->vt_mode |= screen->save_modes[5] & M_DECAW;
		update_autowrap();
		break;
	case 8:	/* DECARM */
		/* ignore autorepeat */
		break;
	case 9:	/* MIT bogus sequence */
		screen->send_mouse_pos = screen->save_modes[7];
		break;
	case 40: /* 132 column mode */
		screen->c132 = screen->save_modes[8];
		update_allow132();
		break;
	case 41: /* curses hack */
		screen->curses = screen->save_modes[9];
		update_cursesemul();
		break;
	case 44: /* margin bell */
		if(!(screen->marginbell = screen->save_modes[12]))
			screen->bellarmed = -1;
		update_marginbell();
		break;
	case 45: /* reverse wraparound */
		termw->vt_mode &= ~M_RVSAW;
		termw->vt_mode |= screen->save_modes[13] & M_RVSAW;
		update_reversewrap();
		break;
	case 46: /* logging */
#ifdef ALLOWLOGFILEONOFF
		if(screen->save_modes[14])
			StartLog(screen);
		else
			CloseLog(screen);
#endif /* ALLOWLOGFILEONOFF */
		/* update_logging done by StartLog and CloseLog */
		break;
	case 47: /* alternate buffer */
		if(!termw->misc.titeInhibit)
			Alternate(screen, screen->save_modes[15]);
		break;

	case 1000: /* mouse bogus sequence */
	case 1001:
		screen->send_mouse_pos = screen->save_modes[7];
		break;
	}
}

/*
 | Set Compatability mode
 */
decSCL()
{
#ifdef notyet
	if(*Ps == 61)
		vt->v_emul = VT100;
	else
	if(*Ps == 62) {
		if(nps == 2) {
			switch(Ps[1]) {
			case 0:
			case 2:
				vt->v_emul = VT200_8;
				vt->v_mode1 |= M_8bits;
				break;
			case 1:
				vt->v_emul = VT200_7;
				vt->v_mode1 &= ~M_8bits;
				break;
			}
		} else
			vt->v_emul = vt->v_mode1 & M_8bits?
				VT200_7:
				VT200_8;
	}
#endif
}

ReportSomething(ps)
{
	char	txt[20], *msg = txt;

	bzero(msg, sizeof txt);
#ifdef notyet
	if()
		*msg++ = CSI;
	else {
		*msg++ = ESC;
		*msg++ = '[';
	}
#else
	*msg++ = ESC;
	*msg++ = '[';
#endif
	switch(ps) {
	case 6:
		ReportCursorPosition(msg);
		break;
	case 5:
		*msg = '0';
		*msg++ = 'n';
		break;
	case 15 | _H:	/* Printer Status Report */
		PrinterStatusReport(msg);
		break;
	case 25:
		/*
		 | Device Status Report
		 */
		*msg++ = '?';
		*msg++ = '2';
		*msg++ = /*(vt->v_mode & M_UDKLOCK)? '1': '0' */ '0';
		break;
	default:
		return;
	}
	SendToHost(txt);
}

/*
 | Called to get the next char when in an esc sequence.
 */
GetEchar(flag)
{
	for(;;) {
		char c;

		switch(c = getChar()) {
		case DEL:
		case NUL:
			/*
			 | Ignore
			 */
			continue;
		case SUB:
			/*
			 | abort and display an inverted question mark.
			 */
#if 0
			writeScreen(IQUEST);
#endif
		case CAN:
			/*
			 | abort
			 */
			return 0;
		case ESC:
			if(flag)
				return c;
			/* 
			 | Restart esc. seq.
			 */
/*			longjmp(vtjmpbuf, 1); */
			longjmp(vtjmpbuf1, 1);
			/* NO RETURN */
		default:
			if(!flag && ((c & 0x7f) < ' '))
				return 0;
			return c;
		}
	}
}

static do132(termw, func)
XtermWidget	termw;
void		(*func)();
{
	TScreen	*screen = &termw->screen;
	int	j;

	ClearScreen(screen);
	CursorSet(screen, 0, 0, termw->vt_mode & M_DECO);

	j = func == bitset ? 132 : 80;
	if(j != ((termw->vt_mode & M_DECCOL)? 132: 80) ||
	   j != screen->max_col + 1) {
		Dimension replyWidth, replyHeight;
		XtGeometryResult status;

		status = fixSize(termw, j, &replyWidth, &replyHeight);
		if(status == XtGeometryYes || status == XtGeometryDone)
			ScreenResize(&termw->screen, replyWidth, replyHeight,
				     &termw->vt_mode);

		(*func)(&termw->vt_mode, M_DECCOL);
	}
}

#define TEXT_BUF_SIZE   256
#define MIN(a, b)	((a) > (b)? (b): (a))

static void showIt(cc)
{
	TScreen	*screen = &term->screen;
	extern	bcnt;
	extern	Char *bptr;
	int	cnt = MIN(TEXT_BUF_SIZE, bcnt);
	Char	*cp;

	cp = bptr;
	*--bptr = cc;
	while(cnt > 0 && isprint(*cp & 0x7f)) {
		cnt--;
		bcnt--;
		cp++;
	}
	if(screen->curss) {
		DoText(screen, term->vt_mode, screen->gsets[screen->curss],
		       bptr, bptr + 1);
		screen->curss = 0;
		bptr++;
	}
	if(cp > bptr)
		DoText(screen, term->vt_mode,
		       screen->gsets[screen->curgl],
		       bptr, cp);
	bptr = cp;
}

/*
 | Character Set Selection
 | +---+---+
 | |chr| G |
 | +---+---+
 | | ( | 0 |
 | +---+---+
 | | ) | 1 |
 | +---+---+
 | | * | 2 |
 | +---+---+
 | | + | 3 |
 | +---+---+
 */
css(c, c1)
{
	int	g, cset;
	TScreen	*screen = &term->screen;

	g = c - '(';
	if((g < 0) || (g > 3))
		return;
	switch(c1) {
	case 'B': cset = CS_ASCII;	break;
	case 'A': cset = CS_UK;		break;	/* U.K national */
	case '0': cset = CS_DECSPEC;	break;	/* Dec Special Graphics */
	case '<': cset = CS_DECSUPP;	break;	/* Dec supplement */
	default:
		return;
	}
#if 0
	if(EMUL(VT100)) {
		if(cset > 3)
			return;
	} else
		if(cset == CS_UK)
			return;
	vt->v_css[g] = cset;
#endif
	screen->gsets[cset]=c1;

}


videoAttributes(n, ps)
ps_t	*ps;
{
	if(n == 0)
		goto clear;
	do{
		switch(*ps++) {
		case 0:
	clear:		term->vt_mode &= ~(A_INVERSE|A_BOLD|A_UNDERLINE);
			break;
		case 1:
		case 5: /* blink, really */
			term->vt_mode |= A_BOLD;
			break;
		case 4:
			term->vt_mode |= A_UNDERLINE;
			break;
		case 7:
			term->vt_mode |= A_INVERSE;
			break;
		}
	}while(*ps);
}


VTReset(full)
Boolean full;
{
	TScreen *screen = &term->screen;

	/* reset scrolling region */
	screen->top_marg = 0;
	screen->bot_marg = screen->max_row;
	term->vt_mode &= ~M_DECO;

	if(full) {
		TabReset(term->tabs);
		term->keyboard.flags = 0;
		update_appcursor();
		update_appkeypad();

		screen->gsets[0] = 'B';
		screen->gsets[1] = 'B';
		screen->gsets[2] = 'B';
		screen->gsets[3] = 'B';
		screen->curgl = 0;
		screen->curgr = 2;
		screen->curss = 0;

		Alternate(screen, 0);
		ClearScreen(screen);
		screen->cursor_state = OFF;
		if(term->vt_mode & M_DECSCN)
			ReverseVideo(term);

		term->vt_mode = term->initflags;
		update_reversevideo();
		update_autowrap();
		update_reversewrap();
		update_autolinefeed();
		screen->jumpscroll = !(term->vt_mode & M_DECSCL);
		update_jumpscroll();
		if(screen->c132 && (term->vt_mode & M_DECCOL)) {
			(void)fixSize(term, 80, 0, 0);
			XSync(screen->display, FALSE);	/* synchronize */
			if(QLength(screen->display) > 0)
				xevents();
		}
#ifdef HEBREW
		update_direction();
		update_mirror();

		if(term->vt_mode & M_DECRL)
			CursorSet(screen, 0, screen->max_col,
				  term->vt_mode & M_DECO);
		else
#endif
		CursorSet(screen, 0, 0, term->vt_mode & M_DECO);
	}
	longjmp(vtjmpbuf, 1);	/* force ground state in parser */
}

static XtGeometryResult fixSize(term, cols, rw, rh)
XtermWidget	term;
Dimension	*rw, *rh;
{
	Dimension junk;
	TScreen	*screen = &term->screen;

	return XtMakeResizeRequest((Widget)term,
		(Dimension)cols * FontWidth(screen) +
				   2 * screen->border + screen->scrollbar,
		(Dimension)FontHeight(screen) * (screen->max_row + 1) +
				   2 * screen->border,
		rw? rw: &junk, rh? rh: &junk);
}
/*
 | inline:	1 erase in line
 |		0 erase in display
 | prot:	1 exclude 'protected areas'; not implemented
 */
static Erase(flag, type, prot)
{
	TScreen	*screen = &term->screen;

	if(flag) {
		/*
		 | in line
		 */
		switch(type) {
		case 0: /* from cursor to EoL */
#ifdef M_DECMIRROR
			if(term->vt_mode & M_DECMIRROR)
				ClearLeft(screen);
			else
#endif
			ClearRight(screen);
			break;
		case 1: /* from BoL to cursor */
#ifdef M_DECMIRROR
			if(term->vt_mode & M_DECMIRROR)
				ClearRight(screen);
			else
#endif
			ClearLeft(screen);
			break;
		case 2: /* all the line */
			ClearLine(screen);
			break;
		}
	}
	else {
		/*
		 | in screen
		 */
		switch(type) {
		case 0: /* from cursor to EoP */
			ClearBelow(screen);
			break;
		case 1: /* from Bop to cursor */
			ClearAbove(screen);
			break;
		case 2: /* all */
			ClearScreen(screen);
			break;
		}
	}
}

static SetPrintMode()
{
}

static SetLogAttr()
{
}

static Udcs()
{
}

static DefFuncKeys(i, params)
{
}

static HardReset()
{
}

static SoftReset()
{
}


void HandleDirection(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
}

void HandleMirror(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
	if(*param_count == 0)
		term->vt_mode ^= M_DECMIRROR;
	else
	if(params[0][0] == '0')
		term->vt_mode &= ~M_DECMIRROR;
	else
		term->vt_mode |= M_DECMIRROR;

	if(term->vt_mode & M_DECMIRROR)
		term->vt_mode |= M_DECRL;
	else
		term->vt_mode &= ~M_DECRL;

	update_mirror();
	update_direction();
}

void HandleKeyboard(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
	if(*param_count == 0)
		term->vt_mode ^= M_DECHEB;
	else
	if(params[0][0] == '0')
		term->vt_mode &= ~M_DECHEB;
	else
		term->vt_mode |= M_DECHEB;

	update_keyboard();
}

void HandleEmulation(w, event, params, param_count)
Widget		w;
XEvent		*event;		/* unused */
String		*params;	/* unused */
Cardinal	*param_count;	/* unused */
{
}

PrinterStatusReport(msg)
{
}

