#include "ptyx.h"
#include "screen.h"
#include "data.h"
#include "error.h"
#include "menu.h"
#include "vtdefs.h"

#include <stdio.h>

static void horizontal_copy_area();
static ScrnInsertChar();
static ScrnDeleteChar();

/*
 * Insert n blanks at the cursor's position, no wraparound
 */
InsertChar(screen, n)
TScreen	*screen;
int	n;
{
	int cx, cy;

	if(screen->cursor_state)
		HideCursor();
	screen->do_wrap = 0;
	if(screen->cur_row - screen->topline > screen->max_row)
		return;
	if(!AddToRefresh(screen)) {
		if(screen->scroll_amt)
			FlushScroll(screen);
		cy = CursorY(screen, screen->cur_row);
#ifdef M_DECMIRROR
		if(term->vt_mode & M_DECMIRROR) {
			horizontal_copy_area(screen, 0, screen->cur_col, -n);
			cx = CursorX(screen, screen->cur_col - n);
		}
		else {
#endif
			/*
			 * prevent InsertChar from shifting the end of a line
			 * over if it is being appended to
			 */
			if(non_blank_line(screen->buf, screen->cur_row,
					  screen->cur_col,
					  screen->max_col + 1))
				horizontal_copy_area(screen, screen->cur_col,
						     screen->max_col + 1 - (screen->cur_col + n),
						     n);
		
			cx = CursorX(screen, screen->cur_col);
#ifdef M_DECMIRROR
		}
#endif
		XFillRectangle(screen->display, TextWindow(screen),
			       screen->reverseGC,
			       cx, cy,
			       n * FontWidth(screen),
			       FontHeight(screen));
	}
#ifdef M_DECMIRROR
	if(term->vt_mode & M_DECMIRROR)
		ScrnDeleteChar(screen->buf, screen->cur_row, 0, n,
			       screen->cur_col + 1);
	else
#endif
	/* adjust screen->buf */
	ScrnInsertChar(screen->buf, screen->cur_row, screen->cur_col, n,
		       screen->max_col + 1);
}

/*
 * Deletes n chars at the cursor's position, no wraparound.
 */
DeleteChar(screen, n)
TScreen *screen;
int n;
{
	int width, cx, cy;

	if(screen->cursor_state)
		HideCursor ();
	screen->do_wrap = 0;
	if(n > (width = screen->max_col + 1 - screen->cur_col))
		n = width;

	if(screen->cur_row - screen->topline <= screen->max_row) {
		if(!AddToRefresh (screen)) {
			if(screen->scroll_amt)
				FlushScroll(screen);
			cy =  CursorY(screen, screen->cur_row);
#ifdef M_DECMIRROR
		if(term->vt_mode & M_DECMIRROR) {
			horizontal_copy_area(screen, 0,
					     screen->cur_col - n + 1, n);
			cx = CursorX(screen, screen->cur_col - n );
		}
		else {
#endif
			horizontal_copy_area(screen, screen->cur_col + n,
					     screen->max_col + 1 - (screen->cur_col + n),
					     -n);
			cx = CursorX(screen,
				     screen->border + screen->scrollbar +
				     Width(screen) - n * FontWidth(screen));
			XFillRectangle(screen->display, TextWindow (screen),
				       screen->reverseGC,
				       cx, cy, 
				       n * FontWidth(screen),
				       FontHeight(screen));
		}
#ifdef M_DECMIRROR
		}
#endif
	}
#ifdef M_DECMIRROR
	if(term->vt_mode & M_DECMIRROR)
		ScrnInsertChar(screen->buf, screen->cur_row, 0, n,
			       screen->cur_col + 1);
	else
#endif
	/* adjust screen->buf */
	ScrnDeleteChar(screen->buf, screen->cur_row, screen->cur_col, n,
		       screen->max_col + 1);

}


/*
 | Inserts n blanks in sb at row, col.  Size is the size of each row.
 */
static ScrnInsertChar(sb, row, col, n, size)
ScrnBuf sb;
int	row, size;
int	col, n;
{
	int	i, j;
	Char	*ptr = sb[2 * row];
	Char	*attrs = sb[2 * row + 1];
	int	wrappedbit = attrs[0] & LINEWRAPPED;

	attrs[0] &= ~LINEWRAPPED; /* make sure the bit isn't moved */
	for(i = size - 1; i >= col + n; i--) {
		ptr[i] = ptr[j = i - n];
		attrs[i] = attrs[j];
	}

	for(i=col; i<col+n; i++)
		ptr[i] = ' ';
	for(i=col; i<col+n; i++)
		attrs[i] = CHARDRAWN;

	if(wrappedbit)
		attrs[0] |= LINEWRAPPED;
}

/*
 | Deletes n characters in sb at row, col. Size is the size of each row.
 */
static ScrnDeleteChar(sb, row, col, n, size)
ScrnBuf sb;
int	row, size;
int	n, col;
{
	Char	*ptr = sb[2 * row];
	Char	*attrs = sb[2 * row + 1];
	int	nbytes = (size - n - col);
	int	wrappedbit = attrs[0]&LINEWRAPPED;

	bcopy(ptr + col + n, ptr + col, nbytes);
	bcopy(attrs + col + n, attrs + col, nbytes);
	bzero(ptr + size - n, n);
	bzero(attrs + size - n, n);
	if(wrappedbit)
		attrs[0] |= LINEWRAPPED;
}
/*
 * Clear from cursor position to beginning of display, inclusive.
 */
ClearAbove(screen)
TScreen *screen;
{
	int top, height;

	if(screen->cursor_state)
		HideCursor ();
	if((top = -screen->topline) <= screen->max_row) {
		if(screen->scroll_amt)
			FlushScroll (screen);
		if((height = screen->cur_row + top) > screen->max_row)
			height = screen->max_row;
		if((height -= top) > 0)
			XClearArea(screen->display, TextWindow (screen),
				   screen->border + screen->scrollbar, top *
				   FontHeight (screen) + screen->border,
				   Width(screen),
				   height * FontHeight(screen), FALSE);

		if(screen->cur_row - screen->topline <= screen->max_row) {
#ifdef M_DECMIRROR
			if(term->vt_mode & M_DECMIRROR)
				ClearRight(screen);
			else
#endif
			ClearLeft(screen);
		}
	}
	ClearBufRows(screen, 0, screen->cur_row - 1);
}

/*
 * Clear from cursor position to end of display, inclusive.
 */
ClearBelow(screen)
TScreen *screen;
{
	int top;

#ifdef M_DECMIRROR
	if(term->vt_mode & M_DECMIRROR)
		ClearLeft(screen);
	else
#endif
	ClearRight(screen);
	if((top = screen->cur_row - screen->topline) <= screen->max_row) {
		if(screen->scroll_amt)
			FlushScroll (screen);
		if(++top <= screen->max_row)
			XClearArea(screen->display, TextWindow (screen),
				   screen->border + screen->scrollbar, top *
				   FontHeight (screen) + screen->border,
				   Width(screen), (screen->max_row - top + 1) *
				   FontHeight(screen), FALSE);
	}
	ClearBufRows(screen, screen->cur_row + 1, screen->max_row);
}

/*
 * use when inserting or deleting characters on the current line
 */
static void horizontal_copy_area(screen, firstchar, nchars, amount)
TScreen	*screen;
int	firstchar;	/* char pos on screen to start copying at */
int	nchars;
int	amount;		/* number of characters to move right */
{
	int src_x = CursorX(screen, firstchar);
	int src_y = CursorY(screen, screen->cur_row);

	copy_area(screen, src_x, src_y,
		  nchars * FontWidth(screen), FontHeight(screen),
		  src_x + amount*FontWidth(screen), src_y);
}

