#ifndef lint
static char	*rcsid =
	"$Id: fonts.c,v 1.2 1993/06/14 11:48:54 danny Exp $";
#endif
#include "ptyx.h"
#include "screen.h"
#include "vtdefs.h"
#include "data.h"
#include "menu.h"

#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Converters.h>
#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
#include <ctype.h>

static	char *_Font_Selected_ = "yes";  /* string is arbitrary */

static void
DoSetSelectedFont(w, client_data, selection, type, value, length, format)
Widget		w;
XtPointer	client_data;
Atom		*selection, *type;
XtPointer	value;
unsigned long	*length;
int		*format;
{
	char *val = (char *)value;
	int len;

	if(*type != XA_STRING  ||  *format != 8) {
		Bell();
		return;
	}
	len = strlen(val);
	if(len > 0) {
		if(val[len-1] == '\n')
			val[len-1] = '\0';
		/*
		 | Do some sanity checking to avoid sending a long selection
		 | back to the server in an OpenFont that is unlikely to
		 | succeed. XLFD allows up to 255 characters and no control
		 | characters; we are a little more liberal here.
		 */
		if(len > 1000  ||  strchr(val, '\n'))
			return;
		if(!LoadNewFont(&term->screen, val, NULL, True, fontMenu_fontsel))
			Bell();
	}
}

void FindFontSelection(atom_name, justprobe)
char	*atom_name;
Bool	justprobe;
{
	static AtomPtr *atoms;
	static int atomCount = 0;
	AtomPtr *pAtom;
	int a;
	Atom target;

	if(!atom_name)
		atom_name = "PRIMARY";

	for(pAtom = atoms, a = atomCount; a; a--, pAtom++)
		if(strcmp(atom_name, XmuNameOfAtom(*pAtom)) == 0)
			break;
	if(!a) {
		atoms = (AtomPtr*) XtRealloc ((char *)atoms,
					      sizeof(AtomPtr)*(atomCount+1));
		*(pAtom = &atoms[atomCount++]) = XmuMakeAtom(atom_name);
	}
	
	target = XmuInternAtom(XtDisplay(term), *pAtom);
	if(justprobe)
		term->screen.menu_font_names[fontMenu_fontsel] = 
			XGetSelectionOwner(XtDisplay(term), target)? _Font_Selected_ : NULL;
	else
		XtGetSelectionValue((Widget)term, target, XA_STRING,
				    DoSetSelectedFont, NULL,
				    XtLastTimestampProcessed(XtDisplay(term)));
	return;
}


/* ARGSUSED */
void HandleSetFont(w, event, params, param_count)
Widget w;
XEvent *event;		/* unused */
String *params;		/* unused */
Cardinal *param_count;	/* unused */
{
	int fontnum;
	char *name1 = NULL, *name2 = NULL;

	if(*param_count == 0)
		fontnum = fontMenu_fontdefault;
	else {
		int maxparams = 1;	/* total number of params allowed */

		switch (params[0][0]) {
		case 'd': case 'D': case '0':
			fontnum = fontMenu_fontdefault; break;
		case '1':
			fontnum = fontMenu_font1; break;
		case '2':
			fontnum = fontMenu_font2; break;
		case '3':
			fontnum = fontMenu_font3; break;
		case '4':
			fontnum = fontMenu_font4; break;
		case '5':
			fontnum = fontMenu_font5; break;
		case '6':
			fontnum = fontMenu_font6; break;
		case 'e': case 'E':
			fontnum = fontMenu_fontescape; maxparams = 3; break;
		case 's': case 'S':
			fontnum = fontMenu_fontsel; maxparams = 2; break;
		default:
			Bell();
			return;
		}
		if(*param_count > maxparams) {	 /* see if extra args given */
			Bell();
			return;
		}
		switch(*param_count) {		/* assign 'em */
		case 3:
			name2 = params[2];
			/* fall through */
		case 2:
			name1 = params[1];
			break;
		}
	}

	SetVTFont(fontnum, True, name1, name2);
}


SetVTFont(i, doresize, name1, name2)
int	i;
Bool	doresize;
char	*name1, *name2;
{
	TScreen *screen = &term->screen;

	if(i < 0 || i >= NMENUFONTS) {
		Bell();
		return;
	}
	if(i == fontMenu_fontsel) {
		/*
		 | go get the selection
		 | name1 = atom, name2 is ignored
		 */
		FindFontSelection (name1, False);
		return;
	}
	if(!name1)
		name1 = screen->menu_font_names[i];
	if(!LoadNewFont(screen, name1, name2, doresize, i))
		Bell();
	return;
}


int LoadNewFont(screen, nfontname, bfontname, doresize, fontnum)
TScreen	*screen;
char	*nfontname, *bfontname;
Bool	doresize;
int	fontnum;
{
	XFontStruct	*nfs = NULL, *bfs = NULL;
	XGCValues	xgcv;
	unsigned long	mask;
	GC	new_normalGC = NULL, new_normalboldGC = NULL;
	GC	new_reverseGC = NULL, new_reverseboldGC = NULL;
	char	*tmpname = NULL;

	if(!nfontname)
		return 0;

	if(fontnum == fontMenu_fontescape &&
	   nfontname != screen->menu_font_names[fontnum]) {
		tmpname = (char *) malloc(strlen(nfontname) + 1);
		if(!tmpname)
			return 0;
		strcpy(tmpname, nfontname);
	}

	if(!(nfs = XLoadQueryFont (screen->display, nfontname)))
		goto bad;

	if(!(bfontname && 
	     (bfs = XLoadQueryFont (screen->display, bfontname))))
		bfs = nfs;

	mask = (GCFont | GCForeground | GCBackground | GCGraphicsExposures |
		GCFunction);

	xgcv.font = nfs->fid;
	xgcv.foreground = screen->foreground;
	xgcv.background = term->core.background_pixel;
	xgcv.graphics_exposures = TRUE;	/* default */
	xgcv.function = GXcopy;

	new_normalGC = XtGetGC((Widget)term, mask, &xgcv);
	if(!new_normalGC)
		goto bad;

	if(nfs == bfs)
		/* there is no bold font */
		new_normalboldGC = new_normalGC;
	else {
		xgcv.font = bfs->fid;
		new_normalboldGC = XtGetGC((Widget)term, mask, &xgcv);
		if(!new_normalboldGC)
			goto bad;
	}

	xgcv.font = nfs->fid;
	xgcv.foreground = term->core.background_pixel;
	xgcv.background = screen->foreground;
	new_reverseGC = XtGetGC((Widget)term, mask, &xgcv);
	if(!new_reverseGC)
		goto bad;

	if(nfs == bfs)
		/* there is no bold font */
		new_reverseboldGC = new_reverseGC;
	else {
		xgcv.font = bfs->fid;
		new_reverseboldGC = XtGetGC((Widget)term, mask, &xgcv);
		if(!new_reverseboldGC)
			goto bad;
	}

	if(screen->normalGC != screen->normalboldGC)
		XtReleaseGC ((Widget) term, screen->normalboldGC);
	XtReleaseGC ((Widget) term, screen->normalGC);
	if(screen->reverseGC != screen->reverseboldGC)
		XtReleaseGC ((Widget) term, screen->reverseboldGC);
	XtReleaseGC ((Widget) term, screen->reverseGC);
	screen->normalGC = new_normalGC;
	screen->normalboldGC = new_normalboldGC;
	screen->reverseGC = new_reverseGC;
	screen->reverseboldGC = new_reverseboldGC;
	screen->fnt_norm = nfs;
	screen->fnt_bold = bfs;
	screen->enbolden = (nfs == bfs);
	set_menu_font(False);
	screen->menu_font_number = fontnum;
	set_menu_font(True);
	if(tmpname) {
		/*
		 | if setting escape or sel
		 */
		if(screen->menu_font_names[fontnum])
			free (screen->menu_font_names[fontnum]);
		screen->menu_font_names[fontnum] = tmpname;
		if(fontnum == fontMenu_fontescape) {
			set_sensitivity(term->screen.fontMenu,
					fontMenuEntries[fontMenu_fontescape].widget,
					TRUE);
		}
	}
	set_cursor_gcs(screen);
	update_font_info(screen, doresize);
	return 1;

 bad:
	if(tmpname)
		free(tmpname);
	if(new_normalGC)
		XtReleaseGC((Widget)term, screen->normalGC);
	if(new_normalGC && new_normalGC != new_normalboldGC)
		XtReleaseGC((Widget)term, new_normalboldGC);
	if(new_reverseGC)
		XtReleaseGC((Widget)term, new_reverseGC);
	if(new_reverseGC && new_reverseGC != new_reverseboldGC)
		XtReleaseGC((Widget)term, new_reverseboldGC);
	if(nfs)
		XFreeFont(screen->display, nfs);
	if(nfs && nfs != bfs)
		XFreeFont (screen->display, bfs);
	return 0;
}


update_font_info (screen, doresize)
TScreen	*screen;
Bool	doresize;
{
	int	i, j, width, height, scrollbar_width;

	screen->fullVwin.f_width = screen->fnt_norm->max_bounds.width;
	screen->fullVwin.f_height = (screen->fnt_norm->ascent +
				     screen->fnt_norm->descent);
	scrollbar_width = (term->misc.scrollbar ? 
			   screen->scrollWidget->core.width +
			   screen->scrollWidget->core.border_width : 0);
	i = 2 * screen->border + scrollbar_width;
	j = 2 * screen->border;
	width = (screen->max_col + 1) * screen->fullVwin.f_width + i;
	height = (screen->max_row + 1) * screen->fullVwin.f_height + j;
	screen->fullVwin.fullwidth = width;
	screen->fullVwin.fullheight = height;
	screen->fullVwin.width = width - i;
	screen->fullVwin.height = height - j;

	if(doresize) {
		if(VWindow(screen))
			XClearWindow (screen->display, VWindow(screen));
		DoResizeScreen(term);	/* set to the new natural size */
		if(screen->scrollWidget)
			ResizeScrollBar(screen->scrollWidget, -1, -1,
					Height(screen) + screen->border * 2);
		Redraw();
	}
	set_vt_box(screen);
}

set_vt_box(screen)
TScreen *screen;
{
	XPoint	*vp;

	vp = &VTbox[1];
	(vp++)->x = FontWidth(screen) - 1;
	(vp++)->y = FontHeight(screen) - 1;
	(vp++)->x = -(FontWidth(screen) - 1);
	vp->y = -(FontHeight(screen) - 1);
	screen->box = VTbox;
}

set_cursor_gcs(screen)
TScreen *screen;
{
	XGCValues	xgcv;
	unsigned long	mask;
	unsigned long	cc = screen->cursorcolor;
	unsigned long	fg = screen->foreground;
	unsigned long	bg = term->core.background_pixel;

	GC new_cursorGC = NULL, new_reversecursorGC = NULL;
	GC new_cursoroutlineGC = NULL;

	/*
	 * Let's see, there are three things that have "color":
	 *
	 *     background
	 *     text
	 *     cursorblock
	 *
	 * And, there are four situation when drawing a cursor, if we decide
	 * that we like have a solid block of cursor color with the letter
	 * that it is highlighting shown in the background color to make it
	 * stand out:
	 *
	 *     selected window, normal video - background on cursor
	 *     selected window, reverse video - foreground on cursor
	 *     unselected window, normal video - foreground on background
	 *     unselected window, reverse video - background on foreground
	 *
	 * Since the last two are really just normalGC and reverseGC, we only
	 * need two new GC's.  Under monochrome, we get the same effect as
	 * above by setting cursor color to foreground.
	 */

	xgcv.font = screen->fnt_norm->fid;
	mask = (GCForeground | GCBackground | GCFont);
	if(cc != fg && cc != bg) {
		/* we have a colored cursor */
		xgcv.foreground = fg;
		xgcv.background = cc;
		new_cursorGC = XtGetGC ((Widget) term, mask, &xgcv);

		if(screen->always_highlight) {
			new_reversecursorGC = (GC)0;
			new_cursoroutlineGC = (GC)0;
		}
		else {
			xgcv.foreground = bg;
			xgcv.background = cc;
			new_reversecursorGC = XtGetGC((Widget)term, mask, &xgcv);
			xgcv.foreground = cc;
			xgcv.background = bg;
			new_cursoroutlineGC = XtGetGC((Widget)term, mask, &xgcv);
		}
	}
	else {
		new_cursorGC = (GC)0;
		new_reversecursorGC = (GC)0;
		new_cursoroutlineGC = (GC)0;
	}
	if(screen->cursorGC)
		XtReleaseGC((Widget)term, screen->cursorGC);
	if(screen->reversecursorGC)
		XtReleaseGC((Widget)term, screen->reversecursorGC);
	if(screen->cursoroutlineGC)
		XtReleaseGC((Widget)term, screen->cursoroutlineGC);

	screen->cursorGC = new_cursorGC;
	screen->reversecursorGC = new_reversecursorGC;
	screen->cursoroutlineGC = new_cursoroutlineGC;
}
