#ifndef lint
static char *rid="$XConsortium: main.c,v 1.200 92/03/11 17:36:12 gildea Exp $";
#endif /* lint */

/*
 * 				 W A R N I N G
 * 
 * If you think you know what all of this code is doing, you are
 * probably very mistaken.  There be serious and nasty dragons here.
 *
 * This client is *not* to be taken as an example of how to write X
 * Toolkit applications.  It is in need of a substantial rewrite,
 * ideally to create a generic tty widget with several different parsing
 * widgets so that you can plug 'em together any way you want.  Don't
 * hold your breath, though....
 */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard,
Massachusetts, and the Massachusetts Institute of Technology,
Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/


/* main.c */

#include "ptyx.h"
#include "screen.h"
#include "data.h"
#include "error.h"
#include "menu.h"
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xatom.h>
#include <pwd.h>
#include <ctype.h>

#include "pty.h"
#include "vtdefs.h"

char *ProgramName;
Boolean sunFunctionKeys;
int	Version = 1;
/*
 | used by VT (charproc.c) so why is it here?
 */

#define offset(field)	XtOffsetOf(struct _resource, field)

static XtResource application_resources[] = {
	{"name", "Name", XtRString, sizeof(char *),
		 offset(xterm_name), XtRString, "xterm"},
	{"iconGeometry", "IconGeometry", XtRString, sizeof(char *),
		 offset(icon_geometry), XtRString, (caddr_t) NULL},
	{XtNtitle, XtCTitle, XtRString, sizeof(char *),
		 offset(title), XtRString, (caddr_t) NULL},
	{XtNiconName, XtCIconName, XtRString, sizeof(char *),
		 offset(icon_name), XtRString, (caddr_t) NULL},
	{"termName", "TermName", XtRString, sizeof(char *),
		 offset(term_name), XtRString, (caddr_t) NULL},
	{"ttyModes", "TtyModes", XtRString, sizeof(char *),
		 offset(tty_modes), XtRString, (caddr_t) NULL},
	{"utmpInhibit", "UtmpInhibit", XtRBoolean, sizeof (Boolean),
		 offset(utmpInhibit), XtRString, "false"},
	{"sunFunctionKeys", "SunFunctionKeys", XtRBoolean, sizeof (Boolean),
		 offset(sunFunctionKeys), XtRString, "false"},
	{"waitForMap", "WaitForMap", XtRBoolean, sizeof (Boolean),
		 offset(wait_for_map), XtRString, "false"},
	{"useInsertMode", "UseInsertMode", XtRBoolean, sizeof (Boolean),
		 offset(useInsertMode), XtRString, "false"},
};
#undef offset

static char *fallback_resources[] = {
	"XTerm*SimpleMenu*menuLabel.vertSpace: 100",
	"XTerm*SimpleMenu*HorizontalMargins: 16",
	"XTerm*SimpleMenu*Sme.height: 16",
	"XTerm*SimpleMenu*Cursor: left_ptr",
	"XTerm*mainMenu.Label:  Main Options (no app-defaults)",
	"XTerm*vtMenu.Label:  VT Options (no app-defaults)",
	"XTerm*fontMenu.Label:  VT Fonts (no app-defaults)",
	"XTerm*tekMenu.Label:  Tek Options (no app-defaults)",
	NULL
};

/*
 | Command line options table.
 |  Only resources are entered here...there is a pass over the remaining
 |   options after XrmParseCommand is let loose.
 */
static XrmOptionDescRec optionDescList[] = {
{"-geometry",	"*vt100.geometry",XrmoptionSepArg,	(caddr_t) NULL},
{"-132",	"*c132",	XrmoptionNoArg,		(caddr_t) "on"},
{"+132",	"*c132",	XrmoptionNoArg,		(caddr_t) "off"},
{"-ah",		"*alwaysHighlight", XrmoptionNoArg,	(caddr_t) "on"},
{"+ah",		"*alwaysHighlight", XrmoptionNoArg,	(caddr_t) "off"},
{"-b",		"*internalBorder",XrmoptionSepArg,	(caddr_t) NULL},
{"-cb",		"*cutToBeginningOfLine", XrmoptionNoArg, (caddr_t) "off"},
{"+cb",		"*cutToBeginningOfLine", XrmoptionNoArg, (caddr_t) "on"},
{"-cc",		"*charClass",	XrmoptionSepArg,	(caddr_t) NULL},
{"-cn",		"*cutNewline",	XrmoptionNoArg,		(caddr_t) "off"},
{"+cn",		"*cutNewline",	XrmoptionNoArg,		(caddr_t) "on"},
{"-cr",		"*cursorColor",	XrmoptionSepArg,	(caddr_t) NULL},
{"-cu",		"*curses",	XrmoptionNoArg,		(caddr_t) "on"},
{"+cu",		"*curses",	XrmoptionNoArg,		(caddr_t) "off"},
{"-e",		NULL,		XrmoptionSkipLine,	(caddr_t) NULL},
{"-fb",		"*boldFont",	XrmoptionSepArg,	(caddr_t) NULL},
{"-j",		"*jumpScroll",	XrmoptionNoArg,		(caddr_t) "on"},
{"+j",		"*jumpScroll",	XrmoptionNoArg,		(caddr_t) "off"},
{"-l",		"*logging",	XrmoptionNoArg,		(caddr_t) "on"},
{"+l",		"*logging",	XrmoptionNoArg,		(caddr_t) "off"},
{"-lf",		"*logFile",	XrmoptionSepArg,	(caddr_t) NULL},
{"-ls",		"*loginShell",	XrmoptionNoArg,		(caddr_t) "on"},
{"+ls",		"*loginShell",	XrmoptionNoArg,		(caddr_t) "off"},
{"-mb",		"*marginBell",	XrmoptionNoArg,		(caddr_t) "on"},
{"+mb",		"*marginBell",	XrmoptionNoArg,		(caddr_t) "off"},
{"-mc",		"*multiClickTime", XrmoptionSepArg,	(caddr_t) NULL},
{"-ms",		"*pointerColor",XrmoptionSepArg,	(caddr_t) NULL},
{"-nb",		"*nMarginBell",	XrmoptionSepArg,	(caddr_t) NULL},
{"-rw",		"*reverseWrap",	XrmoptionNoArg,		(caddr_t) "on"},
{"+rw",		"*reverseWrap",	XrmoptionNoArg,		(caddr_t) "off"},
{"-aw",		"*autoWrap",	XrmoptionNoArg,		(caddr_t) "on"},
{"+aw",		"*autoWrap",	XrmoptionNoArg,		(caddr_t) "off"},
{"-s",		"*multiScroll",	XrmoptionNoArg,		(caddr_t) "on"},
{"+s",		"*multiScroll",	XrmoptionNoArg,		(caddr_t) "off"},
{"-sb",		"*scrollBar",	XrmoptionNoArg,		(caddr_t) "on"},
{"+sb",		"*scrollBar",	XrmoptionNoArg,		(caddr_t) "off"},
{"-sf",		"*sunFunctionKeys", XrmoptionNoArg,	(caddr_t) "on"},
{"+sf",		"*sunFunctionKeys", XrmoptionNoArg,	(caddr_t) "off"},
{"-si",		"*scrollTtyOutput",	XrmoptionNoArg,		(caddr_t) "off"},
{"+si",		"*scrollTtyOutput",	XrmoptionNoArg,		(caddr_t) "on"},
{"-sk",		"*scrollKey",	XrmoptionNoArg,		(caddr_t) "on"},
{"+sk",		"*scrollKey",	XrmoptionNoArg,		(caddr_t) "off"},
{"-sl",		"*saveLines",	XrmoptionSepArg,	(caddr_t) NULL},
{"-t",		"*tekStartup",	XrmoptionNoArg,		(caddr_t) "on"},
{"+t",		"*tekStartup",	XrmoptionNoArg,		(caddr_t) "off"},
{"-tm",		"*ttyModes",	XrmoptionSepArg,	(caddr_t) NULL},
{"-tn",		"*termName",	XrmoptionSepArg,	(caddr_t) NULL},
{"-ut",		"*utmpInhibit",	XrmoptionNoArg,		(caddr_t) "on"},
{"+ut",		"*utmpInhibit",	XrmoptionNoArg,		(caddr_t) "off"},
{"-im",		"*useInsertMode", XrmoptionNoArg,	(caddr_t) "on"},
{"+im",		"*useInsertMode", XrmoptionNoArg,	(caddr_t) "off"},
{"-vb",		"*visualBell",	XrmoptionNoArg,		(caddr_t) "on"},
{"+vb",		"*visualBell",	XrmoptionNoArg,		(caddr_t) "off"},
{"-wf",		"*waitForMap",	XrmoptionNoArg,		(caddr_t) "on"},
{"+wf",		"*waitForMap",	XrmoptionNoArg,		(caddr_t) "off"},
/* bogus old compatibility stuff for which there are
   standard XtAppInitialize options now */
{"%",		"*tekGeometry",	XrmoptionStickyArg,	(caddr_t) NULL},
{"#",		".iconGeometry",XrmoptionStickyArg,	(caddr_t) NULL},
{"-T",		"*title",	XrmoptionSepArg,	(caddr_t) NULL},
{"-n",		"*iconName",	XrmoptionSepArg,	(caddr_t) NULL},
{"-r",		"*reverseVideo",XrmoptionNoArg,		(caddr_t) "on"},
{"+r",		"*reverseVideo",XrmoptionNoArg,		(caddr_t) "off"},
{"-rv",		"*reverseVideo",XrmoptionNoArg,		(caddr_t) "on"},
{"+rv",		"*reverseVideo",XrmoptionNoArg,		(caddr_t) "off"},
{"-w",		".borderWidth", XrmoptionSepArg,	(caddr_t) NULL},
#ifdef HEBREW
{"-rl",		"*displayDirection", XrmoptionNoArg,	(caddr_t) "on"},
{"-lr",		"*displayDirection", XrmoptionNoArg,	(caddr_t) "off"},
{"-mirror",	"*screenMirror", XrmoptionNoArg,	(caddr_t) "on"},
{"+mirror",	"*screenMirror", XrmoptionNoArg,	(caddr_t) "off"},
#endif
};

static struct _options {
	char *opt;
	char *desc;
} options[] = {
{ "-help",                 "print out this message" },
{ "-display displayname",  "X server to contact" },
{ "-geometry geom",        "size (in characters) and position" },
{ "-/+rv",                 "turn on/off reverse video" },
{ "-bg color",             "background color" },
{ "-fg color",             "foreground color" },
{ "-bd color",             "border color" },
{ "-bw number",            "border width in pixels" },
{ "-fn fontname",          "normal text font" },
{ "-iconic",               "start iconic" },
{ "-name string",          "client instance, icon, and title strings" },
{ "-title string",         "title string" },
{ "-xrm resourcestring",   "additional resource specifications" },
{ "-/+132",                "turn on/off column switch inhibiting" },
{ "-/+ah",                 "turn on/off always highlight" },
{ "-b number",             "internal border in pixels" },
{ "-/+cb",                 "turn on/off cut-to-beginning-of-line inhibit" },
{ "-cc classrange",        "specify additional character classes" },
{ "-/+cn",                 "turn on/off cut newline inhibit" },
{ "-cr color",             "text cursor color" },
{ "-/+cu",                 "turn on/off curses emulation" },
{ "-fb fontname",          "bold text font" },
{ "-/+im",		   "use insert mode for TERMCAP" },
{ "-/+j",                  "turn on/off jump scroll" },
{ "-/+l",                  "turn on/off logging" },
{ "-lf filename",          "logging filename" },
{ "-/+ls",                 "turn on/off login shell" },
{ "-/+mb",                 "turn on/off margin bell" },
{ "-mc milliseconds",      "multiclick time in milliseconds" },
{ "-ms color",             "pointer color" },
{ "-nb number",            "margin bell in characters from right end" },
{ "-/+aw",                 "turn on/off auto wraparound" },
{ "-/+rw",                 "turn on/off reverse wraparound" },
{ "-/+s",                  "turn on/off multiscroll" },
{ "-/+sb",                 "turn on/off scrollbar" },
{ "-/+sf",                 "turn on/off Sun Function Key escape codes" },
{ "-/+si",                 "turn on/off scroll-on-tty-output inhibit" },
{ "-/+sk",                 "turn on/off scroll-on-keypress" },
{ "-sl number",            "number of scrolled lines to save" },
{ "-/+t",                  "turn on/off Tek emulation window" },
{ "-tm string",            "terminal mode keywords and characters" },
{ "-tn name",              "TERM environment variable name" },
#ifdef UTMP
{ "-/+ut",                 "turn on/off utmp inhibit" },
#else
{ "-/+ut",                 "turn on/off utmp inhibit (not supported)" },
#endif
{ "-/+vb",                 "turn on/off visual bell" },
{ "-/+wf",                 "turn on/off wait for map before command exec" },
{ "-e command args ...",   "command to execute" },
{ "%geom",                 "Tek window geometry" },
{ "#geom",                 "icon window geometry" },
{ "-T string",             "title name for window" },
{ "-n string",             "icon name for window" },
#ifdef TIOCCONS
{ "-C",                    "intercept console messages" },
#else
{ "-C",                    "intercept console messages (not supported)" },
#endif
{ "-Sxxd",                 "slave mode on \"ttyxx\", file descriptor \"d\"" },
#ifdef HEBREW
{ "-rl",		   "display direction is right to left"},
{ "-lr",		   "display direction is left to right"},
{ "-mirror",		   "screen in \"mirror mode\""},
{ "+mirror",		   "screen in \"normal mode\""},
#endif
{ NULL, NULL }
};

static char *message[] = {
"Fonts must be fixed width and, if both normal and bold are specified, must",
"have the same size.  If only a normal font is specified, it will be used for",
"both normal and bold text (by doing overstriking).  The -e option, if given,",
"must be appear at the end of the command line, otherwise the user's default",
"shell will be started.  Options that start with a plus sign (+) restore the",
"default.",
NULL};


extern WidgetClass xtermWidgetClass;

Arg ourTopLevelShellArgs[] = {
	{ XtNallowShellResize, (XtArgVal) TRUE },	
	{ XtNinput, (XtArgVal) TRUE },
};
int number_ourTopLevelShellArgs = 2;
	
XtAppContext app_con;
Widget toplevel;
Bool waiting_for_initial_map;

extern void do_hangup();

static void Syntax();
static void Help();

/*
 * DeleteWindow(): Action proc to implement ICCCM delete_window.
 */
void DeleteWindow(), KeyboardMapping();

XtActionsRec actionProcs[] = {
    "DeleteWindow", DeleteWindow,
    "KeyboardMapping", KeyboardMapping,
};

Atom wm_delete_window;


extern void HandlePopupMenu();

main(argc, argv)
int	argc;
char	**argv;
{
	TScreen		*screen;
	int		i, pty;
	int		xerror(), xioerror();
	char		passedPty[2];	/* name if pty if slave */
	char		**command_to_exec = 0;
	extern		SIGNAL_T reapchild();
	int		inhibit;

	ProgramName = argv[0];

	/* Init the Toolkit. */
	toplevel = XtAppInitialize(&app_con, "XTerm", 
				   optionDescList, XtNumber(optionDescList), 
				   &argc, argv, fallback_resources, NULL, 0);

	XtGetApplicationResources(toplevel, (XtPointer)&resource,
				  application_resources,
				  XtNumber(application_resources), NULL, 0);

	waiting_for_initial_map = resource.wait_for_map;

	/*
	 | ICCCM delete_window.
	 */
	XtAppAddActions(app_con, actionProcs, XtNumber(actionProcs));

	initTty();

	xterm_name = resource.xterm_name;
	sunFunctionKeys = resource.sunFunctionKeys;
	if(strcmp(xterm_name, "-") == 0)
		xterm_name = "xterm";

	if(resource.icon_geometry != NULL) {
		int scr, junk;
		int ix, iy;
		Arg args[2];

		for(scr = 0;	/* yyuucchh */
		    XtScreen(toplevel) != ScreenOfDisplay(XtDisplay(toplevel),scr);
		    scr++);

		args[0].name = XtNiconX;
		args[1].name = XtNiconY;
		XGeometry(XtDisplay(toplevel), scr, resource.icon_geometry, "",
			  0, 0, 0, 0, 0, &ix, &iy, &junk, &junk);
		args[0].value = (XtArgVal) ix;
		args[1].value = (XtArgVal) iy;
		XtSetValues( toplevel, args, 2);
	}

	XtSetValues(toplevel, ourTopLevelShellArgs,
		    number_ourTopLevelShellArgs);
	/*
	 | Parse the rest of the command line
	 */
	for(argc--, argv++ ; argc > 0 ; argc--, argv++) {
		if(**argv != '-')
			Syntax(*argv);

		switch(argv[0][1]) {
		case 'h':
			Help ();
			/* NOTREACHED */
		case 'C':
			takeConsole();
			continue;
		case 'S':
			if(sscanf(*argv + 2, "%c%c%d", passedPty, passedPty+1,
				  &am_slave) != 3)
				Syntax(*argv);
			continue;
#ifdef DEBUG
		case 'D':
			debug = TRUE;
			continue;
#endif	/* DEBUG */
		case 'e':
			if (argc <= 1)
				Syntax (*argv);
			command_to_exec = (++argv);
			break;
		default:
			Syntax (*argv);
		}
		break;
	}

	XawSimpleMenuAddGlobalActions(app_con);
	XtRegisterGrabAction(HandlePopupMenu, True,
			     (ButtonPressMask|ButtonReleaseMask),
			     GrabModeAsync, GrabModeAsync);

        term = (XtermWidget)XtCreateManagedWidget("vt100",
						  xtermWidgetClass,
						  toplevel, NULL, 0);
	/*
	 | this causes the initialize method to be called
	 */
        screen = &term->screen;

	if(screen->savelines < 0)
		screen->savelines = 0;
	inhibit = 0;

	if(term->misc.logInhibit)
		inhibit |= I_LOG;
	if(term->misc.signalInhibit)
		inhibit |= I_SIGNAL;
	if(term->misc.tekInhibit)
		inhibit |= I_TEK;

	KbInit();

	/*
	 | Set title and icon name if not specified
	 */
	if(command_to_exec) {
		Arg args[2];

		if(!resource.title && *command_to_exec) {
  		      if(resource.title = rindex(*command_to_exec,0))
  			      resource.title = *command_to_exec;
  		      else
  			      resource.title++;
		}
		if(!resource.icon_name) 
  		      resource.icon_name = resource.title;
		XtSetArg(args[0], XtNtitle, resource.title);
		XtSetValues(toplevel, args, 1);
	}

	if(inhibit & I_TEK)
		screen->TekEmu = FALSE;

	if(screen->TekEmu && !TekInit())
		exit(ERROR_INIT);

#ifdef DEBUG
	if(debug)
		setStderr();
#endif

	screen->arrow = make_colored_cursor(XC_left_ptr, 
					    screen->mousecolor,
					    screen->mousecolorback);

	spawn(passedPty, command_to_exec);
	/*
	 | Child process is out there, let's catch its termination
	 */
	signal(SIGCHLD, reapchild);

	/*
	 | Realize procs have now been executed
	 */
	pty = screen->respond;

	if(am_slave) {
		/* Write window id so master end can read and use */
		char buf[80];

		buf[0] = '\0';
		sprintf(buf, "%lx\n",screen->TekEmu?
			XtWindow(XtParent(tekWidget)):
			XtWindow(XtParent(term)));
		write(pty, buf, strlen (buf));
	}

	if(term->misc.log_on)
		StartLog(screen);

	screen->inhibit = inhibit;

	setUpPtyMasks(pty, ConnectionNumber(screen->display));

#ifdef DEBUG
	if(debug)
		printf ("debugging on\n");
#endif	/* DEBUG */

	XSetErrorHandler(xerror);
	XSetIOErrorHandler(xioerror);

	for(;;) {
		if(screen->TekEmu)
			TekRun();
		else
			VTRun();
	}
}

void DeleteWindow(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if(w == toplevel)
		if(term->screen.Tshow)
			hide_vt_window();
		else
			do_hangup(w);
	else
	if(term->screen.Vshow)
		hide_tek_window();
	else
		do_hangup(w);
}

/* ARGSUSED */
void KeyboardMapping(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	switch(event->type) {
	case MappingNotify:
#ifdef _HEBREW_
		{
			TScreen	*screen = &term->screen;
			int		format, stat;
			u_long		numitems, more;
			u_char		*keymap;
			Atom		type;
			extern Atom	KEYMAP;

			stat = XGetWindowProperty(screen->display,
					  DefaultRootWindow(screen->display),
						  KEYMAP, 0, 100,
						  False, XA_STRING,
						  &type, &format, &numitems,
						  &more, &keymap);
			if(stat == Success) {
				screen->globalKeyMap = 1;
				fprintf(stderr, "keymap='%s'\n", keymap);

				if(strcmp(keymap, "HEBR"))
					term->vt_mode |= M_DECHEB;
				else
				/* if(strcmp(keymap, "ENGL")) */
					term->vt_mode &= ~M_DECHEB;
			} else
				screen->globalKeyMap = 0;
			update_keyboard();
		}
#endif
		XRefreshKeyboardMapping(&event->xmapping);
		break;
        }
}

#ifdef DEBUG
/*
 | set up stderr properly
 */
setStderr()
{
	int	i;

	i = open("xterm.debug.log", O_WRONLY | O_CREAT | O_TRUNC, 0666);
	if(i >= 0) {
#if defined(USE_SYSV_TERMIO) && !defined(SVR4)
		/* SYSV has another pointer which should be part of the
		** FILE structure but is actually a seperate array.
		*/
		unsigned char *old_bufend;

		old_bufend = (unsigned char *) _bufend(stderr);
		stderr->_file = i;
		_bufend(stderr) = old_bufend;
#else	/* USE_SYSV_TERMIO */
		stderr->_file = i;
#endif	/* USE_SYSV_TERMIO */

		/* mark this file as close on exec */
		(void)fcntl(i, F_SETFD, 1);
	}
}
#endif /* DEBUG */

static void Syntax(badOption)
char *badOption;
{
	struct _options *opt;
	int col;

	fprintf(stderr, "%s:  bad command line option \"%s\"\r\n\n",
		ProgramName, badOption);

	fprintf(stderr, "usage:  %s", ProgramName);
	col = 8 + strlen(ProgramName);
	for(opt = options; opt->opt; opt++) {
		int len = 3 + strlen(opt->opt);	 /* space [ string ] */
		if (col + len > 79) {
			fprintf (stderr, "\r\n   ");  /* 3 spaces */
			col = 3;
		}
		fprintf(stderr, " [%s]", opt->opt);
		col += len;
	}

	fprintf(stderr, "\r\n\nType %s -help for a full description.\r\n\n",
		 ProgramName);
	exit(1);
}

static void Help ()
{
	struct _options *opt;
	char **cpp;

	fprintf(stderr, "usage:\n\t%s [-options ...] [-e command args]\n\n",
		ProgramName);
	fprintf(stderr, "where options include:\n");
	for(opt = options; opt->opt; opt++)
		fprintf (stderr, "\t%-28s %s\n", opt->opt, opt->desc);
	
	putc('\n', stderr);
	for(cpp = message; *cpp; cpp++) {
		fputs(*cpp, stderr);
		putc('\n', stderr);
	}
	putc('\n', stderr);

	exit (0);
}

