#ifndef lint
static char *rcsid = 
	"$Id: pty.c,v 1.3 1993/09/09 12:01:09 danny Exp $";
#endif

#include "ptyx.h"
#ifdef SYSV
#include "pty.h"
#endif
#include "screen.h"
#include "vtdefs.h"
#include "menu.h"
#include "data.h"
#include "error.h"
#include <X11/Xos.h>

#include <stdio.h>
#include <errno.h>

static Char *v_buffer;		/* pointer to physical buffer */
static Char *v_bufstr = NULL;	/* beginning of area to write */
static Char *v_bufptr;		/* end of area to write */
static Char *v_bufend;		/* end of physical buffer */

#define	ptymask()	(v_bufptr > v_bufstr ? pty_mask : 0)

/*
 * Check for both EAGAIN and EWOULDBLOCK, because some supposedly POSIX
 * systems are broken and return EWOULDBLOCK when they should return EAGAIN.
 * Note that this macro may evaluate its argument more than once.
 */
#if defined(EAGAIN) && defined(EWOULDBLOCK)
#define E_TEST(err) ((err) == EAGAIN || (err) == EWOULDBLOCK)
#else
#ifdef EAGAIN
#define E_TEST(err) ((err) == EAGAIN)
#else
#define E_TEST(err) ((err) == EWOULDBLOCK)
#endif
#endif

/*
 | Write data to the pty as typed by the user, pasted with the mouse,
 | or generated by us in response to a query ESC sequence.
 */
v_write(f, d, len)
int	f;
char	*d;
int	len;
{
	int riten;
	int c = len;

	if(v_bufstr == NULL  &&  len > 0) {
	        v_buffer = XtMalloc(len);
		v_bufstr = v_buffer;
		v_bufptr = v_buffer;
		v_bufend = v_buffer + len;
	}
#ifdef PTY_DEBUG
	fprintf(stderr, "v_write called with %d bytes (%d left over)",
		len, v_bufptr - v_bufstr);
	if(len > 1  &&  len < 10) fprintf(stderr, " \"%.*s\"", len, d);
	fprintf(stderr, "\n");
#endif

	if((1 << f) != pty_mask)
		return(write(f, d, len));

	/*
	 * Append to the block we already have.
	 * Always doing this simplifies the code, and
	 * isn't too bad, either.  If this is a short
	 * block, it isn't too expensive, and if this is
	 * a long block, we won't be able to write it all
	 * anyway.
	 */

	if(len > 0) {
		if(v_bufend < v_bufptr + len) { /* we've run out of room */
			if(v_bufstr != v_buffer) {
				/*
				  | there is unused space, move everything down
				  | possibly overlapping bcopy here
				  */
#ifdef PTY_DEBUG
				fprintf(stderr, "moving data down %d\n",
					v_bufstr - v_buffer);
#endif
				bcopy(v_bufstr, v_buffer, v_bufptr - v_bufstr);
				v_bufptr -= v_bufstr - v_buffer;
				v_bufstr = v_buffer;
			}
			if(v_bufend < v_bufptr + len) {
				/*
				 | still won't fit: get more space.  Don't use
				 | XtRealloc because an error is not fatal.
				 */
				/* save across realloc */
				int size = v_bufptr - v_buffer;

				v_buffer = (Char *)realloc(v_buffer, size + len);
				if(v_buffer) {
#ifdef PTY_DEBUG
					fprintf(stderr,
						"expanded buffer to %d\n",
						size + len);
#endif
					v_bufstr = v_buffer;
					v_bufptr = v_buffer + size;
					v_bufend = v_bufptr + len;
				}
				else {
					/*
					 | no memory: ignore entire
					 | write request
					 */
				    fprintf(stderr,
					    "%s: cannot allocate buffer space\n",
					    xterm_name);
				    /* restore clobbered pointer */
				    v_buffer = v_bufstr;
				    c = 0;
			    }
			}
		}
		if (v_bufend >= v_bufptr + len) {
			/* new stuff will fit */
			bcopy(d, v_bufptr, len);
			v_bufptr += len;
		}
	}
	
	/*
	 * Write out as much of the buffer as we can.
	 * Be careful not to overflow the pty's input silo.
	 * We are conservative here and only write
	 * a small amount at a time.
	 *
	 * If we can't push all the data into the pty yet, we expect write
	 * to return a non-negative number less than the length requested
	 * (if some data written) or -1 and set errno to EAGAIN,
	 * EWOULDBLOCK, or EINTR (if no data written).
	 *
	 * (Not all systems do this, sigh, so the code is actually
	 * a little more forgiving.)
	 */

#define MAX_PTY_WRITE 128	/* 1/2 POSIX minimum MAX_INPUT */

	if(v_bufptr > v_bufstr) {
		riten = write(f, v_bufstr,
			      v_bufptr - v_bufstr <= MAX_PTY_WRITE ?
			      v_bufptr - v_bufstr : MAX_PTY_WRITE);
		if (riten < 0) {
#ifdef PTY_DEBUG
			perror("write");
#endif
			riten = 0;
	    }
#ifdef PTY_DEBUG
		fprintf(stderr, "write called with %d, wrote %d\n",
			v_bufptr - v_bufstr <= MAX_PTY_WRITE ?
			v_bufptr - v_bufstr : MAX_PTY_WRITE,
			riten);
#endif
		v_bufstr += riten;
		if (v_bufstr >= v_bufptr) /* we wrote it all */
			v_bufstr = v_bufptr = v_buffer;
	}

	/*
	 * If we have lots of unused memory allocated, return it
	 */
	if(v_bufend - v_bufptr > 1024) { /* arbitrary hysteresis */
		/* save pointers across realloc */
		int start = v_bufstr - v_buffer;
		int size = v_bufptr - v_buffer;
		int allocsize = size ? size : 1;
	    
		v_buffer = (Char *)realloc(v_buffer, allocsize);
		if(v_buffer) {
			v_bufstr = v_buffer + start;
			v_bufptr = v_buffer + size;
			v_bufend = v_buffer + allocsize;
#ifdef PTY_DEBUG
			fprintf(stderr, "shrunk buffer to %d\n", allocsize);
#endif
		}
		else {
			/*
			 | should we print a warning
			 | if couldn't return memory?
			 */
			/* restore clobbered pointer */
			v_buffer = v_bufstr - start;
		}
	}
	return c;
}

static int select_mask;
static int write_mask;
static int pty_read_bytes;

in_put()
{
	TScreen *screen = &term->screen;
	int i;
	struct timeval select_timeout;

	for(;;) {
		if(select_mask & pty_mask && eventMode == NORMAL) {
			if(screen->logging)
				FlushLog(screen);
			bcnt = read(screen->respond,
				    (char *)(bptr = buffer), BUF_SIZE);
			if(bcnt < 0) {
				if(errno == EIO)
					Cleanup(0);
				else
				if(!E_TEST(errno))
					Panic("input: read returned unexpected error(%d)\n",
					      errno);
			} else
			if(bcnt == 0)
				Panic("input: read returned zero\n", 0);
			else {
				/* read from pty was successful */

#ifdef DEBUG1
			  {
			    int j;
			    fprintf(stderr,"in_put ");
			    for(j=0;j<bcnt;j++){
				fprintf(stderr,"%x-%c ",*(bptr+j),*(bptr+j));
			      }
			    fprintf(stderr,"end\n");
			  }
#endif
				if(!screen->output_eight_bits) {
					int bc = bcnt;
					Char *b = bptr;
					for(; bc > 0; bc--, b++)
						*b &=(Char) 0x7f;
				}
				if(screen->scrollWidget &&
				   screen->scrollttyoutput &&
				   screen->topline < 0)
					/* Scroll to bottom */
					WindowScroll(screen, 0);
				pty_read_bytes += bcnt;
				/* stop speed reading at some point to look for X stuff */
				/*(4096 is just a random large number.) */
				if(pty_read_bytes > 4096)
					select_mask &= ~pty_mask;
				break;
			}
		}
		pty_read_bytes = 0;
		/* update the screen */
		if(screen->scroll_amt)
			FlushScroll(screen);
		if(screen->cursor_set &&
		   (screen->cursor_col != screen->cur_col
		    || screen->cursor_row != screen->cur_row)) {
			if(screen->cursor_state)
				HideCursor();
			ShowCursor();
		} else
		if(screen->cursor_set != screen->cursor_state) {
			if(screen->cursor_set)
				ShowCursor();
			else
				HideCursor();
		}
		/* always flush writes before waiting */
		XFlush(screen->display);

		/*
		 | Update the masks and,
		 |  unless X events are already in the queue,
		 | wait for I/O to be possible.
		 */
		select_mask = Select_mask;
		write_mask = ptymask();
		select_timeout.tv_sec = 0;
		select_timeout.tv_usec = 0;
		i = select(max_plus1, &select_mask, &write_mask,(int *)NULL,
		    QLength(screen->display) ? &select_timeout
		    :(struct timeval *) NULL);
		if(i < 0) {
			if(errno != EINTR)
				SysError(ERROR_SELECT);
			continue;
		}

		/*
		 | if there is room to write more data to the pty,
		 | go write more
		 */
		if(write_mask & ptymask())
			 /* flush buffer */
			v_write(screen->respond, 0, 0);

		/*
		 | if there are X events already in our queue, it
		 |  counts as being readable
		 */
		if(QLength(screen->display) || (select_mask & X_mask))
			xevents();
	}
	bcnt--;

	return *bptr++;
}

resetInputBufp()
{
	int	i;

	bcnt = 0;
	bptr = buffer;
	while(Tpushb > Tpushback) {
		*bptr++ = *--Tpushb;
		bcnt++;
	}
	bcnt += (i = Tbcnt);
	for( ; i > 0 ; i--)
		*bptr++ = *Tbptr++;
	bptr = buffer;

}
