/* $Id: vtdefs.h,v 1.2 1993/09/09 11:41:42 danny Exp $ */
/*
 | Control Characters
 */
#define NUL    0x00
#define SOH    0x01
#define STX    0x02
#define ETX    0x03
#define EOT    0x04
#define ENQ    0x05
#define ACK    0x06
#define BEL    0x07
#define BS     0x08
#define HT     0x09
#define LF     0x0A
#define VT     0x0B
#define FF     0x0C
#define CR     0x0D
#define SO     0x0E
#define SI     0x0F
#define DLE    0x10
#define DC1    0x11
#define XON    0x11
#define DC2    0x12
#define DC3    0x13
#define XOFF   0x13
#define DC4    0x14
#define NAK    0x15
#define SYN    0x16
#define ETB    0x17
#define CAN    0x18
#define EM     0x19
#define SUB    0x1A
#define ESC    0x1B
#define FS     0x1C
#define GS     0x1D
#define RS     0x1E
#define US     0x1F
#define DEL    0x7F

#define IND	0x84
#define	NEL	0x85
#define HTS	0x88
#define RI	0x8D
#define SS2	0x8E
#define SS3	0x8F
#define DCS	0x90
#define CSI	0x9B
#define ST	0x9C

#define OSC	0x9D
#define PM	0x9E
#define APC	0x9F

#define IQUEST	0x8F	/* the 'inverted' question mark !? */


/*
 | define masks for keyboard.flags
 */
#	define M_SHIFTLOCK	BIT(0)	/* Shift/Caps Lock */
#define CAPS_LOCK	BIT(0)

#	define M_DECKPD	BIT(1)	/* Keypad application/Numeric */
#define KYPD_APL	BIT(1)

#	define M_KA		BIT(2)	/* Keyboard Action */
#define CURSOR_APL	BIT(2)

/*
 | screen.vt_modes - Terminal Modes
 */
#define M_LN		BIT(8)	/* Line feed - New line */
/*#define M_DECCK		BIT(9)	/* Cursor Key */
#define M_DECCOL	BIT(10)	/* Column - 80 / 132 */
#define M_DECSCL	BIT(11)	/* Scrolling sooth/jump */
#define M_DECSCN	BIT(12)	/* Screen reverse-video */
#define M_DECO		BIT(13)	/* Origin */
#define M_DECAW		BIT(14)	/* Auto Wrap */
#define M_IR		BIT(15) /* Insert/replace */

#define M_MARGBELL	BIT(16)	/* Margin Bell */
#	define M_POUND		BIT(17)	/* # or sterling pound */

#define M_R8BIT		BIT(20)	/* accept 8 bit input */
#define M_S8BIT		BIT(21)	/* send 8 bits ?? */

#define M_RVSAW		BIT(22)	/* xterm private: reverse auto wrap */ 

#ifdef HEBREW
#define M_DECHEB	BIT(23)	/* Hebrew Keyboard */
#define M_DECHE		BIT(24)	/* Hebrew Encoding */
#define M_DECRL		BIT(25)	/* Right to Left */
#define M_DECMIRROR	BIT(26) /* MIRROR */
#endif /* HEBREW */

/*	#define M_DECAN		/* ANSI - VT52 */
/*	#define M_DECAR		/* Auto Repeat */
/*	#define M_VISCR		/* Control Representation (Visual) */
/*	#define M_SR		/* Send/receive - Local Echo */
/*	#define M_XONXOFF	/* auto xon-xoff */
/*	#define M_DECINL	/* Interlace */
/*	#define M_UDKLOCK	/* User Defined Keys locked */
/*	#define M_UDFLOCK	/* User defined features locked */
/*	#define M_WARBELL	/* Warning Bell */
/*	#define M_KEYCLICK	/* key-click */
/*	#define M_VT52G		/* vt-52 graphic mode */
/*	#define M_INTERLACE	/* 72hz, 60Hz */
/*	#define M_DECPFF	/* Print FormFeed */
/*	#define M_DECPEX	/* Print extent */
/*	#define M_DECTCE	/* Text Cursor */
/*	#define M_DATAPROC	/* Data Processing Keys */
/*	#define M_BRKENABL	/* Break Key Enabled */
/*	#define M_CONCEAL	/* Conceal Answerback Message */
/*	#define M_AANSWR	/* Auto Answerback */
/*	#define M_STATUSLINE	/* Show Status Line */


#define _H	BIT(7)

#define	BLANK	' '
/*
 | terminal id
 */
#define VT220_ID	0
#define VT100_ID	1
#define VT101_ID	2
#define VT102_ID	3
/*
 | Printer Mode Operation
 */
#define PR_NORMAL	0
#define PR_AUTO		1
#define PR_CONTROLLER	2
#define PR_COPY		3
/*
 | Character Sets
 */
#define CS_ASCII	0
#define CS_UK		1
#define CS_DECSPEC	2
#define CS_DECSUPP	3
#define CS_SOFT		4
/*
 | Cursor type
 */
#define CURSOR_BLOCK	BIT(0)
#define CURSOR_BLINK	BIT(1)
#define CURSOR_ON	BIT(2)

/*
 | for cursorMove
 */
#define C_UP	0
#define C_DOWN	1
#define C_RIGHT	2
#define C_LEFT	3
/*
 | VTxxx type of emulation
 */
#define VT100	0
#define VT102	1
#define VT200	2
#define VT200_8	3
