/* $Id: editpwin.c,v 1.2 1995/06/02 03:23:59 pturner Exp pturner $
 *
 * spreadsheet-like editing of data points
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/Separator.h>
#include <Xm/Protocols.h>

#include "globals.h"
#include "motifinc.h"
#include "noxprotos.h"

static SetChoiceItem editp_set_item;

#ifdef HAS_XBAE

#include <Xbae/Matrix.h>

String **cells;

static short widths[6] =
{10, 10, 10, 10, 10, 10};
static int precision[6] =
{3, 3, 3, 3, 3, 3};
static int format[6] =
{DECIMAL, DECIMAL, DECIMAL, DECIMAL, DECIMAL, DECIMAL};

String labels1[2] =
{"X", "Y"};
String labels2[3] =
{"X", "Y", "DX"};
String labels3[3] =
{"X", "Y", "DY"};
String labels4[4] =
{"X", "Y", "DX1", "DX2"};
String labels5[4] =
{"X", "Y", "DY1", "DY2"};
String labels6[4] =
{"X", "Y", "DX", "DY"};
String labels7[3] =
{"X", "Y", "DZ"};
String labels8[5] =
{"X", "HI", "LO", "OPEN", "CLOSE"};
String labels9[4] =
{"X", "Y", "Radius", "Theta"};

String *rowlabels;
String *collabels = labels1;

/* */
typedef struct _EditPoints {
    int gno;
    int setno;
    int ncols;
    int nrows;
    String *collabels;
    short *widths;
    Widget top;
    Widget mw;
    Widget *editp_format_item;
    Widget *editp_precision_item;
    Widget *editp_width_item;
    int cformat[10];
    int cprec[10];
    int cwidth[10];
} EditPoints;

typedef enum {
    NoSelection,
    CellSelection,
    RowSelection,
    ColumnSelection
} SelectionType;

typedef enum {
    AddMode,
    ExclusiveMode
} SelectionMode;

typedef struct _SelectionStruct {
    int row, column;
    SelectionType type;
    SelectionMode mode;
    Boolean selected;
    Widget matrix;
}

*SelectionPtr, SelectionStruct;

EditPoints *newep(int gno, int setno)
{
    int i;
    EditPoints *ep;
    ep = (EditPoints *) malloc(sizeof(EditPoints));
    ep->gno = gno;
    ep->setno = setno;
    ep->ncols = getncols(gno, setno);
    ep->nrows = getsetlength(gno, setno);
    g[gno].p[setno].ep = ep;
    switch (dataset_type(gno, setno)) {
    case XY:
	ep->collabels = labels1;
	break;
    case XYDX:
	ep->collabels = labels2;
	break;
    case XYDY:
	ep->collabels = labels3;
	break;
    case XYDXDX:
	ep->collabels = labels4;
	break;
    case XYDYDY:
	ep->collabels = labels5;
	break;
    case XYDXDY:
	ep->collabels = labels6;
	break;
    case XYZ:
	ep->collabels = labels7;
	break;
    case XYHILO:
	ep->collabels = labels8;
	break;
    case XYRT:
	ep->collabels = labels9;
	break;
    }
    for (i=0;i<6;i++) {
	ep->cwidth[i] = widths[i];
	ep->cprec[i] = precision[i];
	ep->cformat[i] = format[i];
    }
    return ep;
}

void epdtor(EditPoints * ep)
{				/* This could be a source of leakage TODO */
    int gno = ep->gno;
    int setno = ep->setno;
    XtUnmanageChild(ep->top);
/* TODO got a leaker here!!!!!!!! ep becomes unreferenced
    XtDestroyWidget(ep->top);
    free(ep);
*/
    g[gno].p[setno].ep = NULL;
}

void create_ss_frame(EditPoints * ep);

void do_ss_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    EditPoints *ep;
    int setno = GetSelectedSet(editp_set_item);
    int gno = cg;
    if (isactive(gno, setno)) {
	if ((ep = (EditPoints *) geteditpoints(gno, setno)) != NULL) {
	    XtRaise(ep->top);
	} else {
	    ep = newep(gno, setno);
	    create_ss_frame(ep);
	}
    } else {
	errwin("Set not active");
    }
}

String **MakeCells(EditPoints * ep)
{
    char buf[512];
    int i, j;
    double *datap;
    String **cells = NULL;
    if (ep != NULL) {
	cells = (String **) XtMalloc(sizeof(String *) * ep->nrows);
	if (cells != NULL) {
	    for (i = 0; i < ep->nrows; i++) {
		cells[i] = (String *) XtMalloc(sizeof(String) * ep->ncols);
		for (j = 0; j < ep->ncols; j++) {
		    datap = getcol(ep->gno, ep->setno, j);
		    sprintf(buf, "%12.*lf", ep->cprec[j], datap[i]);
		    cells[i][j] = XtNewString(buf);
		}
	    }
	}
    }
    return cells;
}

static Widget *editp_col_item;
static Widget *editp_format_item;
static Widget *editp_precision_item;
static Widget *editp_width_item;

static void update_props(EditPoints * ep)
{
    int col, rows;
    short *widths, width;
    Widget matrix = ep->mw;
    col = GetChoice(editp_col_item);
    XtVaGetValues(matrix,
		  XmNcolumnWidths, &widths,
		  NULL);
/*
    SetChoice(editp_format_item, ep->cformat[col]); 
*/
    SetChoice(editp_precision_item, ep->cprec[col]);
    SetChoice(editp_width_item, ep->cwidth[col]);
}

static void do_accept_props(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i, col, rows;
    short widths[6], width;
    int *lengths, length;
    String label, *row_labels, *column_labels;
    String **cells;
    EditPoints *ep = (EditPoints *) client_data;
    Widget matrix = ep->mw;
    col = GetChoice(editp_col_item);
/*
    ep->cformat[col] = GetChoice(editp_format_item);
*/
    ep->cprec[col] = GetChoice(editp_precision_item);
    ep->cwidth[col] = GetChoice(editp_width_item);
    for (i=0;i<6;i++) {
	widths[i] = ep->cwidth[i];
    }
/*
    cells = MakeCells(ep);
    if (cells != NULL) {
	XtVaSetValues(matrix,
		      XmNcells, cells,
		      XmNcolumnWidths, widths,
		      NULL);
    }
*/
    XtVaSetValues(matrix, XmNcolumnWidths, widths, NULL);
}

void do_props_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int rows;
    int x, y;
    static Widget top;
    Widget dialog;
    Widget wbut, rc;
    short *widths, width;
    int *lengths, length;
    String label, *row_labels, *column_labels;
    String **cells;
    EditPoints *ep = (EditPoints *) client_data;
    Widget matrix = ep->mw;

    set_wait_cursor();
    if (top == NULL) {
	char buf[32];
	double *xp, *yp;
	Widget but1[2];
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	XmGetPos(app_shell, 0, &x, &y);
	top = XmCreateDialogShell(app_shell, "Edit set", NULL, 0);
	handle_close(top);
	XtVaSetValues(top, XmNx, x, XmNy, y, NULL);
	dialog = XmCreateRowColumn(top, "dialog_rc", NULL, 0);

	editp_col_item = CreatePanelChoice(dialog, "Apply to column:",
				    8, "1", "2", "3", "4", "5", "6", "All",
					   NULL, 0);

	editp_format_item = CreatePanelChoice(dialog, "Format:",
					      4,
					      "Decimal",
					      "General",
					      "Exponential",
					      NULL, 0);

	editp_precision_item = CreatePanelChoice(dialog, "Precision:",
						 11,
						 "0", "1", "2", "3", "4",
						 "5", "6", "7", "8", "9",
						 NULL, 0);

	editp_width_item = CreatePanelChoice0(dialog, "Width:",
					     5, 21,
					     "1", "2", "3", "4", "5",
			      "6", "7", "8", "9", "10", 
				"11", "12", "13", "14", "15",
				"16", "17", "18", "19", "20",
					     NULL, 0);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) do_accept_props, (XtPointer) ep);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);
	XtManageChild(dialog);
    }
    update_props(ep);
    XtRaise(top);
    unset_wait_cursor();
}

void verifyCB(Widget w, XtPointer client_data, XtPointer calld)
{
    XbaeMatrixModifyVerifyCallbackStruct *cs = (XbaeMatrixModifyVerifyCallbackStruct *) calld;
/*
    printf("Called verify %d %d\n", cs->row, cs->column);
*/
}

void enterCB(Widget w, XtPointer client_data, XtPointer calld)
{
    XbaeMatrixEnterCellCallbackStruct *cs = (XbaeMatrixEnterCellCallbackStruct *) calld;
/*
    printf("Called enter %d %d\n", cs->row, cs->column);
*/
}

void leaveCB(Widget w, XtPointer client_data, XtPointer calld)
{
    double *datap;
    String **cells;
    char buf[128];
    EditPoints *ep = (EditPoints *) client_data;
    XbaeMatrixLeaveCellCallbackStruct *cs = (XbaeMatrixLeaveCellCallbackStruct *) calld;
    XtVaGetValues(w, XmNcells, &cells, NULL);
/*
    printf("Called leave %d %d, %s\n", cs->row, cs->column, cs->value);
*/
    datap = getcol(ep->gno, ep->setno, cs->column);
    sprintf(buf, "%8.1lf", datap[cs->row]);
    if (strcmp(buf, cs->value) != 0) {
	String s = (String) XtMalloc(sizeof(char) * (strlen(buf) + 1));
	strcpy(s, buf);
	cells[cs->row][cs->column] = s;
	datap[cs->row] = atof(cs->value);
	updatesetminmax(ep->gno, ep->setno);
	update_set_status(ep->gno, ep->setno);
	drawgraph();
    }
}

void drawcellCB(Widget w, XtPointer client_data, XtPointer calld)
{
    double *datap;
    EditPoints *ep = (EditPoints *) client_data;
    String cell;
    static char buf[128];
    int i, j;
    XbaeMatrixDrawCellCallbackStruct *cs = (XbaeMatrixDrawCellCallbackStruct *) calld;
    i = cs->row;
    j = cs->column;
    datap = getcol(ep->gno, ep->setno, j);
    sprintf(buf, "%12.*lf", ep->cprec[j], datap[i]);
/*
    printf("Called draw cell %d %d = %s\n", i, j, buf);
    cell = (String) XtMalloc(sizeof(char) * (strlen(buf) + 1));
    cs->string = cell;
    strcpy(cell, buf);
*/
    cs->type = XbaeString;
    cs->string = buf;
}

void selectCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XbaeMatrixSelectCellCallbackStruct *sc =
    (XbaeMatrixSelectCellCallbackStruct *) call_data;
/*
    SelectionPtr selection = GetSelectionFromWidget(w);

    if (selection->mode == ExclusiveMode && selection->selected)
        switch (selection->type) {
        case CellSelection:
            XbaeMatrixDeselectCell(w, selection->row, selection->column);
            break;
        case RowSelection:
            XbaeMatrixDeselectRow(w, selection->row);
            break;
        case ColumnSelection:
            XbaeMatrixDeselectColumn(w, selection->column);
            break;
        }

    selection->row = call_data->row;
    selection->column = call_data->column;

    switch (selection->type) {
    case CellSelection:
        XbaeMatrixSelectCell(w, selection->row, selection->column);
        break;
    case RowSelection:
        XbaeMatrixSelectRow(w, selection->row);
        break;
    case ColumnSelection:
        XbaeMatrixSelectColumn(w, selection->column);
        break;
    }

    selection->selected = True;
*/
    XbaeMatrixSelectRow(w, sc->row);
    XbaeMatrixSelectColumn(w, sc->column);
/*
    printf("Selected %d %d\n", sc->row, sc->column);
*/
}

void create_editp_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    int x, y;
    static Widget top;
    Widget dialog;
    Widget wbut, rc;

    set_wait_cursor();

    if (top == NULL) {
	Widget but1[2];
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	XmGetPos(app_shell, 0, &x, &y);
	top = XmCreateDialogShell(app_shell, "Edit set", NULL, 0);
	handle_close(top);
	XtVaSetValues(top, XmNx, x, XmNy, y, NULL);
	dialog = XmCreateRowColumn(top, "dialog_rc", NULL, 0);
	editp_set_item = CreateSetSelector(dialog, "Edit set:",
					   SET_SELECT_ACTIVE,
					   FILTER_SELECT_NONE,
					   GRAPH_SELECT_CURRENT,
					   SELECTION_TYPE_SINGLE);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) do_ss_frame, NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);

	XtManageChild(dialog);
    }
    XtRaise(top);
    unset_wait_cursor();
}

void create_ss_frame(EditPoints * ep)
{
    int x, y;
    Widget dialog;
    Widget wbut, rc;
    char buf[32];
    int i, j;
    double *datap;
    Widget but1[2];
    char *label1[2];
    label1[0] = "Props...";
    label1[1] = "Close";

    set_wait_cursor();
    XmGetPos(app_shell, 0, &x, &y);
    ep->top = XmCreateDialogShell(app_shell, "Edit set", NULL, 0);
    handle_close(ep->top);
    XtVaSetValues(ep->top, XmNx, x, XmNy, y, NULL);
    dialog = XmCreateRowColumn(ep->top, "dialog_rc", NULL, 0);

    cells = MakeCells(ep);

    rowlabels = (String *) malloc(ep->nrows * sizeof(String));
    for (i = 0; i < ep->nrows; i++) {
	sprintf(buf, "%d", i + 1);
	rowlabels[i] = (String) malloc((sizeof(buf) + 1) * sizeof(char));
	strcpy(rowlabels[i], buf);
    }
    ep->mw = XtVaCreateManagedWidget("mw",
				     xbaeMatrixWidgetClass, dialog,
				     XmNrows, ep->nrows,
				     XmNcolumns, ep->ncols,
				     XmNcolumnWidths, widths,
				     XmNvisibleRows, 10,
				     XmNvisibleColumns, 2,
				     XmNrowLabels, rowlabels,
				     XmNcolumnLabels, ep->collabels,
				     XmNcells, cells,
				     NULL);
    XtAddCallback(ep->mw, XmNdrawCellCallback, drawcellCB, ep);
    XtAddCallback(ep->mw, XmNmodifyVerifyCallback, verifyCB, ep);
    XtAddCallback(ep->mw, XmNleaveCellCallback, leaveCB, ep);
    XtAddCallback(ep->mw, XmNenterCellCallback, enterCB, ep);
    XtAddCallback(ep->mw, XmNselectCellCallback, selectCB, ep);
/*
    XtVaSetValues(w,
                  XmNuserData, selection,
                  NULL);

    ep->cells = cells;
*/
    for (i = 0; i < ep->nrows; i++) {
	for (j = 0; j < ep->ncols; j++) {
	    XtFree((XtPointer) cells[i][j]);
	}
	XtFree((XtPointer) cells[i]);
    }
    XtFree((XtPointer) cells);

    XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

    CreateCommandButtons(dialog, 2, but1, label1);
    XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) do_props_proc, (XtPointer) ep);
    XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) ep->top);

    XtManageChild(dialog);
    XtRaise(ep->top);
    unset_wait_cursor();
}

#else

/*
 * Create the editor using xterm & GR_EDITOR
 */
void create_editp_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    char tbuf[256], buf[256], *fname, *mktemp(char *);
    char ebuf[256], *s;
    if ((s = getenv("GR_EDITOR")) != NULL) {
	strcpy(ebuf, s);
    } else {
	strcpy(ebuf, "vi");
    }
    strcpy(tbuf, "/tmp/xmgrXXXXXX");
    fname = mktemp(tbuf);
    sprintf(buf, "xterm -e %s %s", ebuf, fname);
    system(buf);
    getdata(cg, fname, DISK, XY);
}

#endif
