
# line 2 "pars.yacc"

/* $Id: pars.yacc,v 1.4 1995/06/30 22:32:11 pturner Exp pturner $
 * 
 * evaluate expressions, commands, parameter files
 * 
 */

#define PARS			/* to overide some defines in defines.h */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <sys/param.h>

#include "globals.h"
#include "noxprotos.h"

#ifndef M_PI
#     define M_PI  3.14159265358979323846
#endif

#ifndef TRUE
#     define TRUE 1
#endif

#ifndef FALSE
#     define FALSE 0
#endif

double result, resx, resy;	/* return value if expression */
double nonl_parms[10];

double drand48(void);
long lrand48(void);
double erf(double arg); /* doesn't seem to be in ANSI C */
double erfc(double arg); /* doesn't seem to be in ANSI C */
double rnorm(double mean, double sdev);
double fx(double x);
double normp(double b, double *s);
double invnorm(double p);
double invt(double p, int n);
double *getvptr(int gno, int setno, int v);
double vmin(double *x, int n);
double vmax(double *x, int n);
void yyerror(char *s);

static int interr;

static double *freelist[100]; 	/* temporary vectors */
static int fcnt;		/* number allocated */

int naxis = 0;	/* current axis */
int curline, curbox, curellipse, curstring, curleg, curgrid;

int gotbatch, gotparams, gotread; /* these guys attempt to avoid reentrancy problems */
int readtype, readsrc, readxformat;
char batchfile[256], paramfile[256], readfile[256];

static char f_string[512];	/* buffer for string to parse */
static int pos = 0;
static double *aa, *bb, *cc, *dd, *xx, *yy;
static int setindex, lxy, ls;
static int setsetno;
static int whichgraph;
static int whichset;

extern int change_gno;
extern int change_type;


# line 74 "pars.yacc"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
    double val;
    long ival;
    double *ptr;
    long func;
    long pset;
    char *str;
} YYSTYPE;
# define ABS 257
# define ACOS 258
# define ASIN 259
# define ATAN 260
# define ATAN2 261
# define CEIL 262
# define COS 263
# define DEG 264
# define DX 265
# define DY 266
# define ERF 267
# define ERFC 268
# define EXP 269
# define FLOOR 270
# define HYPOT 271
# define INDEX 272
# define INT 273
# define INVN 274
# define INVT 275
# define IRAND 276
# define JDAY 277
# define JDAY0 278
# define LGAMMA 279
# define LN 280
# define LOG 281
# define LOGISTIC 282
# define MAXP 283
# define MINP 284
# define MOD 285
# define NORM 286
# define NORMP 287
# define PI 288
# define RAD 289
# define RAND 290
# define RNORM 291
# define SETNO 292
# define SIN 293
# define SQR 294
# define SQRT 295
# define TAN 296
# define INUM 297
# define VX1 298
# define VX2 299
# define VY1 300
# define VY2 301
# define WX1 302
# define WX2 303
# define WY1 304
# define WY2 305
# define DELAYP 306
# define DOUBLEBUFFER 307
# define DOWN 308
# define ABSOLUTE 309
# define ABORT 310
# define ACTIVATE 311
# define ACTIVE 312
# define ALT 313
# define ALTERNATE 314
# define ALTXAXIS 315
# define ALTYAXIS 316
# define ANGLE 317
# define ANNOTATE 318
# define APPEND 319
# define AREA 320
# define ARRANGE 321
# define ARROW 322
# define ASCENDING 323
# define AUTO 324
# define AUTOSCALE 325
# define AUTOTICKS 326
# define AVG 327
# define AXIS 328
# define AXES 329
# define BACKBUFFER 330
# define BACKGROUND 331
# define BAR 332
# define BATCH 333
# define BLOCK 334
# define BIN 335
# define BOTH 336
# define BOTTOM 337
# define BOX 338
# define BOXPLOT 339
# define CD 340
# define CELLS 341
# define CENTER 342
# define CHAR 343
# define CHRSTR 344
# define CLEAR 345
# define CLICK 346
# define CMAP 347
# define COLOR 348
# define COMMENT 349
# define COPY 350
# define CYCLE 351
# define DECIMAL 352
# define DEF 353
# define DEFAULT 354
# define DELETE 355
# define DEVICE 356
# define DESCENDING 357
# define DFT 358
# define DIFFERENCE 359
# define DISK 360
# define DRAW2 361
# define DROP 362
# define DXDX 363
# define DXP 364
# define DYDY 365
# define DYP 366
# define ECHO 367
# define EDIT 368
# define ELSE 369
# define END 370
# define ERRORBAR 371
# define EXIT 372
# define EXPONENTIAL 373
# define FALSEP 374
# define FFT 375
# define FILEP 376
# define FILL 377
# define FIND 378
# define FIXEDPOINT 379
# define FLUSH 380
# define FOCUS 381
# define FOLLOWS 382
# define FONTP 383
# define FOREGROUND 384
# define FORMAT 385
# define FRONTBUFFER 386
# define FRAMEP 387
# define GETP 388
# define GRAPH 389
# define GRAPHNO 390
# define GRAPHS 391
# define GRAPHTYPE 392
# define GRID 393
# define HARDCOPY 394
# define HBAR 395
# define HBOXPLOT 396
# define HGAP 397
# define HIDDEN 398
# define HORIZONTAL 399
# define HPGLL 400
# define HPGLP 401
# define HISTO 402
# define IF 403
# define IGNORE 404
# define IHL 405
# define IMAGE 406
# define IN 407
# define INIT 408
# define INOUT 409
# define INTEGRATE 410
# define INTERP 411
# define INVDFT 412
# define INVFFT 413
# define JUST 414
# define KILL 415
# define LABEL 416
# define LAYOUT 417
# define LEAVE 418
# define LEFT 419
# define LEGEND 420
# define LENGTH 421
# define LEVEL 422
# define LEVELS 423
# define LINE 424
# define LINESTYLE 425
# define LINETO 426
# define LINEWIDTH 427
# define LINK 428
# define LOAD 429
# define LOCATOR 430
# define LOCTYPE 431
# define LOGX 432
# define LOGY 433
# define LOGXY 434
# define MAJOR 435
# define MIFL 436
# define MIFP 437
# define MINOR 438
# define MISSINGP 439
# define MOVE 440
# define MOVE2 441
# define MOVETO 442
# define NEGATE 443
# define NO 444
# define NONE 445
# define NORMAL 446
# define NXY 447
# define OFF 448
# define OFFSETX 449
# define OFFSETY 450
# define ON 451
# define OP 452
# define ORIENT 453
# define OUT 454
# define PAGE 455
# define PARA 456
# define PARALLEL 457
# define PARAMETERS 458
# define PARAMS 459
# define PATTERN 460
# define PERIMETER 461
# define PERP 462
# define PERPENDICULAR 463
# define PIE 464
# define PIPE 465
# define PLACE 466
# define POINT 467
# define POLAR 468
# define POLY 469
# define POWER 470
# define PREC 471
# define PREPEND 472
# define PRINT 473
# define PS 474
# define PSCOLORP 475
# define PSMONOP 476
# define PSCOLORL 477
# define PSMONOL 478
# define PUSH 479
# define POP 480
# define PUTP 481
# define RAWSPICE 482
# define READ 483
# define REDRAW 484
# define REGRESS 485
# define REGNUM 486
# define REGIONS 487
# define RENDER 488
# define REVERSE 489
# define RIGHT 490
# define RISER 491
# define ROT 492
# define RUNAVG 493
# define RUNMED 494
# define RUNSTD 495
# define RUNMIN 496
# define RUNMAX 497
# define SAMPLE 498
# define SAVEALL 499
# define SCALE 500
# define SCIENTIFIC 501
# define SET 502
# define SETNUM 503
# define SETS 504
# define SIGN 505
# define SIZE 506
# define SKIP 507
# define SLEEP 508
# define SLICE 509
# define SMITH 510
# define SORT 511
# define SOURCE 512
# define SPEC 513
# define SPECIFIED 514
# define SPECTRUM 515
# define STACK 516
# define STACKEDBAR 517
# define STACKEDHBAR 518
# define STACKEDLINE 519
# define STAGGER 520
# define START 521
# define STARTTYPE 522
# define STATUS 523
# define STOP 524
# define STRING 525
# define SUBTITLE 526
# define SWAPBUFFER 527
# define SYMBOL 528
# define TICKP 529
# define TICKLABEL 530
# define TICKMARKS 531
# define TIME 532
# define TITLE 533
# define TO 534
# define TOP 535
# define TRUEP 536
# define TYPE 537
# define UP 538
# define VELOCITY 539
# define VERTICAL 540
# define VGAP 541
# define VIEW 542
# define WITH 543
# define WORLD 544
# define WRITE 545
# define X 546
# define X0 547
# define X1 548
# define XAXES 549
# define XAXIS 550
# define XCOR 551
# define XMAX 552
# define XMIN 553
# define XY 554
# define XYARC 555
# define XYBOX 556
# define XYBOXPLOT 557
# define XYFIXED 558
# define XYHILO 559
# define XYRT 560
# define XYSEG 561
# define XYSTRING 562
# define XYDX 563
# define XYDY 564
# define XYDXDX 565
# define XYDYDY 566
# define XYDXDY 567
# define XYX2Y2 568
# define XYXX 569
# define XYYY 570
# define XYZ 571
# define XYZW 572
# define XYUV 573
# define TSV 574
# define Y 575
# define Y0 576
# define Y1 577
# define Y2 578
# define Y3 579
# define Y4 580
# define Y5 581
# define YAXES 582
# define YAXIS 583
# define YES 584
# define YMAX 585
# define YMIN 586
# define ZEROXAXIS 587
# define ZEROYAXIS 588
# define ABOVE 589
# define BELOW 590
# define POLYI 591
# define POLYO 592
# define GENERAL 593
# define DDMMYY 594
# define YYMMDD 595
# define MMDDYY 596
# define MMYY 597
# define MMDD 598
# define MONTHDAY 599
# define DAYMONTH 600
# define MONTHS 601
# define MONTHSY 602
# define MONTHL 603
# define DAYOFWEEKS 604
# define DAYOFWEEKL 605
# define DAYOFYEAR 606
# define HMS 607
# define MMDDHMS 608
# define MMDDYYHMS 609
# define YYMMDDHMS 610
# define DEGREESLON 611
# define DEGREESMMLON 612
# define DEGREESMMSSLON 613
# define MMSSLON 614
# define DEGREESLAT 615
# define DEGREESMMLAT 616
# define DEGREESMMSSLAT 617
# define MMSSLAT 618
# define DOT 619
# define STAR 620
# define PLUS 621
# define CROSS 622
# define CIRCLE 623
# define SQUARE 624
# define DIAMOND 625
# define TRIANGLE1 626
# define TRIANGLE2 627
# define TRIANGLE3 628
# define TRIANGLE4 629
# define SPLINE 630
# define LANDSCAPE 631
# define PORTRAIT 632
# define FREE 633
# define FIXED 634
# define STATUSBAR 635
# define LOCATORBAR 636
# define TOOLBAR 637
# define VAR 638
# define NUMBER 639
# define FITPARM 640
# define OR 641
# define AND 642
# define GT 643
# define LT 644
# define LE 645
# define GE 646
# define EQ 647
# define NE 648
# define UMINUS 649
# define NOT 650
# define ELLIPSE 651

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 3624 "pars.yacc"


void fixupstr(char *val)
{
    int vl = strlen(val);
    lowtoupper(val);
    val[vl + 1] = 0;
    val[vl] = '\n';
}

void scanner(char *s, double *x, double *y, int len, double *a, double *b, double *c, double *d, int lenscr, int i, int setno, int *errpos)
{
    interr = 0;
    whichgraph = cg;
    whichset = setno;
    if (s[0] == '#') {
	return;
    }
    pos = 0;
    aa = a;
    bb = b;
    cc = c;
    dd = d;
    xx = x;
    yy = y;
    lxy = len;
    ls = lenscr;
    setindex = i + 1;
    curset = setsetno = setno;
    strcpy(f_string, s);
    fcnt = 0;
    log_results(s);
    yyparse();
    *errpos = interr;
    for (i = 0; i < fcnt; i++) {
	cfree(freelist[i]);
	freelist[i] = NULL;
    }
}

void runbatch(char *bfile)
{
    double x, y, a, b, c, d;
    int i, setno, errpos, lcnt = 1;
    char stext[256];
    FILE *fp;
    if (strcmp("stdin", bfile)) {
	fp = fopen(bfile, "r");
    }
    else {
	fp = stdin;
    }
    if (fp == NULL) {
        fprintf(stderr, "Error opening batch file \"%s\"\n", bfile);
        exit(1);
    }
    while(fgets(stext, 255, fp) != NULL) {
        if (stext[0] == '#') {
            continue;
        }
	if (strlen(stext) == 0) {
	    continue;
	}
        lowtoupper(stext);
/* TODO check on 0, 0 here for index and setno */
        scanner(stext, &x, &y, 1, ax, bx, cx, dx, 1, 0, 0, &errpos);
        stext[0] = 0;
        if (gotparams && paramfile[0]) {
            if (!getparms(cg, paramfile)) {
            }
            gotparams = 0;
        } else if (gotread && readfile[0]) {
            if (getdata(cg, readfile, readsrc, readtype)) {
                drawgraph();
            }
            gotread = 0;
        }
    }
    if (fp != stdin) {
	fclose(fp);
    }
}

symtab_entry key[] = {
	"A", VAR,
	"A0", FITPARM,
	"A1", FITPARM,
	"A2", FITPARM,
	"A3", FITPARM,
	"A4", FITPARM,
	"A5", FITPARM,
	"A6", FITPARM,
	"A7", FITPARM,
	"A8", FITPARM,
	"A9", FITPARM,
	"ABORT", ABORT,
	"ABOVE", ABOVE,
	"ABS", ABS,
	"ABSOLUTE", ABSOLUTE,
	"ACOS", ACOS,
	"ACTIVATE", ACTIVATE,
	"ACTIVE", ACTIVE,
	"ALT", ALT,
	"ALTERNATE", ALTERNATE,
	"ALTXAXIS", ALTXAXIS,
	"ALTYAXIS", ALTYAXIS,
	"AND", AND,
	"ANGLE", ANGLE,
	"ANNOTATE", ANNOTATE,
	"APPEND", APPEND,
	"AREA", AREA,
	"ARRANGE", ARRANGE,
	"ARROW", ARROW,
	"ASCENDING", ASCENDING,
	"ASIN", ASIN,
	"ATAN", ATAN,
	"ATAN2", ATAN2,
	"AUTO", AUTO,
	"AUTOSCALE", AUTOSCALE,
	"AUTOTICKS", AUTOTICKS,
	"AVG", AVG,
	"AXES", AXES,
	"AXIS", AXIS,
	"B", VAR,
	"BACKBUFFER", BACKBUFFER,
	"BACKGROUND", BACKGROUND,
	"BAR", BAR,
	"BATCH", BATCH,
	"BELOW", BELOW,
	"BIN", BIN,
	"BLOCK", BLOCK,
	"BOTH", BOTH,
	"BOTTOM", BOTTOM,
	"BOX", BOX,
	"BOXPLOT", BOXPLOT,
	"C", VAR,
	"CD", CD,
	"CEIL", CEIL,
	"CELLS", CELLS,
	"CENTER", CENTER,
	"CHAR", CHAR,
	"CHRSTR", CHRSTR,
	"CLEAR", CLEAR,
	"CLICK", CLICK,
	"CMAP", CMAP,
	"CO", COLOR,
	"COLOR", COLOR,
	"COMMENT", COMMENT,
	"COPY", COPY,
	"COS", COS,
	"CYCLE", CYCLE,
	"D", VAR,
	"DAYMONTH", DAYMONTH,
	"DAYOFWEEKL", DAYOFWEEKL,
	"DAYOFWEEKS", DAYOFWEEKS,
	"DAYOFYEAR", DAYOFYEAR,
	"DDMMYY", DDMMYY,
	"DECIMAL", DECIMAL,
	"DEF", DEF,
	"DEFAULT", DEFAULT,
	"DEG", DEG,
	"DEGREESLAT", DEGREESLAT,
	"DEGREESLON", DEGREESLON,
	"DEGREESMMLAT", DEGREESMMLAT,
	"DEGREESMMLON", DEGREESMMLON,
	"DEGREESMMSSLAT", DEGREESMMSSLAT,
	"DEGREESMMSSLON", DEGREESMMSSLON,
	"DELAY", DELAYP,
	"DELETE", DELETE,
	"DESCENDING", DESCENDING,
	"DEVICE", DEVICE,
	"DFT", DFT,
	"DIFF", DIFFERENCE,
	"DIFFERENCE", DIFFERENCE,
	"DISK", DISK,
	"DOUBLEBUFFER", DOUBLEBUFFER,
	"DOWN", DOWN,
	"DRAW2", DRAW2,
	"DROP", DROP,
	"DX", DX,
	"DXDX", DXDX,
	"DY", DY,
	"DYDY", DYDY,
	"ECHO", ECHO,
	"EDIT", EDIT,
	"ELLIPSE", ELLIPSE,
	"ELSE", ELSE,
	"END", END,
	"EQ", EQ,
	"ER", ERRORBAR,
	"ERF", ERF,
	"ERFC", ERFC,
	"ERRORBAR", ERRORBAR,
	"EXIT", EXIT,
	"EXP", EXP,
	"EXPONENTIAL", EXPONENTIAL,
	"FALSE", FALSEP,
	"FFT", FFT,
	"FILE", FILEP,
	"FILL", FILL,
	"FIND", FIND,
	"FIXED", FIXED,
	"FIXEDPOINT", FIXEDPOINT,
	"FLOOR", FLOOR,
	"FLUSH", FLUSH,
	"FOCUS", FOCUS,
	"FOLLOWS", FOLLOWS,
	"FONT", FONTP,
	"FOREGROUND", FOREGROUND,
	"FORMAT", FORMAT,
	"FRAME", FRAMEP,
	"FREE", FREE,
	"FRONTBUFFER", FRONTBUFFER,
	"GE", GE,
	"GENERAL", GENERAL,
	"GETP", GETP,
	"GRAPH", GRAPH,
	"GRAPHS", GRAPHS,
	"GRAPHTYPE", GRAPHTYPE,
	"GRID", GRID,
	"GT", GT,
	"HARDCOPY", HARDCOPY,
	"HBAR", HBAR,
	"HBOXPLOT", HBOXPLOT,
	"HGAP", HGAP,
	"HIDDEN", HIDDEN,
	"HISTO", HISTO,
	"HMS", HMS,
	"HORIZONTAL", HORIZONTAL,
	"HPGLL", HPGLL,
	"HPGLP", HPGLP,
	"HYPOT", HYPOT,
	"IF", IF,
	"IGNORE", IGNORE,
	"IHL", IHL,
	"IMAGE", IMAGE,
	"IN", IN,
	"INDEX", INDEX,
	"INIT", INIT,
	"INOUT", INOUT,
	"INT", INT,
	"INTEGRATE", INT,
	"INTERP", INTERP,
	"INUM", INUM,
	"INVDFT", INVDFT,
	"INVFFT", INVFFT,
	"INVN", INVN,
	"INVT", INVT,
	"IRAND", IRAND,
	"JDAY", JDAY,
	"JDAY0", JDAY0,
	"JUST", JUST,
	"KILL", KILL,
	"LABEL", LABEL,
	"LANDSCAPE", LANDSCAPE,
	"LAYOUT", LAYOUT,
	"LE", LE,
	"LEAVE", LEAVE,
	"LEFT", LEFT,
	"LEGEND", LEGEND,
	"LENGTH", LENGTH,
	"LEVEL", LEVEL,
	"LEVELS", LEVELS,
	"LGAMMA", LGAMMA,
	"LINE", LINE,
	"LINESTYLE", LINESTYLE,
	"LINETO", LINETO,
	"LINEWIDTH", LINEWIDTH,
	"LINK", LINK,
	"LN", LN,
	"LOAD", LOAD,
	"LOCATOR", LOCATOR,
	"LOCATORBAR", LOCATORBAR,
	"LOCTYPE", LOCTYPE,
	"LOG", LOG,
	"LOGISTIC", LOGISTIC,
	"LOGX", LOGX,
	"LOGXY", LOGXY,
	"LOGY", LOGY,
	"LS", LINESTYLE,
	"LT", LT,
	"LW", LINEWIDTH,
	"MAJOR", MAJOR,
	"MAX", MAXP,
	"MIFL", MIFL,
	"MIFP", MIFP,
	"MIN", MINP,
	"MINOR", MINOR,
	"MISSING", MISSINGP,
	"MMDD", MMDD,
	"MMDDHMS", MMDDHMS,
	"MMDDYY", MMDDYY,
	"MMDDYYHMS", MMDDYYHMS,
	"MMSSLAT", MMSSLAT,
	"MMSSLON", MMSSLON,
	"MMYY", MMYY,
	"MOD", MOD,
	"MONTHDAY", MONTHDAY,
	"MONTHL", MONTHL,
	"MONTHS", MONTHS,
	"MONTHSY", MONTHSY,
	"MOVE", MOVE,
	"MOVE2", MOVE2,
	"MOVETO", MOVETO,
	"NE", NE,
	"NEGATE", NEGATE,
	"NO", NO,
	"NONE", NONE,
	"NORM", NORM,
	"NORMAL", NORMAL,
	"NORMP", NORMP,
	"NOT", NOT,
	"NUMBER", NUMBER,
	"NXY", NXY,
	"OFF", OFF,
	"OFFSETX", OFFSETX,
	"OFFSETY", OFFSETY,
	"ON", ON,
	"OP", OP,
	"OR", OR,
	"ORIENT", ORIENT,
	"OUT", OUT,
	"PAGE", PAGE,
	"PARA", PARA,
	"PARALLEL", PARALLEL,
	"PARAMETERS", PARAMETERS,
	"PARAMS", PARAMS,
	"PATTERN", PATTERN,
	"PERIMETER", PERIMETER,
	"PERP", PERP,
	"PERPENDICULAR", PERPENDICULAR,
	"PI", PI,
	"PIE", PIE,
	"PIPE", PIPE,
	"PLACE", PLACE,
	"POINT", POINT,
	"POLAR", POLAR,
	"POLY", POLY,
	"POLYI", POLYI,
	"POLYO", POLYO,
	"POP", POP,
	"PORTRAIT", PORTRAIT,
	"POWER", POWER,
	"PREC", PREC,
	"PREPEND", PREPEND,
	"PRINT", PRINT,
	"PS", PS,
	"PSCOLORL", PSCOLORL,
	"PSCOLORP", PSCOLORP,
	"PSMONOL", PSMONOL,
	"PSMONOP", PSMONOP,
	"PUSH", PUSH,
	"PUTP", PUTP,
	"RAD", RAD,
	"RAND", RAND,
	"RAWSPICE", RAWSPICE,
	"READ", READ,
	"REDRAW", REDRAW,
	"REGRESS", REGRESS,
	"RENDER", RENDER,
	"REVERSE", REVERSE,
	"RIGHT", RIGHT,
	"RISER", RISER,
	"RNORM", RNORM,
	"ROT", ROT,
	"RUNAVG", RUNAVG,
	"RUNMAX", RUNMAX,
	"RUNMED", RUNMED,
	"RUNMIN", RUNMIN,
	"RUNSTD", RUNSTD,
	"SAMPLE", SAMPLE,
	"SAVEALL", SAVEALL,
	"SCALE", SCALE,
	"SCIENTIFIC", SCIENTIFIC,
	"SET", SET,
	"SETNO", SETNO,
	"SETS", SETS,
	"SIGN", SIGN,
	"SIN", SIN,
	"SIZE", SIZE,
	"SKIP", SKIP,
	"SLEEP", SLEEP,
	"SLICE", SLICE,
	"SORT", SORT,
	"SOURCE", SOURCE,
	"SPEC", SPEC,
	"SPECIFIED", SPECIFIED,
	"SPECTRUM", SPECTRUM,
	"SPLINE", SPLINE,
	"SQR", SQR,
	"SQRT", SQRT,
	"STACK", STACK,
	"STACKEDBAR", STACKEDBAR,
	"STACKEDHBAR", STACKEDHBAR,
	"STACKEDLINE", STACKEDLINE,
	"STAGGER", STAGGER,
	"START", START,
	"STARTTYPE", STARTTYPE,
	"STATUS", STATUS,
	"STATUSBAR", STATUSBAR,
	"STOP", STOP,
	"STRING", STRING,
	"SUBTITLE", SUBTITLE,
	"SWAPBUFFER", SWAPBUFFER,
	"SYMBOL", SYMBOL,
	"TAN", TAN,
	"TICK", TICKP,
	"TICKLABEL", TICKLABEL,
	"TICKMARKS", TICKMARKS,
	"TIME", TIME,
	"TITLE", TITLE,
	"TO", TO,
	"TOOLBAR", TOOLBAR,
	"TOP", TOP,
	"TRUE", TRUEP,
	"TSV", TSV,
	"TYPE", TYPE,
	"UP", UP,
	"VAR", VAR,
	"VELOCITY", VELOCITY,
	"VERTICAL", VERTICAL,
	"VGAP", VGAP,
	"VIEW", VIEW,
	"VX1", VX1,
	"VX2", VX2,
	"VY1", VY1,
	"VY2", VY2,
	"WITH", WITH,
	"WORLD", WORLD,
	"WRITE", WRITE,
	"WX1", WX1,
	"WX2", WX2,
	"WY1", WY1,
	"WY2", WY2,
	"X", X,
	"X0", X0,
	"X1", X1,
	"XAXES", XAXES,
	"XAXIS", XAXIS,
	"XCOR", XCOR,
	"XMAX", XMAX,
	"XMIN", XMIN,
	"XY", XY,
	"XYARC", XYARC,
	"XYBOX", XYBOX,
	"XYBOXPLOT", XYBOXPLOT,
	"XYDX", XYDX,
	"XYDXDX", XYDXDX,
	"XYDXDY", XYDXDY,
	"XYDY", XYDY,
	"XYDYDY", XYDYDY,
	"XYFIXED", XYFIXED,
	"XYHILO", XYHILO,
	"XYRT", XYRT,
	"XYSEG", XYSEG,
	"XYSTRING", XYSTRING,
	"XYUV", XYUV,
	"XYX2Y2", XYX2Y2,
	"XYXX", XYXX,
	"XYYY", XYYY,
	"XYZ", XYZ,
	"XYZW", XYZW,
	"Y", Y,
	"Y0", Y0,
	"Y1", Y1,
	"Y2", Y2,
	"Y3", Y3,
	"Y4", Y4,
	"Y5", Y5,
	"YAXES", YAXES,
	"YAXIS", YAXIS,
	"YES", YES,
	"YMAX", YMAX,
	"YMIN", YMIN,
	"YYMMDD", YYMMDD,
	"YYMMDDHMS", YYMMDDHMS,
	"ZEROXAXIS", ZEROXAXIS,
	"ZEROYAXIS", ZEROYAXIS,
};

int maxparms = sizeof(key) / sizeof(symtab_entry);
int maxfunc = sizeof(key) / sizeof(symtab_entry);

int findf(symtab_entry *key, char *s, int tlen)
{

    int low, high, mid;

    low = 0;
    high = tlen - 1;
    while (low <= high) {
	mid = (low + high) / 2;
	if (strcmp(s, key[mid].s) < 0) {
	    high = mid - 1;
	} else {
	    if (strcmp(s, key[mid].s) > 0) {
		low = mid + 1;
	    } else {
		return (mid);
	    }
	}
    }
    return (-1);
}

int getcharstr(void)
{
    if (pos >= strlen(f_string))
	 return EOF;
    return (f_string[pos++]);
}

void ungetchstr(void)
{
    if (pos > 0)
	pos--;
}

int yylex(void)
{
    int c, i;
    int found;
    static char s[256];
    char sbuf[256];
    char *str;

    while ((c = getcharstr()) == ' ' || c == '\t');
    if (c == EOF) {
	return (0);
    }
    if (c == '"') {
	i = 0;
	while ((c = getcharstr()) != '"' && c != EOF) {
	    if (c == '\\') {
		int ctmp;
		ctmp = getcharstr();
		if (ctmp != '"') {
		    ungetchstr();
		}
		else {
		    c = ctmp;
		}
	    }
	    s[i] = c;
	    i++;
	}
	if (c == EOF) {
	    yyerror("Nonterminating string");
	    return 0;
	}
	s[i] = '\0';
	str = (char *) malloc(strlen(s) + 1);
	strcpy(str, s);
	yylval.str = str;
	return CHRSTR;
    }
    if (c == '.' || isdigit(c)) {
	char stmp[80];
	double d;
	int i, gotdot = 0;

	i = 0;
	while (c == '.' || isdigit(c)) {
	    if (c == '.') {
		if (gotdot) {
		    yyerror("Reading number, too many dots");
	    	    return 0;
		} else {
		    gotdot = 1;
		}
	    }
	    stmp[i++] = c;
	    c = getcharstr();
	}
	if (c == 'E' || c == 'e') {
	    stmp[i++] = c;
	    c = getcharstr();
	    if (c == '+' || c == '-') {
		stmp[i++] = c;
		c = getcharstr();
	    }
	    while (isdigit(c)) {
		stmp[i++] = c;
		c = getcharstr();
	    }
	}
	if (gotdot && i == 1) {
	    ungetchstr();
	    return '.';
	}
	stmp[i] = '\0';
	ungetchstr();
	sscanf(stmp, "%lf", &d);
	yylval.val = d;
	return NUMBER;
    }
/* graphs, sets, regions resp. */
    if (c == 'G' || c == 'S' || c == 'R') {
	char stmp[80];
	double d;
	int i = 0, ctmp = c, gn, sn, rn;
	c = getcharstr();
	while (isdigit(c)) {
	    stmp[i++] = c;
	    c = getcharstr();
	}
	if (i == 0) {
	    c = ctmp;
	    ungetchstr();
	} else {
	    ungetchstr();
	    if (ctmp == 'G') {
	        stmp[i] = '\0';
		gn = atoi(stmp);
		if (gn >= 0 && gn < maxgraph) {
		    yylval.ival = gn;
		    whichgraph = gn;
		    return GRAPHNO;
		}
	    } else if (ctmp == 'S') {
	        stmp[i] = '\0';
		sn = atoi(stmp);
		if (sn >= 0 && sn < g[cg].maxplot) {
		    lxy = getsetlength(cg, sn);
		    yylval.ival = sn;
		    whichset = sn;
		    return SETNUM;
		}
	    } else if (ctmp == 'R') {
	        stmp[i] = '\0';
		rn = atoi(stmp);
		if (rn >= 0 && rn < MAXREGION) {
		    yylval.ival = rn;
		    return REGNUM;
		}
	    }
	}
    }
    if (isalpha(c)) {
	char *p = sbuf;
	int gno = -1, setno = -1, xy = -1, elno = -1;

	do {
	    *p++ = c;
	} while ((c = getcharstr()) != EOF && isalnum(c));
	ungetchstr();
	*p = '\0';
        if (debuglevel == 2) {
	    printf("->%s<-\n", sbuf);
	}
	if ((found = findf(key, sbuf, maxfunc)) >= 0) {
	    if (key[found].type == VAR) {
		switch (sbuf[0]) {
		case 'A':
		    yylval.ptr = aa;
		    return VAR;
		case 'B':
		    yylval.ptr = bb;
		    return VAR;
		case 'C':
		    yylval.ptr = cc;
		    return VAR;
		case 'D':
		    yylval.ptr = dd;
		    return VAR;
		}
	    }
	    else if (key[found].type == FITPARM) {
		int index = sbuf[1] - '0';
		yylval.val = nonl_parms[index];
		return FITPARM;
	    }
	    else { /* set up special cases */
		switch (key[found].type) {
		case XAXIS:
		    naxis = 0;
		    break;
		case YAXIS:
		    naxis = 1;
		    break;
		case ZEROXAXIS:
		    naxis = 2;
		    break;
		case ZEROYAXIS:
		    naxis = 3;
		    break;
		case ALTXAXIS:
		    naxis = 4;
		    break;
		case ALTYAXIS:
		    naxis = 5;
		    break;
		case AXES:
		    naxis = 6;
		    break;
		case XAXES:
		    naxis = 7;
		    break;
		case YAXES:
		    naxis = 8;
		    break;
		case GRAPHS:
		    yylval.ival = -1;
		    whichgraph = -1;
		    return GRAPHS;
		    break;
		case SETS:
		    yylval.ival = -1;
		    whichset = -1;
		    return SETS;
		    break;
		default:
		    break;
		}
	    }
	    yylval.func = key[found].type;
	    return key[found].type;
	} else {
	    strcat(sbuf, ": No such function or variable");
	    yyerror(sbuf);
	    return 0;
	}
    }
    switch (c) {
    case '>':
	return follow('=', GE, GT);
    case '<':
	return follow('=', LE, LT);
    case '=':
	return follow('=', EQ, '=');
    case '!':
	return follow('=', NE, NOT);
    case '|':
	return follow('|', OR, '|');
    case '&':
	return follow('&', AND, '&');
    case '\n':
	return '\n';
    default:
	return c;
    }
}

int follow(int expect, int ifyes, int ifno)
{
    int c = getcharstr();

    if (c == expect) {
	return ifyes;
    }
    ungetchstr();
    return ifno;
}

void yyerror(char *s)
{
    int i;
    char buf[256];
    sprintf(buf, "%s: %s", s, f_string);
    i = strlen(buf);
    buf[i - 1] = 0;
    errwin(buf);
    interr = 1;
}

#define C1 0.1978977093962766
#define C2 0.1352915131768107

double rnorm(double mean, double sdev)
{
    double u = drand48();

    return mean + sdev * (pow(u, C2) - pow(1.0 - u, C2)) / C1;
}

double fx(double x)
{
    return 1.0 / sqrt(2.0 * M_PI) * exp(-x * x * 0.5);
}

double normp(double b, double *s)
{
    double sum, dx, a = -8.0, fx(double x);
    int i, n = 48;

    sum = fx(a) + fx(b);
    dx = (b - a) / n;
    for (i = 1; i <= ((n - 1) / 2); i++)
	sum = sum + 4.0 * fx(a + (2.0 * i - 1.0) * dx) + 2.0 * fx(a + 2.0 * i * dx);
    sum = sum + 4.0 * fx(b - dx);
    *s = fx(b);
    return sum * dx / 3.0;
}

double invnorm(double p)
{
    double s, x, z, temp, normp(double b, double *s);

    if (p > 0.5)
	x = 1.0 - p;
    else
	x = p;
    s = sqrt(-2.0 * log(x));
    x = ((-7.49101 * s - 448.047) * s - 1266.846);
    x = x / (((s + 109.8371) * s + 748.189) * s + 498.003) + s;
    if (p < 0.5)
	x = -x;
    z = p - normp(x, &s);
    z = z / s;
    s = x * x;
    return (((((((((720.0 * s + 2556.0) * s + 1740.0) * s + 127.0) * z / 7.0 +
		 ((120.0 * s + 326.0) * s + 127.0) * x) * z / 6.0 + (24 * s + 46.0) * s + 7.0) * z / 40.0 +
	       (0.75 * s + 0.875) * x) * z + s + 0.5) * z / 3.0 + x * 0.5) * z + 1.0) * z + x + 0.832e-24 * x;
}

double invt(double p, int n)
{
    double sign, temp, a, b, c, d, x, y;

    sign = 1.0;
    if (p < 0.5) {
	p = 1.0 - p;
	sign = -1.0;
    }
    p = (1 - p) * 2;
    if (n == 2) {
	temp = sqrt(2.0 / (p * (2.0 - p)) - 2.0);
	temp = sign * temp;
	return temp;
    } else if (n == 1) {
	p = p * M_PI / 2.0;
	return sign * cos(p) / sin(p);
    } else {
	a = 1.0 / (n - 0.5);
	b = 48.0 / (a * a);
	c = ((20700 * a / b - 98.0) * a - 16.0) * a + 96.36;
	d = ((94.5 / (b + c) - 3.0) / b + 1.0) * sqrt(a * M_PI / 2.0) * n;
	x = d * p;
	y = exp((2.0 / n) * log(x));
	if (y > (0.05 + a)) {
	    x = invnorm(p * 0.5);
	    y = x * x;
	    if (n < 5)
		c = c + 0.3 * (n - 4.5) * (x + 0.6);
	    c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
	    y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
	    y = a * y * y;
	    if (y > 0.002)
		y = exp(y) - 1.0;
	    else
		y = 0.5 * y * y + y;
	} else
	    y = ((1.0 / (((n + 0.6) / (n * y) - 0.089 * d - 0.822) * (n + 2.0) * 3.0) + 0.5 / (n + 4.0)) * y - 1.0) * (n + 1.0) / (n + 2.0) + 1.0 / y;
	return sign * sqrt(n * y);
    }
}

/*
 * return a pointer to the array given by v
 */
double *getvptr(int gno, int setno, int v)
{
    switch (v) {
    case X:
    case X0:
	return g[gno].p[setno].ex[0];
	break;
    case Y:
    case Y0:
	return g[gno].p[setno].ex[1];
	break;
    case Y1:
	return g[gno].p[setno].ex[2];
	break;
    case Y2:
	return g[gno].p[setno].ex[3];
	break;
    case Y3:
	return g[gno].p[setno].ex[4];
	break;
    case Y4:
	return g[gno].p[setno].ex[5];
	break;
    case Y5:
	return g[gno].p[setno].ex[6];
	break;
    }
    return NULL;
}
yytabelem yyexca[] ={
-1, 0,
	0, 1,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
-1, 28,
	37, 688,
	-2, 616,
-1, 44,
	37, 712,
	-2, 625,
-1, 45,
	37, 713,
	-2, 626,
-1, 61,
	37, 729,
	-2, 641,
-1, 62,
	37, 730,
	-2, 642,
-1, 63,
	37, 731,
	-2, 643,
-1, 286,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 746,
-1, 296,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 748,
-1, 635,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 588,
-1, 637,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 592,
-1, 639,
	37, 677,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 596,
-1, 641,
	37, 678,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 600,
-1, 643,
	37, 680,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 604,
-1, 647,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 738,
-1, 648,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 739,
-1, 649,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 740,
-1, 650,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 741,
-1, 651,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 742,
-1, 652,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 743,
-1, 656,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 591,
-1, 658,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 595,
-1, 660,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 599,
-1, 662,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 603,
-1, 663,
	10, 587,
	44, 587,
	41, 587,
	58, 587,
	-2, 606,
-1, 667,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 653,
-1, 668,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 654,
-1, 669,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 655,
-1, 670,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 656,
-1, 671,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 657,
-1, 672,
	643, 0,
	644, 0,
	645, 0,
	646, 0,
	647, 0,
	648, 0,
	-2, 658,
-1, 1130,
	37, 681,
	-2, 608,
-1, 1161,
	37, 717,
	-2, 631,
-1, 1529,
	37, 693,
	-2, 624,
-1, 1530,
	37, 716,
	-2, 629,
-1, 1545,
	37, 732,
	-2, 647,
	};
# define YYNPROD 749
# define YYLAST 8633
yytabelem yyact[]={

   666,     5,  1411,  1079,   441,   413,  1320,   369,  1346,   924,
  1018,   995,  1544,   203,   201,   480,   202,  1638,   204,   946,
  1634,  1627,   190,  1626,  1370,  1624,  1611,   821,   819,  1643,
   820,  1582,   822,   482,   206,  1581,  1080,  1574,  1571,  1553,
   925,  1551,  1548,  1521,  1509,   442,  1508,  1507,   191,  1504,
  1497,  1496,  1495,  1494,  1492,  1491,  1490,  1489,  1488,  1483,
  1482,  1477,  1476,  1473,  1472,   205,   443,  1471,   190,  1467,
   286,   294,   296,   821,   819,  1641,   820,  1440,   822,   823,
  1439,  1438,  1437,  1421,   381,   315,   359,   360,  1419,  1407,
  1401,  1395,  1394,  1392,   191,  1391,  1389,  1388,  1386,  1385,
  1382,   372,   373,  1381,  1380,  1379,   376,  1378,  1377,  1376,
   479,  1375,  1366,  1365,  1364,  1362,  1361,  1351,  1350,   484,
  1345,   190,  1333,  1328,  1319,   823,   821,   819,  1318,   820,
  1317,   822,   488,   497,   506,   515,   379,  1315,   531,  1294,
   537,  1292,   923,  1290,   564,  1289,   945,   191,  1081,  1288,
   190,  1284,  1280,  1279,  1278,   821,   819,  1637,   820,  1276,
   822,  1275,  1273,   444,  1272,   317,    15,  1270,  1269,  1267,
   383,  1266,  1264,  1263,  1250,  1221,   191,  1197,   823,  1126,
  1125,  1123,  1121,  1120,  1097,  1096,   635,   637,   639,   641,
   643,   645,   646,   647,   648,   649,   650,   651,   652,   653,
   654,  1095,   656,   658,   660,   662,   663,   823,  1094,  1093,
  1092,   481,  1082,  1371,  1076,  1065,  1060,  1059,  1058,  1056,
   485,   991,   990,   675,   677,   678,   680,   989,   988,   684,
   987,  1078,   681,   986,   985,   288,   288,   288,   984,   983,
   973,   972,   971,   702,   703,   970,   966,   965,   964,   380,
   963,   736,   737,   962,   739,   742,   744,   746,   748,   750,
   752,   754,   756,   758,   760,   762,   765,   767,   768,   961,
   960,   384,   774,   776,   778,   780,   782,   784,   786,   788,
   790,   792,   794,   796,   798,   800,   445,   446,   448,   447,
   449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
   459,   460,   461,   462,   463,   464,   465,   466,   467,   468,
   469,   470,   959,   958,   957,   956,   955,   943,   942,   941,
   932,   931,   930,   929,   928,   922,   921,  1077,   920,   914,
   190,   913,  1335,   912,   397,   821,   819,   905,   820,  1372,
   822,   904,   903,   897,   883,   871,   483,   870,   869,   868,
   867,   288,   288,   288,   288,   288,   191,   856,   857,   858,
  1542,   203,   201,   817,   202,   861,   204,   288,   288,   288,
   288,   288,   288,   288,   288,   288,   288,   288,   288,   288,
   288,   810,   206,   772,   771,   874,  1625,   823,   770,   288,
   735,   288,   734,   733,   685,   683,   686,   382,   622,   396,
   375,   374,   363,   362,   361,   301,   814,   815,   813,   816,
   612,   477,   536,   205,   875,   902,   416,   901,   738,   288,
   288,   288,   288,   288,   288,   288,   288,   288,   288,   288,
   288,   288,   288,   288,   580,   764,     6,   288,   288,   288,
   288,   288,   288,   288,   288,   288,   288,   288,   288,   288,
   288,   406,   190,  1062,  1469,  1338,  1468,   821,   819,   190,
   820,   878,   822,   876,   821,   819,   865,   820,   937,   822,
   524,  1374,  1363,   938,  1274,  1098,   982,   967,   191,   892,
   894,   898,   947,   729,   365,   191,   394,   395,   190,   371,
  1080,   725,   944,   821,   819,  1616,   820,   404,   822,  1503,
   933,   719,   718,  1613,  1612,   285,   293,   295,   936,   823,
  1579,  1416,  1501,  1249,   191,   190,   823,  1331,  1248,   371,
   821,   819,  1615,   820,   900,   822,  1247,  1246,  1242,   889,
   405,   888,  1326,   949,   950,   951,   952,   953,   190,   474,
   476,   191,  1609,   821,   819,   823,   820,   887,   822,  1118,
   886,   190,   939,   885,   730,   884,   821,   819,  1614,   820,
   387,   822,   881,   297,   191,   880,   980,   981,   624,  1340,
  1424,   690,   823,   244,   391,   906,   243,   191,   368,   244,
  1369,   366,   243,   623,   203,   201,  1368,   202,  1557,   204,
   244,   389,   386,   243,   721,   823,  1339,  1556,  1064,   392,
   393,  1067,  1081,   364,  1066,   206,  1088,  1355,   823,   367,
  1241,  1466,   214,   213,   207,   208,   209,   210,   211,   212,
   414,   636,   638,   640,   642,   644,   199,   198,   192,   193,
   194,   195,   196,   197,   153,   155,   205,   655,   657,   659,
   661,   664,   665,   667,   668,   669,   670,   671,   672,   673,
   674,   370,   626,   727,   728,   731,   732,   244,   993,   676,
   243,   679,  1349,   154,   156,   157,   158,   159,   160,   161,
   233,   245,   199,   198,   192,   193,   194,   195,   196,   197,
   722,   370,   701,  1423,   689,  1286,   300,   390,  1502,   740,
   741,   743,   745,   747,   749,   751,   753,   755,   757,   759,
   761,  1500,   766,   769,   388,   385,  1332,   773,   775,   777,
   779,   781,   783,   785,   787,   789,   791,   793,   795,   797,
   799,  1327,  1325,  1322,  1124,   415,  1122,   192,   193,   194,
   195,   196,   197,   864,   312,   313,   314,   893,  1119,  1348,
  1591,  1356,   863,  1083,  1354,  1080,   724,  1086,  1244,  1085,
  1555,   891,  1514,   414,   199,   198,   192,   193,   194,   195,
   196,   197,  1505,   723,   940,   802,   801,   414,   190,   916,
   407,   409,  1608,   821,   819,  1400,   820,  1337,   822,   146,
  1336,   191,  1245,   907,   486,   495,   504,   513,  1293,  1540,
   203,   201,  1259,   202,   191,   204,   557,   573,   585,  1258,
  1342,   594,  1192,  1193,  1240,  1323,   765,   307,  1239,  1104,
  1347,   206,  1090,  1087,  1089,   934,   896,   895,   890,  1198,
  1199,  1200,  1201,  1202,  1203,   823,   862,  1206,  1207,  1208,
  1209,  1210,  1211,  1212,  1213,  1214,  1215,  1216,  1217,  1218,
  1219,  1220,   205,  1222,  1223,  1224,  1225,  1226,  1227,  1228,
  1229,  1230,  1231,  1232,  1233,  1234,  1235,  1081,   415,  1084,
  1236,  1237,  1398,   190,  1397,   478,   909,   378,   821,   819,
  1605,   820,   415,   822,   377,   299,  1324,  1343,   298,   682,
   909,   917,  1414,  1413,   191,   244,   190,   700,   243,   191,
   688,   821,   819,   720,   820,   908,   822,   190,  1414,  1413,
  1262,   206,   821,   819,  1602,   820,   310,   822,   305,  1341,
   206,  1265,   191,   552,  1116,   823,   302,  1622,   309,  1268,
   823,  1321,   554,   191,   625,   190,  1412,  1271,  1519,  1117,
   145,   414,   205,  1572,   199,   198,   192,   193,   194,   195,
   196,   197,  1604,   823,  1633,   173,   174,   191,  1344,  1281,
   809,   191,  1405,   311,   823,  1283,  1636,   225,  1404,   177,
   214,   213,   207,   208,   209,   210,   211,   212,  1129,  1194,
   547,   288,  1196,  1586,   550,  1110,  1593,  1592,   189,  1287,
  1291,  1109,   189,  1520,   223,   579,   190,   224,   968,   308,
  1204,   821,   819,  1601,   820,  1630,   822,   687,  1297,  1304,
  1310,  1311,   577,  1313,  1314,   230,  1295,   252,  1458,   548,
   688,  1456,   191,  1063,   222,   153,   155,  1111,   825,   244,
   231,   866,   243,   911,  1091,  1154,  1455,  1334,  1330,   879,
   803,   578,   919,   877,  1357,  1359,   415,   306,  1352,  1519,
   872,   927,   824,   823,   154,   156,   157,   158,   159,   160,
   161,   806,   804,   551,  1518,  1373,   199,   198,   192,   193,
   194,   195,   196,   197,   198,   192,   193,   194,   195,   196,
   197,  1384,   803,   553,  1387,  1607,  1587,  1383,   915,   575,
  1533,   576,  1390,   969,  1517,  1532,  1516,  1506,  1457,   584,
  1426,  1393,   199,   198,   192,   193,   194,   195,   196,   197,
  1367,  1402,   244,   633,   634,   243,  1406,  1329,  1408,  1410,
  1277,  1415,   528,  1260,  1257,  1420,  1061,   527,  1417,   199,
   198,   192,   193,   194,   195,   196,   197,  1425,  1428,  1429,
  1430,  1256,   549,   556,   555,   153,   155,  1255,   304,  1254,
  1432,  1253,   199,   198,   192,   193,   194,   195,   196,   197,
  1252,  1251,   529,  1434,  1436,   199,   198,   192,   193,   194,
   195,   196,   197,  1163,   154,   156,   157,   158,   159,   160,
   161,  1441,  1442,   583,  1444,  1162,  1446,   935,  1448,   178,
   171,  1640,  1106,  1450,  1452,   207,   208,   209,   210,   211,
   212,   574,   882,   203,   525,  1632,   526,   811,   204,  1631,
  1053,  1606,  1589,  1564,  1561,   244,   585,  1560,   243,  1559,
  1531,   412,   179,   172,   206,  1530,   974,   175,   176,   692,
   693,   694,   695,   696,   697,   698,   699,  1027,  1462,  1023,
  1115,   992,  1161,   855,   996,  1019,   854,  1052,   853,  1465,
  1057,   852,   542,   610,   606,   205,   545,   411,   851,  1109,
   850,   621,  1470,  1037,   849,   408,  1474,  1475,  1039,   848,
   847,   846,  1478,   845,  1108,   844,   604,   288,   843,   620,
   842,   841,   602,   840,   288,   619,   618,  1054,   609,  1055,
   599,   543,  1422,  1485,   839,  1099,   581,   582,   838,  1113,
  1487,   837,   836,  1038,  1107,  1022,  1112,   530,   835,   595,
   244,   834,   833,   243,   288,   203,   201,  1036,   202,   247,
   204,   617,   616,   244,   832,   831,   243,   830,   288,   288,
   607,   229,   608,   829,  1028,   546,   206,  1025,   828,   827,
  1499,   826,   805,   403,   597,  1114,   402,  1040,   288,   401,
   288,  1026,   288,   244,   400,   592,   243,   399,   288,   288,
   398,   614,   284,   615,   283,   282,   281,   205,   244,   280,
   279,   243,  1031,   278,   277,   276,   598,   410,   275,   274,
   273,   590,   199,   198,   192,   193,   194,   195,   196,   197,
   227,  1021,  1024,   272,   271,   250,   248,   226,   249,   214,
   213,   207,   208,   209,   210,   211,   212,   270,   269,   268,
  1510,   611,   603,   267,   544,  1511,  1512,   266,   265,   244,
   264,   263,   243,   262,   261,  1032,   260,  1029,   259,   258,
   257,   256,   255,   600,  1205,   254,   228,   253,  1522,   221,
  1030,  1033,   596,   220,  1034,   692,   693,   694,   695,   696,
   697,   698,   699,   587,   219,   218,   217,  1020,   589,   216,
   588,  1035,   190,   215,   591,   183,  1546,   821,   819,   182,
   820,  1550,   822,   181,  1552,  1051,   605,   199,   198,   192,
   193,   194,   195,   196,   197,  1042,  1017,   994,   191,   593,
  1566,  1567,  1568,   976,    12,  1569,    11,  1570,     9,     1,
   199,   198,   192,   193,   194,   195,   196,   197,   246,  1243,
   873,   199,   198,   192,   193,   194,   195,   196,   197,   823,
   812,   112,   975,   111,   601,   251,  1573,     7,  1575,  1577,
   190,    10,  1578,   586,  1580,   821,   819,  1600,   820,   148,
   822,   704,   726,     8,   303,  1583,  1584,  1403,  1353,  1005,
     4,     3,     2,     0,  1409,     0,   191,     0,     0,  1041,
    70,     0,     0,     0,     0,    71,     0,     0,     0,  1594,
   977,     0,   978,  1595,  1596,     0,  1597,     0,     0,     0,
     0,     0,     0,  1603,  1431,     0,     0,   823,     0,     0,
     0,     0,     0,   244,     0,     0,   243,  1610,  1433,  1435,
   199,   198,   192,   193,   194,   195,   196,   197,     0,  1617,
  1618,  1619,  1620,  1621,     0,     0,  1623,     0,  1443,     0,
  1445,     0,  1447,     0,     0,     0,   631,  1628,  1449,  1451,
     0,   627,  1547,  1629,  1549,     0,     0,     0,  1285,     0,
     0,   190,     0,     0,  1635,  1590,   821,   819,  1639,   820,
  1195,   822,  1642,     0,  1644,     0,     0,   996,   190,     0,
  1296,  1303,     0,   821,  1312,   190,   630,   191,   822,  1316,
   821,   819,  1599,   820,     0,   822,   632,     0,     0,     0,
  1019,     0,     0,     0,   191,     0,     0,   190,     0,     0,
     0,   191,   821,   819,   288,   820,     0,   822,   823,   692,
   693,   694,   695,   696,   697,   698,   699,     0,   629,     0,
   628,   190,     0,   191,     0,   823,   821,   819,  1598,   820,
     0,   822,   823,     0,     0,     0,     0,     0,     0,     0,
     0,   244,     0,     0,   243,     0,     0,   191,     0,     0,
     0,     0,     0,  1585,   823,     0,     0,     0,     0,     0,
  1396,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   823,     0,
     0,     0,     0,     0,     0,  1418,    13,    21,    22,    23,
    24,    25,    26,    27,    28,    42,    43,    29,    30,    31,
    32,    33,    44,    46,    47,    48,    49,    50,    51,    52,
    53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
    63,    64,    45,    65,    66,    67,    68,     0,    34,    35,
    36,    37,    38,    39,    40,    41,    97,    92,     0,     0,
    98,   102,     0,     0,     0,   173,   174,   621,     0,     0,
     0,   108,     0,     0,    73,   116,     0,     0,     0,   177,
    94,    77,     0,     0,   123,   620,     0,     0,   131,     0,
    74,   619,   618,     0,     0,   130,     0,    78,    87,     0,
   104,   128,   203,   201,   136,   202,   150,   204,   167,   115,
     0,    84,     0,     0,     0,  1047,  1043,    75,  1101,     0,
  1049,     0,    79,   206,     0,   168,     0,   617,   616,     0,
   107,   118,     0,     0,   691,   121,    93,   144,    99,     0,
    17,   142,     0,     0,   151,   213,   207,   208,   209,   210,
   211,   212,   114,     0,   205,  1048,   124,     0,     0,     0,
     0,     0,   169,   170,     0,   106,     0,   614,     0,   615,
   143,   190,     0,     0,   133,    89,   187,    88,    91,   109,
   117,   188,     0,     0,     0,     0,  1046,   357,     0,  1044,
   105,    85,   358,     0,  1576,  1493,     0,   191,     0,  1050,
     0,     0,  1498,     0,     0,    80,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   203,   201,   138,   202,
     0,   204,     0,   149,   152,   613,     0,     0,   189,   126,
   127,   100,     0,   122,    72,   110,    18,   206,  1045,     0,
     0,     0,     0,   162,   164,   163,   166,   165,     0,   125,
     0,     0,     0,    16,   180,     0,     0,     0,    96,   190,
     0,   103,   119,  1588,   821,   819,   129,   820,   205,   822,
     0,     0,     0,    76,     0,   134,   141,    95,    86,     0,
     0,     0,   135,   140,     0,   191,     0,   120,     0,   147,
     0,     0,   139,   101,   137,    90,   153,   155,     0,   178,
   171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   823,     0,     0,     0,
     0,     0,     0,     0,     0,   154,   156,   157,   158,   159,
   160,   161,   179,   172,   190,     0,     0,   175,   176,   821,
   819,  1565,   820,     0,   822,     0,   190,     0,     0,     0,
     0,   821,   819,  1563,   820,     0,   822,     0,     0,     0,
   191,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   191,     0,     0,     0,     0,     0,     0,     0,
   113,     0,     0,     0,     0,    81,    83,    82,    14,    19,
    20,   823,     0,     0,     0,     0,     0,     0,     0,     0,
    69,   132,     0,   823,   320,   321,   322,   323,   324,   325,
   326,   327,    42,    43,   328,   329,   330,   331,   332,   333,
   335,   336,   337,   338,    50,    51,   339,   340,   341,   342,
   343,   344,   345,   346,   347,   348,   349,   350,   351,   334,
   352,   353,   354,   355,     0,    34,    35,    36,    37,    38,
    39,    40,    41,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,     0,   563,     0,     0,     0,     0,
   567,     0,     0,     0,     0,   571,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
   190,     0,   357,     0,  1545,   187,   185,   358,   186,     0,
   188,   199,   198,   192,   193,   194,   195,   196,   197,     0,
   568,     0,     0,     0,     0,     0,   191,   319,     0,     0,
     0,     0,     0,     0,   561,   199,   198,   192,   193,   194,
   195,   196,   197,   190,     0,     0,     0,     0,   821,   819,
  1562,   820,     0,   822,   559,     0,     0,   189,   562,     0,
     0,     0,   569,     0,   570,   190,     0,     0,   558,   191,
   821,   819,  1558,   820,     0,   822,   190,     0,     0,     0,
     0,   821,   819,  1554,   820,   244,   822,     0,   243,   190,
     0,   191,     0,  1543,   187,   185,     0,   186,   190,   188,
   823,     0,   191,   821,   819,  1535,   820,     0,   822,     0,
     0,     0,     0,     0,     0,   191,     0,     0,     0,     0,
     0,     0,   823,   292,   191,     0,     0,     0,     0,     0,
     0,     0,     0,   823,     0,     0,     0,     0,     0,     0,
   318,     0,     0,     0,     0,     0,   189,     0,     0,     0,
     0,     0,     0,     0,     0,   823,     0,     0,     0,     0,
     0,     0,   572,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   560,     0,
     0,     0,     0,   153,   155,   565,     0,     0,     0,     0,
     0,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   154,   156,   566,   158,   159,   160,   161,   320,
   321,   322,   323,   324,   325,   326,   327,    42,    43,   328,
   329,   330,   331,   332,   333,   335,   336,   337,   338,    50,
    51,   339,   340,   341,   342,   343,   344,   345,   346,   347,
   348,   349,   350,   351,   334,   352,   353,   354,   355,     0,
    34,    35,    36,    37,    38,    39,    40,    41,     0,     0,
     0,     0,     0,   709,     0,   316,    19,    20,     0,     0,
   715,     0,     0,     0,     0,     0,   190,   356,     0,     0,
  1541,   821,   819,     0,   820,     0,   822,     0,     0,     0,
     0,     0,     0,     0,     0,   522,     0,     0,     0,     0,
   518,     0,   191,   190,     0,   523,     0,  1539,   821,   819,
     0,   820,     0,   822,     0,   190,     0,   357,     0,  1537,
   821,   819,   358,   820,     0,   822,   710,   716,     0,   191,
     0,     0,     0,   823,     0,   520,     0,     0,     0,     0,
     0,   191,   514,   199,   198,   192,   193,   194,   195,   196,
   197,   190,     0,     0,     0,     0,   821,   819,  1534,   820,
   823,   822,     0,   706,   707,   708,   521,     0,     0,     0,
   190,     0,   823,     0,  1529,   187,   185,   191,   186,   517,
   188,     0,     0,   516,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   191,     0,     0,   713,
   244,     0,     0,   243,     0,     0,     0,     0,   823,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,     0,   189,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,   292,     0,
     0,   717,     0,     0,   519,     0,     0,     0,   711,   712,
     0,     0,     0,     0,     0,   318,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   705,     0,     0,   357,   714,
     0,     0,     0,   358,     0,     0,     0,     0,   153,   155,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   154,   156,   157,
   158,   159,   160,   161,   320,   321,   322,   323,   324,   325,
   326,   327,    42,    43,   328,   329,   330,   331,   332,   333,
   335,   336,   337,   338,    50,    51,   339,   340,   341,   342,
   343,   344,   345,   346,   347,   348,   349,   350,   351,   334,
   352,   353,   354,   355,     0,    34,    35,    36,    37,    38,
    39,    40,    41,     0,     0,     0,     0,     0,     0,     0,
   316,    19,    20,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   356,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,  1069,
  1071,     0,   190,     0,     0,  1073,  1527,   187,   185,     0,
   186,     0,   188,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,     0,     0,   191,     0,
     0,     0,     0,     0,  1068,     0,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,   319,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,   189,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,  1075,     0,  1074,   320,   321,   322,   323,   324,
   325,   326,   327,    42,    43,   328,   329,   330,   331,   332,
   333,   335,   336,   337,   338,    50,    51,   339,   340,   341,
   342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
   334,   352,   353,   354,   355,     0,    34,    35,    36,    37,
    38,    39,    40,    41,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   292,     0,     0,     0,     0,     0,     0,
   511,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   318,     0,     0,  1070,  1072,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   510,     0,     0,     0,
     0,   512,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   190,     0,   357,     0,  1525,   821,   819,   358,   820,
   190,   822,     0,   153,   155,   821,   819,  1523,   820,     0,
   822,     0,     0,     0,   190,     0,     0,   191,   505,   821,
   819,  1515,   820,     0,   822,     0,   191,     0,     0,     0,
     0,     0,   154,   156,   157,   158,   159,   160,   161,     0,
   191,     0,     0,     0,     0,     0,     0,     0,   823,     0,
     0,     0,     0,   509,     0,   508,     0,   823,     0,   507,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,   823,   190,     0,     0,     0,   244,   821,   819,   243,
   820,     0,   822,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,   316,    19,    20,   191,   199,
   198,   192,   193,   194,   195,   196,   197,   356,     0,     0,
     0,     0,     0,     0,   292,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,  1513,   823,
     0,   318,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,   190,     0,     0,     0,     0,   821,   819,
  1486,   820,     0,   822,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,     0,     0,     0,     0,   191,
     0,     0,     0,     0,   153,   155,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   823,     0,     0,   154,   156,   157,   158,   159,   160,   161,
   320,   321,   322,   323,   324,   325,   326,   327,    42,    43,
   328,   329,   330,   331,   332,   333,   335,   336,   337,   338,
    50,    51,   339,   340,   341,   342,   343,   344,   345,   346,
   347,   348,   349,   350,   351,   334,   352,   353,   354,   355,
     0,    34,    35,    36,    37,    38,    39,    40,    41,     0,
     0,     0,     0,     0,     0,     0,   316,    19,    20,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   356,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   501,     0,     0,     0,     0,   503,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   357,     0,
     0,     0,     0,   358,     0,     0,   190,     0,     0,     0,
   502,   821,   819,  1484,   820,     0,   822,     0,     0,   190,
     0,     0,     0,   496,   821,   819,  1481,   820,   190,   822,
     0,     0,   191,   821,   819,  1480,   820,     0,   822,     0,
     0,     0,     0,     0,     0,   191,     0,     0,     0,     0,
     0,   190,     0,     0,   191,  1191,   821,   819,   499,   820,
   500,   822,     0,   823,   498,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   823,   191,     0,     0,
     0,   244,     0,     0,   243,   823,   199,   198,   192,   193,
   194,   195,   196,   197,   190,     0,     0,     0,     0,   821,
   819,  1479,   820,     0,   822,     0,     0,   190,   823,     0,
     0,     0,   821,   819,  1464,   820,     0,   822,   190,   292,
   191,     0,  1189,   821,   819,     0,   820,     0,   822,     0,
     0,     0,     0,   191,     0,   190,   318,     0,     0,  1187,
   821,   819,     0,   820,   191,   822,     0,     0,   190,     0,
     0,   823,  1185,   821,   819,     0,   820,     0,   822,     0,
     0,   191,     0,     0,   823,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   191,   823,     0,     0,     0,   153,
   155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   823,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   823,     0,     0,   154,   156,
   157,   158,   159,   160,   161,   320,   321,   322,   323,   324,
   325,   326,   327,    42,    43,   328,   329,   330,   331,   332,
   333,   335,   336,   337,   338,    50,    51,   339,   340,   341,
   342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
   334,   352,   353,   354,   355,     0,    34,    35,    36,    37,
    38,    39,    40,    41,     0,     0,     0,     0,     0,     0,
     0,   316,    19,    20,     0,   199,   198,   192,   193,   194,
   195,   196,   197,   356,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,     0,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,   492,     0,     0,     0,
     0,   494,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   357,     0,     0,     0,     0,   358,     0,
     0,     0,     0,     0,     0,   493,     0,     0,     0,   190,
     0,     0,     0,     0,   821,   819,  1463,   820,   487,   822,
     0,     0,     0,     0,     0,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,   191,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   190,   490,     0,   491,  1181,   821,   819,   489,
   820,     0,   822,     0,     0,     0,   823,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   244,     0,   191,   243,
   190,     0,     0,     0,  1179,   821,   819,     0,   820,     0,
   822,     0,     0,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,   191,     0,     0,   823,
   190,     0,     0,     0,   292,   821,   819,  1177,   820,     0,
   822,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   318,     0,   190,     0,     0,   191,   823,   821,   819,
  1175,   820,   190,   822,     0,     0,     0,   821,   819,  1173,
   820,     0,   822,     0,     0,     0,     0,     0,     0,   191,
     0,     0,     0,     0,     0,     0,     0,   823,   191,     0,
     0,     0,     0,     0,   153,   155,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   823,     0,     0,     0,     0,     0,     0,     0,     0,   823,
     0,     0,     0,   154,   156,   157,   158,   159,   160,   161,
   320,   321,   322,   323,   324,   325,   326,   327,    42,    43,
   328,   329,   330,   331,   332,   333,   335,   336,   337,   338,
    50,    51,   339,   340,   341,   342,   343,   344,   345,   346,
   347,   348,   349,   350,   351,   334,   352,   353,   354,   355,
     0,    34,    35,    36,    37,    38,    39,    40,    41,     0,
     0,     0,     0,     0,     0,     0,   316,    19,    20,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   356,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,  1306,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,     0,     0,     0,     0,   357,     0,
     0,     0,     0,   358,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   319,     0,     0,  1309,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,     0,     0,  1308,     0,
  1307,   199,   198,   192,   193,   194,   195,   196,   197,     0,
     0,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,   244,     0,     0,   243,     0,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
     0,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   292,
   190,     0,     0,     0,     0,   821,   819,  1171,   820,     0,
   822,     0,     0,     0,     0,     0,   318,   190,     0,  1305,
     0,  1169,   821,   819,     0,   820,   191,   822,     0,   190,
     0,     0,     0,  1167,   821,   819,     0,   820,     0,   822,
     0,     0,     0,   191,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   191,     0,   823,     0,   153,
   155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   823,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   823,     0,   154,   156,
   157,   158,   159,   160,   161,   320,   321,   322,   323,   324,
   325,   326,   327,    42,    43,   328,   329,   330,   331,   332,
   333,   335,   336,   337,   338,    50,    51,   339,   340,   341,
   342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
   334,   352,   353,   354,   355,     0,    34,    35,    36,    37,
    38,    39,    40,    41,     0,     0,   442,     0,     0,     0,
     0,   316,    19,    20,     0,     0,   190,     0,     0,     0,
  1165,   821,   819,   356,   820,     0,   822,   443,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,   191,     0,     0,     0,  1299,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   190,     0,   357,     0,  1158,   821,   819,   358,   820,
     0,   822,     0,   823,     0,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,     0,     0,   191,   319,     0,
     0,  1302,     0,     0,     0,  1538,   203,   201,     0,   202,
     0,   204,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,     0,     0,   206,   823,     0,
     0,     0,     0,  1301,   444,  1300,     0,     0,     0,     0,
     0,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   357,     0,     0,     0,   244,   358,   205,   243,
     0,     0,     0,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
   190,     0,     0,     0,   292,   821,   819,  1461,   820,     0,
   822,     0,     0,     0,     0,     0,     0,   357,     0,     0,
     0,   318,   358,     0,  1298,     0,   191,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   823,     0,     0,
     0,     0,     0,     0,   153,   155,     0,   445,   446,   448,
   447,   449,   450,   451,   452,   453,   454,   455,   456,   457,
   458,   459,   460,   461,   462,   463,   464,   465,   466,   467,
   468,   469,   470,   154,   156,   157,   158,   159,   160,   161,
   320,   321,   322,   323,   324,   325,   326,   327,    42,    43,
   328,   329,   330,   331,   332,   333,   335,   336,   337,   338,
    50,    51,   339,   340,   341,   342,   343,   344,   345,   346,
   347,   348,   349,   350,   351,   334,   352,   353,   354,   355,
     0,    34,    35,    36,    37,    38,    39,    40,    41,     0,
     0,     0,     0,     0,     0,     0,   316,    19,    20,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   356,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   320,
   321,   322,   323,   324,   325,   326,   327,    42,    43,   328,
   329,   330,   331,   332,   333,   335,   336,   337,   338,    50,
    51,   339,   340,   341,   342,   343,   344,   345,   346,   347,
   348,   349,   350,   351,   334,   352,   353,   354,   355,     0,
    34,    35,    36,    37,    38,    39,    40,    41,     0,     0,
     0,     0,     0,   319,   320,   321,   322,   323,   324,   325,
   326,   327,    42,    43,   328,   329,   330,   331,   332,   333,
   335,   336,   337,   338,    50,    51,   339,   340,   341,   342,
   343,   344,   345,   346,   347,   348,   349,   350,   351,   334,
   352,   353,   354,   355,     0,    34,    35,    36,    37,    38,
    39,    40,    41,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
     0,     0,   319,   199,   198,   192,   193,   194,   195,   196,
   197,     0,   190,     0,     0,     0,  1156,   821,   819,   292,
   820,   190,   822,     0,     0,     0,   821,   819,  1460,   820,
     0,   822,     0,     0,     0,     0,   318,     0,   191,     0,
   190,     0,     0,     0,  1151,   821,   819,   191,   820,     0,
   822,     0,     0,     0,     0,     0,     0,   319,     0,     0,
     0,     0,     0,     0,     0,     0,   191,   190,     0,   823,
     0,  1149,   821,   819,     0,   820,     0,   822,   823,   153,
   155,     0,     0,     0,     0,   539,   538,     0,     0,     0,
     0,     0,     0,   191,     0,     0,     0,   823,   292,     0,
     0,   357,     0,     0,     0,     0,   358,     0,   154,   156,
   157,   158,   159,   160,   161,   318,     0,   190,   541,   540,
     0,  1147,   821,   819,   823,   820,     0,   822,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,     0,     0,   191,     0,     0,     0,     0,     0,     0,
   357,     0,     0,   292,     0,   358,     0,     0,   153,   155,
     0,     0,     0,     0,   533,   532,     0,     0,     0,     0,
   318,   316,    19,    20,   823,   199,   198,   192,   193,   194,
   195,   196,   197,   356,     0,     0,     0,   154,   156,   157,
   158,   159,   160,   161,     0,     0,     0,   535,   534,     0,
     0,     0,     0,     0,  1360,   214,   213,   207,   208,   209,
   210,   211,   212,   153,   155,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   154,   156,   157,   158,   159,   160,   161,     0,
   316,    19,    20,     0,     0,     0,     0,     0,     0,   190,
     0,     0,   356,  1145,   821,   819,     0,   820,     0,   822,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   191,     0,     0,     0,     0,
     0,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,   316,    19,    20,     0,     0,
     0,     0,     0,     0,     0,     0,   823,   356,   320,   321,
   322,   323,   324,   325,   326,   327,    42,    43,   328,   329,
   330,   331,   332,   333,   335,   336,   337,   338,    50,    51,
   339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
   349,   350,   351,   334,   352,   353,   354,   355,     0,    34,
    35,    36,    37,    38,    39,    40,    41,   320,   321,   322,
   323,   324,   325,   326,   327,    42,    43,   328,   329,   330,
   331,   332,   333,   335,   336,   337,   338,    50,    51,   339,
   340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
   350,   351,   334,   352,   353,   354,   355,     0,    34,    35,
    36,    37,    38,    39,    40,    41,   190,     0,     0,     0,
  1143,   821,   819,     0,   820,     0,   822,   190,     0,     0,
     0,  1141,   821,   819,     0,   820,     0,   822,   190,     0,
     0,     0,   191,   821,   819,  1139,   820,     0,   822,     0,
     0,   319,     0,   191,     0,   190,     0,     0,     0,  1137,
   821,   819,     0,   820,   191,   822,   190,     0,     0,     0,
  1135,   821,   819,   823,   820,     0,   822,     0,     0,     0,
     0,   191,     0,   190,   823,     0,     0,  1133,   821,   819,
     0,   820,   191,   822,     0,   823,     0,     0,   190,     0,
   319,     0,  1459,   821,   819,     0,   820,     0,   822,   191,
   190,     0,   823,     0,     0,   821,   819,     0,   820,     0,
   822,     0,     0,   823,   191,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   191,     0,     0,     0,
   823,     0,     0,     0,    70,     0,     0,   292,     0,    71,
     0,     0,     0,   190,     0,   823,     0,     0,   821,   819,
     0,   820,     0,   822,   318,     0,  1454,   823,     0,     0,
     0,     0,     0,     0,     0,     0,   190,     0,     0,   191,
     0,   821,   819,  1427,   820,     0,   822,     0,     0,     0,
     0,     0,     0,     0,    70,     0,   292,     0,  1358,    71,
     0,     0,   191,     0,     0,     0,     0,   153,   155,  1453,
   823,     0,     0,   318,     0,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,   199,   198,   192,   193,   194,
   195,   196,   197,   823,     0,     0,   154,   156,   157,   158,
   159,   160,   161,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,   190,     0,     0,   153,   155,   821,   819,
  1399,   820,     0,   822,     0,     0,     0,     0,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,   191,
     0,     0,     0,     0,     0,   154,   156,   157,   158,   159,
   160,   161,     0,     0,     0,     0,     0,     0,     0,   316,
    19,    20,     0,     0,     0,     0,     0,     0,     0,     0,
   823,   356,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   316,    19,
    20,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   356,    21,    22,    23,    24,    25,    26,    27,    28,    42,
    43,    29,    30,    31,    32,    33,    44,   291,    47,    48,
    49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
    59,    60,    61,    62,    63,    64,    45,    65,    66,    67,
    68,     0,    34,    35,    36,    37,    38,    39,    40,    41,
     0,    21,    22,    23,    24,    25,    26,    27,    28,    42,
    43,    29,    30,    31,    32,    33,    44,   291,    47,    48,
    49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
    59,    60,    61,    62,    63,    64,    45,    65,    66,    67,
    68,     0,    34,    35,    36,    37,    38,    39,    40,    41,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,   190,     0,     0,     0,     0,   821,   819,  1282,   820,
   190,   822,     0,     0,     0,   821,   819,  1261,   820,     0,
   822,     0,     0,   190,   290,     0,     0,   191,   821,   819,
  1238,   820,     0,   822,   190,     0,   191,     0,   808,   821,
   819,     0,   820,     0,   822,     0,   190,     0,     0,   191,
  1191,   187,   185,     0,   186,     0,   188,     0,   823,     0,
   191,     0,     0,     0,     0,     0,     0,   823,     0,     0,
     0,   190,   191,     0,   290,  1189,   187,   185,     0,   186,
   823,   188,   190,     0,     0,     0,  1187,   187,   185,     0,
   186,   823,   188,     0,     0,     0,     0,   191,     0,     0,
     0,   190,     0,   189,     0,  1185,   187,   185,   191,   186,
     0,   188,     0,     0,     0,     0,     0,     0,     0,     0,
   292,     0,     0,     0,     0,     0,     0,   191,   189,     0,
     0,     0,     0,     0,     0,     0,     0,   289,     0,   189,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,   189,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
   292,     0,   199,   198,   192,   193,   194,   195,   196,   197,
   153,   155,     0,     0,     0,     0,     0,   763,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,   154,
   156,   157,   158,   159,   160,   161,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,     0,     0,     0,     0,
   153,   155,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,     0,     0,     0,     0,   154,
   156,   157,   158,   159,   160,   161,     0,     0,     0,     0,
   190,     0,   287,    19,    20,   187,   185,  1183,   186,     0,
   188,     0,     0,     0,    69,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,   190,   191,     0,     0,  1181,
   187,   185,     0,   186,     0,   188,     0,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,   191,   287,    19,    20,   190,     0,   189,     0,  1179,
   187,   185,     0,   186,    69,   188,     0,     0,   190,     0,
     0,     0,     0,   187,   185,  1177,   186,     0,   188,   190,
     0,   191,   189,     0,   187,   185,  1175,   186,     0,   188,
   190,     0,     0,     0,   191,   187,   185,  1173,   186,     0,
   188,   190,     0,     0,     0,   191,   187,   185,  1171,   186,
     0,   188,   189,     0,     0,     0,   191,   199,   198,   192,
   193,   194,   195,   196,   197,   189,     0,   191,     0,   190,
     0,     0,     0,  1169,   187,   185,   189,   186,   190,   188,
     0,     0,  1167,   187,   185,     0,   186,   189,   188,     0,
     0,     0,     0,     0,     0,   191,     0,   190,   189,     0,
     0,  1165,   187,   185,   191,   186,   190,   188,     0,     0,
     0,   187,   185,  1159,   186,     0,   188,     0,     0,   190,
     0,     0,     0,   191,   821,   819,   189,   820,     0,   822,
     0,     0,   191,   190,     0,   189,     0,  1158,   187,   185,
  1100,   186,   190,   188,     0,   191,  1156,   187,   185,     0,
   186,     0,   188,     0,   189,     0,   190,     0,     0,   191,
  1151,   187,   185,   189,   186,   190,   188,     0,   191,     0,
   187,   185,  1153,   186,     0,   188,   823,     0,     0,   190,
     0,     0,   191,  1149,   187,   185,     0,   186,   190,   188,
   189,   191,  1147,   187,   185,     0,   186,     0,   188,   189,
     0,     0,   190,     0,     0,   191,  1145,   187,   185,     0,
   186,   190,   188,   189,   191,  1143,   187,   185,     0,   186,
     0,   188,   189,     0,     0,     0,     0,     0,   191,     0,
     0,     0,     0,     0,     0,     0,   189,   191,   190,     0,
     0,     0,  1141,   187,   185,   189,   186,     0,   188,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     0,     0,     0,     0,   191,     0,     0,     0,   189,     0,
     0,     0,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,   199,   198,   192,   193,   194,   195,
   196,   197,     0,     0,     0,   189,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,     0,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,   190,     0,
     0,     0,     0,   187,   185,  1139,   186,     0,   188,     0,
     0,     0,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,   191,     0,   199,   198,   192,   193,
   194,   195,   196,   197,   190,     0,     0,     0,  1137,   187,
   185,     0,   186,     0,   188,   199,   198,   192,   193,   194,
   195,   196,   197,   190,     0,   189,     0,  1135,   187,   185,
   191,   186,   190,   188,     0,     0,  1133,   187,   185,     0,
   186,     0,   188,     0,     0,     0,   190,     0,     0,   191,
  1130,   187,   185,     0,   186,     0,   188,   190,   191,     0,
     0,   189,   821,   819,  1128,   820,     0,   822,   190,     0,
     0,     0,   191,   821,   819,  1127,   820,     0,   822,     0,
   189,     0,     0,   191,     0,   190,     0,     0,     0,   189,
   821,   819,  1105,   820,   191,   822,   190,     0,     0,     0,
     0,   821,   819,   189,   820,     0,   822,   190,     0,     0,
     0,   191,   821,   819,   823,   820,     0,   822,     0,     0,
     0,   190,   191,     0,     0,   823,   821,   819,   979,   820,
     0,   822,     0,   191,     0,     0,     0,     0,     0,     0,
     0,     0,   823,     0,     0,     0,     0,   191,     0,   190,
     0,     0,  1103,   823,   821,   819,   954,   820,     0,   822,
     0,     0,     0,  1102,   823,     0,   190,     0,     0,     0,
     0,   821,   819,   948,   820,   191,   822,     0,   823,     0,
     0,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   191,   190,     0,     0,     0,     0,   821,   819,
   926,   820,     0,   822,     0,     0,   823,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,   191,
     0,     0,     0,   823,     0,   190,     0,     0,     0,     0,
   821,   819,   918,   820,     0,   822,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
   823,   191,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,     0,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   823,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,     0,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,     0,     0,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,     0,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,   190,     0,     0,     0,     0,   821,
   819,   910,   820,     0,   822,     0,     0,     0,     0,     0,
     0,     0,   199,   198,   192,   193,   194,   195,   196,   197,
   191,   190,     0,     0,     0,     0,   821,   819,   899,   820,
   190,   822,     0,     0,     0,   821,   819,   860,   820,     0,
   822,     0,     0,     0,     0,     0,     0,   191,   184,     0,
     0,   823,     0,   190,     0,     0,   191,     0,   821,   819,
   859,   820,   190,   822,     0,     0,     0,   821,   819,   818,
   820,     0,   822,     0,     0,   190,     0,     0,   823,   191,
   187,   185,     0,   186,     0,   188,     0,   823,   191,   190,
     0,     0,     0,   808,   187,   185,     0,   186,     0,   188,
     0,   191,   199,   198,   192,   193,   194,   195,   196,   197,
   823,     0,  1536,   203,   201,   191,   202,     0,   204,   823,
     0,   190,     0,     0,     0,     0,   821,   819,     0,   820,
     0,   822,   189,     0,   206,     0,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,   189,   191,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,   205,   199,   198,   192,   193,
   194,   195,   196,   197,     0,     0,     0,     0,   823,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
     0,     0,   199,   198,   192,   193,   194,   195,   196,   197,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,   199,   198,   192,   193,   194,   195,   196,   197,     0,
     0,     0,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,     0,   190,     0,     0,     0,     0,
   187,   185,     0,   186,     0,   188,     0,     0,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,   191,  1528,   203,   201,     0,   202,     0,   204,     0,
   199,   198,   192,   193,   194,   195,   196,   197,     0,     0,
     0,     0,     0,     0,   206,  1526,   203,   201,     0,   202,
     0,   204,   189,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,     0,   206,     0,     0,
     0,     0,     0,     0,     0,   205,     0,  1524,   203,   201,
     0,   202,     0,   204,     0,     0,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,   205,   206,
  1190,   203,   201,     0,   202,     0,   204,     0,     0,  1188,
   203,   201,     0,   202,     0,   204,     0,  1186,   203,   201,
     0,   202,   206,   204,     0,     0,     0,     0,     0,     0,
   205,   206,  1184,   203,   201,     0,   202,     0,   204,   206,
     0,     0,   203,   201,  1182,   202,     0,   204,     0,     0,
     0,     0,     0,   205,   206,  1180,   203,   201,     0,   202,
     0,   204,   205,   206,     0,  1178,   203,   201,     0,   202,
   205,   204,     0,     0,     0,     0,     0,   206,   203,   201,
  1176,   202,     0,   204,     0,   205,     0,   206,   203,   201,
  1174,   202,     0,   204,   205,     0,     0,     0,     0,   206,
   203,   201,  1172,   202,     0,   204,     0,     0,   205,   206,
   203,   201,  1170,   202,     0,   204,     0,     0,   205,     0,
     0,   206,  1168,   203,   201,     0,   202,     0,   204,     0,
   205,   206,  1166,   203,   201,     0,   202,     0,   204,     0,
   205,  1164,   203,   201,   206,   202,     0,   204,     0,     0,
     0,     0,   205,     0,   206,   203,   201,  1160,   202,     0,
   204,     0,   205,   206,  1157,   203,   201,     0,   202,     0,
   204,     0,     0,     0,     0,   205,   206,     0,     0,     0,
     0,     0,     0,     0,     0,   205,   206,  1155,   203,   201,
     0,   202,     0,   204,   205,     0,     0,   203,   201,  1152,
   202,     0,   204,     0,     0,     0,     0,   205,     0,   206,
     0,     0,     0,     0,     0,     0,     0,   205,   206,  1150,
   203,   201,     0,   202,     0,   204,     0,     0,   199,   198,
   192,   193,   194,   195,   196,   197,     0,     0,     0,     0,
   205,   206,     0,     0,     0,     0,     0,     0,     0,   205,
     0,     0,     0,     0,     0,   199,   198,   192,   193,   194,
   195,   196,   197,     0,   199,   198,   192,   193,   194,   195,
   196,   197,   205,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   199,   198,   192,
   193,   194,   195,   196,   197,     0,   199,   198,   192,   193,
   194,   195,   196,   197,     0,     0,     0,     0,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
     0,     0,     0,   199,   198,   192,   193,   194,   195,   196,
   197,  1148,   203,   201,     0,   202,     0,   204,     0,     0,
     0,     0,   214,   213,   207,   208,   209,   210,   211,   212,
     0,     0,     0,   206,     0,   199,   198,   192,   193,   194,
   195,   196,   197,  1146,   203,   201,     0,   202,     0,   204,
     0,  1144,   203,   201,     0,   202,     0,   204,     0,     0,
     0,     0,     0,     0,   205,   206,  1142,   203,   201,     0,
   202,     0,   204,   206,     0,  1140,   203,   201,     0,   202,
     0,   204,     0,     0,   203,   201,  1138,   202,   206,   204,
     0,     0,     0,     0,     0,     0,   205,   206,     0,     0,
     0,     0,     0,     0,   205,   206,     0,  1136,   203,   201,
     0,   202,     0,   204,     0,     0,  1134,   203,   201,   205,
   202,     0,   204,     0,     0,     0,     0,     0,   205,   206,
     0,     0,     0,     0,     0,     0,   205,     0,   206,  1132,
   203,   201,     0,   202,     0,   204,     0,     0,  1131,   203,
   201,     0,   202,     0,   204,     0,     0,     0,     0,     0,
   205,   206,   200,     0,     0,     0,     0,     0,     0,   205,
   206,   807,   203,   201,     0,   202,     0,   204,     0,   199,
   198,   192,   193,   194,   195,   196,   197,     0,     0,     0,
     0,     0,   205,   206,   203,   201,     0,   202,     0,   204,
     0,   205,   214,   213,   207,   208,   209,   210,   211,   212,
     0,     0,     0,   203,   201,   206,   202,     0,   204,     0,
     0,     0,     0,     0,   205,   214,   213,   207,   208,   209,
   210,   211,   212,     0,   206,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   214,   213,   207,
   208,   209,   210,   211,   212,   205,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   214,   213,   207,   208,   209,   210,   211,   212,     0,   214,
   213,   207,   208,   209,   210,   211,   212,   214,   213,   207,
   208,   209,   210,   211,   212,     0,     0,     0,   438,     0,
     0,     0,   214,   213,   207,   208,   209,   210,   211,   212,
     0,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,     0,   214,   213,   207,   208,   209,
   210,   211,   212,     0,     0,   214,   213,   207,   208,   209,
   210,   211,   212,     0,     0,     0,     0,   214,   213,   207,
   208,   209,   210,   211,   212,     0,     0,   214,   213,   207,
   208,   209,   210,   211,   212,     0,     0,     0,     0,   214,
   213,   207,   208,   209,   210,   211,   212,     0,     0,   214,
   213,   207,   208,   209,   210,   211,   212,     0,     0,     0,
     0,     0,   214,   213,   207,   208,   209,   210,   211,   212,
     0,     0,   214,   213,   207,   208,   209,   210,   211,   212,
   437,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,   214,   213,   207,   208,   209,   210,
   211,   212,   439,     0,   214,   213,   207,   208,   209,   210,
   211,   212,     0,     0,     0,   440,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   214,   213,   207,
   208,   209,   210,   211,   212,     0,   214,   213,   207,   208,
   209,   210,   211,   212,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   214,
   213,   207,   208,   209,   210,   211,   212,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
   420,     0,   421,   422,   423,   424,   425,   426,   427,   428,
   429,   430,   431,   432,   433,   434,   435,   436,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   232,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   214,   213,   207,   208,   209,   210,   211,
   212,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,     0,     0,   214,   213,   207,   208,
   209,   210,   211,   212,     0,   214,   213,   207,   208,   209,
   210,   211,   212,   214,   213,   207,   208,   209,   210,   211,
   212,   472,   473,   438,     0,     0,     0,     0,     0,     0,
     0,     0,   471,     0,     0,     0,     0,   214,   213,   207,
   208,   209,   210,   211,   212,     0,   214,   213,   207,   208,
   209,   210,   211,   212,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,  1006,     0,  1003,  1002,     0,   214,
   213,   207,   208,   209,   210,   211,   212,     0,   214,   213,
   207,   208,   209,   210,   211,   212,     0,     0,     0,     0,
     0,     0,     0,     0,   475,     0,  1001,     0,     0,     0,
     0,   214,   213,   207,   208,   209,   210,   211,   212,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,  1016,
     0,     0,     0,   214,   213,   207,   208,   209,   210,   211,
   212,  1008,     0,     0,     0,   437,     0,  1004,     0,     0,
     0,     0,   214,   213,   207,   208,   209,   210,   211,   212,
   241,     0,     0,     0,     0,     0,     0,   439,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   440,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
  1014,     0,   235,     0,     0,     0,     0,     0,     0,   238,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
  1009,     0,     0,     0,     0,     0,     0,     0,   997,     0,
     0,   998,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   244,   999,  1000,   243,  1010,     0,  1015,     0,     0,
     0,     0,   417,   418,   419,   420,   240,   421,   422,   423,
   424,   425,   426,   427,   428,   429,   430,   431,   432,   433,
   434,   435,   436,     0,     0,   236,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   234,     0,     0,     0,     0,     0,  1007,
     0,     0,     0,     0,     0,     0,  1012,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   244,     0,     0,   243,     0,
  1011,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   242,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   239,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   237,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,  1013 };
yytabelem yypact[]={

  1510,-10000000,  1453,  1449,  1445,  6888,  7692,  1443,  1439,  1436,
  1435,  1434,  1423,  1419,   923,   896,   959,  8077,   961,-10000000,
-10000000,  1387,  1385,  1382,  1381,  1380,  1379,  1378,-10000000,  1376,
  1374,  1373,  1371,  1370,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  1368,  1367,  1363,  1359,
  1358,  1357,  1344,  1343,  1330,  1329,  1328,  1325,  1324,  1323,
  1320,-10000000,-10000000,-10000000,  1319,  1316,  1315,  1314,  1312,  5324,
  5324,  5324,-10000000,    79,   534,   531,-10000000,   338,  -234,-10000000,
   499,   131,   131,   131,  4930,  4930,  4930,  -235,  -236,  -237,
    78,   123,   115,   115,   115,-10000000,  -238,  -239,   115,   530,
   523,  -254,   202,    57,   201,   184,    96,-10000000,  -240,  -304,
  1310,  1307,  1304,  1299,  1296,  1293,   -52,   131,   865,   260,
  7513,  3984,  7898,  7513,  -143,   521,-10000000,-10000000,-10000000,  -529,
  -305,  3378,  3053,  2728,  2232,   -55,   769,  4432,  -132,  4353,
   898,   626,   630,  1907,   654,   757,-10000000,  1023,   895,  1451,
  -241,   227,   141,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  1273,  1273,  1273,
-10000000,-10000000,-10000000,-10000000,-10000000,  5324,  5324,  5324,  5324,  5324,
  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,
-10000000,  5324,  5324,  5324,  5324,  5324,  5324,  5324,  5324,  5324,
  5324,  5324,  5324,  5324,  5324,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  4930,  5324,  4930,  5324,   571,  -244,  4930,  -245,
   469,   181,  1391,-10000000,   131,   145,   115,  2211,    -4,    -5,
   209,   -13,-10000000,-10000000,-10000000,-10000000,    64,  -246,  -247,  -249,
  4930,  4930,    88,  5324,  5324,  5324,  5324,  5324,  5324,  5324,
  5324,  5324,  5324,  5324,  5324,  5374,  5324,  5324,  -251,  -255,
  -256,  5324,  5324,  5324,  5324,  5324,  5324,  5324,  5324,  5324,
  5324,  5324,  5324,  5324,  5324,   847,   718,   675,   674,  1026,
  1006,  1292,  1005,  7670,  6902,   847,   718,   131,-10000000,-10000000,
  -258,  1153,  -225,-10000000,-10000000,  -276,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,  6875,   675,   674,   996,   972,
  1291,  1289,  1288,  1283,  1277,  1275,  1274,-10000000,  1262,  1261,
  1258,  1252,  1251,-10000000,-10000000,  1248,  1244,  1233,  1231,  1230,
  1228,  1225,  1223,  1221,  1220,  1219,  1214,  1210,-10000000,-10000000,
-10000000,  1208,  1201,  1198,  1196,  1193,  4930,  4930,  4930,  6866,
  6843,-10000000,-10000000,-10000000,  4930,   482,   357,   -68,   131,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,  -289,  -290,  -291,  -292,  -294,   994,  -161,   -71,   987,
   -73,   983,    66,    63,-10000000,-10000000,  1148,  -295,    52,    50,
    47,    44,    28,    26,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,   474,   407,   393,   473,   472,  -296,-10000000,-10000000,
  4930,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,   972,  6834,  -127,
  -297,  -298,  -302,   435,-10000000,-10000000,   972,  6807,  -127,  -306,
  -308,  -310,   421,-10000000,-10000000,   972,  6568,  -127,  -311,  -313,
  -314,  -497,-10000000,-10000000,   972,  6536,  -127,  -315,  -316,  -317,
  -318,  -319,    -6,   471,   125,  -320,  -321,  -322,   -14,  -493,
   -24,  6509,  4930,  4930,  4930,  4930,  4930,  6492,  -323,  -324,
  -325,  -326,-10000000,  -327,  -369,  -370,  -386,-10000000,  -389,  -391,
  -392,  -393,   -27,   757,-10000000,-10000000,-10000000,-10000000,  -127,  -394,
  -397,  -398,  -399,  1135,  6464,  4930,  4930,   -30,  -400,  -401,
  -405,  -406,  -409,-10000000,  -411,  -412,  -417,  -418,   131,   310,
-10000000,  7993,   910,  1532,   852,-10000000,  -420,   131,  -421,  -422,
  -423,  -127,   -84,-10000000,-10000000,-10000000,  7513,  4930,  -424,  3984,
  2557,  -425,  -312,  -427,   322,  4930,   470,-10000000,-10000000,-10000000,
-10000000,-10000000,   468,   875,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,  -429,  -430,-10000000,-10000000,  -431,  -438,  -454,
  -455,   -31,   131,-10000000,-10000000,  1894,  1151,  1894,  1151,   884,
   838,   884,   838,   884,   838,   821,  6102,  1415,  1415,  1415,
  1415,  1415,  1415,    84,   422,  1151,  1894,  1151,  1894,   838,
   888,   838,   888,   888,   838,  1820,  7078,  1934,  1934,  1934,
  1934,  1934,  1934,   542,  1263,  6450,  7711,  7078,  6439,  7711,
  7078,   465,-10000000,-10000000,  6428,  1138,  1203,   914,-10000000,-10000000,
   971,   868,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,   225,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -456,  -457,
-10000000,  3984,  -458,  4930,  -459,  -460,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  6411,  6400,   907,  6389,
  7647,  7638,  6375,  7615,  6366,  7606,  6347,  7582,  6311,  7574,
  6221,  7565,  6194,  7550,  6185,  7542,  6171,  7510,  6162,  7398,
  6139,  7375,  6148,   984,  7366,  6125,  7343,  6116,  6089,  7333,
  1191,  1131,  1119,  7320,  6080,  7311,  6061,  7301,  6052,  7288,
  6024,  7278,  6013,  7266,  6002,  7256,  5991,  7244,  5978,  7234,
  5948,  7220,  5923,  7211,  5754,  7196,  5735,  7188,  5724,  7179,
  5699,  4930,  4930,   589,  1137,  5324,    88,-10000000,-10000000,-10000000,
-10000000,  -462,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  4930,  4930,
  4930,  4930,  4930,  4930,   589,   921,  4930,  4930,  4930,  4930,
  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,
  4930,  -464,  4930,  4930,  4930,  4930,  4930,  4930,  4930,  4930,
  4930,  4930,  4930,  4930,  4930,  4930,   718,  5687,   718,  4930,
  4930,  5676,-10000000,   464,   460,   220,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,    25,   425,-10000000,-10000000,    24,    23,    15,    10,
-10000000,-10000000,  -465,  1107,  1106,  1097,  1095,  1093,  1087,  1070,
-10000000,-10000000,   455,-10000000,   448,-10000000,-10000000,  1069,  5663,  4930,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -466,  -467,-10000000,
  4930,-10000000,-10000000,-10000000,-10000000,-10000000,  -468,  -470,  4930,-10000000,
-10000000,-10000000,-10000000,-10000000,  -471,  -472,  4930,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,  -475,-10000000,-10000000,  -477,   -32,  -478,  -480,
  1066,-10000000,-10000000,-10000000,  -485,-10000000,  -486,  -487,  4930,  6934,
  6934,  6934,  6934,  5654,  4930,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -488,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,   142,  -490,  -494,  -496,  4930,
  6934,  6934,  -498,-10000000,-10000000,-10000000,-10000000,   444,-10000000,-10000000,
-10000000,-10000000,-10000000,  -500,  7993,-10000000,-10000000,  4028,  3703,  4930,
  4930,   131,  4930,  4930,  -502,-10000000,   131,  -509,  -511,  -515,
   386,   208,  -516,  1063,-10000000,-10000000,-10000000,   910,-10000000,-10000000,
   193,  -517,  -307,   436,   433,    56,   458,  -519,   320,  -521,
  -522,   386,   298,  4881,  4487,  -523,  -524,   -34,  -525,  -526,
  -527,  1056,-10000000,-10000000,   124,  -300,   320,   -35,  -528,  -530,
  -531,-10000000,-10000000,  -532,  -534,  -535,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  -536,-10000000,  6934,-10000000,-10000000,  6934,  -539,   115,
  4930,  -540,  -541,  4930,  -542,  -543,-10000000,-10000000,   397,  -544,
-10000000,-10000000,-10000000,  -546,   386,  -547,  -548,   437,  5436,-10000000,
-10000000,   431,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -549,-10000000,
  4930,  5324,   897,   891,-10000000,  4930,  -550,  4930,  5324,   599,
  4930,     8,   571,  -551,  4930,  -556,    88,   180,-10000000,-10000000,
-10000000,-10000000,  3984,  1046,  5359,-10000000,-10000000,  4930,  4930,  4930,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  5324,  4930,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  5324,  5324,-10000000,-10000000,-10000000,-10000000,-10000000,  -557,
  -558,-10000000,  -559,  -562,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
  4930,  4930,  5324,  4930,  5324,  4930,  5324,  4930,-10000000,-10000000,
-10000000,-10000000,  5324,  5324,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  5336,  5293,   935,   965,-10000000,  1044,  6934,  1611,
  1611,   821,   821,   821,   935,   962,  5281,  5266,  5249,  5238,
  5221,  5210,  5199,  5042,  4900,  4850,  4823,  4804,  4795,  4354,
  4473,  1187,  4309,  4182,  4170,  4153,  3855,  3846,  3823,  3793,
  3765,  3722,  3531,  3518,  3501,  3434,  6934,  3490,  4930,-10000000,
   226,-10000000,  -570,-10000000,-10000000,-10000000,-10000000,   -78,-10000000,   -80,
-10000000,  4930,  -572,  -575,  -576,  4930,  4930,  -577,-10000000,-10000000,
  -578,  4930,  3477,-10000000,-10000000,  3411,-10000000,-10000000,  3402,-10000000,
-10000000,  6934,-10000000,-10000000,  -579,-10000000,-10000000,  -580,-10000000,-10000000,
-10000000,  3389,  4930,  3206,-10000000,-10000000,   397,  -581,-10000000,-10000000,
-10000000,  6934,-10000000,-10000000,-10000000,-10000000,-10000000,  6934,  -582,  -583,
  -584,  -585,   131,-10000000,  6934,  -586,  -587,  -588,  -589,   131,
  6934,  6934,-10000000,  6934,  6934,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  4930,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  6934,   188,  6934,
   175,-10000000,-10000000,  -590,-10000000,-10000000,-10000000,   418,-10000000,-10000000,
-10000000,-10000000,  1043,-10000000,  -592,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,  6934,-10000000,-10000000,  6934,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -593,  -595,  4930,
-10000000,-10000000,  6934,  7711,  4930,  4930,  6934,-10000000,  3135,  7711,
  7078,-10000000,-10000000,-10000000,-10000000,  6934,-10000000,   408,-10000000,-10000000,
  3077,  1042,   993,-10000000,   937,-10000000,  -596,  4930,  3063,  6934,
  6934,  7156,  3054,  7124,  2865,  7101,  2613,  1174,  1169,  1041,
  1036,  2594,  2331,  6921,  2558,  4384,  2546,   748,  2519,   319,
  2322,   -29,  2233,-10000000,-10000000,  4930,    88,  -597,    88,-10000000,
  4930,  -598,-10000000,  4930,  -600,  2309,   406,-10000000,   207,   198,
  2298,  1168,  1166,  1163,  2276,  2069,  1162,-10000000,  2057,  4930,
  4930,  4930,-10000000,-10000000,  4930,  6934,  4930,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  6934,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -601,-10000000,-10000000,-10000000,
  6934,  6934,  6934,   872,-10000000,  4930,  -602,  4930,  5324,   615,
     7,-10000000,  6934,  4930,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  -604,  -608,  4930,  4930,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  1640,   882,  1032,   882,
  1982,  1161,  1594,-10000000,   396,-10000000,   931,   930,  4930,-10000000,
-10000000,-10000000,  4930,  4930,-10000000,  4930,  1664,  1618,  1483,   949,
   860,-10000000,  4930,  6934,-10000000,   849,  7711,  7078,-10000000,-10000000,
   826,  1160,  1031,   731,   501,-10000000,  4930,  -613,-10000000,-10000000,
-10000000,-10000000,     1,     0,  6934,   514,   478,   451,  4930,  4930,
  4930,  4930,  4930,  6934,   856,  4930,-10000000,  -614,-10000000,-10000000,
   293,-10000000,-10000000,-10000000,  -616,  -618,  4930,  6934,  6934,  6934,
  6934,  6934,  4930,  6934,   951,-10000000,  1158,  1154,   415,  6934,
  -619,-10000000,-10000000,  4930,   912,   113,  -622,  4930,  1140,    31,
-10000000,  4930,   -15,  4930,  6934 };
yytabelem yypgo[]={

     0,     0,   435,  1542,  1541,  1540,   165,   652,     3,     7,
   524,     4,  1539,  1538,     8,     6,  1534,   410,  1533,  1532,
  1531,  1529,  1521,  1517,  1514,   575,     5,   416,  1513,  1511,
     2,  1510,  1500,  1499,  1489,  1488,  1486,  1484,  1479,   930,
   434,   779,   924,  1477,  1476,  1475,  1465,    11,    10 };
yytabelem yyr1[]={

     0,    34,    34,    34,    34,    34,    34,    34,    34,    34,
    34,    34,    34,    34,    37,    37,    37,    37,    37,    37,
    37,    17,    17,    17,    17,    17,    17,    17,    17,    18,
    18,    18,    18,    18,    18,    18,    18,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    22,    22,    22,    22,    22,    22,    22,
    27,    27,    27,    27,    27,    27,    27,    27,    27,    27,
    27,    27,    27,    27,    27,    27,    27,    27,    27,    27,
    27,    27,    27,    27,    20,    20,    20,    20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    31,    31,    31,
    31,    19,    19,    19,    19,    19,    19,    36,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    35,    35,    35,
    35,    35,    35,    39,    39,    39,    39,    39,    39,    41,
    41,    41,    42,    42,    42,    42,    42,    42,    42,    40,
    40,    40,    40,    40,    43,    43,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    44,    44,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,
    48,    48,    48,    48,    48,    48,    48,    48,    48,    48,
    48,    48,    48,    45,    45,    45,    45,    45,    45,    45,
    45,    45,    45,    45,    46,    46,    46,    46,    21,    21,
    21,    21,    21,    21,    24,    24,    24,    24,    24,     7,
     7,     8,     8,    28,    28,    28,    28,    28,    29,    29,
    29,    29,    26,    26,    25,    25,    25,    15,    15,    15,
    15,    15,    14,    14,    14,    30,    30,     9,     9,    12,
    12,    12,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    13,    13,    13,    16,    16,    16,    16,    16,    16,
    10,    10,    33,    33,    32,    32,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     3,     3,     3,     3,     3,
     5,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1 };
yytabelem yyr2[]={

     0,     0,     4,     4,     4,     5,     5,     4,     4,     4,
     4,     4,     4,     5,     7,     9,     7,     5,     7,     3,
     7,     3,     3,     3,     3,     3,     3,     3,     3,     5,
     7,     7,     7,     7,    19,    11,     9,     3,     7,     5,
     5,     3,     7,    17,     3,     7,     5,     5,     5,     9,
     9,    13,     5,     5,     5,    15,     5,     5,     7,     7,
     5,     5,     5,     3,     5,     5,     5,     5,     5,     5,
     5,     9,    13,     7,    11,     7,    11,     7,    11,    11,
    15,    11,    15,     9,     9,    17,     9,    17,     5,     5,
     7,     7,     5,     5,     3,     9,    15,    13,    13,    13,
    21,    21,    13,     9,     3,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     7,     7,
     9,     7,     7,     9,     7,     7,    11,     5,     9,     9,
    13,     5,     3,     3,     3,     5,    35,     5,     5,     5,
     7,     5,     5,    17,     7,     7,     7,     7,     7,     9,
     9,     5,     5,     5,     7,     5,     5,    17,     7,     7,
     7,     7,     7,     9,     9,     5,     5,     7,     5,     5,
     5,    17,     7,     7,     7,     7,     7,     9,     9,     5,
     5,     5,     7,     5,     5,     9,     7,     7,     7,     7,
     7,     7,     9,     7,     7,     9,    11,     9,     9,    11,
     7,     7,     7,     9,     7,     9,     9,    17,     7,     7,
     7,     7,    11,    17,     7,     7,     7,     7,     5,     7,
     7,     7,     7,     5,     7,     7,     7,     7,     9,     5,
     7,     7,     7,     7,     7,     7,     9,    11,    11,     9,
     9,     9,     9,     7,     7,     9,     7,     7,     7,     7,
     9,     5,     7,     7,     7,     7,     7,     9,     5,     7,
     9,     9,     7,     7,     7,     9,     9,     7,    11,    13,
    13,     9,     9,     7,     7,     7,     7,     7,     7,     9,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     2,     2,     2,     2,     2,     2,     4,     3,     3,
     5,     5,     5,     5,     5,     7,     7,     7,     7,     7,
     7,     7,     7,     5,     5,     7,     7,     5,     7,     7,
     7,     7,     7,     9,     9,     9,     5,     2,     4,     2,
     4,     6,     4,     2,     2,     2,     2,     2,     2,     4,
     4,     4,     3,     5,     5,     5,     5,     7,     5,     4,
     4,     4,     4,     3,     2,     4,     3,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     3,     5,     5,
     7,     7,     5,     5,     7,     7,     7,     7,     7,     7,
     7,     7,     5,     5,     5,     5,     7,     2,     4,     3,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     7,     7,     7,     7,     5,     5,     7,     5,
     5,     5,     7,     3,     5,     5,     5,     5,     9,     5,
     7,     5,     5,     5,     3,     5,     5,     5,     7,     3,
     3,     5,     5,     5,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,    13,    13,    17,    11,    21,
    11,     7,     7,     7,    11,    11,    15,    11,    15,     7,
     7,    11,    15,     3,     3,     7,    11,     3,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     9,     9,
     9,     9,     9,    13,     9,     9,     3,     9,     9,     9,
     9,    13,    13,    13,    13,     3,     3,     9,     9,    13,
    13,     9,     9,     9,     9,    17,    13,    13,    13,     9,
     9,     3,     3,     3,    13,    13,    13,    13,     9,     9,
     9,     9,    11,     7,     7,     7,     7,     7,     7,     7,
     7,     5,     7,     5,     2,     3,     9,     7,     9,    13,
    17,    11,    15,     7,    11,     7,     7,     7,     7,     7,
     7,     9,     9,     9,     9,    13,     9,     9,     3,     9,
     9,     9,     9,    13,     7,     7,     7,     7,     7,     7,
     7,     7,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     9,     9,    13,     9,    17,    29,
     9,     9,     9,    17,    13,    13,    13,     9,     9,     3,
     3,     3,    13,     9,     9,     9,     9,    11,     7,     7,
     7,     7,     7,     7,     7,     7,     5,     7,     5 };
yytabelem yychk[]={

-10000000,   -34,    -3,    -4,    -5,    -1,    -2,   -23,   -18,   -35,
   -22,   -36,   -37,   256,   638,    -6,   503,   390,   486,   639,
   640,   257,   258,   259,   260,   261,   262,   263,   264,   267,
   268,   269,   270,   271,   298,   299,   300,   301,   302,   303,
   304,   305,   265,   266,   272,   292,   273,   274,   275,   276,
   277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
   287,   288,   289,   290,   291,   293,   294,   295,   296,   650,
    40,    45,   484,   324,   340,   367,   523,   331,   347,   372,
   455,   635,   637,   636,   361,   441,   528,   348,   427,   425,
   545,   428,   307,   386,   330,   527,   508,   306,   310,   388,
   481,   543,   311,   511,   350,   440,   415,   380,   321,   429,
   485,   -28,   -29,   630,   402,   359,   325,   430,   381,   512,
   537,   385,   483,   334,   406,   499,   479,   480,   351,   516,
   345,   338,   651,   424,   525,   532,   354,   544,   468,   542,
   533,   526,   391,   420,   387,   -39,   -41,   539,   -21,   473,
   356,   394,   474,   546,   575,   547,   576,   577,   578,   579,
   580,   581,   493,   495,   494,   497,   496,   358,   375,   412,
   413,   550,   583,   315,   316,   587,   588,   329,   549,   582,
   504,    10,    10,    10,    10,    43,    45,    42,    47,    94,
    37,    63,   643,   644,   645,   646,   647,   648,   642,   641,
    10,    43,    45,    42,    47,    94,    63,   643,   644,   645,
   646,   647,   648,   642,   641,    10,    10,    10,    10,    10,
    10,    10,    91,    61,    91,    61,   428,   421,   467,   362,
    46,    61,    46,    -7,   416,   325,   398,   537,   332,   517,
   379,   283,   504,   451,   448,    -7,   537,   348,   425,   427,
   424,   554,    46,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    -2,    -1,   638,    -6,   503,
   390,   273,   486,    -2,    -1,    -2,    -1,   484,   344,   344,
   348,   639,   417,   -16,   639,   409,   538,   308,   490,   419,
   407,   454,    -7,    -7,    -7,    -1,   638,    -6,   503,   390,
   257,   258,   259,   260,   261,   262,   263,   264,   267,   268,
   269,   270,   271,   272,   292,   273,   274,   275,   276,   279,
   280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
   290,   291,   293,   294,   295,   296,   650,    40,    45,    -1,
    -1,   639,   639,   639,   525,   406,   503,   486,   455,    -9,
   536,   374,    -9,    -9,   639,   639,    -9,   344,   344,   390,
   503,   338,   651,   424,   525,   503,   390,   503,   503,   390,
   503,   390,   503,   504,   390,   391,   639,   638,    40,    40,
    40,    40,    40,    40,   549,   582,   503,    -7,   390,    -7,
   502,   382,   346,   -26,   360,   465,   -27,   554,   555,   556,
   557,   559,   560,   561,   562,   563,   564,   565,   566,   567,
   568,   569,   570,   571,   572,   573,   574,   447,   335,   469,
   482,   -11,   352,   373,   470,   593,   594,   596,   595,   597,
   598,   599,   600,   601,   602,   603,   604,   605,   606,   607,
   608,   609,   610,   611,   612,   613,   614,   615,   616,   617,
   618,   344,   333,   334,   -27,   406,   -27,   554,   344,   639,
   544,   516,   338,   651,   424,   525,    -7,   390,    -1,   431,
   425,   427,   348,   377,   353,    -7,   390,    -1,   431,   425,
   427,   348,   377,   353,    -7,   390,    -1,   431,   427,   425,
   348,   322,   353,    -7,   390,    -1,   431,   427,   348,   492,
   383,   414,   343,   353,   525,   425,   427,   348,   343,   383,
   528,    -1,   553,   552,   586,   585,   544,    -1,   553,   552,
   586,   585,   344,   383,   506,   348,   427,   344,   383,   506,
   348,   427,   283,   -39,   -41,   504,   503,    -7,   431,   417,
   541,   397,   421,   338,    -1,   548,   577,   343,   383,   425,
   427,   348,   525,    -7,   537,   425,   427,   348,   377,   331,
   -40,   529,   530,   416,   332,    -7,   500,   420,   427,   425,
   348,   431,   322,   -38,    -7,   404,   537,   439,   471,   385,
   528,   -24,   377,   507,   371,   571,   349,   425,   427,   383,
   348,   506,   -17,   534,   476,   478,   437,   436,   401,   400,
   394,   376,   639,   356,   427,   -42,    -7,   348,   427,   425,
   383,   343,   393,   -42,   -42,    -1,    -2,    -1,    -2,    -1,
    -2,    -1,    -2,    -1,    -2,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    -1,    -2,    -2,    -1,    -2,    -2,    -2,
    -2,    -2,    -2,    -2,    -2,    -1,    -2,    -1,    -1,    -2,
    -1,   -26,    -7,   639,    -1,   639,    -6,   528,   421,   503,
   390,   503,   298,   299,   300,   301,   302,   303,   304,   305,
    -7,   537,    -9,    -9,   -20,   554,   432,   433,   434,   332,
   395,   517,   518,   468,   558,   339,   396,   510,   506,   506,
    -7,   385,   471,   554,   537,   504,   -19,   589,   590,   419,
   490,   591,   592,   639,   639,   639,    -1,    -1,    -6,    -1,
    -2,    -2,    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,   503,    -2,    -1,    -2,    -1,    -1,    -2,
   639,   639,   639,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    91,    91,    46,    46,    40,    46,    41,    41,    -7,
   639,    44,   -31,   633,   631,   632,   634,   639,    44,    43,
    45,    42,    47,    94,    46,    46,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,    40,    40,    40,    -1,    -1,    -1,    44,
    44,    -1,   344,   385,   376,   534,    -7,   639,   639,   639,
   639,   639,    46,   -32,   546,   575,   534,    46,   534,    46,
   499,   499,    44,   639,   503,   503,   503,   503,   503,   503,
   344,   344,   -26,   344,   -26,   344,   344,   639,    -1,    44,
   -10,   544,   542,   639,   639,   639,   -25,   348,   460,   445,
    44,   -10,   639,   639,   639,   -25,   348,   460,    44,   -10,
   639,   639,   639,   639,   506,   537,    44,   -10,   639,   639,
   639,   639,   639,   506,   344,    -7,   383,   343,   348,   427,
   639,   639,   639,   639,   506,   639,   512,   506,    44,    -1,
    -1,    -1,    -1,    -1,    44,   639,   639,   639,   639,   639,
   639,   639,   639,   639,   639,   639,   639,   504,   -40,   -10,
   639,   639,   639,   639,    -7,   377,   348,   425,   427,    44,
    -1,    -1,   506,   639,   639,   639,   639,   639,   639,   639,
   639,   639,    -7,   348,   -43,   -47,    -7,   435,   438,   449,
   450,   313,   284,   283,   354,   -12,   281,   506,   348,   427,
   452,   537,   513,   639,   407,   454,   336,   -44,   -48,    -7,
   537,   471,   385,   319,   472,   417,   431,   317,   414,   507,
   520,   452,   505,   521,   524,   541,   397,   343,   383,   348,
   427,   639,   -45,   344,   417,   466,   414,   343,   383,   348,
   427,   -46,    -7,   348,   425,   427,   639,    -7,   639,   639,
   639,   -10,   537,   -27,    -1,   639,   -11,    -1,   377,   342,
   506,   343,   507,   348,   427,   425,   639,   639,   543,    -8,
   348,   460,   639,   421,   537,   427,   425,   491,    -1,   344,
   344,   -17,   639,   639,   639,   639,   639,   639,   506,    -7,
    58,    58,    93,    93,   344,    44,    44,    91,    61,    46,
    61,    46,   428,   421,   467,   362,    46,    61,   324,   513,
   639,   639,   -11,   639,    -1,   639,   639,    44,    44,    61,
    41,    41,    41,    41,    41,    41,    41,    41,    44,    44,
    41,    41,    41,    41,    41,    41,    41,    41,    41,    41,
    41,    41,    44,    44,    41,    41,    41,    41,    41,    44,
    44,    41,    44,    44,    41,    41,    41,    41,    41,    41,
    44,    44,    44,    44,    44,    44,    44,    44,    41,    41,
    41,    41,    44,    44,    41,    41,    41,    41,    41,    41,
    41,    41,    -1,    -1,    -6,   503,    -6,   639,    -1,    -1,
    -1,    -1,    -1,    -1,    -6,   503,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    44,   344,
   344,   390,   503,   -33,   323,   357,   503,   503,   503,   503,
   639,    44,    44,    44,    44,    44,    44,    44,   344,   344,
    44,    44,    -1,   639,   639,    -1,   639,   639,    -1,   639,
   639,    -1,   639,   639,   506,   639,   639,    44,   639,   639,
   639,    -1,    44,    -1,   639,    -7,   543,    -8,   639,   639,
   639,    -1,   639,   344,   639,   -47,    -7,    -1,   506,   348,
   427,   425,   393,    -7,    -1,   506,   348,   427,   425,   393,
    -1,    -1,    -7,    -1,    -1,   639,    -7,   639,   639,   639,
   -15,   535,   337,   419,   490,   336,   324,   513,   639,    44,
   -48,   324,   513,   639,   -11,   639,   344,   344,   399,   540,
   513,   451,   342,   419,   490,   639,   -14,   490,   419,   342,
   639,   639,   -15,   -13,   446,   309,   443,    -1,   537,    -1,
   537,   639,   639,   506,   639,   639,   639,    44,   462,   456,
   324,   513,   639,   -14,   506,   639,   639,   639,   639,   639,
   639,   639,   639,    -9,    -1,   639,   639,    -1,   639,   639,
    -8,   639,   639,   -15,   639,   639,    -7,   427,   425,    44,
   344,   639,    -1,    -2,    61,    61,    -1,   639,    -1,    -2,
    -1,   -30,   327,   284,   283,    -1,   503,   -26,    -7,   639,
    -1,   639,    -6,   503,   390,   -11,    44,    44,    -1,    -1,
    -1,    -2,    -1,    -2,    -1,    -2,    -1,   639,   639,   639,
   639,    -1,    -1,    -2,    -1,    -2,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    93,    93,    91,    46,    44,    46,    41,
    44,    44,    41,    44,    44,    -1,   385,   639,   534,   534,
    -1,   639,   639,   639,    -1,    -1,   639,   639,    -1,    44,
    44,    44,   639,   639,    44,    -1,    44,    -8,   639,   639,
   639,   639,   639,    -7,   639,   639,   639,   639,    -7,    -1,
   513,   324,   513,   324,   639,   344,    44,   639,   639,   639,
    -1,    -1,    -1,    93,   344,    44,    44,    91,    61,    46,
    46,   639,    -1,    44,    41,    41,    41,    41,    41,    41,
    41,    41,    44,    44,    44,    44,    41,    41,    41,    41,
    41,    41,    41,    41,    41,    41,    -1,    -6,   639,    -6,
    -1,   639,    -1,   639,    44,   344,   390,   390,    44,    41,
    41,    41,    44,    44,    41,    44,    -1,    -1,    -1,    -1,
    -1,   639,    61,    -1,   639,    -1,    -2,    -1,   -30,   503,
    -1,   639,   639,    -1,    -1,    93,    91,    44,    41,    41,
    41,   344,    46,    46,    -1,    -1,    -1,    -1,    44,    44,
    44,    44,    44,    -1,    93,    44,    41,    44,    41,    41,
    -1,   639,   503,   503,    44,    44,    44,    -1,    -1,    -1,
    -1,    -1,    61,    -1,   639,    93,   639,   639,    -1,    -1,
    44,    41,    41,   529,   639,    -1,    44,    44,   639,    -1,
    41,    44,    -1,    44,    -1 };
yytabelem yydef[]={

    -2,    -2,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   583,   584,   469,     0,     0,   664,
   665,     0,     0,     0,     0,     0,     0,     0,    -2,     0,
     0,     0,     0,     0,   702,   703,   704,   705,   706,   707,
   708,   709,   710,   711,    -2,    -2,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    -2,    -2,    -2,     0,     0,     0,     0,     0,     0,
     0,     0,    37,     0,     0,     0,    41,     0,     0,    44,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    63,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    94,     0,     0,
     0,     0,     0,     0,     0,     0,   104,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   132,   133,   134,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   357,   359,     0,     0,     0,
     0,    19,     0,   556,   557,   558,   559,   560,   561,   562,
   563,   564,   483,   484,   485,   486,   487,   488,   489,   490,
   491,   363,   364,   365,   366,   367,   368,     0,     0,     0,
   470,     2,     3,     4,     5,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     6,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     7,     8,     9,    10,    11,
    12,    13,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   258,     0,     0,     0,     0,     0,     0,
     0,     0,   471,   479,   480,    29,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   661,    -2,   583,   584,     0,
     0,     0,     0,     0,     0,   663,    -2,     0,    39,    40,
     0,     0,     0,    56,    57,     0,   544,   545,   546,   547,
   548,   549,    46,    47,    48,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   688,     0,     0,
     0,     0,     0,   712,   713,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   729,   730,
   731,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    52,    53,    54,     0,     0,   127,     0,     0,    60,
   507,   508,    61,    62,    64,    65,    66,    67,    68,    69,
    70,   139,   153,   166,   181,     0,     0,     0,     0,     0,
     0,     0,    88,    89,    92,    93,     0,     0,     0,     0,
     0,     0,     0,     0,   105,   106,   107,   108,   109,   110,
   111,   112,   113,   114,   492,   493,   115,   280,   281,   282,
   283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
   293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
   303,   116,   512,   513,   514,   515,   516,   517,   518,   519,
   520,   521,   522,   523,   524,   525,   526,   527,   528,   529,
   530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
   540,   117,     0,     0,     0,     0,     0,     0,   131,   135,
     0,   137,   138,   152,   168,   180,   141,   142,     0,     0,
     0,     0,     0,     0,   151,   155,   156,     0,     0,     0,
     0,     0,     0,   165,   169,   170,     0,     0,     0,     0,
     0,     0,   179,   183,   184,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   218,     0,     0,     0,     0,   223,     0,     0,
     0,     0,     0,   360,   362,   472,   473,   229,     0,     0,
     0,     0,     0,     0,     0,     0,   560,     0,     0,     0,
     0,     0,     0,   251,     0,     0,     0,     0,     0,     0,
   358,     0,     0,     0,     0,   383,     0,     0,     0,     0,
     0,     0,     0,   327,   328,   329,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   474,   475,   476,
   477,   478,     0,     0,    21,    22,    23,    24,    25,    26,
    27,    28,    17,     0,     0,   369,   372,     0,     0,     0,
     0,     0,     0,   370,   371,    -2,   590,    -2,   594,    -2,
   598,    -2,   602,    -2,   605,   679,     0,    -2,    -2,    -2,
    -2,    -2,    -2,   744,   745,   589,    -2,   593,    -2,   597,
    -2,   601,    -2,    -2,   607,     0,   587,    -2,    -2,    -2,
    -2,    -2,    -2,   659,   660,     0,   571,   579,     0,   572,
   580,     0,    73,    77,     0,     0,   585,     0,   673,   573,
     0,   468,   694,   695,   696,   697,   698,   699,   700,   701,
   259,     0,   262,   263,   264,   304,   305,   306,   307,   308,
   309,   310,   311,   312,   313,   314,   315,   316,     0,     0,
   267,     0,     0,     0,     0,     0,    30,   321,   322,   323,
   324,   325,   326,    31,    32,    33,     0,     0,   667,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   662,   747,    38,
    42,     0,    45,   317,   318,   319,   320,    58,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   746,     0,   748,     0,
     0,     0,   125,     0,     0,     0,    59,   140,   154,   167,
   182,    75,     0,     0,   554,   555,     0,     0,     0,     0,
    90,    91,     0,     0,     0,     0,     0,     0,     0,     0,
   118,   119,     0,   122,     0,   124,   121,     0,     0,     0,
   144,   550,   551,   145,   146,   147,   148,   495,   494,   496,
     0,   158,   159,   160,   161,   162,   495,   494,     0,   172,
   173,   174,   175,   176,     0,     0,     0,   186,   187,   188,
   189,   190,   191,     0,   193,   194,     0,     0,     0,     0,
     0,   200,   201,   202,     0,   204,     0,     0,     0,   208,
   209,   210,   211,     0,     0,   214,   215,   216,   217,   219,
   220,   221,   222,   224,   225,   226,   227,     0,   361,   230,
   231,   232,   233,   234,   235,     0,     0,     0,     0,     0,
   243,   244,     0,   246,   247,   248,   249,     0,   252,   253,
   254,   255,   256,     0,   379,   384,   386,     0,     0,     0,
     0,     0,     0,     0,     0,   397,     0,     0,     0,     0,
     0,     0,     0,     0,   509,   510,   511,   380,   417,   419,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   381,   453,     0,     0,     0,     0,     0,     0,
     0,   382,   464,     0,     0,     0,   273,   274,   275,   276,
   277,   278,     0,   330,   331,   332,   333,   334,     0,     0,
     0,     0,     0,     0,     0,     0,   343,   344,     0,     0,
   481,   482,   347,     0,     0,     0,     0,     0,     0,   356,
    14,    16,    18,    20,   373,   374,   375,   376,     0,   378,
     0,     0,   666,   668,    71,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   260,   261,
   265,   266,     0,     0,     0,   271,   272,     0,     0,     0,
    -2,   609,   610,   682,   611,   683,   612,   684,     0,     0,
   614,   686,   615,   687,   617,   689,   618,   690,   619,   691,
   620,   692,     0,     0,   103,   627,   714,   628,   715,     0,
     0,    -2,     0,     0,   632,   720,   633,   721,   634,   722,
     0,     0,     0,     0,     0,     0,     0,     0,   639,   727,
   640,   728,     0,     0,   648,   733,   649,   734,   650,   735,
   651,   736,     0,     0,   585,     0,   667,     0,    49,   675,
   676,   677,   678,   680,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    50,     0,     0,   128,
   129,    36,     0,    83,   552,   553,    84,     0,    86,     0,
    95,     0,     0,     0,     0,     0,     0,     0,   120,   123,
     0,     0,     0,   149,   150,     0,   163,   164,     0,   177,
   178,   185,   192,   195,     0,   197,   198,     0,   203,   205,
   206,     0,     0,     0,   228,   236,     0,     0,   239,   240,
   241,   242,   245,   250,   257,   385,   387,   389,     0,     0,
     0,     0,     0,   388,   390,     0,     0,     0,     0,     0,
   391,   392,   393,   394,   395,   396,   398,   399,   402,   403,
   412,   497,   498,   499,   500,   501,   413,   414,   415,     0,
   418,   420,   421,   422,   423,   424,   425,   426,   427,   428,
   429,   430,   431,   432,   433,   434,   435,   502,   503,   504,
   436,   437,   438,   439,   541,   542,   543,   440,     0,   441,
     0,   446,   447,     0,   449,   450,   451,     0,   454,   455,
   456,   457,     0,   459,     0,   461,   462,   463,   465,   466,
   467,   279,   335,   336,   337,   338,   339,   340,   341,   342,
   345,   346,   348,   349,   350,   351,   352,     0,     0,     0,
    15,   377,   737,   652,     0,     0,    79,    81,     0,   577,
   581,   671,   674,   505,   506,   568,   575,     0,    74,    78,
     0,     0,   586,   574,     0,   268,     0,     0,     0,    35,
   570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   666,   668,     0,     0,     0,     0,   681,
     0,     0,   717,     0,     0,     0,     0,    76,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   126,     0,     0,
     0,     0,   196,   199,     0,   212,     0,   237,   238,   400,
   404,   406,   408,   410,   401,   405,   407,   409,   411,   416,
   442,   443,   444,   445,   448,   452,     0,   460,   353,   354,
   355,   565,   566,   669,    72,     0,     0,     0,     0,     0,
     0,   269,   270,     0,   613,   685,   621,   623,   622,    -2,
    -2,   630,     0,     0,     0,     0,   636,   724,   637,   725,
   638,   726,   644,   646,   645,    -2,     0,   586,     0,     0,
     0,     0,     0,    51,     0,   130,     0,     0,     0,    97,
    98,    99,     0,     0,   102,     0,     0,     0,     0,     0,
     0,   458,     0,    80,    82,     0,   578,   582,   672,   576,
     0,     0,     0,     0,     0,   669,     0,     0,   693,   716,
   732,    55,     0,     0,    96,     0,     0,     0,     0,     0,
     0,     0,     0,   567,   670,     0,   718,     0,   635,   723,
     0,    43,    85,    87,     0,     0,     0,   143,   157,   171,
   207,   213,     0,    34,     0,   670,     0,     0,     0,   569,
     0,   100,   101,     0,     0,     0,     0,     0,     0,     0,
   719,     0,     0,     0,   136 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	1	/* allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"ABS",	257,
	"ACOS",	258,
	"ASIN",	259,
	"ATAN",	260,
	"ATAN2",	261,
	"CEIL",	262,
	"COS",	263,
	"DEG",	264,
	"DX",	265,
	"DY",	266,
	"ERF",	267,
	"ERFC",	268,
	"EXP",	269,
	"FLOOR",	270,
	"HYPOT",	271,
	"INDEX",	272,
	"INT",	273,
	"INVN",	274,
	"INVT",	275,
	"IRAND",	276,
	"JDAY",	277,
	"JDAY0",	278,
	"LGAMMA",	279,
	"LN",	280,
	"LOG",	281,
	"LOGISTIC",	282,
	"MAXP",	283,
	"MINP",	284,
	"MOD",	285,
	"NORM",	286,
	"NORMP",	287,
	"PI",	288,
	"RAD",	289,
	"RAND",	290,
	"RNORM",	291,
	"SETNO",	292,
	"SIN",	293,
	"SQR",	294,
	"SQRT",	295,
	"TAN",	296,
	"INUM",	297,
	"VX1",	298,
	"VX2",	299,
	"VY1",	300,
	"VY2",	301,
	"WX1",	302,
	"WX2",	303,
	"WY1",	304,
	"WY2",	305,
	"DELAYP",	306,
	"DOUBLEBUFFER",	307,
	"DOWN",	308,
	"ABSOLUTE",	309,
	"ABORT",	310,
	"ACTIVATE",	311,
	"ACTIVE",	312,
	"ALT",	313,
	"ALTERNATE",	314,
	"ALTXAXIS",	315,
	"ALTYAXIS",	316,
	"ANGLE",	317,
	"ANNOTATE",	318,
	"APPEND",	319,
	"AREA",	320,
	"ARRANGE",	321,
	"ARROW",	322,
	"ASCENDING",	323,
	"AUTO",	324,
	"AUTOSCALE",	325,
	"AUTOTICKS",	326,
	"AVG",	327,
	"AXIS",	328,
	"AXES",	329,
	"BACKBUFFER",	330,
	"BACKGROUND",	331,
	"BAR",	332,
	"BATCH",	333,
	"BLOCK",	334,
	"BIN",	335,
	"BOTH",	336,
	"BOTTOM",	337,
	"BOX",	338,
	"BOXPLOT",	339,
	"CD",	340,
	"CELLS",	341,
	"CENTER",	342,
	"CHAR",	343,
	"CHRSTR",	344,
	"CLEAR",	345,
	"CLICK",	346,
	"CMAP",	347,
	"COLOR",	348,
	"COMMENT",	349,
	"COPY",	350,
	"CYCLE",	351,
	"DECIMAL",	352,
	"DEF",	353,
	"DEFAULT",	354,
	"DELETE",	355,
	"DEVICE",	356,
	"DESCENDING",	357,
	"DFT",	358,
	"DIFFERENCE",	359,
	"DISK",	360,
	"DRAW2",	361,
	"DROP",	362,
	"DXDX",	363,
	"DXP",	364,
	"DYDY",	365,
	"DYP",	366,
	"ECHO",	367,
	"EDIT",	368,
	"ELSE",	369,
	"END",	370,
	"ERRORBAR",	371,
	"EXIT",	372,
	"EXPONENTIAL",	373,
	"FALSEP",	374,
	"FFT",	375,
	"FILEP",	376,
	"FILL",	377,
	"FIND",	378,
	"FIXEDPOINT",	379,
	"FLUSH",	380,
	"FOCUS",	381,
	"FOLLOWS",	382,
	"FONTP",	383,
	"FOREGROUND",	384,
	"FORMAT",	385,
	"FRONTBUFFER",	386,
	"FRAMEP",	387,
	"GETP",	388,
	"GRAPH",	389,
	"GRAPHNO",	390,
	"GRAPHS",	391,
	"GRAPHTYPE",	392,
	"GRID",	393,
	"HARDCOPY",	394,
	"HBAR",	395,
	"HBOXPLOT",	396,
	"HGAP",	397,
	"HIDDEN",	398,
	"HORIZONTAL",	399,
	"HPGLL",	400,
	"HPGLP",	401,
	"HISTO",	402,
	"IF",	403,
	"IGNORE",	404,
	"IHL",	405,
	"IMAGE",	406,
	"IN",	407,
	"INIT",	408,
	"INOUT",	409,
	"INTEGRATE",	410,
	"INTERP",	411,
	"INVDFT",	412,
	"INVFFT",	413,
	"JUST",	414,
	"KILL",	415,
	"LABEL",	416,
	"LAYOUT",	417,
	"LEAVE",	418,
	"LEFT",	419,
	"LEGEND",	420,
	"LENGTH",	421,
	"LEVEL",	422,
	"LEVELS",	423,
	"LINE",	424,
	"LINESTYLE",	425,
	"LINETO",	426,
	"LINEWIDTH",	427,
	"LINK",	428,
	"LOAD",	429,
	"LOCATOR",	430,
	"LOCTYPE",	431,
	"LOGX",	432,
	"LOGY",	433,
	"LOGXY",	434,
	"MAJOR",	435,
	"MIFL",	436,
	"MIFP",	437,
	"MINOR",	438,
	"MISSINGP",	439,
	"MOVE",	440,
	"MOVE2",	441,
	"MOVETO",	442,
	"NEGATE",	443,
	"NO",	444,
	"NONE",	445,
	"NORMAL",	446,
	"NXY",	447,
	"OFF",	448,
	"OFFSETX",	449,
	"OFFSETY",	450,
	"ON",	451,
	"OP",	452,
	"ORIENT",	453,
	"OUT",	454,
	"PAGE",	455,
	"PARA",	456,
	"PARALLEL",	457,
	"PARAMETERS",	458,
	"PARAMS",	459,
	"PATTERN",	460,
	"PERIMETER",	461,
	"PERP",	462,
	"PERPENDICULAR",	463,
	"PIE",	464,
	"PIPE",	465,
	"PLACE",	466,
	"POINT",	467,
	"POLAR",	468,
	"POLY",	469,
	"POWER",	470,
	"PREC",	471,
	"PREPEND",	472,
	"PRINT",	473,
	"PS",	474,
	"PSCOLORP",	475,
	"PSMONOP",	476,
	"PSCOLORL",	477,
	"PSMONOL",	478,
	"PUSH",	479,
	"POP",	480,
	"PUTP",	481,
	"RAWSPICE",	482,
	"READ",	483,
	"REDRAW",	484,
	"REGRESS",	485,
	"REGNUM",	486,
	"REGIONS",	487,
	"RENDER",	488,
	"REVERSE",	489,
	"RIGHT",	490,
	"RISER",	491,
	"ROT",	492,
	"RUNAVG",	493,
	"RUNMED",	494,
	"RUNSTD",	495,
	"RUNMIN",	496,
	"RUNMAX",	497,
	"SAMPLE",	498,
	"SAVEALL",	499,
	"SCALE",	500,
	"SCIENTIFIC",	501,
	"SET",	502,
	"SETNUM",	503,
	"SETS",	504,
	"SIGN",	505,
	"SIZE",	506,
	"SKIP",	507,
	"SLEEP",	508,
	"SLICE",	509,
	"SMITH",	510,
	"SORT",	511,
	"SOURCE",	512,
	"SPEC",	513,
	"SPECIFIED",	514,
	"SPECTRUM",	515,
	"STACK",	516,
	"STACKEDBAR",	517,
	"STACKEDHBAR",	518,
	"STACKEDLINE",	519,
	"STAGGER",	520,
	"START",	521,
	"STARTTYPE",	522,
	"STATUS",	523,
	"STOP",	524,
	"STRING",	525,
	"SUBTITLE",	526,
	"SWAPBUFFER",	527,
	"SYMBOL",	528,
	"TICKP",	529,
	"TICKLABEL",	530,
	"TICKMARKS",	531,
	"TIME",	532,
	"TITLE",	533,
	"TO",	534,
	"TOP",	535,
	"TRUEP",	536,
	"TYPE",	537,
	"UP",	538,
	"VELOCITY",	539,
	"VERTICAL",	540,
	"VGAP",	541,
	"VIEW",	542,
	"WITH",	543,
	"WORLD",	544,
	"WRITE",	545,
	"X",	546,
	"X0",	547,
	"X1",	548,
	"XAXES",	549,
	"XAXIS",	550,
	"XCOR",	551,
	"XMAX",	552,
	"XMIN",	553,
	"XY",	554,
	"XYARC",	555,
	"XYBOX",	556,
	"XYBOXPLOT",	557,
	"XYFIXED",	558,
	"XYHILO",	559,
	"XYRT",	560,
	"XYSEG",	561,
	"XYSTRING",	562,
	"XYDX",	563,
	"XYDY",	564,
	"XYDXDX",	565,
	"XYDYDY",	566,
	"XYDXDY",	567,
	"XYX2Y2",	568,
	"XYXX",	569,
	"XYYY",	570,
	"XYZ",	571,
	"XYZW",	572,
	"XYUV",	573,
	"TSV",	574,
	"Y",	575,
	"Y0",	576,
	"Y1",	577,
	"Y2",	578,
	"Y3",	579,
	"Y4",	580,
	"Y5",	581,
	"YAXES",	582,
	"YAXIS",	583,
	"YES",	584,
	"YMAX",	585,
	"YMIN",	586,
	"ZEROXAXIS",	587,
	"ZEROYAXIS",	588,
	"ABOVE",	589,
	"BELOW",	590,
	"POLYI",	591,
	"POLYO",	592,
	"GENERAL",	593,
	"DDMMYY",	594,
	"YYMMDD",	595,
	"MMDDYY",	596,
	"MMYY",	597,
	"MMDD",	598,
	"MONTHDAY",	599,
	"DAYMONTH",	600,
	"MONTHS",	601,
	"MONTHSY",	602,
	"MONTHL",	603,
	"DAYOFWEEKS",	604,
	"DAYOFWEEKL",	605,
	"DAYOFYEAR",	606,
	"HMS",	607,
	"MMDDHMS",	608,
	"MMDDYYHMS",	609,
	"YYMMDDHMS",	610,
	"DEGREESLON",	611,
	"DEGREESMMLON",	612,
	"DEGREESMMSSLON",	613,
	"MMSSLON",	614,
	"DEGREESLAT",	615,
	"DEGREESMMLAT",	616,
	"DEGREESMMSSLAT",	617,
	"MMSSLAT",	618,
	"DOT",	619,
	"STAR",	620,
	"PLUS",	621,
	"CROSS",	622,
	"CIRCLE",	623,
	"SQUARE",	624,
	"DIAMOND",	625,
	"TRIANGLE1",	626,
	"TRIANGLE2",	627,
	"TRIANGLE3",	628,
	"TRIANGLE4",	629,
	"SPLINE",	630,
	"LANDSCAPE",	631,
	"PORTRAIT",	632,
	"FREE",	633,
	"FIXED",	634,
	"STATUSBAR",	635,
	"LOCATORBAR",	636,
	"TOOLBAR",	637,
	"VAR",	638,
	"NUMBER",	639,
	"FITPARM",	640,
	"=",	61,
	"OR",	641,
	"AND",	642,
	"GT",	643,
	"LT",	644,
	"LE",	645,
	"GE",	646,
	"EQ",	647,
	"NE",	648,
	"+",	43,
	"-",	45,
	"*",	42,
	"/",	47,
	"%",	37,
	"^",	94,
	"UMINUS",	649,
	"NOT",	650,
	"ELLIPSE",	651,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"list : /* empty */",
	"list : asgn '\n'",
	"list : vasgn '\n'",
	"list : rasgn '\n'",
	"list : expr '\n'",
	"list : vexpr '\n'",
	"list : parmset '\n'",
	"list : regionset '\n'",
	"list : setaxis '\n'",
	"list : setvelocity '\n'",
	"list : set_setprop '\n'",
	"list : setprint '\n'",
	"list : error '\n'",
	"setprint : PRINT printer CHRSTR",
	"setprint : PRINT TO printer CHRSTR",
	"setprint : PRINT TO printer",
	"setprint : DEVICE NUMBER",
	"setprint : HARDCOPY DEVICE NUMBER",
	"setprint : HARDCOPY",
	"setprint : PS LINEWIDTH NUMBER",
	"printer : PSMONOP",
	"printer : PSMONOL",
	"printer : MIFP",
	"printer : MIFL",
	"printer : HPGLP",
	"printer : HPGLL",
	"printer : HARDCOPY",
	"printer : FILEP",
	"regionset : REGNUM onoff",
	"regionset : REGNUM TYPE regiontype",
	"regionset : REGNUM COLOR NUMBER",
	"regionset : REGNUM LINESTYLE NUMBER",
	"regionset : REGNUM LINEWIDTH NUMBER",
	"regionset : REGNUM LINE expr ',' expr ',' expr ',' expr",
	"regionset : REGNUM XY expr ',' expr",
	"regionset : LINK REGNUM TO GRAPHNO",
	"parmset : REDRAW",
	"parmset : AUTO REDRAW onoff",
	"parmset : CD CHRSTR",
	"parmset : ECHO CHRSTR",
	"parmset : STATUS",
	"parmset : BACKGROUND COLOR NUMBER",
	"parmset : CMAP NUMBER ',' NUMBER ',' NUMBER ',' NUMBER",
	"parmset : EXIT",
	"parmset : PAGE LAYOUT pagelayout",
	"parmset : STATUSBAR onoff",
	"parmset : TOOLBAR onoff",
	"parmset : LOCATORBAR onoff",
	"parmset : DRAW2 expr ',' expr",
	"parmset : MOVE2 expr ',' expr",
	"parmset : SYMBOL expr ',' expr ',' NUMBER",
	"parmset : COLOR NUMBER",
	"parmset : LINEWIDTH NUMBER",
	"parmset : LINESTYLE NUMBER",
	"parmset : WRITE STRING expr ',' expr ',' CHRSTR",
	"parmset : PAGE direction",
	"parmset : PAGE NUMBER",
	"parmset : PAGE INOUT NUMBER",
	"parmset : LINK PAGE onoff",
	"parmset : DOUBLEBUFFER torf",
	"parmset : FRONTBUFFER torf",
	"parmset : BACKBUFFER torf",
	"parmset : SWAPBUFFER",
	"parmset : SLEEP NUMBER",
	"parmset : DELAYP NUMBER",
	"parmset : ABORT torf",
	"parmset : GETP CHRSTR",
	"parmset : PUTP CHRSTR",
	"parmset : WITH GRAPHNO",
	"parmset : WITH SETNUM",
	"parmset : SETNUM LINK sourcetype CHRSTR",
	"parmset : GRAPHNO '.' SETNUM LINK sourcetype CHRSTR",
	"parmset : SETNUM LINK onoff",
	"parmset : GRAPHNO '.' SETNUM LINK onoff",
	"parmset : ACTIVATE SETNUM NUMBER",
	"parmset : ACTIVATE GRAPHNO '.' SETNUM NUMBER",
	"parmset : SETNUM LENGTH NUMBER",
	"parmset : GRAPHNO '.' SETNUM LENGTH NUMBER",
	"parmset : SETNUM POINT expr ',' expr",
	"parmset : GRAPHNO '.' SETNUM POINT expr ',' expr",
	"parmset : SETNUM DROP NUMBER ',' NUMBER",
	"parmset : GRAPHNO '.' SETNUM DROP NUMBER ',' NUMBER",
	"parmset : SORT SETNUM sorton sortdir",
	"parmset : COPY SETNUM TO SETNUM",
	"parmset : COPY GRAPHNO '.' SETNUM TO GRAPHNO '.' SETNUM",
	"parmset : MOVE SETNUM TO SETNUM",
	"parmset : MOVE GRAPHNO '.' SETNUM TO GRAPHNO '.' SETNUM",
	"parmset : KILL SETNUM",
	"parmset : KILL SETS",
	"parmset : KILL SETNUM SAVEALL",
	"parmset : KILL SETS SAVEALL",
	"parmset : KILL GRAPHNO",
	"parmset : KILL GRAPHS",
	"parmset : FLUSH",
	"parmset : ARRANGE NUMBER ',' NUMBER",
	"parmset : LOAD VAR NUMBER ',' expr ',' expr",
	"parmset : REGRESS '(' SETNUM ',' NUMBER ')'",
	"parmset : runtype '(' SETNUM ',' NUMBER ')'",
	"parmset : ffttype '(' SETNUM ',' NUMBER ')'",
	"parmset : SPLINE '(' SETNUM ',' expr ',' expr ',' NUMBER ')'",
	"parmset : HISTO '(' SETNUM ',' expr ',' expr ',' NUMBER ')'",
	"parmset : DIFFERENCE '(' SETNUM ',' NUMBER ')'",
	"parmset : INT '(' SETNUM ')'",
	"parmset : AUTOSCALE",
	"parmset : AUTOSCALE XAXES",
	"parmset : AUTOSCALE YAXES",
	"parmset : AUTOSCALE SETNUM",
	"parmset : LOCATOR onoff",
	"parmset : FOCUS GRAPHNO",
	"parmset : FOCUS onoff",
	"parmset : FOCUS SET",
	"parmset : FOCUS FOLLOWS",
	"parmset : FOCUS CLICK",
	"parmset : SOURCE sourcetype",
	"parmset : TYPE xytype",
	"parmset : FORMAT formatchoice",
	"parmset : READ CHRSTR",
	"parmset : READ BATCH CHRSTR",
	"parmset : READ BLOCK CHRSTR",
	"parmset : READ BLOCK sourcetype CHRSTR",
	"parmset : BLOCK xytype CHRSTR",
	"parmset : READ xytype CHRSTR",
	"parmset : READ xytype sourcetype CHRSTR",
	"parmset : READ IMAGE CHRSTR",
	"parmset : WRITE IMAGE CHRSTR",
	"parmset : IMAGE XY NUMBER ',' NUMBER",
	"parmset : WRITE SETNUM",
	"parmset : WRITE SETNUM FORMAT CHRSTR",
	"parmset : WRITE SETNUM FILEP CHRSTR",
	"parmset : WRITE SETNUM FILEP CHRSTR FORMAT CHRSTR",
	"parmset : SAVEALL CHRSTR",
	"parmset : PUSH",
	"parmset : POP",
	"parmset : CYCLE",
	"parmset : STACK NUMBER",
	"parmset : STACK WORLD expr ',' expr ',' expr ',' expr TICKP expr ',' expr ',' expr ',' expr",
	"parmset : CLEAR STACK",
	"parmset : CLEAR BOX",
	"parmset : WITH BOX",
	"parmset : WITH BOX NUMBER",
	"parmset : BOX onoff",
	"parmset : BOX GRAPHNO",
	"parmset : BOX expr ',' expr ',' expr ',' expr",
	"parmset : BOX LOCTYPE worldview",
	"parmset : BOX LINESTYLE NUMBER",
	"parmset : BOX LINEWIDTH NUMBER",
	"parmset : BOX COLOR NUMBER",
	"parmset : BOX FILL filltype",
	"parmset : BOX FILL COLOR NUMBER",
	"parmset : BOX FILL PATTERN NUMBER",
	"parmset : BOX DEF",
	"parmset : CLEAR ELLIPSE",
	"parmset : WITH ELLIPSE",
	"parmset : WITH ELLIPSE NUMBER",
	"parmset : ELLIPSE onoff",
	"parmset : ELLIPSE GRAPHNO",
	"parmset : ELLIPSE expr ',' expr ',' expr ',' expr",
	"parmset : ELLIPSE LOCTYPE worldview",
	"parmset : ELLIPSE LINESTYLE NUMBER",
	"parmset : ELLIPSE LINEWIDTH NUMBER",
	"parmset : ELLIPSE COLOR NUMBER",
	"parmset : ELLIPSE FILL filltype",
	"parmset : ELLIPSE FILL COLOR NUMBER",
	"parmset : ELLIPSE FILL PATTERN NUMBER",
	"parmset : ELLIPSE DEF",
	"parmset : WITH LINE",
	"parmset : WITH LINE NUMBER",
	"parmset : CLEAR LINE",
	"parmset : LINE onoff",
	"parmset : LINE GRAPHNO",
	"parmset : LINE expr ',' expr ',' expr ',' expr",
	"parmset : LINE LOCTYPE worldview",
	"parmset : LINE LINEWIDTH NUMBER",
	"parmset : LINE LINESTYLE NUMBER",
	"parmset : LINE COLOR NUMBER",
	"parmset : LINE ARROW NUMBER",
	"parmset : LINE ARROW SIZE NUMBER",
	"parmset : LINE ARROW TYPE NUMBER",
	"parmset : LINE DEF",
	"parmset : CLEAR STRING",
	"parmset : WITH STRING",
	"parmset : WITH STRING NUMBER",
	"parmset : STRING onoff",
	"parmset : STRING GRAPHNO",
	"parmset : STRING expr ',' expr",
	"parmset : STRING LOCTYPE worldview",
	"parmset : STRING LINEWIDTH NUMBER",
	"parmset : STRING COLOR NUMBER",
	"parmset : STRING ROT NUMBER",
	"parmset : STRING FONTP NUMBER",
	"parmset : STRING JUST NUMBER",
	"parmset : STRING CHAR SIZE NUMBER",
	"parmset : STRING DEF CHRSTR",
	"parmset : TIME STRING onoff",
	"parmset : TIME STRING FONTP NUMBER",
	"parmset : TIME STRING CHAR SIZE NUMBER",
	"parmset : TIME STRING COLOR NUMBER",
	"parmset : TIME STRING LINEWIDTH NUMBER",
	"parmset : TIME STRING NUMBER ',' NUMBER",
	"parmset : DEFAULT LINESTYLE NUMBER",
	"parmset : DEFAULT LINEWIDTH NUMBER",
	"parmset : DEFAULT COLOR NUMBER",
	"parmset : DEFAULT CHAR SIZE NUMBER",
	"parmset : DEFAULT FONTP NUMBER",
	"parmset : DEFAULT FONTP SOURCE NUMBER",
	"parmset : DEFAULT SYMBOL SIZE NUMBER",
	"parmset : WORLD expr ',' expr ',' expr ',' expr",
	"parmset : WORLD XMIN expr",
	"parmset : WORLD XMAX expr",
	"parmset : WORLD YMIN expr",
	"parmset : WORLD YMAX expr",
	"parmset : POLAR WORLD expr ',' expr",
	"parmset : VIEW expr ',' expr ',' expr ',' expr",
	"parmset : VIEW XMIN NUMBER",
	"parmset : VIEW XMAX NUMBER",
	"parmset : VIEW YMIN NUMBER",
	"parmset : VIEW YMAX NUMBER",
	"parmset : TITLE CHRSTR",
	"parmset : TITLE FONTP NUMBER",
	"parmset : TITLE SIZE NUMBER",
	"parmset : TITLE COLOR NUMBER",
	"parmset : TITLE LINEWIDTH NUMBER",
	"parmset : SUBTITLE CHRSTR",
	"parmset : SUBTITLE FONTP NUMBER",
	"parmset : SUBTITLE SIZE NUMBER",
	"parmset : SUBTITLE COLOR NUMBER",
	"parmset : SUBTITLE LINEWIDTH NUMBER",
	"parmset : GRAPHS MAXP SETS NUMBER",
	"parmset : LEGEND onoff",
	"parmset : LEGEND LOCTYPE worldview",
	"parmset : LEGEND LAYOUT NUMBER",
	"parmset : LEGEND VGAP NUMBER",
	"parmset : LEGEND HGAP NUMBER",
	"parmset : LEGEND LENGTH NUMBER",
	"parmset : LEGEND BOX onoff",
	"parmset : LEGEND BOX FILL onoff",
	"parmset : LEGEND BOX FILL WITH colpat",
	"parmset : LEGEND BOX FILL colpat NUMBER",
	"parmset : LEGEND BOX COLOR NUMBER",
	"parmset : LEGEND BOX LINESTYLE NUMBER",
	"parmset : LEGEND BOX LINEWIDTH NUMBER",
	"parmset : LEGEND expr ',' expr",
	"parmset : LEGEND X1 expr",
	"parmset : LEGEND Y1 expr",
	"parmset : LEGEND CHAR SIZE NUMBER",
	"parmset : LEGEND FONTP NUMBER",
	"parmset : LEGEND LINESTYLE NUMBER",
	"parmset : LEGEND LINEWIDTH NUMBER",
	"parmset : LEGEND COLOR NUMBER",
	"parmset : LEGEND STRING NUMBER CHRSTR",
	"parmset : FRAMEP onoff",
	"parmset : FRAMEP TYPE NUMBER",
	"parmset : FRAMEP LINESTYLE NUMBER",
	"parmset : FRAMEP LINEWIDTH NUMBER",
	"parmset : FRAMEP COLOR NUMBER",
	"parmset : FRAMEP FILL onoff",
	"parmset : FRAMEP BACKGROUND COLOR NUMBER",
	"parmset : GRAPHNO onoff",
	"parmset : GRAPHNO LABEL onoff",
	"parmset : GRAPHNO AUTOSCALE TYPE AUTO",
	"parmset : GRAPHNO AUTOSCALE TYPE SPEC",
	"parmset : GRAPHNO AUTOSCALE torf",
	"parmset : GRAPHNO HIDDEN torf",
	"parmset : GRAPHNO TYPE graphtype",
	"parmset : GRAPHNO BAR SIZE NUMBER",
	"parmset : GRAPHNO STACKEDBAR SIZE NUMBER",
	"parmset : GRAPHNO FIXEDPOINT onoff",
	"parmset : GRAPHNO FIXEDPOINT FORMAT formatchoice formatchoice",
	"parmset : GRAPHNO FIXEDPOINT PREC NUMBER ',' NUMBER",
	"parmset : GRAPHNO FIXEDPOINT XY expr ',' expr",
	"parmset : GRAPHNO FIXEDPOINT TYPE NUMBER",
	"parmset : GRAPHNO MAXP SETS NUMBER",
	"setvelocity : VELOCITY SCALE NUMBER",
	"setvelocity : VELOCITY LEGEND onoff",
	"setvelocity : VELOCITY LINEWIDTH NUMBER",
	"setvelocity : VELOCITY LINESTYLE NUMBER",
	"setvelocity : VELOCITY COLOR NUMBER",
	"setvelocity : VELOCITY LOCTYPE worldview",
	"setvelocity : VELOCITY ARROW TYPE NUMBER",
	"xytype : XY",
	"xytype : XYARC",
	"xytype : XYBOX",
	"xytype : XYBOXPLOT",
	"xytype : XYHILO",
	"xytype : XYRT",
	"xytype : XYSEG",
	"xytype : XYSTRING",
	"xytype : XYDX",
	"xytype : XYDY",
	"xytype : XYDXDX",
	"xytype : XYDYDY",
	"xytype : XYDXDY",
	"xytype : XYX2Y2",
	"xytype : XYXX",
	"xytype : XYYY",
	"xytype : XYZ",
	"xytype : XYZW",
	"xytype : XYUV",
	"xytype : TSV",
	"xytype : NXY",
	"xytype : BIN",
	"xytype : POLY",
	"xytype : RAWSPICE",
	"graphtype : XY",
	"graphtype : LOGX",
	"graphtype : LOGY",
	"graphtype : LOGXY",
	"graphtype : BAR",
	"graphtype : HBAR",
	"graphtype : STACKEDBAR",
	"graphtype : STACKEDHBAR",
	"graphtype : POLAR",
	"graphtype : XYFIXED",
	"graphtype : BOXPLOT",
	"graphtype : HBOXPLOT",
	"graphtype : SMITH",
	"pagelayout : FREE",
	"pagelayout : LANDSCAPE",
	"pagelayout : PORTRAIT",
	"pagelayout : FIXED",
	"regiontype : ABOVE",
	"regiontype : BELOW",
	"regiontype : LEFT",
	"regiontype : RIGHT",
	"regiontype : POLYI",
	"regiontype : POLYO",
	"set_setprop : selectsets setprop",
	"setprop : onoff",
	"setprop : IGNORE",
	"setprop : TYPE xytype",
	"setprop : MISSINGP expr",
	"setprop : PREC NUMBER",
	"setprop : FORMAT formatchoice",
	"setprop : SYMBOL expr",
	"setprop : SYMBOL FILL NUMBER",
	"setprop : SYMBOL CENTER torf",
	"setprop : SYMBOL SIZE expr",
	"setprop : SYMBOL CHAR NUMBER",
	"setprop : SYMBOL SKIP NUMBER",
	"setprop : SYMBOL COLOR expr",
	"setprop : SYMBOL LINEWIDTH NUMBER",
	"setprop : SYMBOL LINESTYLE NUMBER",
	"setprop : prop NUMBER",
	"setprop : FILL NUMBER",
	"setprop : FILL WITH colpat",
	"setprop : FILL colpat NUMBER",
	"setprop : SKIP NUMBER",
	"setprop : ERRORBAR LENGTH NUMBER",
	"setprop : ERRORBAR TYPE opchoice",
	"setprop : ERRORBAR LINEWIDTH NUMBER",
	"setprop : ERRORBAR LINESTYLE NUMBER",
	"setprop : ERRORBAR RISER onoff",
	"setprop : ERRORBAR RISER LINEWIDTH NUMBER",
	"setprop : ERRORBAR RISER LINESTYLE NUMBER",
	"setprop : XYZ expr ',' expr",
	"setprop : COMMENT CHRSTR",
	"setaxis : axis",
	"setaxis : axis axisfeature",
	"setaxis : allaxes",
	"setaxis : GRAPHS axis",
	"setaxis : GRAPHS axis axisfeature",
	"setaxis : GRAPHS allaxes",
	"axis : XAXIS",
	"axis : YAXIS",
	"axis : ALTXAXIS",
	"axis : ALTYAXIS",
	"axis : ZEROXAXIS",
	"axis : ZEROYAXIS",
	"allaxes : AXES axesprops",
	"allaxes : XAXES axesprops",
	"allaxes : YAXES axesprops",
	"axesprops : onoff",
	"axesprops : COLOR NUMBER",
	"axesprops : LINEWIDTH NUMBER",
	"axesprops : LINESTYLE NUMBER",
	"axesprops : FONTP NUMBER",
	"axesprops : CHAR SIZE NUMBER",
	"axesprops : GRID onoff",
	"axisfeature : TICKP tickdesc",
	"axisfeature : TICKLABEL ticklabeldesc",
	"axisfeature : LABEL axislabeldesc",
	"axisfeature : BAR axisbardesc",
	"axisfeature : onoff",
	"tickdesc : tickattr",
	"tickdesc : tickdesc tickattr",
	"tickattr : onoff",
	"tickattr : MAJOR onoff",
	"tickattr : MINOR onoff",
	"tickattr : MAJOR expr",
	"tickattr : MINOR expr",
	"tickattr : OFFSETX expr",
	"tickattr : OFFSETY expr",
	"tickattr : ALT onoff",
	"tickattr : MINP expr",
	"tickattr : MAXP expr",
	"tickattr : DEFAULT NUMBER",
	"tickattr : inoutchoice",
	"tickattr : LOG onoff",
	"tickattr : SIZE NUMBER",
	"tickattr : MAJOR SIZE NUMBER",
	"tickattr : MINOR SIZE NUMBER",
	"tickattr : COLOR NUMBER",
	"tickattr : LINEWIDTH NUMBER",
	"tickattr : MAJOR COLOR NUMBER",
	"tickattr : MINOR COLOR NUMBER",
	"tickattr : MAJOR LINEWIDTH NUMBER",
	"tickattr : MINOR LINEWIDTH NUMBER",
	"tickattr : MAJOR LINESTYLE NUMBER",
	"tickattr : MINOR LINESTYLE NUMBER",
	"tickattr : MAJOR GRID onoff",
	"tickattr : MINOR GRID onoff",
	"tickattr : OP opchoice",
	"tickattr : TYPE AUTO",
	"tickattr : TYPE SPEC",
	"tickattr : SPEC NUMBER",
	"tickattr : NUMBER ',' expr",
	"ticklabeldesc : ticklabelattr",
	"ticklabeldesc : ticklabeldesc ticklabelattr",
	"ticklabelattr : onoff",
	"ticklabelattr : TYPE AUTO",
	"ticklabelattr : TYPE SPEC",
	"ticklabelattr : PREC NUMBER",
	"ticklabelattr : FORMAT formatchoice",
	"ticklabelattr : FORMAT NUMBER",
	"ticklabelattr : APPEND CHRSTR",
	"ticklabelattr : PREPEND CHRSTR",
	"ticklabelattr : LAYOUT HORIZONTAL",
	"ticklabelattr : LAYOUT VERTICAL",
	"ticklabelattr : LAYOUT SPEC",
	"ticklabelattr : LOCTYPE ON",
	"ticklabelattr : LOCTYPE CENTER",
	"ticklabelattr : LOCTYPE LEFT",
	"ticklabelattr : LOCTYPE RIGHT",
	"ticklabelattr : ANGLE NUMBER",
	"ticklabelattr : JUST justchoice",
	"ticklabelattr : SKIP NUMBER",
	"ticklabelattr : STAGGER NUMBER",
	"ticklabelattr : OP opchoice",
	"ticklabelattr : SIGN signchoice",
	"ticklabelattr : START expr",
	"ticklabelattr : STOP expr",
	"ticklabelattr : START TYPE SPEC",
	"ticklabelattr : START TYPE AUTO",
	"ticklabelattr : STOP TYPE SPEC",
	"ticklabelattr : STOP TYPE AUTO",
	"ticklabelattr : VGAP NUMBER",
	"ticklabelattr : HGAP NUMBER",
	"ticklabelattr : CHAR SIZE NUMBER",
	"ticklabelattr : FONTP NUMBER",
	"ticklabelattr : COLOR NUMBER",
	"ticklabelattr : LINEWIDTH NUMBER",
	"ticklabelattr : NUMBER ',' CHRSTR",
	"axislabeldesc : CHRSTR",
	"axislabeldesc : LAYOUT PERP",
	"axislabeldesc : LAYOUT PARA",
	"axislabeldesc : PLACE AUTO",
	"axislabeldesc : PLACE SPEC",
	"axislabeldesc : PLACE NUMBER ',' NUMBER",
	"axislabeldesc : JUST justchoice",
	"axislabeldesc : CHAR SIZE NUMBER",
	"axislabeldesc : FONTP NUMBER",
	"axislabeldesc : COLOR NUMBER",
	"axislabeldesc : LINEWIDTH NUMBER",
	"axisbardesc : onoff",
	"axisbardesc : COLOR NUMBER",
	"axisbardesc : LINESTYLE NUMBER",
	"axisbardesc : LINEWIDTH NUMBER",
	"selectsets : GRAPHNO '.' SETNUM",
	"selectsets : SETNUM",
	"selectsets : SETS",
	"selectsets : GRAPHNO SETS",
	"selectsets : GRAPHS SETS",
	"selectsets : GRAPHS SETNUM",
	"prop : LINESTYLE",
	"prop : LINEWIDTH",
	"prop : FONTP",
	"prop : COLOR",
	"prop : SIZE",
	"onoff : ON",
	"onoff : OFF",
	"colpat : COLOR",
	"colpat : PATTERN",
	"runtype : RUNAVG",
	"runtype : RUNSTD",
	"runtype : RUNMED",
	"runtype : RUNMAX",
	"runtype : RUNMIN",
	"ffttype : DFT",
	"ffttype : FFT",
	"ffttype : INVDFT",
	"ffttype : INVFFT",
	"sourcetype : DISK",
	"sourcetype : PIPE",
	"filltype : PATTERN",
	"filltype : COLOR",
	"filltype : NONE",
	"opchoice : TOP",
	"opchoice : BOTTOM",
	"opchoice : LEFT",
	"opchoice : RIGHT",
	"opchoice : BOTH",
	"justchoice : RIGHT",
	"justchoice : LEFT",
	"justchoice : CENTER",
	"extremetype : MINP",
	"extremetype : MAXP",
	"torf : TRUEP",
	"torf : FALSEP",
	"inoutchoice : IN",
	"inoutchoice : OUT",
	"inoutchoice : BOTH",
	"formatchoice : DECIMAL",
	"formatchoice : EXPONENTIAL",
	"formatchoice : POWER",
	"formatchoice : GENERAL",
	"formatchoice : DDMMYY",
	"formatchoice : MMDDYY",
	"formatchoice : YYMMDD",
	"formatchoice : MMYY",
	"formatchoice : MMDD",
	"formatchoice : MONTHDAY",
	"formatchoice : DAYMONTH",
	"formatchoice : MONTHS",
	"formatchoice : MONTHSY",
	"formatchoice : MONTHL",
	"formatchoice : DAYOFWEEKS",
	"formatchoice : DAYOFWEEKL",
	"formatchoice : DAYOFYEAR",
	"formatchoice : HMS",
	"formatchoice : MMDDHMS",
	"formatchoice : MMDDYYHMS",
	"formatchoice : YYMMDDHMS",
	"formatchoice : DEGREESLON",
	"formatchoice : DEGREESMMLON",
	"formatchoice : DEGREESMMSSLON",
	"formatchoice : MMSSLON",
	"formatchoice : DEGREESLAT",
	"formatchoice : DEGREESMMLAT",
	"formatchoice : DEGREESMMSSLAT",
	"formatchoice : MMSSLAT",
	"signchoice : NORMAL",
	"signchoice : ABSOLUTE",
	"signchoice : NEGATE",
	"direction : UP",
	"direction : DOWN",
	"direction : RIGHT",
	"direction : LEFT",
	"direction : IN",
	"direction : OUT",
	"worldview : WORLD",
	"worldview : VIEW",
	"sortdir : ASCENDING",
	"sortdir : DESCENDING",
	"sorton : X",
	"sorton : Y",
	"vector : X",
	"vector : Y",
	"vector : X0",
	"vector : Y0",
	"vector : Y1",
	"vector : Y2",
	"vector : Y3",
	"vector : Y4",
	"vector : Y5",
	"asgn : VAR '[' expr ']' '=' expr",
	"asgn : vector '[' expr ']' '=' expr",
	"asgn : SETNUM '.' vector '[' expr ']' '=' expr",
	"asgn : SETNUM '.' SYMBOL '=' expr",
	"asgn : GRAPHNO '.' SETNUM '.' vector '[' expr ']' '=' expr",
	"rasgn : REGNUM '.' vector '=' expr",
	"vasgn : VAR '=' vexpr",
	"vasgn : vector '=' vexpr",
	"vasgn : SETNUM '=' SETNUM",
	"vasgn : GRAPHNO '.' SETNUM '=' SETNUM",
	"vasgn : SETNUM '=' GRAPHNO '.' SETNUM",
	"vasgn : GRAPHNO '.' SETNUM '=' GRAPHNO '.' SETNUM",
	"vasgn : SETNUM '.' vector '=' vexpr",
	"vasgn : GRAPHNO '.' SETNUM '.' vector '=' vexpr",
	"vasgn : VAR '=' expr",
	"vasgn : vector '=' expr",
	"vasgn : SETNUM '.' vector '=' expr",
	"vasgn : GRAPHNO '.' SETNUM '.' vector '=' expr",
	"vexpr : VAR",
	"vexpr : vector",
	"vexpr : SETNUM '.' vector",
	"vexpr : GRAPHNO '.' SETNUM '.' vector",
	"vexpr : expr",
	"vexpr : expr '+' expr",
	"vexpr : vexpr '+' vexpr",
	"vexpr : expr '+' vexpr",
	"vexpr : vexpr '+' expr",
	"vexpr : expr '-' expr",
	"vexpr : vexpr '-' vexpr",
	"vexpr : expr '-' vexpr",
	"vexpr : vexpr '-' expr",
	"vexpr : expr '*' expr",
	"vexpr : vexpr '*' vexpr",
	"vexpr : expr '*' vexpr",
	"vexpr : vexpr '*' expr",
	"vexpr : expr '/' expr",
	"vexpr : vexpr '/' vexpr",
	"vexpr : expr '/' vexpr",
	"vexpr : vexpr '/' expr",
	"vexpr : expr '^' expr",
	"vexpr : expr '^' vexpr",
	"vexpr : vexpr '^' expr",
	"vexpr : vexpr '^' vexpr",
	"vexpr : ABS '(' expr ')'",
	"vexpr : ABS '(' vexpr ')'",
	"vexpr : ACOS '(' vexpr ')'",
	"vexpr : ASIN '(' vexpr ')'",
	"vexpr : ATAN '(' vexpr ')'",
	"vexpr : ATAN2 '(' vexpr ',' vexpr ')'",
	"vexpr : CEIL '(' vexpr ')'",
	"vexpr : COS '(' vexpr ')'",
	"vexpr : DEG",
	"vexpr : ERF '(' vexpr ')'",
	"vexpr : ERFC '(' vexpr ')'",
	"vexpr : EXP '(' vexpr ')'",
	"vexpr : FLOOR '(' vexpr ')'",
	"vexpr : HYPOT '(' vexpr ',' vexpr ')'",
	"vexpr : HYPOT '(' expr ',' vexpr ')'",
	"vexpr : HYPOT '(' vexpr ',' expr ')'",
	"vexpr : HYPOT '(' expr ',' expr ')'",
	"vexpr : INDEX",
	"vexpr : SETNO",
	"vexpr : INT '(' vexpr ')'",
	"vexpr : INVN '(' vexpr ')'",
	"vexpr : INVT '(' expr ',' NUMBER ')'",
	"vexpr : INVT '(' vexpr ',' NUMBER ')'",
	"vexpr : IRAND '(' NUMBER ')'",
	"vexpr : LGAMMA '(' vexpr ')'",
	"vexpr : LN '(' vexpr ')'",
	"vexpr : LOG '(' vexpr ')'",
	"vexpr : LOGISTIC '(' vexpr ',' expr ',' expr ')'",
	"vexpr : MAXP '(' vexpr ',' vexpr ')'",
	"vexpr : MINP '(' vexpr ',' vexpr ')'",
	"vexpr : MOD '(' vexpr ',' vexpr ')'",
	"vexpr : NORM '(' vexpr ')'",
	"vexpr : NORMP '(' vexpr ')'",
	"vexpr : PI",
	"vexpr : RAD",
	"vexpr : RAND",
	"vexpr : RNORM '(' vexpr ',' vexpr ')'",
	"vexpr : RNORM '(' expr ',' vexpr ')'",
	"vexpr : RNORM '(' vexpr ',' expr ')'",
	"vexpr : RNORM '(' expr ',' expr ')'",
	"vexpr : SIN '(' vexpr ')'",
	"vexpr : SQR '(' vexpr ')'",
	"vexpr : SQRT '(' vexpr ')'",
	"vexpr : TAN '(' vexpr ')'",
	"vexpr : vexpr '?' vexpr ':' vexpr",
	"vexpr : vexpr GT vexpr",
	"vexpr : vexpr LT vexpr",
	"vexpr : vexpr LE vexpr",
	"vexpr : vexpr GE vexpr",
	"vexpr : vexpr EQ vexpr",
	"vexpr : vexpr NE vexpr",
	"vexpr : vexpr AND vexpr",
	"vexpr : vexpr OR vexpr",
	"vexpr : NOT vexpr",
	"vexpr : '(' vexpr ')'",
	"vexpr : '-' vexpr",
	"expr : NUMBER",
	"expr : FITPARM",
	"expr : VAR '[' expr ']'",
	"expr : REGNUM '.' vector",
	"expr : vector '[' expr ']'",
	"expr : SETNUM '.' vector '[' expr ']'",
	"expr : GRAPHNO '.' SETNUM '.' vector '[' expr ']'",
	"expr : SETNUM '.' vector '.' extremetype",
	"expr : GRAPHNO '.' SETNUM '.' vector '.' extremetype",
	"expr : SETNUM '.' LENGTH",
	"expr : SETNUM '.' vector '.' AVG",
	"expr : expr '+' expr",
	"expr : expr '-' expr",
	"expr : expr '*' expr",
	"expr : expr '/' expr",
	"expr : expr '%' expr",
	"expr : expr '^' expr",
	"expr : ABS '(' expr ')'",
	"expr : ACOS '(' expr ')'",
	"expr : ASIN '(' expr ')'",
	"expr : ATAN '(' expr ')'",
	"expr : ATAN2 '(' expr ',' expr ')'",
	"expr : CEIL '(' expr ')'",
	"expr : COS '(' expr ')'",
	"expr : DEG",
	"expr : ERF '(' expr ')'",
	"expr : ERFC '(' expr ')'",
	"expr : EXP '(' expr ')'",
	"expr : FLOOR '(' expr ')'",
	"expr : HYPOT '(' expr ',' expr ')'",
	"expr : GRAPHNO '.' VX1",
	"expr : GRAPHNO '.' VX2",
	"expr : GRAPHNO '.' VY1",
	"expr : GRAPHNO '.' VY2",
	"expr : GRAPHNO '.' WX1",
	"expr : GRAPHNO '.' WX2",
	"expr : GRAPHNO '.' WY1",
	"expr : GRAPHNO '.' WY2",
	"expr : VX1",
	"expr : VX2",
	"expr : VY1",
	"expr : VY2",
	"expr : WX1",
	"expr : WX2",
	"expr : WY1",
	"expr : WY2",
	"expr : DX",
	"expr : DY",
	"expr : INDEX",
	"expr : SETNO",
	"expr : INT '(' expr ')'",
	"expr : INVN '(' expr ')'",
	"expr : INVT '(' expr ',' NUMBER ')'",
	"expr : IRAND '(' NUMBER ')'",
	"expr : JDAY '(' NUMBER ',' NUMBER ',' NUMBER ')'",
	"expr : JDAY0 '(' NUMBER ',' NUMBER ',' NUMBER ',' NUMBER ',' NUMBER ',' NUMBER ')'",
	"expr : LGAMMA '(' expr ')'",
	"expr : LN '(' expr ')'",
	"expr : LOG '(' expr ')'",
	"expr : LOGISTIC '(' expr ',' expr ',' expr ')'",
	"expr : MAXP '(' expr ',' expr ')'",
	"expr : MINP '(' expr ',' expr ')'",
	"expr : MOD '(' expr ',' expr ')'",
	"expr : NORM '(' expr ')'",
	"expr : NORMP '(' expr ')'",
	"expr : PI",
	"expr : RAD",
	"expr : RAND",
	"expr : RNORM '(' expr ',' expr ')'",
	"expr : SIN '(' expr ')'",
	"expr : SQR '(' expr ')'",
	"expr : SQRT '(' expr ')'",
	"expr : TAN '(' expr ')'",
	"expr : expr '?' expr ':' expr",
	"expr : expr GT expr",
	"expr : expr LT expr",
	"expr : expr LE expr",
	"expr : expr GE expr",
	"expr : expr EQ expr",
	"expr : expr NE expr",
	"expr : expr AND expr",
	"expr : expr OR expr",
	"expr : NOT expr",
	"expr : '(' expr ')'",
	"expr : '-' expr",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 5:
# line 520 "pars.yacc"
{
	    result = yypvt[-1].val;
	} break;
case 6:
# line 523 "pars.yacc"
{
	    result = *yypvt[-1].ptr;
	} break;
case 13:
# line 532 "pars.yacc"
{
	    return 1;
	} break;
case 14:
# line 538 "pars.yacc"
{
	    if (yypvt[-1].pset == FILEP) {
		set_printer(FILEP, yypvt[-0].pset);
	    }
	    else {
		set_printer(yypvt[-1].pset, yypvt[-0].pset);
	    }
	    free((char *) yypvt[-0].pset);
	} break;
case 15:
# line 547 "pars.yacc"
{
	    if (yypvt[-1].pset == FILEP) {
		set_printer(FILEP, yypvt[-0].pset);
	    }
	    else {
		set_printer(yypvt[-1].pset, yypvt[-0].pset);
	    }
	    free((char *) yypvt[-0].pset);
	} break;
case 16:
# line 556 "pars.yacc"
{
	    if (yypvt[-0].pset == FILEP) {
		set_printer(FILEP, NULL);
	    }
	    else {
		set_printer(yypvt[-0].pset, NULL);
	    }
	} break;
case 17:
# line 564 "pars.yacc"
{
	    tdevice = (int) yypvt[-0].val;
	} break;
case 18:
# line 567 "pars.yacc"
{
	    hdevice = (int) yypvt[-0].val;
	} break;
case 19:
# line 570 "pars.yacc"
{
	    do_hardcopy();
	} break;
case 20:
# line 574 "pars.yacc"
{ 
	    extern int pslwfactor; /* fudge factor for linewidths in the PS driver */
	    pslwfactor = yypvt[-0].val; 
	} break;
case 21:
# line 581 "pars.yacc"
{ yyval.pset = GR_PS_P; } break;
case 22:
# line 582 "pars.yacc"
{ yyval.pset = GR_PS_L; } break;
case 23:
# line 583 "pars.yacc"
{ yyval.pset = GR_MIF_P; } break;
case 24:
# line 584 "pars.yacc"
{ yyval.pset = GR_MIF_L; } break;
case 25:
# line 585 "pars.yacc"
{ yyval.pset = GR_HPGL_P; } break;
case 26:
# line 586 "pars.yacc"
{ yyval.pset = GR_HPGL_L; } break;
case 27:
# line 587 "pars.yacc"
{ yyval.pset = hdevice; } break;
case 28:
# line 588 "pars.yacc"
{ yyval.pset = FILEP; } break;
case 29:
# line 592 "pars.yacc"
{
	    rg[yypvt[-1].pset].active = yypvt[-0].pset;
	} break;
case 30:
# line 595 "pars.yacc"
{
	    rg[yypvt[-2].pset].type = yypvt[-0].pset;
	} break;
case 31:
# line 598 "pars.yacc"
{
	    rg[yypvt[-2].pset].color = checkon(COLOR, rg[yypvt[-2].pset].color, (int) yypvt[-0].val);
	} break;
case 32:
# line 601 "pars.yacc"
{
	    rg[yypvt[-2].pset].lines = checkon(LINESTYLE, rg[yypvt[-2].pset].lines, (int) yypvt[-0].val);
	} break;
case 33:
# line 604 "pars.yacc"
{
	    rg[yypvt[-2].pset].linew = checkon(LINEWIDTH, rg[yypvt[-2].pset].linew, (int) yypvt[-0].val);
	} break;
case 34:
# line 608 "pars.yacc"
{
	    rg[yypvt[-8].pset].x1 = yypvt[-6].val;
	    rg[yypvt[-8].pset].y1 = yypvt[-4].val;
	    rg[yypvt[-8].pset].x2 = yypvt[-2].val;
	    rg[yypvt[-8].pset].y2 = yypvt[-0].val;
	} break;
case 35:
# line 615 "pars.yacc"
{
	    if (rg[yypvt[-4].pset].x == NULL || rg[yypvt[-4].pset].n == 0) {
		rg[yypvt[-4].pset].n = 0;
		rg[yypvt[-4].pset].x = (double *) calloc(1, sizeof(double));
		rg[yypvt[-4].pset].y = (double *) calloc(1, sizeof(double));
	    } else {
		rg[yypvt[-4].pset].x = (double *) realloc(rg[yypvt[-4].pset].x, (rg[yypvt[-4].pset].n + 1) * sizeof(double));
		rg[yypvt[-4].pset].y = (double *) realloc(rg[yypvt[-4].pset].y, (rg[yypvt[-4].pset].n + 1) * sizeof(double));
	    }
	    rg[yypvt[-4].pset].x[rg[yypvt[-4].pset].n] = yypvt[-2].val;
	    rg[yypvt[-4].pset].y[rg[yypvt[-4].pset].n] = yypvt[-0].val;
	    rg[yypvt[-4].pset].n++;
	} break;
case 36:
# line 628 "pars.yacc"
{
	    rg[yypvt[-2].pset].linkto[yypvt[-0].pset] = TRUE;
	} break;
case 37:
# line 634 "pars.yacc"
{
	    drawgraph();
	} break;
case 38:
# line 637 "pars.yacc"
{
	    auto_redraw = (yypvt[-0].pset == ON);
	} break;
case 39:
# line 640 "pars.yacc"
{
	    char buf[MAXPATHLEN];
	    strcpy(buf, (char *) yypvt[-0].pset);
	    expand_tilde(buf); 
	    if (chdir(buf) >= 0) {
		strcpy(workingdir, buf);
	    	if (inwin) {
		    set_title(workingdir);
	        }
	    }
	    free((char *) yypvt[-0].pset);
	} break;
case 40:
# line 652 "pars.yacc"
{
	    if (inwin) {
		set_left_footer(yypvt[-0].pset);
	    }
	    else {
		printf("%s\n", yypvt[-0].pset);
	    }
	    free((char *) yypvt[-0].pset);
	} break;
case 41:
# line 661 "pars.yacc"
{
	    update_stuff_status();
	} break;
case 42:
# line 664 "pars.yacc"
{
	    setbgcolor((int) yypvt[-0].val);
	} break;
case 43:
# line 667 "pars.yacc"
{
	    xlibsetcmap((int) yypvt[-6].val, (int) yypvt[-4].val, (int) yypvt[-2].val, (int) yypvt[-0].val);
	} break;
case 44:
# line 670 "pars.yacc"
{
	    exit(0);
	} break;
case 45:
# line 674 "pars.yacc"
{
            set_pagelayout(yypvt[-0].pset);
        } break;
case 46:
# line 678 "pars.yacc"
{
            set_toolbars(yypvt[-1].pset, yypvt[-0].pset == ON);
        } break;
case 47:
# line 682 "pars.yacc"
{
            set_toolbars(yypvt[-1].pset, yypvt[-0].pset == ON);
        } break;
case 48:
# line 686 "pars.yacc"
{
            set_toolbars(yypvt[-1].pset, yypvt[-0].pset == ON);
        } break;
case 49:
# line 690 "pars.yacc"
{
	    if (inwin) {
		my_draw2((double) yypvt[-2].val, (double) yypvt[-0].val);
		flush_pending();
	    }
	} break;
case 50:
# line 696 "pars.yacc"
{
	    if (inwin) {
		my_move2((double) yypvt[-2].val, (double) yypvt[-0].val);
	    }
	} break;
case 51:
# line 701 "pars.yacc"
{
	    if (inwin) {
		double x = (double) yypvt[-4].val;
		double y = (double) yypvt[-2].val;
		drawpolysym(&x, &y, 1, (int) yypvt[-0].val, 0, 0, 1.0);
		flush_pending();
	    }
	} break;
case 52:
# line 709 "pars.yacc"
{
	    if (inwin) {
		setcolor((int) yypvt[-0].val);
	    }
	} break;
case 53:
# line 714 "pars.yacc"
{
	    if (inwin) {
		setlinewidth((int) yypvt[-0].val);
	    }
	} break;
case 54:
# line 719 "pars.yacc"
{
	    if (inwin) {
		setlinestyle((int) yypvt[-0].val);
	    }
	} break;
case 55:
# line 724 "pars.yacc"
{
	} break;
case 56:
# line 728 "pars.yacc"
{
	    switch (yypvt[-0].pset) {
	    case UP:
		gwindup_proc();
		break;
	    case DOWN:
		gwinddown_proc();
		break;
	    case RIGHT:
		gwindright_proc();
		break;
	    case LEFT:
		gwindleft_proc();
		break;
	    case IN:
		gwindshrink_proc();
		break;
	    case OUT:
		gwindexpand_proc();
		break;
	    }
	} break;
case 57:
# line 750 "pars.yacc"
{
	    scroll_proc((int) yypvt[-0].val);
	} break;
case 58:
# line 753 "pars.yacc"
{
	    scrollinout_proc((int) yypvt[-0].val);
	} break;
case 59:
# line 756 "pars.yacc"
{
	    scrolling_islinked = yypvt[-0].pset == ON;
	} break;
case 60:
# line 759 "pars.yacc"
{
	    my_doublebuffer(yypvt[-0].pset == TRUEP);
	} break;
case 61:
# line 762 "pars.yacc"
{
	    my_frontbuffer(yypvt[-0].pset == TRUEP);
	} break;
case 62:
# line 765 "pars.yacc"
{
	    my_backbuffer(yypvt[-0].pset == TRUEP);
	} break;
case 63:
# line 768 "pars.yacc"
{
	    my_swapbuffer();
	} break;
case 64:
# line 771 "pars.yacc"
{
	    sleep((int) yypvt[-0].val);
	} break;
case 65:
# line 774 "pars.yacc"
{	/* TODO add delay function */
	} break;
case 66:
# line 776 "pars.yacc"
{		/* TODO add abort flag and function */
	} break;
case 67:
# line 779 "pars.yacc"
{
	    gotparams = TRUE;
	    strcpy(paramfile, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 68:
# line 785 "pars.yacc"
{
	    if (!fexists((char *) yypvt[-0].pset)) {
		FILE *pp = fopen((char *) yypvt[-0].pset, "w");
		if (pp != NULL) {
		    putparms(cg, pp, 0);
		    fclose(pp);
		} else {
		    errwin("Unable to write parameter file");
		}
	    }
	    free((char *) yypvt[-0].pset);
	} break;
case 69:
# line 797 "pars.yacc"
{
	    cg = (int) yypvt[-0].pset;
	    g[cg].parmsread = TRUE;
	    change_gno = cg;
	} break;
case 70:
# line 802 "pars.yacc"
{
	    curset = (int) yypvt[-0].pset;
	} break;
case 71:
# line 807 "pars.yacc"
{
	    set_hotlink(cg, yypvt[-3].pset, 1, (char *) yypvt[-0].pset, yypvt[-1].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 72:
# line 811 "pars.yacc"
{
	    set_hotlink(yypvt[-5].pset, yypvt[-3].pset, 1, (char *) yypvt[-0].pset, yypvt[-1].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 73:
# line 815 "pars.yacc"
{
	    set_hotlink(cg, yypvt[-2].pset, yypvt[-0].pset == ON, NULL, 0);
	} break;
case 74:
# line 818 "pars.yacc"
{
	    set_hotlink(yypvt[-4].pset, yypvt[-2].pset, yypvt[-0].pset == ON, NULL, 0);
	} break;
case 75:
# line 821 "pars.yacc"
{
	    do_activateset(cg, yypvt[-1].pset, (int) yypvt[-0].val);
	} break;
case 76:
# line 824 "pars.yacc"
{
	    do_activateset(yypvt[-3].pset, yypvt[-1].pset, (int) yypvt[-0].val);
	} break;
case 77:
# line 827 "pars.yacc"
{
	    setlength(cg, yypvt[-2].pset, (int) yypvt[-0].val);
	    updatesetminmax(cg, yypvt[-2].pset);
	    update_set_status(cg, yypvt[-2].pset);
	} break;
case 78:
# line 832 "pars.yacc"
{
	    setlength(yypvt[-4].pset, yypvt[-2].pset, (int) yypvt[-0].val);
	    updatesetminmax(yypvt[-4].pset, yypvt[-2].pset);
	    update_set_status(yypvt[-4].pset, yypvt[-2].pset);
	} break;
case 79:
# line 837 "pars.yacc"
{
	    add_point(cg, yypvt[-4].pset, yypvt[-2].val, yypvt[-0].val, 0.0, 0.0, XY);
	} break;
case 80:
# line 840 "pars.yacc"
{
	    add_point(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].val, yypvt[-0].val, 0.0, 0.0, XY);
	} break;
case 81:
# line 844 "pars.yacc"
{
	    int start = (int) yypvt[-2].val - 1;
	    int stop = (int) yypvt[-0].val - 1;
	    int dist = stop - start + 1;
	    if (dist > 0 && start >= 0) {
	        droppoints(cg, yypvt[-4].pset, start, stop, dist);
	    }
	} break;
case 82:
# line 852 "pars.yacc"
{
	    int start = (int) yypvt[-2].val - 1;
	    int stop = (int) yypvt[-0].val - 1;
	    int dist = stop - start + 1;
	    if (dist > 0 && start >= 0) {
	        droppoints(yypvt[-6].pset, yypvt[-4].pset, start, stop, dist);
	    }
	} break;
case 83:
# line 860 "pars.yacc"
{
	    if (isactive_set(cg, yypvt[-2].pset)) {
	        sortset(cg, yypvt[-2].pset, yypvt[-1].pset, yypvt[-0].pset == ASCENDING ? 0 : 1);
	    } else {
		errwin("Set not active!");
	    }
	} break;
case 84:
# line 867 "pars.yacc"
{
	    do_copyset(cg, yypvt[-2].pset, cg, yypvt[-0].pset);
	} break;
case 85:
# line 870 "pars.yacc"
{
	    do_copyset(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].pset, yypvt[-0].pset);
	} break;
case 86:
# line 873 "pars.yacc"
{
	    do_moveset(cg, yypvt[-2].pset, cg, yypvt[-0].pset);
	} break;
case 87:
# line 876 "pars.yacc"
{
	    do_moveset(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].pset, yypvt[-0].pset);
	} break;
case 88:
# line 880 "pars.yacc"
{
	    killset(cg, yypvt[-0].pset);
	} break;
case 89:
# line 884 "pars.yacc"
{
	    int i;
	    for (i = 0; i < g[cg].maxplot; i++) {
		killset(cg, i);
	    }
	} break;
case 90:
# line 890 "pars.yacc"
{ softkillset(cg, yypvt[-1].pset); } break;
case 91:
# line 892 "pars.yacc"
{
	    int i;
	    for (i = 0; i < g[cg].maxplot; i++) {
		softkillset(cg, i);
	    }
	} break;
case 92:
# line 898 "pars.yacc"
{ kill_graph(yypvt[-0].pset); } break;
case 93:
# line 899 "pars.yacc"
{ kill_graph(maxgraph); } break;
case 94:
# line 900 "pars.yacc"
{ wipeout(0); } break;
case 95:
# line 901 "pars.yacc"
{ arrange_graphs((int) yypvt[-2].val, (int) yypvt[-0].val); } break;
case 96:
# line 903 "pars.yacc"
{
	    int i, ilen = (int) yypvt[-4].val;
	    if (ilen < 0) {
		yyerror("Length of array < 0");
		return 1;
	    } else if (ilen > maxarr) {
		maxarr = ilen;
		init_scratch_arrays(ilen);
	    }
	    for (i = 0; i < ilen; i++) {
		yypvt[-5].ptr[i] = yypvt[-2].val + yypvt[-0].val * i;
	    }
	} break;
case 97:
# line 917 "pars.yacc"
{
	    int setno = yypvt[-3].pset, ideg = (int) yypvt[-1].val;
	    do_regress(setno, ideg, 0, -1, 0);
	} break;
case 98:
# line 922 "pars.yacc"
{
	    do_running_command(yypvt[-5].pset, yypvt[-3].pset, (int) yypvt[-1].val);
	} break;
case 99:
# line 926 "pars.yacc"
{
	    do_fourier_command(yypvt[-5].pset, yypvt[-3].pset, (int) yypvt[-1].val);
	} break;
case 100:
# line 930 "pars.yacc"
{
	    do_spline(yypvt[-7].pset, yypvt[-5].val, yypvt[-3].val, (int) yypvt[-1].val);
	} break;
case 101:
# line 934 "pars.yacc"
{
	    do_histo_command(yypvt[-7].pset, -1, -1, yypvt[-5].val, yypvt[-3].val, (int) yypvt[-1].val);
	} break;
case 102:
# line 938 "pars.yacc"
{
	    do_differ(yypvt[-3].pset, (int) yypvt[-1].val);
	} break;
case 103:
# line 942 "pars.yacc"
{
	    do_int(yypvt[-1].pset, 0);
	} break;
case 104:
# line 946 "pars.yacc"
{
	    if (activeset(cg)) {
		defaultgraph(cg);
		default_axis(cg, g[cg].auto_type, X_AXIS);
		default_axis(cg, g[cg].auto_type, ZX_AXIS);
		default_axis(cg, g[cg].auto_type, Y_AXIS);
		default_axis(cg, g[cg].auto_type, ZY_AXIS);
		update_world(cg);
		drawgraph();
	    } else {
		errwin("No active sets!");
	    }
	} break;
case 105:
# line 960 "pars.yacc"
{
	    if (activeset(cg)) {
		defaultx(cg, -1);
		default_axis(cg, g[cg].auto_type, X_AXIS);
		default_axis(cg, g[cg].auto_type, ZX_AXIS);
		update_world(cg);
		drawgraph();
	    } else {
		errwin("No active sets!");
	    }
	} break;
case 106:
# line 972 "pars.yacc"
{
	    if (activeset(cg)) {
		defaulty(cg, -1);
		default_axis(cg, g[cg].auto_type, Y_AXIS);
		default_axis(cg, g[cg].auto_type, ZY_AXIS);
		update_world(cg);
		drawgraph();
	    } else {
		errwin("No active sets!");
	    }
	} break;
case 107:
# line 984 "pars.yacc"
{
	    if (isactive_set(cg, yypvt[-0].pset)) {
		defaultsetgraph(cg, yypvt[-0].pset);
		default_axis(cg, g[cg].auto_type, X_AXIS);
		default_axis(cg, g[cg].auto_type, ZX_AXIS);
		default_axis(cg, g[cg].auto_type, Y_AXIS);
		default_axis(cg, g[cg].auto_type, ZY_AXIS);
		update_world(cg);
		drawgraph();
	    } else {
		errwin("Set not active");
	    }
	} break;
case 108:
# line 998 "pars.yacc"
{
	    extern int go_locateflag;
	    go_locateflag = (yypvt[-0].pset == ON);
	} break;
case 109:
# line 1003 "pars.yacc"
{
	    draw_focus(cg);
	    cg = (int) yypvt[-0].pset;
	    defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, 
			islogx(cg), islogy(cg));
	    viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
	    draw_focus(cg);
	    update_all(cg);
	} break;
case 110:
# line 1012 "pars.yacc"
{
	    draw_focus_flag = yypvt[-0].pset;
	} break;
case 111:
# line 1015 "pars.yacc"
{
	    focus_policy = yypvt[-0].pset;
	} break;
case 112:
# line 1018 "pars.yacc"
{
	    focus_policy = yypvt[-0].pset;
	} break;
case 113:
# line 1021 "pars.yacc"
{
	    focus_policy = yypvt[-0].pset;
	} break;
case 114:
# line 1024 "pars.yacc"
{
	    cursource = yypvt[-0].pset;
	} break;
case 115:
# line 1027 "pars.yacc"
{
	    curtype = yypvt[-0].pset;
	    change_type = curtype;
	} break;
case 116:
# line 1032 "pars.yacc"
{
	    readxformat = yypvt[-0].pset;
	} break;
case 117:
# line 1036 "pars.yacc"
{
	    gotread = TRUE;
	    readtype = curtype;
	    readsrc = cursource;
	    strcpy(readfile, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 118:
# line 1044 "pars.yacc"
{
	    gotbatch = TRUE;
	    strcpy(batchfile, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 119:
# line 1050 "pars.yacc"
{
	    getdata(cg, (char *) yypvt[-0].pset, DISK, BLOCK);
	    free((char *) yypvt[-0].pset);
	} break;
case 120:
# line 1055 "pars.yacc"
{
	    getdata(cg, (char *) yypvt[-0].pset, yypvt[-1].pset, BLOCK);
	    free((char *) yypvt[-0].pset);
	} break;
case 121:
# line 1060 "pars.yacc"
{
	    create_set_fromblock(cg, yypvt[-1].pset, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 122:
# line 1065 "pars.yacc"
{
	    gotread = TRUE;
	    readtype = yypvt[-1].pset;
	    readsrc = cursource;
	    strcpy(readfile, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 123:
# line 1073 "pars.yacc"
{
	    gotread = TRUE;
	    strcpy(readfile, (char *) yypvt[-0].pset);
	    readtype = yypvt[-2].pset;
	    readsrc = yypvt[-1].pset;
	    free((char *) yypvt[-0].pset);
	} break;
case 124:
# line 1081 "pars.yacc"
{
	    read_image((char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 125:
# line 1086 "pars.yacc"
{
	    write_image((char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 126:
# line 1091 "pars.yacc"
{
	    imagex = (int) yypvt[-2].val;
	    imagey = (int) yypvt[-0].val;
	} break;
case 127:
# line 1096 "pars.yacc"
{
	    outputset(cg, yypvt[-0].pset, (char *) NULL, (char *) NULL);
	} break;
case 128:
# line 1100 "pars.yacc"
{
	    outputset(cg, yypvt[-2].pset, (char *) NULL, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 129:
# line 1105 "pars.yacc"
{
	    outputset(cg, yypvt[-2].pset, (char *) yypvt[-0].pset, (char *) NULL);
	    free((char *) yypvt[-0].pset);
	} break;
case 130:
# line 1110 "pars.yacc"
{
	    outputset(cg, yypvt[-4].pset, (char *) yypvt[-2].pset, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-2].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 131:
# line 1116 "pars.yacc"
{
            extern char sformat[];
            do_writesets(maxgraph, -1, 1, (char *) yypvt[-0].pset, sformat);
            free((char *) yypvt[-0].pset);
        } break;
case 132:
# line 1121 "pars.yacc"
{
	    push_world();
	} break;
case 133:
# line 1124 "pars.yacc"
{
	    pop_world();
	} break;
case 134:
# line 1127 "pars.yacc"
{
	    cycle_world_stack();
	} break;
case 135:
# line 1130 "pars.yacc"
{
	    if ((int) yypvt[-0].val > 0)
		show_world_stack((int) yypvt[-0].val - 1);
	} break;
case 136:
# line 1135 "pars.yacc"
{
	    add_world(cg, yypvt[-14].val, yypvt[-12].val, yypvt[-10].val, yypvt[-8].val, yypvt[-6].val, yypvt[-4].val, yypvt[-2].val, yypvt[-0].val);
	} break;
case 137:
# line 1138 "pars.yacc"
{
	    clear_world_stack();
	} break;
case 138:
# line 1141 "pars.yacc"
{
	    do_clear_boxes();
	} break;
case 139:
# line 1144 "pars.yacc"
{
	    curbox = next_box();
	} break;
case 140:
# line 1147 "pars.yacc"
{
	    curbox = (int) yypvt[-0].val;
	} break;
case 141:
# line 1150 "pars.yacc"
{
	    boxes[curbox].active = yypvt[-0].pset;
	} break;
case 142:
# line 1153 "pars.yacc"
{
	    boxes[curbox].gno = yypvt[-0].pset;
	} break;
case 143:
# line 1157 "pars.yacc"
{
	    if (curbox >= 0 && curbox < maxboxes) {
		boxes[curbox].x1 = yypvt[-6].val;
		boxes[curbox].y1 = yypvt[-4].val;
		boxes[curbox].x2 = yypvt[-2].val;
		boxes[curbox].y2 = yypvt[-0].val;
	    }
	} break;
case 144:
# line 1165 "pars.yacc"
{
	    box_loctype = yypvt[-0].pset;
	} break;
case 145:
# line 1168 "pars.yacc"
{
	    box_lines = checkon(LINESTYLE, box_lines, (int) yypvt[-0].val);
	} break;
case 146:
# line 1171 "pars.yacc"
{
	    box_linew = checkon(LINEWIDTH, box_linew, (int) yypvt[-0].val);
	} break;
case 147:
# line 1174 "pars.yacc"
{
	    box_color = checkon(COLOR, box_color, (int) yypvt[-0].val);
	} break;
case 148:
# line 1177 "pars.yacc"
{
	    box_fill = yypvt[-0].pset;
	} break;
case 149:
# line 1180 "pars.yacc"
{
	    box_fillcolor = checkon(COLOR, box_fillcolor, (int) yypvt[-0].val);
	} break;
case 150:
# line 1183 "pars.yacc"
{
	    box_fillpat = checkon(PATTERN, box_fillpat, (int) yypvt[-0].val);
	} break;
case 151:
# line 1187 "pars.yacc"
{
	    if (curbox >= 0 && curbox < maxboxes) {
		boxes[curbox].lines = box_lines;
		boxes[curbox].linew = box_linew;
		boxes[curbox].color = box_color;
		boxes[curbox].fill = box_fill;
		boxes[curbox].fillcolor = box_fillcolor;
		boxes[curbox].fillpattern = box_fillpat;
		boxes[curbox].loctype = box_loctype;
	    }
	} break;
case 152:
# line 1198 "pars.yacc"
{
	    do_clear_ellipses();
	} break;
case 153:
# line 1201 "pars.yacc"
{
		curellipse = next_ellipse();
	} break;
case 154:
# line 1204 "pars.yacc"
{
	    curellipse = (int) yypvt[-0].val;
	} break;
case 155:
# line 1207 "pars.yacc"
{
	    ellip[curellipse].active = yypvt[-0].pset;
	} break;
case 156:
# line 1210 "pars.yacc"
{
	    ellip[curellipse].gno = yypvt[-0].pset;
	} break;
case 157:
# line 1214 "pars.yacc"
{
	    if (curellipse >= 0 && curellipse < maxellipses) {
		ellip[curellipse].x1 = yypvt[-6].val;
		ellip[curellipse].y1 = yypvt[-4].val;
		ellip[curellipse].x2 = yypvt[-2].val;
		ellip[curellipse].y2 = yypvt[-0].val;
	    }
	} break;
case 158:
# line 1222 "pars.yacc"
{
	    ellipse_loctype = yypvt[-0].pset;
	} break;
case 159:
# line 1225 "pars.yacc"
{
	    ellipse_lines = checkon(LINESTYLE, ellipse_lines, (int) yypvt[-0].val);
	} break;
case 160:
# line 1228 "pars.yacc"
{
	    ellipse_linew = checkon(LINEWIDTH, ellipse_linew, (int) yypvt[-0].val);
	} break;
case 161:
# line 1231 "pars.yacc"
{
	    ellipse_color = checkon(COLOR, ellipse_color, (int) yypvt[-0].val);
	} break;
case 162:
# line 1234 "pars.yacc"
{
	    ellipse_fill = yypvt[-0].pset;
	} break;
case 163:
# line 1237 "pars.yacc"
{
	    ellipse_fillcolor = checkon(COLOR, ellipse_fillcolor, (int) yypvt[-0].val);
	} break;
case 164:
# line 1240 "pars.yacc"
{
	    ellipse_fillpat = checkon(PATTERN, ellipse_fillpat, (int) yypvt[-0].val);
	} break;
case 165:
# line 1244 "pars.yacc"
{
	    if (curellipse >= 0 && curellipse < maxellipses) {
		ellip[curellipse].lines = ellipse_lines;
		ellip[curellipse].linew = ellipse_linew;
		ellip[curellipse].color = ellipse_color;
		ellip[curellipse].fill = ellipse_fill;
		ellip[curellipse].fillcolor = ellipse_fillcolor;
		ellip[curellipse].fillpattern = ellipse_fillpat;
		ellip[curellipse].loctype = ellipse_loctype;
	    }
	} break;
case 166:
# line 1255 "pars.yacc"
{
	    curline = next_line();
	} break;
case 167:
# line 1258 "pars.yacc"
{
	    curline = (int) yypvt[-0].val;
	} break;
case 168:
# line 1261 "pars.yacc"
{
	    do_clear_lines();
	} break;
case 169:
# line 1264 "pars.yacc"
{
	    lines[curline].active = yypvt[-0].pset;
	} break;
case 170:
# line 1267 "pars.yacc"
{
	    lines[curline].gno = yypvt[-0].pset;
	} break;
case 171:
# line 1271 "pars.yacc"
{
	    lines[curline].x1 = yypvt[-6].val;
	    lines[curline].y1 = yypvt[-4].val;
	    lines[curline].x2 = yypvt[-2].val;
	    lines[curline].y2 = yypvt[-0].val;
	} break;
case 172:
# line 1277 "pars.yacc"
{
	    line_loctype = yypvt[-0].pset;
	} break;
case 173:
# line 1280 "pars.yacc"
{
	    line_linew = checkon(LINEWIDTH, line_linew, (int) yypvt[-0].val);
	} break;
case 174:
# line 1283 "pars.yacc"
{
	    line_lines = checkon(LINESTYLE, line_lines, (int) yypvt[-0].val);
	} break;
case 175:
# line 1286 "pars.yacc"
{
	    line_color = checkon(COLOR, line_color, (int) yypvt[-0].val);
	} break;
case 176:
# line 1289 "pars.yacc"
{
	    line_arrow = checkon(ARROW, line_arrow, (int) yypvt[-0].val);
	} break;
case 177:
# line 1292 "pars.yacc"
{
	    line_asize = yypvt[-0].val;
	} break;
case 178:
# line 1295 "pars.yacc"
{
	    line_atype = (int) yypvt[-0].val;
	} break;
case 179:
# line 1299 "pars.yacc"
{
	    if (curline >= 0 && curline < maxlines) {
		lines[curline].lines = line_lines;
		lines[curline].linew = line_linew;
		lines[curline].color = line_color;
		lines[curline].arrow = line_arrow;
		lines[curline].asize = line_asize;
		lines[curline].atype = line_atype;
		lines[curline].loctype = line_loctype;
	    }
	} break;
case 180:
# line 1310 "pars.yacc"
{
	    do_clear_text();
	} break;
case 181:
# line 1313 "pars.yacc"
{ curstring = next_string(); } break;
case 182:
# line 1314 "pars.yacc"
{ curstring = (int) yypvt[-0].val; } break;
case 183:
# line 1315 "pars.yacc"
{ pstr[curstring].active = yypvt[-0].pset; } break;
case 184:
# line 1316 "pars.yacc"
{ pstr[curstring].gno = yypvt[-0].pset; } break;
case 185:
# line 1318 "pars.yacc"
{
	    pstr[curstring].x = yypvt[-2].val;
	    pstr[curstring].y = yypvt[-0].val;
	} break;
case 186:
# line 1322 "pars.yacc"
{ string_loctype = yypvt[-0].pset; } break;
case 187:
# line 1323 "pars.yacc"
{ string_linew = checkon(LINEWIDTH, string_linew, (int) yypvt[-0].val); } break;
case 188:
# line 1324 "pars.yacc"
{ string_color = checkon(COLOR, string_color, (int) yypvt[-0].val); } break;
case 189:
# line 1325 "pars.yacc"
{ string_rot = (int) yypvt[-0].val; } break;
case 190:
# line 1326 "pars.yacc"
{ string_font = checkon(FONTP, string_font, (int) yypvt[-0].val); } break;
case 191:
# line 1327 "pars.yacc"
{ string_just = checkon(JUST, string_just, (int) yypvt[-0].val); } break;
case 192:
# line 1328 "pars.yacc"
{ string_size = yypvt[-0].val; } break;
case 193:
# line 1330 "pars.yacc"
{
	    set_plotstr_string(&pstr[curstring], (char *) yypvt[-0].pset);
	    pstr[curstring].linew = string_linew;
	    pstr[curstring].color = string_color;
	    pstr[curstring].font = string_font;
	    pstr[curstring].just = string_just;
	    pstr[curstring].loctype = string_loctype;
	    pstr[curstring].rot = string_rot;
	    pstr[curstring].charsize = string_size;
	    free((char *) yypvt[-0].pset);
	} break;
case 194:
# line 1341 "pars.yacc"
{ timestamp.active = yypvt[-0].pset; } break;
case 195:
# line 1342 "pars.yacc"
{ timestamp.font = checkon(FONTP, timestamp.font, (int) yypvt[-0].val); } break;
case 196:
# line 1343 "pars.yacc"
{ timestamp.charsize = yypvt[-0].val; } break;
case 197:
# line 1344 "pars.yacc"
{ timestamp.color = checkon(COLOR, timestamp.color, (int) yypvt[-0].val); } break;
case 198:
# line 1345 "pars.yacc"
{ timestamp.linew = checkon(LINEWIDTH, timestamp.linew, (int) yypvt[-1].pset); } break;
case 199:
# line 1347 "pars.yacc"
{
	    timestamp.x = yypvt[-2].val;
	    timestamp.y = yypvt[-0].val;
	} break;
case 200:
# line 1351 "pars.yacc"
{
	    grdefaults.lines = (int) yypvt[-0].val;
	} break;
case 201:
# line 1354 "pars.yacc"
{
	    grdefaults.linew = (int) yypvt[-0].val;
	} break;
case 202:
# line 1357 "pars.yacc"
{
	    grdefaults.color = (int) yypvt[-0].val;
	} break;
case 203:
# line 1360 "pars.yacc"
{
	    grdefaults.charsize = yypvt[-0].val;
	} break;
case 204:
# line 1363 "pars.yacc"
{
	    grdefaults.font = (int) yypvt[-0].val;
	} break;
case 205:
# line 1366 "pars.yacc"
{
	    grdefaults.fontsrc = (int) yypvt[-0].val;
	} break;
case 206:
# line 1369 "pars.yacc"
{
	    grdefaults.symsize = yypvt[-0].val;
	} break;
case 207:
# line 1373 "pars.yacc"
{
	    g[cg].w.xg1 = yypvt[-6].val;
	    g[cg].w.yg1 = yypvt[-4].val;
	    g[cg].w.xg2 = yypvt[-2].val;
	    g[cg].w.yg2 = yypvt[-0].val;
	} break;
case 208:
# line 1379 "pars.yacc"
{
	    g[cg].w.xg1 = yypvt[-0].val;
	} break;
case 209:
# line 1382 "pars.yacc"
{
	    g[cg].w.xg2 = yypvt[-0].val;
	} break;
case 210:
# line 1385 "pars.yacc"
{
	    g[cg].w.yg1 = yypvt[-0].val;
	} break;
case 211:
# line 1388 "pars.yacc"
{
	    g[cg].w.yg2 = yypvt[-0].val;
	} break;
case 212:
# line 1392 "pars.yacc"
{
            g[cg].rt.xg1 = yypvt[-2].val;
            g[cg].rt.yg1 = yypvt[-0].val;
        } break;
case 213:
# line 1397 "pars.yacc"
{
	    g[cg].v.xv1 = yypvt[-6].val;
	    g[cg].v.yv1 = yypvt[-4].val;
	    g[cg].v.xv2 = yypvt[-2].val;
	    g[cg].v.yv2 = yypvt[-0].val;
	} break;
case 214:
# line 1403 "pars.yacc"
{
	    g[cg].v.xv1 = yypvt[-0].val;
	} break;
case 215:
# line 1406 "pars.yacc"
{
	    g[cg].v.xv2 = yypvt[-0].val;
	} break;
case 216:
# line 1409 "pars.yacc"
{
	    g[cg].v.yv1 = yypvt[-0].val;
	} break;
case 217:
# line 1412 "pars.yacc"
{
	    g[cg].v.yv2 = yypvt[-0].val;
	} break;
case 218:
# line 1415 "pars.yacc"
{
	    set_plotstr_string(&g[cg].labs.title, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 219:
# line 1419 "pars.yacc"
{
	    g[cg].labs.title.font = checkon(FONTP, g[cg].labs.title.font, (int) yypvt[-0].val);
	} break;
case 220:
# line 1422 "pars.yacc"
{
	    g[cg].labs.title.charsize = yypvt[-0].val;
	} break;
case 221:
# line 1425 "pars.yacc"
{
	    g[cg].labs.title.color = checkon(COLOR, g[cg].labs.title.color, (int) yypvt[-0].val);
	} break;
case 222:
# line 1429 "pars.yacc"
{
	    g[cg].labs.title.linew = checkon(LINEWIDTH, g[cg].labs.title.linew, (int) yypvt[-0].val);
	} break;
case 223:
# line 1432 "pars.yacc"
{
	    set_plotstr_string(&g[cg].labs.stitle, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 224:
# line 1437 "pars.yacc"
{
	    g[cg].labs.stitle.font = checkon(FONTP, g[cg].labs.stitle.font, (int) yypvt[-0].val);
	} break;
case 225:
# line 1440 "pars.yacc"
{
	    g[cg].labs.stitle.charsize = yypvt[-0].val;
	} break;
case 226:
# line 1444 "pars.yacc"
{
	    g[cg].labs.stitle.color = checkon(COLOR, g[cg].labs.stitle.color, (int) yypvt[-0].val);
	} break;
case 227:
# line 1448 "pars.yacc"
{
	    g[cg].labs.stitle.linew = checkon(LINEWIDTH, g[cg].labs.stitle.color, (int) yypvt[-0].val);
	} break;
case 228:
# line 1451 "pars.yacc"
{
	    realloc_plots((int) yypvt[-0].val);
	} break;
case 229:
# line 1454 "pars.yacc"
{
	    g[cg].l.active = yypvt[-0].pset;
	} break;
case 230:
# line 1457 "pars.yacc"
{
	    g[cg].l.loctype = yypvt[-0].pset;
	} break;
case 231:
# line 1460 "pars.yacc"
{
	    g[cg].l.layout = (int) yypvt[-0].val;
	} break;
case 232:
# line 1463 "pars.yacc"
{
	    g[cg].l.vgap = (int) yypvt[-0].val;
	} break;
case 233:
# line 1466 "pars.yacc"
{
	    g[cg].l.hgap = (int) yypvt[-0].val;
	} break;
case 234:
# line 1469 "pars.yacc"
{
	    g[cg].l.len = (int) yypvt[-0].val;
	} break;
case 235:
# line 1472 "pars.yacc"
{
	    g[cg].l.box = yypvt[-0].pset;
	} break;
case 236:
# line 1475 "pars.yacc"
{
	    g[cg].l.boxfill = yypvt[-0].pset;
	} break;
case 237:
# line 1478 "pars.yacc"
{
	    g[cg].l.boxfillusing = yypvt[-0].pset;
	} break;
case 238:
# line 1482 "pars.yacc"
{
	    if (yypvt[-1].pset == COLOR) {
		g[cg].l.boxfillcolor = (int) yypvt[-0].val;
	    } else {
		g[cg].l.boxfillpat = (int) yypvt[-0].val;
	    }
	} break;
case 239:
# line 1489 "pars.yacc"
{
	    g[cg].l.boxlcolor = checkon(COLOR, g[cg].l.boxlcolor, (int) yypvt[-0].val);
	} break;
case 240:
# line 1492 "pars.yacc"
{
	    g[cg].l.boxlines = checkon(LINESTYLE, g[cg].l.boxlines, (int) yypvt[-0].val);
	} break;
case 241:
# line 1495 "pars.yacc"
{
	    g[cg].l.boxlinew = checkon(LINEWIDTH, g[cg].l.boxlinew, (int) yypvt[-0].val);
	} break;
case 242:
# line 1498 "pars.yacc"
{
	    g[cg].l.legx = yypvt[-2].val;
	    g[cg].l.legy = yypvt[-0].val;
	} break;
case 243:
# line 1502 "pars.yacc"
{
	    g[cg].l.legx = yypvt[-0].val;
	} break;
case 244:
# line 1505 "pars.yacc"
{
	    g[cg].l.legy = yypvt[-0].val;
	} break;
case 245:
# line 1508 "pars.yacc"
{
	    g[cg].l.charsize = yypvt[-0].val;
	} break;
case 246:
# line 1511 "pars.yacc"
{
	    g[cg].l.font = checkon(FONTP, g[cg].l.font, (int) yypvt[-0].val);
	} break;
case 247:
# line 1514 "pars.yacc"
{
	    g[cg].l.lines = checkon(LINESTYLE, g[cg].l.lines, (int) yypvt[-0].val);
	} break;
case 248:
# line 1517 "pars.yacc"
{
	    g[cg].l.linew = checkon(LINEWIDTH, g[cg].l.linew, (int) yypvt[-0].val);
	} break;
case 249:
# line 1520 "pars.yacc"
{
	    g[cg].l.color = checkon(COLOR, g[cg].l.color, (int) yypvt[-0].val);
	} break;
case 250:
# line 1523 "pars.yacc"
{
	    strcpy(g[cg].p[(int) yypvt[-1].val].lstr, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 251:
# line 1527 "pars.yacc"
{
	    g[cg].f.active = yypvt[-0].pset;
	} break;
case 252:
# line 1530 "pars.yacc"
{
	    g[cg].f.type = (int) yypvt[-0].val;
	} break;
case 253:
# line 1533 "pars.yacc"
{
	    g[cg].f.lines = checkon(LINESTYLE, g[cg].f.lines, (int) yypvt[-0].val);
	} break;
case 254:
# line 1536 "pars.yacc"
{
	    g[cg].f.linew = checkon(LINEWIDTH, g[cg].f.linew, (int) yypvt[-0].val);
	} break;
case 255:
# line 1539 "pars.yacc"
{
	    g[cg].f.color = checkon(COLOR, g[cg].f.color, (int) yypvt[-0].val);
	} break;
case 256:
# line 1542 "pars.yacc"
{ g[cg].f.fillbg = yypvt[-0].pset; } break;
case 257:
# line 1543 "pars.yacc"
{ g[cg].f.bgcolor = (int) yypvt[-0].val; } break;
case 258:
# line 1544 "pars.yacc"
{ g[yypvt[-1].pset].active = yypvt[-0].pset; } break;
case 259:
# line 1545 "pars.yacc"
{ g[yypvt[-2].pset].label = yypvt[-0].pset; } break;
case 260:
# line 1546 "pars.yacc"
{ g[yypvt[-3].pset].auto_type = yypvt[-0].pset; } break;
case 261:
# line 1547 "pars.yacc"
{ g[yypvt[-3].pset].auto_type = yypvt[-0].pset; } break;
case 262:
# line 1548 "pars.yacc"
{ g[yypvt[-2].pset].parmsread = (yypvt[-0].pset == FALSEP); } break;
case 263:
# line 1549 "pars.yacc"
{ g[yypvt[-2].pset].hidden = (yypvt[-0].pset == TRUEP); } break;
case 264:
# line 1550 "pars.yacc"
{ g[yypvt[-2].pset].type = yypvt[-0].pset; } break;
case 265:
# line 1551 "pars.yacc"
{ g[yypvt[-3].pset].barwid = yypvt[-0].val; } break;
case 266:
# line 1552 "pars.yacc"
{ g[yypvt[-3].pset].sbarwid = yypvt[-0].val; } break;
case 267:
# line 1553 "pars.yacc"
{ g[yypvt[-2].pset].pointset = (yypvt[-0].pset == ON); } break;
case 268:
# line 1555 "pars.yacc"
{
	    g[yypvt[-4].pset].fx = yypvt[-1].pset;
	    g[yypvt[-4].pset].fy = yypvt[-0].pset;
	} break;
case 269:
# line 1560 "pars.yacc"
{
	    g[yypvt[-5].pset].px = yypvt[-2].val;
	    g[yypvt[-5].pset].py = yypvt[-0].val;
	} break;
case 270:
# line 1565 "pars.yacc"
{
	    g[yypvt[-5].pset].dsx = yypvt[-2].val;
	    g[yypvt[-5].pset].dsy = yypvt[-0].val;
	} break;
case 271:
# line 1569 "pars.yacc"
{ g[yypvt[-3].pset].pt_type = (int) yypvt[-0].val; } break;
case 272:
# line 1570 "pars.yacc"
{ realloc_graph_plots(yypvt[-3].pset, (int) yypvt[-0].val); } break;
case 273:
# line 1574 "pars.yacc"
{ g[cg].vp.vscale = yypvt[-0].val; } break;
case 274:
# line 1575 "pars.yacc"
{ g[cg].vp.active = yypvt[-0].pset; } break;
case 275:
# line 1576 "pars.yacc"
{ g[cg].vp.linew = (int) yypvt[-0].val; } break;
case 276:
# line 1577 "pars.yacc"
{ g[cg].vp.lines = (int) yypvt[-0].val; } break;
case 277:
# line 1578 "pars.yacc"
{ g[cg].vp.color = (int) yypvt[-0].val; } break;
case 278:
# line 1579 "pars.yacc"
{ g[cg].vp.loctype = yypvt[-0].pset; } break;
case 279:
# line 1580 "pars.yacc"
{ g[cg].vp.arrowtype = (int) yypvt[-0].val; } break;
case 280:
# line 1584 "pars.yacc"
{ yyval.pset = XY; } break;
case 281:
# line 1585 "pars.yacc"
{ yyval.pset = XYARC; } break;
case 282:
# line 1586 "pars.yacc"
{ yyval.pset = XYBOX; } break;
case 283:
# line 1587 "pars.yacc"
{ yyval.pset = XYBOXPLOT; } break;
case 284:
# line 1588 "pars.yacc"
{ yyval.pset = XYHILO; } break;
case 285:
# line 1589 "pars.yacc"
{ yyval.pset = XYRT; } break;
case 286:
# line 1590 "pars.yacc"
{ yyval.pset = XYSEG; } break;
case 287:
# line 1591 "pars.yacc"
{ yyval.pset = XYSTRING; } break;
case 288:
# line 1592 "pars.yacc"
{ yyval.pset = XYDX; } break;
case 289:
# line 1593 "pars.yacc"
{ yyval.pset = XYDY; } break;
case 290:
# line 1594 "pars.yacc"
{ yyval.pset = XYDXDX; } break;
case 291:
# line 1595 "pars.yacc"
{ yyval.pset = XYDYDY; } break;
case 292:
# line 1596 "pars.yacc"
{ yyval.pset = XYDXDY; } break;
case 293:
# line 1597 "pars.yacc"
{ yyval.pset = XYX2Y2; } break;
case 294:
# line 1598 "pars.yacc"
{ yyval.pset = XYXX; } break;
case 295:
# line 1599 "pars.yacc"
{ yyval.pset = XYYY; } break;
case 296:
# line 1600 "pars.yacc"
{ yyval.pset = XYZ; } break;
case 297:
# line 1601 "pars.yacc"
{ yyval.pset = XYZW; } break;
case 298:
# line 1602 "pars.yacc"
{ yyval.pset = XYUV; } break;
case 299:
# line 1603 "pars.yacc"
{ yyval.pset = TSV; } break;
case 300:
# line 1604 "pars.yacc"
{ yyval.pset = NXY; } break;
case 301:
# line 1605 "pars.yacc"
{ yyval.pset = BIN; } break;
case 302:
# line 1606 "pars.yacc"
{ yyval.pset = POLY; } break;
case 303:
# line 1607 "pars.yacc"
{ yyval.pset = RAWSPICE; } break;
case 304:
# line 1611 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 305:
# line 1612 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 306:
# line 1613 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 307:
# line 1614 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 308:
# line 1615 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 309:
# line 1616 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 310:
# line 1617 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 311:
# line 1618 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 312:
# line 1619 "pars.yacc"
{ yyval.pset = XY;		/* not active */ } break;
case 313:
# line 1620 "pars.yacc"
{ yyval.pset = XY;		/* not active */ } break;
case 314:
# line 1621 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 315:
# line 1622 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 316:
# line 1623 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 317:
# line 1627 "pars.yacc"
{ yyval.pset = FREE; } break;
case 318:
# line 1628 "pars.yacc"
{ yyval.pset = LANDSCAPE; } break;
case 319:
# line 1629 "pars.yacc"
{ yyval.pset = PORTRAIT; } break;
case 320:
# line 1630 "pars.yacc"
{ yyval.pset = FIXED; } break;
case 328:
# line 1658 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ACTIVE, yypvt[-0].pset, 0);
	} break;
case 329:
# line 1661 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ACTIVE, yypvt[-0].pset, 0);
	} break;
case 330:
# line 1664 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, TYPE, yypvt[-0].pset, 0);
	} break;
case 331:
# line 1667 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, MISSINGP, yypvt[-0].val, 0);
	} break;
case 332:
# line 1670 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, PREC, (int) yypvt[-0].val, 0);
	} break;
case 333:
# line 1673 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, FORMAT, yypvt[-0].pset, 0);
	} break;
case 334:
# line 1676 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, TYPE, (int) yypvt[-0].val, 0);
	} break;
case 335:
# line 1679 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, FILL, (int) yypvt[-0].val, 0);
	} break;
case 336:
# line 1682 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, CENTER, (yypvt[-0].pset == TRUEP), 0);
	} break;
case 337:
# line 1685 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, SIZE, yypvt[-0].val, 0);
	} break;
case 338:
# line 1688 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, CHAR, (int) yypvt[-0].val, 0);
	} break;
case 339:
# line 1691 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, SKIP, (int) yypvt[-0].val, 0);
	} break;
case 340:
# line 1694 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, COLOR, (int) yypvt[-0].val, 0);
	} break;
case 341:
# line 1697 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, LINEWIDTH, (int) yypvt[-0].val, 0);
	} break;
case 342:
# line 1700 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SYMBOL, LINESTYLE, (int) yypvt[-0].val, 0);
	} break;
case 343:
# line 1703 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, yypvt[-1].pset, (int) yypvt[-0].val, 0);
	} break;
case 344:
# line 1706 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, FILL, TYPE, (int) yypvt[-0].val, 0);
	} break;
case 345:
# line 1709 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, FILL, WITH, yypvt[-0].pset, 0);
	} break;
case 346:
# line 1712 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, FILL, yypvt[-1].pset, (int) yypvt[-0].val, 0);
	} break;
case 347:
# line 1715 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, SKIP, (int) yypvt[-0].val, 0);
	} break;
case 348:
# line 1718 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, LENGTH, yypvt[-0].val, 0);
	} break;
case 349:
# line 1721 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, TYPE, yypvt[-0].pset, 0);
	} break;
case 350:
# line 1724 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, LINEWIDTH, (int) yypvt[-0].val, 0);
	} break;
case 351:
# line 1727 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, LINESTYLE, (int) yypvt[-0].val, 0);
	} break;
case 352:
# line 1730 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, RISER, ACTIVE, yypvt[-0].pset, 0);
	} break;
case 353:
# line 1733 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, RISER, LINEWIDTH, (int) yypvt[-0].val, 0);
	} break;
case 354:
# line 1736 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, ERRORBAR, RISER, LINESTYLE, (int) yypvt[-0].val, 0);
	} break;
case 355:
# line 1739 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, XYZ, yypvt[-2].val, yypvt[-0].val, 0);
	} break;
case 356:
# line 1742 "pars.yacc"
{
	    set_prop(whichgraph, SET, SETNUM, whichset, COMMENT, (char *) yypvt[-0].pset, 0);
	    free((char *) yypvt[-0].pset);
	} break;
case 372:
# line 1773 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-0].pset, 0.0);
	} break;
case 373:
# line 1776 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-1].pset, yypvt[-0].val);
	} break;
case 374:
# line 1779 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-1].pset, yypvt[-0].val);
	} break;
case 375:
# line 1782 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-1].pset, yypvt[-0].val);
	} break;
case 376:
# line 1785 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-1].pset, yypvt[-0].val);
	} break;
case 377:
# line 1788 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-2].pset, yypvt[-0].val);
	} break;
case 378:
# line 1791 "pars.yacc"
{
	    set_axis_prop(whichgraph, naxis, yypvt[-1].pset, yypvt[-0].pset);
	} break;
case 383:
# line 1801 "pars.yacc"
{
	    g[cg].t[naxis].active = yypvt[-0].pset;
	} break;
case 386:
# line 1813 "pars.yacc"
{
	    g[cg].t[naxis].t_flag = yypvt[-0].pset;
	    g[cg].t[naxis].t_mflag = yypvt[-0].pset;
	} break;
case 387:
# line 1817 "pars.yacc"
{
	    g[cg].t[naxis].t_flag = yypvt[-0].pset;
	} break;
case 388:
# line 1820 "pars.yacc"
{
	    g[cg].t[naxis].t_mflag = yypvt[-0].pset;
	} break;
case 389:
# line 1823 "pars.yacc"
{
	    g[cg].t[naxis].tmajor = yypvt[-0].val;
	} break;
case 390:
# line 1826 "pars.yacc"
{
	    g[cg].t[naxis].tminor = yypvt[-0].val;
	} break;
case 391:
# line 1829 "pars.yacc"
{
	    g[cg].t[naxis].offsx = yypvt[-0].val;
	} break;
case 392:
# line 1832 "pars.yacc"
{
	    g[cg].t[naxis].offsy = yypvt[-0].val;
	} break;
case 393:
# line 1835 "pars.yacc"
{
	    g[cg].t[naxis].alt = yypvt[-0].pset;
	} break;
case 394:
# line 1838 "pars.yacc"
{
	    g[cg].t[naxis].tmin = yypvt[-0].val;
	} break;
case 395:
# line 1841 "pars.yacc"
{
	    g[cg].t[naxis].tmax = yypvt[-0].val;
	} break;
case 396:
# line 1844 "pars.yacc"
{
	    g[cg].t[naxis].t_num = (int) yypvt[-0].val;
	} break;
case 397:
# line 1847 "pars.yacc"
{
	    g[cg].t[naxis].t_inout = yypvt[-0].pset;
	} break;
case 398:
# line 1850 "pars.yacc"
{
	    g[cg].t[naxis].t_log = yypvt[-0].pset;
	} break;
case 399:
# line 1853 "pars.yacc"
{
	    g[cg].t[naxis].t_size = yypvt[-0].val;
	} break;
case 400:
# line 1856 "pars.yacc"
{
	    g[cg].t[naxis].t_size = yypvt[-0].val;
	} break;
case 401:
# line 1859 "pars.yacc"
{
	    g[cg].t[naxis].t_msize = yypvt[-0].val;
	} break;
case 402:
# line 1862 "pars.yacc"
{
	    g[cg].t[naxis].t_color = g[cg].t[naxis].t_mcolor = (int) yypvt[-0].val;
	} break;
case 403:
# line 1865 "pars.yacc"
{
	    g[cg].t[naxis].t_linew = g[cg].t[naxis].t_mlinew = (int) yypvt[-0].val;
	} break;
case 404:
# line 1868 "pars.yacc"
{
	    g[cg].t[naxis].t_color = (int) yypvt[-0].val;
	} break;
case 405:
# line 1871 "pars.yacc"
{
	    g[cg].t[naxis].t_mcolor = (int) yypvt[-0].val;
	} break;
case 406:
# line 1874 "pars.yacc"
{
	    g[cg].t[naxis].t_linew = (int) yypvt[-0].val;
	} break;
case 407:
# line 1877 "pars.yacc"
{
	    g[cg].t[naxis].t_mlinew = (int) yypvt[-0].val;
	} break;
case 408:
# line 1880 "pars.yacc"
{
	    g[cg].t[naxis].t_lines = (int) yypvt[-0].val;
	} break;
case 409:
# line 1883 "pars.yacc"
{
	    g[cg].t[naxis].t_mlines = (int) yypvt[-0].val;
	} break;
case 410:
# line 1886 "pars.yacc"
{
	    g[cg].t[naxis].t_gridflag = yypvt[-0].pset;
	} break;
case 411:
# line 1889 "pars.yacc"
{
	    g[cg].t[naxis].t_mgridflag = yypvt[-0].pset;
	} break;
case 412:
# line 1892 "pars.yacc"
{
	    g[cg].t[naxis].t_op = yypvt[-0].pset;
	} break;
case 413:
# line 1895 "pars.yacc"
{
	    g[cg].t[naxis].t_type = AUTO;
	} break;
case 414:
# line 1898 "pars.yacc"
{
	    g[cg].t[naxis].t_type = SPEC;
	} break;
case 415:
# line 1901 "pars.yacc"
{
	    g[cg].t[naxis].t_spec = (int) yypvt[-0].val;
	} break;
case 416:
# line 1904 "pars.yacc"
{
	    g[cg].t[naxis].t_specloc[(int) yypvt[-2].val] = yypvt[-0].val;
	} break;
case 419:
# line 1915 "pars.yacc"
{
	    g[cg].t[naxis].tl_flag = yypvt[-0].pset;
	} break;
case 420:
# line 1918 "pars.yacc"
{
	    g[cg].t[naxis].tl_type = AUTO;
	} break;
case 421:
# line 1921 "pars.yacc"
{
	    g[cg].t[naxis].tl_type = SPEC;
	} break;
case 422:
# line 1924 "pars.yacc"
{
	    g[cg].t[naxis].tl_prec = (int) yypvt[-0].val;
	} break;
case 423:
# line 1927 "pars.yacc"
{
	    g[cg].t[naxis].tl_format = yypvt[-0].pset;
	} break;
case 424:
# line 1930 "pars.yacc"
{
	    g[cg].t[naxis].tl_format = yypvt[-0].val;
	} break;
case 425:
# line 1933 "pars.yacc"
{
	    strcpy(g[cg].t[naxis].tl_appstr, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 426:
# line 1937 "pars.yacc"
{
	    strcpy(g[cg].t[naxis].tl_prestr, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 427:
# line 1941 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = HORIZONTAL;
	} break;
case 428:
# line 1944 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = VERTICAL;
	} break;
case 429:
# line 1947 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = SPEC;
	} break;
case 430:
# line 1950 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = ON;
	} break;
case 431:
# line 1953 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = CENTER;
	} break;
case 432:
# line 1956 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = LEFT;
	} break;
case 433:
# line 1959 "pars.yacc"
{
	    g[cg].t[naxis].tl_layout = RIGHT;
	} break;
case 434:
# line 1962 "pars.yacc"
{
	    g[cg].t[naxis].tl_angle = (int) yypvt[-0].val;
	} break;
case 435:
# line 1965 "pars.yacc"
{
	    g[cg].t[naxis].tl_just = (int) yypvt[-0].pset;
	} break;
case 436:
# line 1968 "pars.yacc"
{
	    g[cg].t[naxis].tl_skip = (int) yypvt[-0].val;
	} break;
case 437:
# line 1971 "pars.yacc"
{
	    g[cg].t[naxis].tl_staggered = (int) yypvt[-0].val;
	} break;
case 438:
# line 1974 "pars.yacc"
{
	    g[cg].t[naxis].tl_op = yypvt[-0].pset;
	} break;
case 439:
# line 1977 "pars.yacc"
{
	    g[cg].t[naxis].tl_sign = yypvt[-0].pset;
	} break;
case 440:
# line 1980 "pars.yacc"
{
	    g[cg].t[naxis].tl_start = yypvt[-0].val;
	} break;
case 441:
# line 1983 "pars.yacc"
{
	    g[cg].t[naxis].tl_stop = yypvt[-0].val;
	} break;
case 442:
# line 1986 "pars.yacc"
{
	    g[cg].t[naxis].tl_starttype = (int) yypvt[-0].pset;
	} break;
case 443:
# line 1989 "pars.yacc"
{
	    g[cg].t[naxis].tl_starttype = (int) yypvt[-0].pset;
	} break;
case 444:
# line 1992 "pars.yacc"
{
	    g[cg].t[naxis].tl_stoptype = (int) yypvt[-0].pset;
	} break;
case 445:
# line 1995 "pars.yacc"
{
	    g[cg].t[naxis].tl_stoptype = (int) yypvt[-0].pset;
	} break;
case 446:
# line 1998 "pars.yacc"
{
	    g[cg].t[naxis].tl_vgap = yypvt[-0].val;
	} break;
case 447:
# line 2001 "pars.yacc"
{
	    g[cg].t[naxis].tl_hgap = yypvt[-0].val;
	} break;
case 448:
# line 2004 "pars.yacc"
{
	    g[cg].t[naxis].tl_charsize = yypvt[-0].val;
	} break;
case 449:
# line 2007 "pars.yacc"
{
	    g[cg].t[naxis].tl_font = (int) yypvt[-0].val;
	} break;
case 450:
# line 2010 "pars.yacc"
{
	    g[cg].t[naxis].tl_color = (int) yypvt[-0].val;
	} break;
case 451:
# line 2013 "pars.yacc"
{
	    g[cg].t[naxis].tl_linew = (int) yypvt[-0].val;
	} break;
case 452:
# line 2016 "pars.yacc"
{
	    set_plotstr_string(&g[cg].t[naxis].t_speclab[(int) yypvt[-2].val], (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 453:
# line 2023 "pars.yacc"
{
	    set_plotstr_string(&g[cg].t[naxis].label, (char *) yypvt[-0].pset);
	    free((char *) yypvt[-0].pset);
	} break;
case 454:
# line 2027 "pars.yacc"
{
	    g[cg].t[naxis].label_layout = PERP;
	} break;
case 455:
# line 2030 "pars.yacc"
{
	    g[cg].t[naxis].label_layout = PARA;
	} break;
case 456:
# line 2033 "pars.yacc"
{
	    g[cg].t[naxis].label_place = yypvt[-0].pset;
	} break;
case 457:
# line 2036 "pars.yacc"
{
	    g[cg].t[naxis].label_place = yypvt[-0].pset;
	} break;
case 458:
# line 2039 "pars.yacc"
{
	    g[cg].t[naxis].label.x = yypvt[-2].val;
	    g[cg].t[naxis].label.y = yypvt[-0].val;
	} break;
case 459:
# line 2043 "pars.yacc"
{
	    g[cg].t[naxis].label.just = (int) yypvt[-0].pset;
	} break;
case 460:
# line 2046 "pars.yacc"
{
	    g[cg].t[naxis].label.charsize = yypvt[-0].val;
	} break;
case 461:
# line 2049 "pars.yacc"
{
	    g[cg].t[naxis].label.font = (int) yypvt[-0].val;
	} break;
case 462:
# line 2052 "pars.yacc"
{
	    g[cg].t[naxis].label.color = (int) yypvt[-0].val;
	} break;
case 463:
# line 2055 "pars.yacc"
{
	    g[cg].t[naxis].label.linew = (int) yypvt[-0].val;
	} break;
case 464:
# line 2061 "pars.yacc"
{
	    g[cg].t[naxis].t_drawbar = yypvt[-0].pset;
	} break;
case 465:
# line 2064 "pars.yacc"
{
	    g[cg].t[naxis].t_drawbarcolor = (int) yypvt[-0].val;
	} break;
case 466:
# line 2067 "pars.yacc"
{
	    g[cg].t[naxis].t_drawbarlines = (int) yypvt[-0].val;
	} break;
case 467:
# line 2070 "pars.yacc"
{
	    g[cg].t[naxis].t_drawbarlinew = (int) yypvt[-0].val;
	} break;
case 468:
# line 2077 "pars.yacc"
{
	    whichgraph = yypvt[-2].pset;
	    whichset = yypvt[-0].pset;
	} break;
case 469:
# line 2082 "pars.yacc"
{
	    whichgraph = cg;
	    whichset = yypvt[-0].pset;
	} break;
case 470:
# line 2087 "pars.yacc"
{
	    whichgraph = cg;
	    whichset = yypvt[-0].pset;
	} break;
case 471:
# line 2092 "pars.yacc"
{
	    whichgraph = yypvt[-1].pset;
	    whichset = yypvt[-0].pset;
	} break;
case 472:
# line 2097 "pars.yacc"
{
	    whichgraph = yypvt[-1].pset;
	    whichset = yypvt[-0].pset;
	} break;
case 473:
# line 2102 "pars.yacc"
{
	    whichgraph = yypvt[-1].pset;
	    whichset = yypvt[-0].pset;
	} break;
case 474:
# line 2108 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 475:
# line 2109 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 476:
# line 2110 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 477:
# line 2111 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 478:
# line 2112 "pars.yacc"
{ yyval.pset = yypvt[-0].pset; } break;
case 479:
# line 2115 "pars.yacc"
{ yyval.pset = ON; } break;
case 480:
# line 2116 "pars.yacc"
{ yyval.pset = OFF; } break;
case 481:
# line 2119 "pars.yacc"
{ yyval.pset = COLOR; } break;
case 482:
# line 2120 "pars.yacc"
{ yyval.pset = PATTERN; } break;
case 483:
# line 2123 "pars.yacc"
{ yyval.pset = RUNAVG; } break;
case 484:
# line 2124 "pars.yacc"
{ yyval.pset = RUNSTD; } break;
case 485:
# line 2125 "pars.yacc"
{ yyval.pset = RUNMED; } break;
case 486:
# line 2126 "pars.yacc"
{ yyval.pset = RUNMAX; } break;
case 487:
# line 2127 "pars.yacc"
{ yyval.pset = RUNMIN; } break;
case 488:
# line 2130 "pars.yacc"
{ yyval.pset = DFT; } break;
case 489:
# line 2131 "pars.yacc"
{ yyval.pset = FFT; } break;
case 490:
# line 2132 "pars.yacc"
{ yyval.pset = INVDFT; } break;
case 491:
# line 2133 "pars.yacc"
{ yyval.pset = INVFFT; } break;
case 492:
# line 2136 "pars.yacc"
{ yyval.pset = DISK; } break;
case 493:
# line 2137 "pars.yacc"
{ yyval.pset = PIPE; } break;
case 494:
# line 2140 "pars.yacc"
{ yyval.pset = PATTERN; } break;
case 495:
# line 2141 "pars.yacc"
{ yyval.pset = COLOR; } break;
case 496:
# line 2142 "pars.yacc"
{ yyval.pset = NONE; } break;
case 497:
# line 2145 "pars.yacc"
{ yyval.pset = TOP; } break;
case 498:
# line 2146 "pars.yacc"
{ yyval.pset = BOTTOM; } break;
case 499:
# line 2147 "pars.yacc"
{ yyval.pset = LEFT; } break;
case 500:
# line 2148 "pars.yacc"
{ yyval.pset = RIGHT; } break;
case 501:
# line 2149 "pars.yacc"
{ yyval.pset = BOTH; } break;
case 502:
# line 2152 "pars.yacc"
{ yyval.pset = RIGHT; } break;
case 503:
# line 2153 "pars.yacc"
{ yyval.pset = LEFT; } break;
case 504:
# line 2154 "pars.yacc"
{ yyval.pset = CENTER; } break;
case 505:
# line 2157 "pars.yacc"
{ yyval.pset = MINP; } break;
case 506:
# line 2158 "pars.yacc"
{ yyval.pset = MAXP; } break;
case 507:
# line 2161 "pars.yacc"
{ yyval.pset = TRUEP; } break;
case 508:
# line 2162 "pars.yacc"
{ yyval.pset = FALSEP; } break;
case 509:
# line 2165 "pars.yacc"
{ yyval.pset = IN; } break;
case 510:
# line 2166 "pars.yacc"
{ yyval.pset = OUT; } break;
case 511:
# line 2167 "pars.yacc"
{ yyval.pset = BOTH; } break;
case 512:
# line 2170 "pars.yacc"
{ yyval.pset = DECIMAL; } break;
case 513:
# line 2171 "pars.yacc"
{ yyval.pset = EXPONENTIAL; } break;
case 514:
# line 2172 "pars.yacc"
{ yyval.pset = POWER; } break;
case 515:
# line 2173 "pars.yacc"
{ yyval.pset = GENERAL; } break;
case 516:
# line 2174 "pars.yacc"
{ yyval.pset = DDMMYY; } break;
case 517:
# line 2175 "pars.yacc"
{ yyval.pset = MMDDYY; } break;
case 518:
# line 2176 "pars.yacc"
{ yyval.pset = YYMMDD; } break;
case 519:
# line 2177 "pars.yacc"
{ yyval.pset = MMYY; } break;
case 520:
# line 2178 "pars.yacc"
{ yyval.pset = MMDD; } break;
case 521:
# line 2179 "pars.yacc"
{ yyval.pset = MONTHDAY; } break;
case 522:
# line 2180 "pars.yacc"
{ yyval.pset = DAYMONTH; } break;
case 523:
# line 2181 "pars.yacc"
{ yyval.pset = MONTHS; } break;
case 524:
# line 2182 "pars.yacc"
{ yyval.pset = MONTHSY; } break;
case 525:
# line 2183 "pars.yacc"
{ yyval.pset = MONTHL; } break;
case 526:
# line 2184 "pars.yacc"
{ yyval.pset = DAYOFWEEKS; } break;
case 527:
# line 2185 "pars.yacc"
{ yyval.pset = DAYOFWEEKL; } break;
case 528:
# line 2186 "pars.yacc"
{ yyval.pset = DAYOFYEAR; } break;
case 529:
# line 2187 "pars.yacc"
{ yyval.pset = HMS; } break;
case 530:
# line 2188 "pars.yacc"
{ yyval.pset = MMDDHMS; } break;
case 531:
# line 2189 "pars.yacc"
{ yyval.pset = MMDDYYHMS; } break;
case 532:
# line 2190 "pars.yacc"
{ yyval.pset = YYMMDDHMS; } break;
case 533:
# line 2191 "pars.yacc"
{ yyval.pset = DEGREESLON; } break;
case 534:
# line 2192 "pars.yacc"
{ yyval.pset = DEGREESMMLON; } break;
case 535:
# line 2193 "pars.yacc"
{ yyval.pset = DEGREESMMSSLON; } break;
case 536:
# line 2194 "pars.yacc"
{ yyval.pset = MMSSLON; } break;
case 537:
# line 2195 "pars.yacc"
{ yyval.pset = DEGREESLAT; } break;
case 538:
# line 2196 "pars.yacc"
{ yyval.pset = DEGREESMMLAT; } break;
case 539:
# line 2197 "pars.yacc"
{ yyval.pset = DEGREESMMSSLAT; } break;
case 540:
# line 2198 "pars.yacc"
{ yyval.pset = MMSSLAT; } break;
case 541:
# line 2201 "pars.yacc"
{ yyval.pset = NORMAL; } break;
case 542:
# line 2202 "pars.yacc"
{ yyval.pset = ABSOLUTE; } break;
case 543:
# line 2203 "pars.yacc"
{ yyval.pset = NEGATE; } break;
case 544:
# line 2206 "pars.yacc"
{ yyval.pset = UP; } break;
case 545:
# line 2207 "pars.yacc"
{ yyval.pset = DOWN; } break;
case 546:
# line 2208 "pars.yacc"
{ yyval.pset = RIGHT; } break;
case 547:
# line 2209 "pars.yacc"
{ yyval.pset = LEFT; } break;
case 548:
# line 2210 "pars.yacc"
{ yyval.pset = IN; } break;
case 549:
# line 2211 "pars.yacc"
{ yyval.pset = OUT; } break;
case 550:
# line 2214 "pars.yacc"
{ yyval.pset = WORLD; } break;
case 551:
# line 2215 "pars.yacc"
{ yyval.pset = VIEW; } break;
case 552:
# line 2218 "pars.yacc"
{ yyval.pset = ASCENDING; } break;
case 553:
# line 2219 "pars.yacc"
{ yyval.pset = DESCENDING; } break;
case 554:
# line 2222 "pars.yacc"
{ yyval.pset = X; } break;
case 555:
# line 2223 "pars.yacc"
{ yyval.pset = Y; } break;
case 556:
# line 2226 "pars.yacc"
{ yyval.pset = X; } break;
case 557:
# line 2227 "pars.yacc"
{ yyval.pset = Y; } break;
case 558:
# line 2228 "pars.yacc"
{ yyval.pset = X0; } break;
case 559:
# line 2229 "pars.yacc"
{ yyval.pset = Y0; } break;
case 560:
# line 2230 "pars.yacc"
{ yyval.pset = Y1; } break;
case 561:
# line 2231 "pars.yacc"
{ yyval.pset = Y2; } break;
case 562:
# line 2232 "pars.yacc"
{ yyval.pset = Y3; } break;
case 563:
# line 2233 "pars.yacc"
{ yyval.pset = Y4; } break;
case 564:
# line 2234 "pars.yacc"
{ yyval.pset = Y5; } break;
case 565:
# line 2239 "pars.yacc"
{
	    int itmp = (int) yypvt[-3].val - 1;
	    if (itmp >= ls) {
		yyerror("Subscript out of range");
		return 1;
	    } else {
		yypvt[-5].ptr[itmp] = yypvt[-0].val;
		result = yypvt[-0].val;
	    }
	} break;
case 566:
# line 2250 "pars.yacc"
{
	    int itmp = (int) yypvt[-3].val - 1;
	    double *ptr = getvptr(cg, curset, yypvt[-3].val);
	    if (ptr != NULL) {
	        ptr[itmp] = yypvt[-0].val;
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    result = yypvt[-0].val;
	    updatesetminmax(cg, curset);
	    update_set_status(cg, curset);
	} break;
case 567:
# line 2265 "pars.yacc"
{
	    int itmp = (int) yypvt[-3].val - 1;
	    double *ptr = getvptr(cg, yypvt[-7].pset, yypvt[-5].pset);
	    if (ptr != NULL) {
	        ptr[itmp] = yypvt[-0].val;
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    result = yypvt[-0].val;
	    updatesetminmax(cg, yypvt[-7].pset);
	    update_set_status(cg, yypvt[-7].pset);
	} break;
case 568:
# line 2280 "pars.yacc"
{
	    set_prop(cg, SET, SETNUM, yypvt[-4].pset, SYMBOL, TYPE, (int) yypvt[-0].val, 0);
	    result = 0;
	} break;
case 569:
# line 2292 "pars.yacc"
{
	    int itmp = (int) yypvt[-3].val - 1;
	    double *ptr = getvptr(yypvt[-9].pset, yypvt[-7].pset, yypvt[-5].pset);
	    if (ptr != NULL) {
	        ptr[itmp] = yypvt[-0].val;
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    result = yypvt[-0].val;
	    updatesetminmax(yypvt[-9].pset, yypvt[-7].pset);
	    update_set_status(yypvt[-9].pset, yypvt[-7].pset);
	} break;
case 570:
# line 2310 "pars.yacc"
{
	    if (yypvt[-2].pset == X) {
		*xx = yypvt[-0].val;
	    } else {
		*yy = yypvt[-0].val;
	    }
	} break;
case 571:
# line 2321 "pars.yacc"
{
	    int i;
	    if (ls < 0) {
		yyerror("Length of array < 0");
		return 1;
	    } else if (ls > maxarr) {
		maxarr = ls;
		init_scratch_arrays(ls);
	    }
	    for (i = 0; i < lxy; i++) {
		yypvt[-2].ptr[i] = yypvt[-0].ptr[i];
	    }
	    result = yypvt[-0].ptr[0];
	} break;
case 572:
# line 2336 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(cg, curset)) {
		activateset(cg, curset);
		setlength(cg, curset, lxy);
		setcomment(cg, curset, "Created");
	    }
	    ptr = getvptr(cg, curset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].ptr[i];
	        }
	        result = yypvt[-0].ptr[0];
	        updatesetminmax(cg, curset);
	        update_set_status(cg, curset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 573:
# line 2359 "pars.yacc"
{
	    if (isactive_set(cg, yypvt[-0].pset)) {
	        do_copyset(cg, yypvt[-0].pset, cg, yypvt[-2].pset);
	    } else {
		yyerror("Right value set not active");
	    }
	    result = 0;
	} break;
case 574:
# line 2368 "pars.yacc"
{
	    if (isactive_set(cg, yypvt[-0].pset)) {
	        do_copyset(cg, yypvt[-0].pset, yypvt[-4].pset, yypvt[-2].pset);
	    } else {
		yyerror("Right value set not active");
	    }
	    result = 0;
	} break;
case 575:
# line 2377 "pars.yacc"
{
	    if (isactive_set(yypvt[-2].pset, yypvt[-0].pset)) {
	        do_copyset(yypvt[-2].pset, yypvt[-0].pset, cg, yypvt[-4].pset);
	    } else {
		yyerror("Right value set not active");
	    }
	    result = 0;
	} break;
case 576:
# line 2386 "pars.yacc"
{
	    if (isactive_set(yypvt[-2].pset, yypvt[-0].pset)) {
	        do_copyset(yypvt[-2].pset, yypvt[-0].pset, yypvt[-6].pset, yypvt[-4].pset);
	    } else {
		yyerror("Right value set not active");
	    }
	    result = 0;
	} break;
case 577:
# line 2394 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(cg, yypvt[-4].pset)) {
		activateset(cg, yypvt[-4].pset);
		setlength(cg, yypvt[-4].pset, lxy);
		setcomment(cg, yypvt[-4].pset, "Created");
	    }
	    ptr = getvptr(cg, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].ptr[i];
	        }
	        result = yypvt[-0].ptr[0];
	        updatesetminmax(cg, yypvt[-4].pset);
	        update_set_status(cg, yypvt[-4].pset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 578:
# line 2417 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(yypvt[-6].pset, yypvt[-4].pset)) {
		activateset(yypvt[-6].pset, yypvt[-4].pset);
		setlength(yypvt[-6].pset, yypvt[-4].pset, lxy);
		setcomment(yypvt[-6].pset, yypvt[-4].pset, "Created");
	    }
	    ptr = getvptr(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].ptr[i];
	        }
	        result = yypvt[-0].ptr[0];
	        updatesetminmax(yypvt[-6].pset, yypvt[-4].pset);
	        update_set_status(yypvt[-6].pset, yypvt[-4].pset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 579:
# line 2440 "pars.yacc"
{
	    int i;
	    if (lxy < 0) {
		yyerror("Length of array < 0");
		return 1;
	    } else if (lxy > maxarr) {
		maxarr = lxy;
		init_scratch_arrays(lxy);
	    }
	    for (i = 0; i < lxy; i++) {
		yypvt[-2].ptr[i] = yypvt[-0].val;
	    }
	    result = yypvt[-0].val;
	} break;
case 580:
# line 2455 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(cg, curset)) {
		activateset(cg, curset);
		setlength(cg, curset, lxy);
		setcomment(cg, curset, "Created");
	    }
	    ptr = getvptr(cg, curset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].val;
	        }
	        result = yypvt[-0].val;
	        updatesetminmax(cg, curset);
	        update_set_status(cg, curset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 581:
# line 2478 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(cg, yypvt[-4].pset)) {
		activateset(cg, yypvt[-4].pset);
		setlength(cg, yypvt[-4].pset, lxy);
		setcomment(cg, yypvt[-4].pset, "Created");
	    }
	    ptr = getvptr(cg, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].val;
	        }
	        result = yypvt[-0].val;
	        updatesetminmax(cg, yypvt[-4].pset);
	        update_set_status(cg, yypvt[-4].pset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 582:
# line 2501 "pars.yacc"
{
	    int i;
	    double *ptr;
	    if (!isactive_set(yypvt[-6].pset, yypvt[-4].pset)) {
		activateset(yypvt[-6].pset, yypvt[-4].pset);
		setlength(yypvt[-6].pset, yypvt[-4].pset, lxy);
		setcomment(yypvt[-6].pset, yypvt[-4].pset, "Created");
	    }
	    ptr = getvptr(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr != NULL) {
	        for (i = 0; i < lxy; i++) {
		    ptr[i] = yypvt[-0].val;
	        }
	        result = yypvt[-0].val;
	        updatesetminmax(yypvt[-6].pset, yypvt[-4].pset);
	        update_set_status(yypvt[-6].pset, yypvt[-4].pset);
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 583:
# line 2527 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    if (lxy < 0) {
		yyerror("Length of array < 0");
		return 1;
	    } else if (lxy > maxarr) {
		maxarr = lxy;
		init_scratch_arrays(lxy);
	    }
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-0].ptr[i];
	    }
	} break;
case 584:
# line 2543 "pars.yacc"
{
	    int i;
	    double *ptr = getvptr(cg, curset, yypvt[-0].pset);
	    if (ptr == NULL) {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = ptr[i];
	    }
	} break;
case 585:
# line 2557 "pars.yacc"
{
	    int i;
	    double *ptr = getvptr(cg, yypvt[-2].pset, yypvt[-0].pset);
	    if (ptr == NULL) {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = ptr[i];
	    }
	} break;
case 586:
# line 2571 "pars.yacc"
{
	    int i;
	    double *ptr = getvptr(yypvt[-4].pset, yypvt[-2].pset, yypvt[-0].pset);
	    if (ptr == NULL) {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = ptr[i];
	    }
	} break;
case 587:
# line 2585 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-0].val;
	    }
	} break;
case 588:
# line 2594 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val + yypvt[-0].val;
	    }
	} break;
case 589:
# line 2603 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] + yypvt[-0].ptr[i];
	    }
	} break;
case 590:
# line 2612 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val + yypvt[-0].ptr[i];
	    }
	} break;
case 591:
# line 2621 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] + yypvt[-0].val;
	    }
	} break;
case 592:
# line 2630 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val - yypvt[-0].val;
	    }
	} break;
case 593:
# line 2639 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] - yypvt[-0].ptr[i];
	    }
	} break;
case 594:
# line 2648 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val - yypvt[-0].ptr[i];
	    }
	} break;
case 595:
# line 2657 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] - yypvt[-0].val;
	    }
	} break;
case 596:
# line 2666 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val * yypvt[-0].val;
	    }
	} break;
case 597:
# line 2675 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] * yypvt[-0].ptr[i];
	    }
	} break;
case 598:
# line 2684 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val * yypvt[-0].ptr[i];
	    }
	} break;
case 599:
# line 2693 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] * yypvt[-0].val;
	    }
	} break;
case 600:
# line 2702 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    if (yypvt[-0].val == 0.0) {
		yyerror("Divide by Zero");
		return 1;
	    }
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val / yypvt[-0].val;
	    }
	} break;
case 601:
# line 2715 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		if (yypvt[-0].ptr[i] == 0.0) {
		    yyerror("Divide by Zero");
		    return 1;
		}
	    }
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] / yypvt[-0].ptr[i];
	    }
	} break;
case 602:
# line 2730 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		if (yypvt[-0].ptr[i] == 0.0) {
		    yyerror("Divide by Zero");
		    return 1;
		}
	    }
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].val / yypvt[-0].ptr[i];
	    }
	} break;
case 603:
# line 2745 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    if (yypvt[-0].val == 0.0) {
		yyerror("Divide by Zero");
		return 1;
	    }
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] / yypvt[-0].val;
	    }
	} break;
case 604:
# line 2758 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = pow(yypvt[-2].val, yypvt[-0].val);
	    }
	} break;
case 605:
# line 2767 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = pow(yypvt[-2].val, yypvt[-0].ptr[i]);
	    }
	} break;
case 606:
# line 2776 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = pow(yypvt[-2].ptr[i], yypvt[-0].val);
	    }
	} break;
case 607:
# line 2785 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = pow(yypvt[-2].ptr[i], yypvt[-0].ptr[i]);
	    }
	} break;
case 608:
# line 2794 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = fabs(yypvt[-1].val);
	    }
	} break;
case 609:
# line 2803 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = fabs(yypvt[-1].ptr[i]);
	    }
	} break;
case 610:
# line 2812 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = acos(yypvt[-1].ptr[i]);
	    }
	} break;
case 611:
# line 2821 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = asin(yypvt[-1].ptr[i]);
	    }
	} break;
case 612:
# line 2830 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = atan(yypvt[-1].ptr[i]);
	    }
	} break;
case 613:
# line 2839 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = atan2(yypvt[-3].ptr[i], yypvt[-1].ptr[i]);
	    }
	} break;
case 614:
# line 2848 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = ceil(yypvt[-1].ptr[i]);
	    }
	} break;
case 615:
# line 2857 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = cos(yypvt[-1].ptr[i]);
	    }
	} break;
case 616:
# line 2866 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] *= M_PI / 180.0;
	    }
	} break;
case 617:
# line 2875 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = erf(yypvt[-1].ptr[i]);
	    }
	} break;
case 618:
# line 2884 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = erfc(yypvt[-1].ptr[i]);
	    }
	} break;
case 619:
# line 2893 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = exp(yypvt[-1].ptr[i]);
	    }
	} break;
case 620:
# line 2902 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = floor(yypvt[-1].ptr[i]);
	    }
	} break;
case 621:
# line 2911 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = my_hypot(yypvt[-3].ptr[i], yypvt[-1].ptr[i]);
	    }
	} break;
case 622:
# line 2920 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = my_hypot(yypvt[-3].val, yypvt[-1].ptr[i]);
	    }
	} break;
case 623:
# line 2929 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = my_hypot(yypvt[-3].ptr[i], yypvt[-1].val);
	    }
	} break;
case 624:
# line 2938 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = my_hypot(yypvt[-3].val, yypvt[-1].val);
	    }
	} break;
case 625:
# line 2947 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = i + 1;
	    }
	} break;
case 626:
# line 2956 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-0].func;
	    }
	} break;
case 627:
# line 2965 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = (int) yypvt[-1].ptr[i];
	    }
	} break;
case 628:
# line 2974 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = invnorm(yypvt[-1].ptr[i]);
	    }
	} break;
case 629:
# line 2983 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = invt(yypvt[-3].val, (int) yypvt[-1].val);
	    }
	} break;
case 630:
# line 2992 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = invt(yypvt[-3].ptr[i], (int) yypvt[-1].val);
	    }
	} break;
case 631:
# line 3001 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = lrand48() % (long) (yypvt[-1].val);
	    }
	} break;
case 632:
# line 3010 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = lgamma(yypvt[-1].ptr[i]);
	    }
	} break;
case 633:
# line 3019 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = log(yypvt[-1].ptr[i]);
	    }
	} break;
case 634:
# line 3028 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = log10(yypvt[-1].ptr[i]);
	    }
	} break;
case 635:
# line 3037 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = 1.0 / (1.0 + exp(-(yypvt[-5].ptr[i] - yypvt[-3].val)/ yypvt[-1].val));
	    }
	} break;
case 636:
# line 3046 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-3].ptr[i] >= yypvt[-1].ptr[i] ? yypvt[-3].ptr[i] : yypvt[-1].ptr[i];
	    }
	} break;
case 637:
# line 3055 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-3].ptr[i] <= yypvt[-1].ptr[i] ? yypvt[-3].ptr[i] : yypvt[-1].ptr[i];
	    }
	} break;
case 638:
# line 3064 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = fmod(yypvt[-3].ptr[i], yypvt[-1].ptr[i]);
	    }
	} break;
case 639:
# line 3073 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = fx(yypvt[-1].ptr[i]);
	    }
	} break;
case 640:
# line 3082 "pars.yacc"
{
	    int i;
	    double tmp;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = normp(yypvt[-1].ptr[i], &tmp);
	    }
	} break;
case 641:
# line 3092 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = M_PI;
	    }
	} break;
case 642:
# line 3101 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = M_PI / 180.0;
	    }
	} break;
case 643:
# line 3110 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = (double) drand48();
	    }
	} break;
case 644:
# line 3119 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = rnorm(yypvt[-3].ptr[i], yypvt[-1].ptr[i]);
	    }
	} break;
case 645:
# line 3128 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = rnorm(yypvt[-3].val, yypvt[-1].ptr[i]);
	    }
	} break;
case 646:
# line 3137 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = rnorm(yypvt[-3].ptr[i], yypvt[-1].val);
	    }
	} break;
case 647:
# line 3146 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = rnorm(yypvt[-3].val, yypvt[-1].val);
	    }
	} break;
case 648:
# line 3155 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = sin(yypvt[-1].ptr[i]);
	    }
	} break;
case 649:
# line 3164 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-1].ptr[i] * yypvt[-1].ptr[i];
	    }
	} break;
case 650:
# line 3173 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = sqrt(yypvt[-1].ptr[i]);
	    }
	} break;
case 651:
# line 3182 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = tan(yypvt[-1].ptr[i]);
	    }
	} break;
case 652:
# line 3190 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
	        if ((int) yypvt[-4].ptr[i]) {
		    yyval.ptr[i] = yypvt[-2].ptr[i];
	        } else {
		    yyval.ptr[i] = yypvt[-0].ptr[i];
	        }
	    }
	} break;
case 653:
# line 3203 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] > yypvt[-0].ptr[i];
	    }
	} break;
case 654:
# line 3212 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] < yypvt[-0].ptr[i];
	    }
	} break;
case 655:
# line 3221 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] <= yypvt[-0].ptr[i];
	    }
	} break;
case 656:
# line 3230 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] >= yypvt[-0].ptr[i];
	    }
	} break;
case 657:
# line 3239 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] == yypvt[-0].ptr[i];
	    }
	} break;
case 658:
# line 3248 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] != yypvt[-0].ptr[i];
	    }
	} break;
case 659:
# line 3257 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] && yypvt[-0].ptr[i];
	    }
	} break;
case 660:
# line 3266 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-2].ptr[i] || yypvt[-0].ptr[i];
	    }
	} break;
case 661:
# line 3275 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = !(yypvt[-0].ptr[i]);
	    }
	} break;
case 662:
# line 3284 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = yypvt[-1].ptr[i];
	    }
	} break;
case 663:
# line 3292 "pars.yacc"
{
	    int i;
	    yyval.ptr = (double *) calloc(lxy, sizeof(double));
	    freelist[fcnt++] = yyval.ptr;
	    for (i = 0; i < lxy; i++) {
		yyval.ptr[i] = -yypvt[-0].ptr[i];
	    }
	} break;
case 665:
# line 3303 "pars.yacc"
{
	    yyval.val = yypvt[-0].val;
	} break;
case 666:
# line 3306 "pars.yacc"
{
	    yyval.val = yypvt[-3].ptr[(int) yypvt[-1].val];
	} break;
case 667:
# line 3309 "pars.yacc"
{
	    yyval.val = (yypvt[-0].pset == X) ? *xx : *yy;
	} break;
case 668:
# line 3312 "pars.yacc"
{
	    double *ptr = getvptr(cg, curset, yypvt[-3].pset);
	    if (ptr != NULL) {
		yyval.val = ptr[(int) yypvt[-1].val - 1];
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 669:
# line 3322 "pars.yacc"
{
	    double *ptr = getvptr(cg, yypvt[-5].pset, yypvt[-3].pset);
	    if (ptr != NULL) {
		yyval.val = ptr[(int) yypvt[-1].val - 1];
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 670:
# line 3332 "pars.yacc"
{
	    double *ptr = getvptr(yypvt[-7].pset, yypvt[-5].pset, yypvt[-3].pset);
	    if (ptr != NULL) {
		yyval.val = ptr[(int) yypvt[-1].val - 1];
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 671:
# line 3342 "pars.yacc"
{
	    double *ptr = getvptr(cg, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr == NULL) {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    switch (yypvt[-0].pset) {
	    case MINP:
		yyval.val = vmin(ptr, g[cg].p[yypvt[-4].pset].len);
		break;
	    case MAXP:
		yyval.val = vmax(ptr, g[cg].p[yypvt[-4].pset].len);
		break;
	    }
	} break;
case 672:
# line 3357 "pars.yacc"
{
	    double *ptr = getvptr(yypvt[-6].pset, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr == NULL) {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	    switch (yypvt[-0].pset) {
	    case MINP:
		yyval.val = vmin(ptr, g[yypvt[-6].pset].p[yypvt[-4].pset].len);
		break;
	    case MAXP:
		yyval.val = vmax(ptr, g[yypvt[-6].pset].p[yypvt[-4].pset].len);
		break;
	    }
	} break;
case 673:
# line 3372 "pars.yacc"
{
	    yyval.val = g[cg].p[yypvt[-2].pset].len;
	} break;
case 674:
# line 3376 "pars.yacc"
{
	    double bar, sd;
	    double *ptr = getvptr(cg, yypvt[-4].pset, yypvt[-2].pset);
	    if (ptr != NULL) {
		stasum(ptr, getsetlength(cg, yypvt[-4].pset), &bar, &sd, 0);
	        yyval.val = bar;
	    }
	    else {
		yyerror("NULL variable, check set type");
		return 1;
	    }
	} break;
case 675:
# line 3388 "pars.yacc"
{
	    yyval.val = yypvt[-2].val + yypvt[-0].val;
	} break;
case 676:
# line 3391 "pars.yacc"
{
	    yyval.val = yypvt[-2].val - yypvt[-0].val;
	} break;
case 677:
# line 3394 "pars.yacc"
{
	    yyval.val = yypvt[-2].val * yypvt[-0].val;
	} break;
case 678:
# line 3398 "pars.yacc"
{
	    if (yypvt[-0].val != 0.0) {
		yyval.val = yypvt[-2].val / yypvt[-0].val;
	    } else {
		yyerror("Divide by Zero");
		return 1;
	    }
	} break;
case 679:
# line 3406 "pars.yacc"
{
	    yyval.val = fmod(yypvt[-2].val, yypvt[-0].val);
	} break;
case 680:
# line 3409 "pars.yacc"
{
	    yyval.val = pow(yypvt[-2].val, yypvt[-0].val);
	} break;
case 681:
# line 3412 "pars.yacc"
{
	    yyval.val = fabs(yypvt[-1].val);
	} break;
case 682:
# line 3415 "pars.yacc"
{
	    yyval.val = acos(yypvt[-1].val);
	} break;
case 683:
# line 3418 "pars.yacc"
{
	    yyval.val = asin(yypvt[-1].val);
	} break;
case 684:
# line 3421 "pars.yacc"
{
	    yyval.val = atan(yypvt[-1].val);
	} break;
case 685:
# line 3424 "pars.yacc"
{
	    yyval.val = atan2(yypvt[-3].val, yypvt[-1].val);
	} break;
case 686:
# line 3427 "pars.yacc"
{
	    yyval.val = ceil(yypvt[-1].val);
	} break;
case 687:
# line 3430 "pars.yacc"
{
	    yyval.val = cos(yypvt[-1].val);
	} break;
case 688:
# line 3433 "pars.yacc"
{
	    yyval.val = 180.0 / M_PI;
	} break;
case 689:
# line 3436 "pars.yacc"
{
	    yyval.val = erf(yypvt[-1].val);
	} break;
case 690:
# line 3439 "pars.yacc"
{
	    yyval.val = erfc(yypvt[-1].val);
	} break;
case 691:
# line 3442 "pars.yacc"
{
	    yyval.val = exp(yypvt[-1].val);
	} break;
case 692:
# line 3445 "pars.yacc"
{
	    yyval.val = floor(yypvt[-1].val);
	} break;
case 693:
# line 3448 "pars.yacc"
{
	    yyval.val = my_hypot(yypvt[-3].val, yypvt[-1].val);
	} break;
case 694:
# line 3451 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].v.xv1;
	} break;
case 695:
# line 3454 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].v.xv2;
	} break;
case 696:
# line 3457 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].v.yv1;
	} break;
case 697:
# line 3460 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].v.yv2;
	} break;
case 698:
# line 3463 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].w.xg1;
	} break;
case 699:
# line 3466 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].w.xg2;
	} break;
case 700:
# line 3469 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].w.yg1;
	} break;
case 701:
# line 3472 "pars.yacc"
{
	    yyval.val = g[yypvt[-2].pset].w.yg2;
	} break;
case 702:
# line 3475 "pars.yacc"
{
	    yyval.val = g[cg].v.xv1;
	} break;
case 703:
# line 3478 "pars.yacc"
{
	    yyval.val = g[cg].v.xv2;
	} break;
case 704:
# line 3481 "pars.yacc"
{
	    yyval.val = g[cg].v.yv1;
	} break;
case 705:
# line 3484 "pars.yacc"
{
	    yyval.val = g[cg].v.yv2;
	} break;
case 706:
# line 3487 "pars.yacc"
{
	    yyval.val = g[cg].w.xg1;
	} break;
case 707:
# line 3490 "pars.yacc"
{
	    yyval.val = g[cg].w.xg2;
	} break;
case 708:
# line 3493 "pars.yacc"
{
	    yyval.val = g[cg].w.yg1;
	} break;
case 709:
# line 3496 "pars.yacc"
{
	    yyval.val = g[cg].w.yg2;
	} break;
case 710:
# line 3499 "pars.yacc"
{
	    yyval.val = g[cg].w.xg2 - g[cg].w.xg1;
	} break;
case 711:
# line 3502 "pars.yacc"
{
	    yyval.val = g[cg].w.yg2 - g[cg].w.yg1;
	} break;
case 712:
# line 3505 "pars.yacc"
{
	    yyval.val = setindex;
	} break;
case 713:
# line 3508 "pars.yacc"
{
	    yyval.val = setsetno;
	} break;
case 714:
# line 3511 "pars.yacc"
{
	    yyval.val = (long) yypvt[-1].val;
	} break;
case 715:
# line 3514 "pars.yacc"
{
	    yyval.val = invnorm(yypvt[-1].val);
	} break;
case 716:
# line 3517 "pars.yacc"
{
	    yyval.val = invt(yypvt[-3].val, (int) yypvt[-1].val);
	} break;
case 717:
# line 3520 "pars.yacc"
{
	    yyval.val = lrand48() % (long) (yypvt[-1].val);
	} break;
case 718:
# line 3523 "pars.yacc"
{ /* yr, mo, day */
	    yyval.val = julday((int) yypvt[-3].val, (int) yypvt[-1].val, (int) yypvt[-5].val, 12, 0, 0.0);
	} break;
case 719:
# line 3527 "pars.yacc"
{ /* yr, mo, day, hr, min, sec */
	    yyval.val = julday((int) yypvt[-9].val, (int) yypvt[-7].val, (int) yypvt[-11].val, (int) yypvt[-5].val, (int) yypvt[-3].val, (double) yypvt[-1].val);
	} break;
case 720:
# line 3530 "pars.yacc"
{
	    yyval.val = lgamma(yypvt[-1].val);
	} break;
case 721:
# line 3533 "pars.yacc"
{
	    yyval.val = log(yypvt[-1].val);
	} break;
case 722:
# line 3536 "pars.yacc"
{
	    yyval.val = log10(yypvt[-1].val);
	} break;
case 723:
# line 3540 "pars.yacc"
{
	    yyval.val = 1.0 / (1.0 + exp(-(yypvt[-5].val - yypvt[-3].val)/ yypvt[-1].val));
	} break;
case 724:
# line 3543 "pars.yacc"
{
	    yyval.val = yypvt[-3].val >= yypvt[-1].val ? yypvt[-3].val : yypvt[-1].val;
	} break;
case 725:
# line 3546 "pars.yacc"
{
	    yyval.val = yypvt[-3].val <= yypvt[-1].val ? yypvt[-3].val : yypvt[-1].val;
	} break;
case 726:
# line 3549 "pars.yacc"
{
	    yyval.val = fmod(yypvt[-3].val, yypvt[-1].val);
	} break;
case 727:
# line 3552 "pars.yacc"
{
	    yyval.val = fx(yypvt[-1].val);
	} break;
case 728:
# line 3555 "pars.yacc"
{
	    double tmp;
	    yyval.val = normp(yypvt[-1].val, &tmp);
	} break;
case 729:
# line 3559 "pars.yacc"
{
	    yyval.val = M_PI;
	} break;
case 730:
# line 3562 "pars.yacc"
{
	    yyval.val = M_PI / 180.0;
	} break;
case 731:
# line 3565 "pars.yacc"
{
	    yyval.val = (double) drand48();
	} break;
case 732:
# line 3568 "pars.yacc"
{
	    yyval.val = rnorm(yypvt[-3].val, yypvt[-1].val);
	} break;
case 733:
# line 3571 "pars.yacc"
{
	    yyval.val = sin(yypvt[-1].val);
	} break;
case 734:
# line 3574 "pars.yacc"
{
	    yyval.val = pow(yypvt[-1].val, 2.0);
	} break;
case 735:
# line 3577 "pars.yacc"
{
	    yyval.val = sqrt(yypvt[-1].val);
	} break;
case 736:
# line 3580 "pars.yacc"
{
	    yyval.val = tan(yypvt[-1].val);
	} break;
case 737:
# line 3583 "pars.yacc"
{
	    if ((int) yypvt[-4].val) {
		yyval.val = yypvt[-2].val;
	    } else {
		yyval.val = yypvt[-0].val;
	    }
	} break;
case 738:
# line 3590 "pars.yacc"
{
	    yyval.val = yypvt[-2].val > yypvt[-0].val;
	} break;
case 739:
# line 3593 "pars.yacc"
{
	    yyval.val = yypvt[-2].val < yypvt[-0].val;
	} break;
case 740:
# line 3596 "pars.yacc"
{
	    yyval.val = yypvt[-2].val <= yypvt[-0].val;
	} break;
case 741:
# line 3599 "pars.yacc"
{
	    yyval.val = yypvt[-2].val >= yypvt[-0].val;
	} break;
case 742:
# line 3602 "pars.yacc"
{
	    yyval.val = yypvt[-2].val == yypvt[-0].val;
	} break;
case 743:
# line 3605 "pars.yacc"
{
	    yyval.val = yypvt[-2].val != yypvt[-0].val;
	} break;
case 744:
# line 3608 "pars.yacc"
{
	    yyval.val = yypvt[-2].val && yypvt[-0].val;
	} break;
case 745:
# line 3611 "pars.yacc"
{
	    yyval.val = yypvt[-2].val || yypvt[-0].val;
	} break;
case 746:
# line 3614 "pars.yacc"
{
	    yyval.val = !(yypvt[-0].val);
	} break;
case 747:
# line 3617 "pars.yacc"
{
	    yyval.val = yypvt[-1].val;
	} break;
case 748:
# line 3620 "pars.yacc"
{
	    yyval.val = -yypvt[-0].val;
	} break;
# line	532 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

