/* $Id: misc.c,v 1.2 1995/06/13 01:59:33 pturner Exp pturner $
 *
 * Misc. support routines
 *
 */
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <math.h>
#include "globals.h"
#include "protos.h"

/*
 * set the current print options
 */
void set_printer(int device, char *prstr)
{
    if (device == FILEP) {
	if (prstr != NULL) {
	    strcpy(printstr, prstr);
	}
	ptofile = TRUE;
    } else {
	switch (device) {
	case GR_PS_L:
	case GR_PS_P:
	    if (prstr != NULL) {
		strcpy(ps_prstr, prstr);
	    }
	    curprint = ps_prstr;
	    break;
	case GR_MIF_L:
	case GR_MIF_P:
	    if (prstr != NULL) {
		strcpy(mif_prstr, prstr);
	    }
	    curprint = mif_prstr;
	    break;
	case GR_HPGL_L:
	case GR_HPGL_P:
	    if (prstr != NULL) {
		strcpy(hp_prstr, prstr);
	    }
	    curprint = hp_prstr;
	    break;
	case GR_LEAF_L:
	case GR_LEAF_P:
	    if (prstr != NULL) {
		strcpy(leaf_prstr, prstr);
	    }
	    curprint = leaf_prstr;
	    break;
	case 15:
	case 16:
	    break;
	default:
	    sprintf(buf, "Unknown printer device %d, printer unchanged", device);
	    errmsg(buf);
	    return;
	    break;
	}
	hdevice = device;
	ptofile = FALSE;
    }
#ifndef GRBATCH
    update_printer_setup();
#endif
}

/* scrunch a pair of integer arrays */
void scrunch_points(int *x, int *y, int *n)
{
    int i, cnt = 0;
    cnt = 0;
    for (i = 0; i < *n - 1; i++) {
        if (x[cnt] == x[i + 1] && y[cnt] == y[i + 1]) {
        } else {
            cnt++;
            x[cnt] = x[i + 1];
            y[cnt] = y[i + 1];
        }
    }
    cnt++;
    if (cnt < 2) {
        cnt = 2;
        x[1] = x[*n + 1];
        y[1] = y[*n + 1];
    }
    *n = cnt;
}

/*
 * stuff results, etc. into a text window
 */
void log_results(char *buf)
{
    char tmpbuf[512];
    if (logwindow) {
        strcpy(tmpbuf, buf);
        if (tmpbuf[strlen(tmpbuf) - 1] != '\n') {
            strcat(tmpbuf, "\n");
        }
        stufftext(tmpbuf, 1);
    }
}


void errmsg(char *buf)
{
#ifdef GRBATCH
    printf("%s\n", buf);
#else
    errwin(buf);
#endif
}


int yesno(char *msg1, char *s1, char *s2, char *helptext)
{
#ifdef GRBATCH
    return 0;
#else
    return (yesnowin(msg1, s1, s2, helptext));
#endif
}
 

int fexists(char *to)
{
    struct stat stto;
    char tbuf[256];

    if (stat(to, &stto) == 0) {
	sprintf(tbuf, "Overwrite %s?", to);
	if (!yesno(tbuf, NULL, NULL, NULL)) {
	    return (1);
	}
	return (0);
    }
    return (0);
}

void stufftext(char *s, int sp)
{
#ifdef GRBATCH
    printf("%s", buf);
#else
    stufftextwin(s, sp);
#endif
}
