/* npipe.c
 * test of -npipe option
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>


#include <varargs.h>

#include <ctype.h>


/* declaration des procedures de communications avec xmgr */
int   xmgrpipe_open();
int   xmgrpipe_printf();    /* pb en mode FILE */



#define NB_PTS 50
#ifndef M_PI
#define M_PI 3.14
#endif

int main(argc, argv)
    int argc;
    char **argv;
{

    int i;
    int pipe_num;
    char buffer[260];    
    FILE *demo;
    double x;
     

    pipe_num = xmgrpipe_open ( 0, argv[0], 0 );
    
/* -------- demo interne ---------------------------------- */

    for ( i = 0; i < 5*NB_PTS; i ++)
    {   x = 0.2 * i;
        xmgrpipe_printf ( "g0.s0 POINT %lf, %lf\n", 
               x, 10.0 * sin(x*x) * sin(x*M_PI/NB_PTS));      
               }
     xmgrpipe_printf ( "AUTOSCALE\n" );      
               

    fprintf( stderr, "acquisition par point : sleeping 1\n");
    sleep( 1 );
    
    xmgrpipe_printf ( "g0.s1 SYMBOL 2\ng0.s1 SYMBOL FILL 1\ng0.s1 SYMBOL SIZE 0.5\n" );      

    for ( i = 0; i < NB_PTS; i ++)
    {   x = i;
        xmgrpipe_printf ( "g0.s1 POINT %lf, %lf\nREDRAW\n", 
               x, 10.0 * sin(x*x) * sin(x*M_PI/NB_PTS));      
        sleep ( 1 );      
        }       
               

    fprintf( stderr, "fin demo interne : sleeping 1\n");
    sleep( 1 );

/* -------- demo externe ---------------------------------- */
    sprintf( buffer, "%s.demo", argv[0]);
    do
    {    
         demo = fopen( buffer, "r"); 
         if (demo == NULL) 
         {    fprintf( stderr, " fichier '%s' de demonstration non trouve\nAbandon\n",
                buffer);
             exit (1);
             }       
         fprintf( stderr, " fichier '%s' trouve\n", buffer);
                
        while ( ! feof( demo ) )
        {   fgets( buffer, 255, demo);
            if ( buffer[0] == '@' )
            {   fprintf( stderr, "sleeping in reading file\n");
                if (isdigit( buffer[1] ) && buffer[1] != '0')  
                     sleep( buffer[1] - '0' );           
                else sleep( 1);
                }
            else if ( strlen(buffer) )
               xmgrpipe_printf( "%s", buffer);
                
            else fputs ( "%d????", 4);
            };   

       close( demo );
            
       puts (" Nom du fichier a emettre ou CR pour quitter" );
       gets( buffer );

       }  while (strlen( buffer ) != 0 );
    
   }
   
