/* $Id: misc.c,v 1.2 1995/06/13 01:59:33 pturner Exp pturner $
 *
 * Misc. support routines
 *
 */
#include <stdio.h>
#include <string.h>
#ifdef ULTRIX
#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <math.h>
#include "globals.h"
#include "protos.h"

extern int ptofile;

/*
 * Change suffix on printer output filename to newsuf
 */
void change_suffix( char *s, char *newsuf )
{
	int i;
	
	/* get suffix */
	i = strlen( s );
	do{}
	while( --i>=0 && s[i] !='.' );
	
	if( i<0 || !strcmp(s+i, newsuf) )		/* don't do a thing */
		return;
	
	/* check if known suffix before changing it */
	if( !strcmp( s+i, hp_suffix )  || !strcmp( s+i, ps_suffix )  || 
	    !strcmp( s+i, leaf_suffix) || !strcmp( s+i, mif_suffix ) ||
		!strcmp( s+i, eps_suffix ) 								      )
		strcpy( s+i, newsuf );
}
 
/*
 * set the current print options
 */
void set_printer(int device, char *prstr)
{
    if (device == FILEP) {
	if (prstr != NULL) {
	    strcpy(printstr, prstr);
	}
	ptofile = TRUE;
    } else {
	switch (device) {
	case GR_PS_L:
	case GR_PS_P:
	    if (prstr != NULL) {
		strcpy(ps_prstr, prstr);
	    }
  	  	curprint = ps_prstr;
	    cursuffix = ps_suffix;
	    break;
	case GR_MIF_L:
	case GR_MIF_P:
	    if (prstr != NULL) {
		strcpy(mif_prstr, prstr);
	    }
  	  	curprint = mif_prstr;
	    cursuffix = mif_suffix;
	    break;
	case GR_HPGL_L:
	case GR_HPGL_P:
	    if (prstr != NULL) {
		strcpy(hp_prstr, prstr);
	    }
  	  	curprint = hp_prstr;
	    cursuffix = hp_suffix;
	    break;
	case GR_LEAF_L:
	case GR_LEAF_P:
	    if (prstr != NULL) {
		strcpy(leaf_prstr, prstr);
	    }
  	  	curprint = leaf_prstr;
	 	cursuffix = leaf_suffix;
   		break;
	case 15:
	case 16:
	    break;
	default:
	    sprintf(buf, "Unknown printer device %d, printer unchanged", device);
	    errmsg(buf);
	    return;
	    break;
	}
	hdevice = device;
/*
 * 	ptofile = FALSE;
 */
    }
#ifndef GRBATCH
    update_printer_setup();
#endif
}

/* scrunch a pair of integer arrays */
void scrunch_points(int *x, int *y, int *n)
{
    int i, cnt = 0;
    cnt = 0;
    for (i = 0; i < *n - 1; i++) {
        if (x[cnt] == x[i + 1] && y[cnt] == y[i + 1]) {
        } else {
            cnt++;
            x[cnt] = x[i + 1];
            y[cnt] = y[i + 1];
        }
    }
    cnt++;
    if (cnt < 2) {
        cnt = 2;
        x[1] = x[*n + 1];
        y[1] = y[*n + 1];
    }
    *n = cnt;
}

/*
 * stuff results, etc. into a text window
 */
void log_results(char *buf)
{
    char tmpbuf[512];
    if (logwindow) {
        strcpy(tmpbuf, buf);
        if (tmpbuf[strlen(tmpbuf) - 1] != '\n') {
            strcat(tmpbuf, "\n");
        }
        stufftext(tmpbuf, 1);
    }
}


void errmsg(char *buf)
{
#ifdef GRBATCH
    printf("%s\n", buf);
#else
    errwin(buf);
#endif
}


int yesno(char *msg1, char *s1, char *s2, char *help_anchor)
{
#ifdef GRBATCH
    return 0;
#else
    return (yesnowin(msg1, s1, s2, help_anchor));
#endif
}
 

int fexists(char *to)
{
    struct stat stto;
    char tbuf[256];

    if (stat(to, &stto) == 0) {
	sprintf(tbuf, "Overwrite %s?", to);
	if (!yesno(tbuf, NULL, NULL, NULL)) {
	    return (1);
	}
	return (0);
    }
    return (0);
}

void stufftext(char *s, int sp)
{
#ifdef GRBATCH
    printf("%s", buf);
#else
    stufftextwin(s, sp);
#endif
}


char *mybasename(char *s)
{
	int start, end;
	static char basename[256];
	
	end = strlen( s )-1;
	if( end==0 && *s=='/' ){	/* root is a special case */
		basename[0] = '/';
		return basename;
	}
	
	/* strip trailing white space and slashes */
	while( s[end]=='/' || s[end]==' ' || s[end]=='\t' )
		end--;
	/* find start of basename */
	start = end;
	do{
		start--;
	} while( start>=0 && s[start]!='/' );
	
	strncpy( basename, s+(start+1), end-start );
	basename[end-start] = '\0';
	return basename;
}

#ifdef NO_STRDUP

/* This is stolen from rotated.c" */

/**************************************************************************/
/* Routine to mimic `strdup()' (some machines don't have it)              */
/**************************************************************************/

char *strdup(str)
    char *str;
{
    char *s;

    if(str==NULL)
        return NULL;

    s=(char *)malloc((unsigned)(strlen(str)+1));
    if(s!=NULL)
        strcpy(s, str);

    return s;
}

#endif
