/* $Id: params.c,v 1.2 1995/06/02 03:23:59 pturner Exp pturner $
 *
 * write a parameter file
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "globals.h"
#include "protos.h"
#include "ps.h"

#define BADMAGIC 999999

void putparms(int gno, FILE * pp, int imbed)
{
    int i, j, k, ming, maxg;
    int ps, pt, gh, gl, gt, fx, fy, px, py;
    double dsx, dsy;
    char imbedstr[2], tmpstr1[128], tmpstr2[128];
    framep f;
    legend leg;
    labels lab;
    plotarr p;
    tickmarks t;
    world w;
    view v;

    if (imbed) {
	strcpy(imbedstr, "@");
    } else {
	imbedstr[0] = 0;
    }
    fprintf(pp, "# xmgr parameter file\n");
    fprintf(pp, "#\n");
    fprintf(pp, "#\n");

    /* Print some global variables. Added by Henrik Seidel Tue Jun 10 16:47:14 MET DST 1997 */
    switch (page_layout) {
        case FREE:       strcpy(tmpstr1, "free"); break;
        case LANDSCAPE:  strcpy(tmpstr1, "landscape"); break;
        case PORTRAIT:   strcpy(tmpstr1, "portrait"); break;
        case FIXED:      strcpy(tmpstr1, "fixed"); break;
        default:         strcpy(tmpstr1, "free"); break;
    }
    fprintf(pp, "%spage layout %s\n", imbedstr, tmpstr1);
    fprintf(pp, "%sps linewidth begin %d\n", imbedstr, pslwbegin);
    fprintf(pp, "%sps linewidth increment %d\n", imbedstr, pslwincr);
    fprintf(pp, "%shardcopy device %d\n", imbedstr, hdevice);
    /* End of added globals */

    fprintf(pp, "%spage %d\n", imbedstr, (int) (scrollper * 100));
    fprintf(pp, "%spage inout %d\n", imbedstr, (int) (shexper * 100));
    fprintf(pp, "%slink page %s\n", imbedstr, scrolling_islinked ? "on" : "off");

    fprintf(pp, "%sdefault linestyle %d\n", imbedstr, grdefaults.lines);
    fprintf(pp, "%sdefault linewidth %d\n", imbedstr, grdefaults.linew);
    fprintf(pp, "%sdefault color %d\n", imbedstr, grdefaults.color);
    fprintf(pp, "%sdefault char size %f\n", imbedstr, grdefaults.charsize);
    fprintf(pp, "%sdefault font %d\n", imbedstr, grdefaults.font);
    fprintf(pp, "%sdefault font source %d\n", imbedstr, grdefaults.fontsrc);
    fprintf(pp, "%sdefault symbol size %f\n", imbedstr, grdefaults.symsize);
    put_annotation(gno, pp, imbed);
    put_region(gno, pp, imbed);
    if (gno == -1) {
	maxg = maxgraph - 1;
	ming = 0;
    } else {
	maxg = gno;
	ming = gno;
    }
    for (k = ming; k <= maxg; k++) {
	if (isactive_graph(k)) {
	    gno = k;
	    gh = g[gno].hidden;
	    gl = g[gno].label;
	    gt = g[gno].type;
	    ps = g[gno].pointset;
	    pt = g[gno].pt_type;
	    dsx = g[gno].dsx;
	    dsy = g[gno].dsy;
	    fx = g[gno].fx;
	    fy = g[gno].fy;
	    px = g[gno].px;
	    py = g[gno].py;

	    fprintf(pp, "%swith g%1d\n", imbedstr, gno);

	    fprintf(pp, "%sg%1d %s\n", imbedstr, gno, on_or_off(g[gno].active));
	    fprintf(pp, "%sg%1d label %s\n", imbedstr, gno, on_or_off(gl));
	    fprintf(pp, "%sg%1d hidden %s\n", imbedstr, gno, gh ? "true" : "false");
	    fprintf(pp, "%sg%1d type %s\n", imbedstr, gno, graph_types(g[gno].type, 1));
	    fprintf(pp, "%sg%1d autoscale type %s\n", imbedstr, gno, g[gno].auto_type == AUTO ? "AUTO" : "SPEC");
	    fprintf(pp, "%sg%1d fixedpoint %s\n", imbedstr, gno, on_or_off(ps));
	    fprintf(pp, "%sg%1d fixedpoint type %d\n", imbedstr, gno, pt);
	    fprintf(pp, "%sg%1d fixedpoint xy %f, %f\n", imbedstr, gno, dsx, dsy);
	    strcpy(tmpstr1, get_format_types(fx));
	    strcpy(tmpstr2, get_format_types(fy));
	    fprintf(pp, "%sg%1d fixedpoint format %s %s\n", imbedstr, gno, tmpstr1, tmpstr2);
	    fprintf(pp, "%sg%1d fixedpoint prec %d, %d\n", imbedstr, gno, px, py);

	    get_graph_world(gno, &w);
	    fprintf(pp, "%s    world xmin %.12g\n", imbedstr, w.xg1);
	    fprintf(pp, "%s    world xmax %.12g\n", imbedstr, w.xg2);
	    fprintf(pp, "%s    world ymin %.12g\n", imbedstr, w.yg1);
	    fprintf(pp, "%s    world ymax %.12g\n", imbedstr, w.yg2);

	    for (i = 0; i < g[gno].ws_top; i++) {
		fprintf(pp, "%s    stack world %.9g, %.9g, %.9g, %.9g tick %g, %g, %g, %g\n", imbedstr,
			g[gno].ws[i].w.xg1, g[gno].ws[i].w.xg2, g[gno].ws[i].w.yg1, g[gno].ws[i].w.yg2,
			g[gno].ws[i].t[0].xg1, g[gno].ws[i].t[0].xg2, g[gno].ws[i].t[0].yg1, g[gno].ws[i].t[0].yg2);
	    }

	    get_graph_view(gno, &v);
	    fprintf(pp, "%s    view xmin %f\n", imbedstr, v.xv1);
	    fprintf(pp, "%s    view xmax %f\n", imbedstr, v.xv2);
	    fprintf(pp, "%s    view ymin %f\n", imbedstr, v.yv1);
	    fprintf(pp, "%s    view ymax %f\n", imbedstr, v.yv2);

	    get_graph_labels(gno, &lab);
	    fprintf(pp, "%s    title \"%s\"\n", imbedstr, escapequotes(lab.title.s));
	    fprintf(pp, "%s    title font %d\n", imbedstr, lab.title.font);
	    fprintf(pp, "%s    title size %f\n", imbedstr, lab.title.charsize);
	    fprintf(pp, "%s    title color %d\n", imbedstr, lab.title.color);
	    fprintf(pp, "%s    title linewidth %d\n", imbedstr, lab.title.linew);
	    fprintf(pp, "%s    subtitle \"%s\"\n", imbedstr, escapequotes(lab.stitle.s));
	    fprintf(pp, "%s    subtitle font %d\n", imbedstr, lab.stitle.font);
	    fprintf(pp, "%s    subtitle size %f\n", imbedstr, lab.stitle.charsize);
	    fprintf(pp, "%s    subtitle color %d\n", imbedstr, lab.stitle.color);
	    fprintf(pp, "%s    subtitle linewidth %d\n", imbedstr, lab.stitle.linew);

	    for (i = 0; i < g[gno].maxplot; i++) {
		get_graph_plotarr(gno, i, &p);
		if (isactive_set(gno, i)) {
/* setting the type here causes big problems
		    fprintf(pp, "%s    s%1d type %s\n", imbedstr, i, (char *) set_types(p.type));
*/
		    fprintf(pp, "%s    s%1d symbol %d\n", imbedstr, i, p.sym);
		    fprintf(pp, "%s    s%1d symbol size %f\n", imbedstr, i, p.symsize);
		    fprintf(pp, "%s    s%1d symbol fill %d\n", imbedstr, i, p.symfill);
		    fprintf(pp, "%s    s%1d symbol color %d\n", imbedstr, i, p.symcolor);
		    fprintf(pp, "%s    s%1d symbol linewidth %d\n", imbedstr, i, p.symlinew);
		    fprintf(pp, "%s    s%1d symbol linestyle %d\n", imbedstr, i, p.symlines);
		    fprintf(pp, "%s    s%1d symbol center %s\n", imbedstr, i, p.symdot ? "true" : "false");
		    fprintf(pp, "%s    s%1d symbol char %d\n", imbedstr, i, p.symchar);
		    fprintf(pp, "%s    s%1d skip %d\n", imbedstr, i, p.symskip);
		    fprintf(pp, "%s    s%1d linestyle %d\n", imbedstr, i, p.lines);
		    fprintf(pp, "%s    s%1d linewidth %d\n", imbedstr, i, p.linew);
		    fprintf(pp, "%s    s%1d color %d\n", imbedstr, i, p.color);
		    fprintf(pp, "%s    s%1d fill %d\n", imbedstr, i, p.fill);
		    fprintf(pp, "%s    s%1d fill with %s\n", imbedstr, i,
			    p.fillusing == COLOR ? "color" : "pattern");
		    fprintf(pp, "%s    s%1d fill color %d\n", imbedstr, i, p.fillcolor);
		    fprintf(pp, "%s    s%1d fill pattern %d\n", imbedstr, i, p.fillpattern);
		    switch (p.errbarxy) {
		    case TOP:
			fprintf(pp, "%s    s%1d errorbar type TOP\n", imbedstr, i);
			break;
		    case BOTTOM:
			fprintf(pp, "%s    s%1d errorbar type BOTTOM\n", imbedstr, i);
			break;
		    case LEFT:
			fprintf(pp, "%s    s%1d errorbar type LEFT\n", imbedstr, i);
			break;
		    case RIGHT:
			fprintf(pp, "%s    s%1d errorbar type RIGHT\n", imbedstr, i);
			break;
		    case BOTH:
			fprintf(pp, "%s    s%1d errorbar type BOTH\n", imbedstr, i);
			break;
		    }
		    fprintf(pp, "%s    s%1d errorbar length %f\n", imbedstr, i, p.errbarper);
		    fprintf(pp, "%s    s%1d errorbar linewidth %d\n", imbedstr, i, p.errbar_linew);
		    fprintf(pp, "%s    s%1d errorbar linestyle %d\n", imbedstr, i, p.errbar_lines);
		    fprintf(pp, "%s    s%1d errorbar riser %s\n", imbedstr, i, p.errbar_riser == ON ? "on" : "off");
		    fprintf(pp, "%s    s%1d errorbar riser linewidth %d\n", imbedstr, i, p.errbar_riser_linew);
		    fprintf(pp, "%s    s%1d errorbar riser linestyle %d\n", imbedstr, i, p.errbar_riser_lines);
		    fprintf(pp, "%s    s%1d xyz %f, %f\n", imbedstr, i, p.zmin, p.zmax);
		    if (is_hotlinked(gno, i)) {
			fprintf(pp, "%s    s%1d link %s \"%s\"\n", imbedstr, i,
			  p.hotsrc == DISK ? "disk" : "pipe", p.hotfile);
		    }
		    fprintf(pp, "%s    s%1d comment \"%s\"\n", imbedstr, i, p.comments);
		}
	    }

	    for (i = 0; i < MAXAXES; i++) {
		switch (i) {
		case 0:
		    get_graph_tickmarks(gno, &t, X_AXIS);
		    if (t.active == OFF) {
			fprintf(pp, "%s    xaxis off\n", imbedstr);
			continue;
		    }
		    sprintf(buf, "%s    xaxis ", imbedstr);
		    break;
		case 1:
		    get_graph_tickmarks(gno, &t, Y_AXIS);
		    if (t.active == OFF) {
			fprintf(pp, "%s    yaxis off\n", imbedstr);
			continue;
		    }
		    sprintf(buf, "%s    yaxis ", imbedstr);
		    break;
		case 2:
		    get_graph_tickmarks(gno, &t, ZX_AXIS);
		    if (t.active == OFF) {
			fprintf(pp, "%s    zeroxaxis off\n", imbedstr);
			continue;
		    }
		    sprintf(buf, "%s    zeroxaxis ", imbedstr);
		    break;
		case 3:
		    get_graph_tickmarks(gno, &t, ZY_AXIS);
		    if (t.active == OFF) {
			fprintf(pp, "%s    zeroyaxis off\n", imbedstr);
			continue;
		    }
		    sprintf(buf, "%s    zeroyaxis ", imbedstr);
		    break;
		}

		fprintf(pp, "%s tick %s\n", buf, on_or_off(t.active));
		fprintf(pp, "%s tick major %.12g\n", buf, t.tmajor);
		fprintf(pp, "%s tick minor %.12g\n", buf, t.tminor);
		fprintf(pp, "%s tick offsetx %f\n", buf, t.offsx);
		fprintf(pp, "%s tick offsety %f\n", buf, t.offsy);
/* DEFUNCT
		fprintf(pp, "%s tick alt %s\n", buf, on_or_off(t.alt));
		fprintf(pp, "%s tick min %.12g\n", buf, t.tmin);
		fprintf(pp, "%s tick max %.12g\n", buf, t.tmax);
*/

		fprintf(pp, "%s label \"%s\"\n", buf, t.label.s);
		if (t.label_layout == PERP) {
		    fprintf(pp, "%s label layout perp\n", buf);
		} else {
		    fprintf(pp, "%s label layout para\n", buf);
		}
		if (t.label_place == AUTO) {
		    fprintf(pp, "%s label place auto\n", buf);
		} else {
		    fprintf(pp, "%s label place spec\n", buf);
		    fprintf(pp, "%s label place %f, %f\n", buf, t.label.x, t.label.y);
		}
		fprintf(pp, "%s label char size %f\n", buf, t.label.charsize);
		fprintf(pp, "%s label font %d\n", buf, t.label.font);
		fprintf(pp, "%s label color %d\n", buf, t.label.color);
		fprintf(pp, "%s label linewidth %d\n", buf, t.label.linew);

		fprintf(pp, "%s ticklabel %s\n", buf, on_or_off(t.tl_flag));
		if (t.tl_type == AUTO) {
		    fprintf(pp, "%s ticklabel type auto\n", buf);
		} else {
		    fprintf(pp, "%s ticklabel type spec\n", buf);
		}
		fprintf(pp, "%s ticklabel prec %d\n", buf, t.tl_prec);
		fprintf(pp, "%s ticklabel format %s\n", buf, get_format_types(t.tl_format));
		fprintf(pp, "%s ticklabel append \"%s\"\n", buf, t.tl_appstr);
		fprintf(pp, "%s ticklabel prepend \"%s\"\n", buf, t.tl_prestr);
		switch (t.tl_layout) {
		case HORIZONTAL:
		    fprintf(pp, "%s ticklabel layout horizontal\n", buf);
		    break;
		case VERTICAL:
		    fprintf(pp, "%s ticklabel layout vertical\n", buf);
		    break;
		case SPEC:
		    fprintf(pp, "%s ticklabel layout spec\n", buf);
		    fprintf(pp, "%s ticklabel angle %d\n", buf, t.tl_angle);
		    break;
		}
		fprintf(pp, "%s ticklabel skip %d\n", buf, t.tl_skip);
		fprintf(pp, "%s ticklabel stagger %d\n", buf, t.tl_staggered);
		switch (t.tl_op) {
		case TOP:
		    fprintf(pp, "%s ticklabel op top\n", buf);
		    break;
		case BOTTOM:
		    fprintf(pp, "%s ticklabel op bottom\n", buf);
		    break;
		case LEFT:
		    fprintf(pp, "%s ticklabel op left\n", buf);
		    break;
		case RIGHT:
		    fprintf(pp, "%s ticklabel op right\n", buf);
		    break;
		case BOTH:
		    fprintf(pp, "%s ticklabel op both\n", buf);
		    break;
		}
		switch (t.tl_sign) {
		case NORMAL:
		    fprintf(pp, "%s ticklabel sign normal\n", buf);
		    break;
		case ABSOLUTE:
		    fprintf(pp, "%s ticklabel sign absolute\n", buf);
		    break;
		case NEGATE:
		    fprintf(pp, "%s ticklabel sign negate\n", buf);
		    break;
		}
		fprintf(pp, "%s ticklabel start type %s\n", buf, t.tl_starttype == AUTO ? "auto" : "spec");
		fprintf(pp, "%s ticklabel start %f\n", buf, t.tl_start);
		fprintf(pp, "%s ticklabel stop type %s\n", buf, t.tl_stoptype == AUTO ? "auto" : "spec");
		fprintf(pp, "%s ticklabel stop %f\n", buf, t.tl_stop);
		fprintf(pp, "%s ticklabel char size %f\n", buf, t.tl_charsize);
		fprintf(pp, "%s ticklabel font %d\n", buf, t.tl_font);
		fprintf(pp, "%s ticklabel color %d\n", buf, t.tl_color);
		fprintf(pp, "%s ticklabel linewidth %d\n", buf, t.tl_linew);

		fprintf(pp, "%s tick major %s\n", buf, on_or_off(t.t_flag));
		fprintf(pp, "%s tick minor %s\n", buf, on_or_off(t.t_mflag));
		fprintf(pp, "%s tick default %d\n", buf, t.t_num);
		switch (t.t_inout) {
		case IN:
		    fprintf(pp, "%s tick in\n", buf);
		    break;
		case OUT:
		    fprintf(pp, "%s tick out\n", buf);
		    break;
		case BOTH:
		    fprintf(pp, "%s tick both\n", buf);
		    break;
		}
		fprintf(pp, "%s tick major color %d\n", buf, t.t_color);
		fprintf(pp, "%s tick major linewidth %d\n", buf, t.t_linew);
		fprintf(pp, "%s tick major linestyle %d\n", buf, t.t_lines);
		fprintf(pp, "%s tick minor color %d\n", buf, t.t_mcolor);
		fprintf(pp, "%s tick minor linewidth %d\n", buf, t.t_mlinew);
		fprintf(pp, "%s tick minor linestyle %d\n", buf, t.t_mlines);
		fprintf(pp, "%s tick log %s\n", buf, on_or_off(t.t_log));
		fprintf(pp, "%s tick size %f\n", buf, t.t_size);
		fprintf(pp, "%s tick minor size %f\n", buf, t.t_msize);
		fprintf(pp, "%s bar %s\n", buf, on_or_off(t.t_drawbar));
		fprintf(pp, "%s bar color %d\n", buf, t.t_drawbarcolor);
		fprintf(pp, "%s bar linestyle %d\n", buf, t.t_drawbarlines);
		fprintf(pp, "%s bar linewidth %d\n", buf, t.t_drawbarlinew);
		fprintf(pp, "%s tick major grid %s\n", buf, on_or_off(t.t_gridflag));
		fprintf(pp, "%s tick minor grid %s\n", buf, on_or_off(t.t_mgridflag));
		switch (t.t_op) {
		case TOP:
		    fprintf(pp, "%s tick op top\n", buf);
		    break;
		case BOTTOM:
		    fprintf(pp, "%s tick op bottom\n", buf);
		    break;
		case LEFT:
		    fprintf(pp, "%s tick op left\n", buf);
		    break;
		case RIGHT:
		    fprintf(pp, "%s tick op right\n", buf);
		    break;
		case BOTH:
		    fprintf(pp, "%s tick op both\n", buf);
		    break;
		}
		if (t.t_type == AUTO) {
		    fprintf(pp, "%s tick type auto\n", buf);
		} else {
		    fprintf(pp, "%s tick type spec\n", buf);
		}
		fprintf(pp, "%s tick spec %d\n", buf, t.t_spec);
		for (j = 0; j < t.t_spec; j++) {
		    fprintf(pp, "%s tick %d, %g\n", buf, j, t.t_specloc[j]);
		    fprintf(pp, "%s ticklabel %d, \"%s\"\n", buf, j, t.t_speclab[j].s);
		}
	    }

	    get_graph_legend(gno, &leg);
	    fprintf(pp, "%s    legend %s\n", imbedstr, on_or_off(leg.active));
	    fprintf(pp, "%s    legend loctype %s\n", imbedstr, w_or_v(leg.loctype));
	    fprintf(pp, "%s    legend layout %d\n", imbedstr, leg.layout);
	    fprintf(pp, "%s    legend vgap %d\n", imbedstr, leg.vgap);
	    fprintf(pp, "%s    legend hgap %d\n", imbedstr, leg.hgap);
	    fprintf(pp, "%s    legend length %d\n", imbedstr, leg.len);
	    fprintf(pp, "%s    legend box %s\n", imbedstr, on_or_off(leg.box));
	    fprintf(pp, "%s    legend box fill %s\n", imbedstr, on_or_off(leg.box));
	    fprintf(pp, "%s    legend box fill with %s\n", imbedstr, leg.boxfillusing == COLOR ? "color" : "pattern");
	    fprintf(pp, "%s    legend box fill color %d\n", imbedstr, leg.boxfillcolor);
	    fprintf(pp, "%s    legend box fill pattern %d\n", imbedstr, leg.boxfillpat);
	    fprintf(pp, "%s    legend box color %d\n", imbedstr, leg.boxlcolor);
	    fprintf(pp, "%s    legend box linewidth %d\n", imbedstr, leg.boxlinew);
	    fprintf(pp, "%s    legend box linestyle %d\n", imbedstr, leg.boxlines);
	    fprintf(pp, "%s    legend x1 %.12g\n", imbedstr, leg.legx);
	    fprintf(pp, "%s    legend y1 %.12g\n", imbedstr, leg.legy);
	    fprintf(pp, "%s    legend font %d\n", imbedstr, leg.font);
	    fprintf(pp, "%s    legend char size %f\n", imbedstr, leg.charsize);
	    fprintf(pp, "%s    legend linestyle %d\n", imbedstr, leg.lines);
	    fprintf(pp, "%s    legend linewidth %d\n", imbedstr, leg.linew);
	    fprintf(pp, "%s    legend color %d\n", imbedstr, leg.color);
	    for (i = 0; i < maxplot; i++) {
		if (isactive_set(gno, i)) {
		    if (strlen(g[gno].p[i].lstr)) {
			fprintf(pp, "%s    legend string %d \"%s\"\n", 
				imbedstr, i, escapequotes(g[gno].p[i].lstr));
		    }
		}
	    }

	    get_graph_framep(gno, &f);
	    fprintf(pp, "%s    frame %s\n", imbedstr, on_or_off(f.active));
	    fprintf(pp, "%s    frame type %d\n", imbedstr, f.type);
	    fprintf(pp, "%s    frame linestyle %d\n", imbedstr, f.lines);
	    fprintf(pp, "%s    frame linewidth %d\n", imbedstr, f.linew);
	    fprintf(pp, "%s    frame color %d\n", imbedstr, f.color);
	    fprintf(pp, "%s    frame fill %s\n", imbedstr, on_or_off(f.fillbg));
	    fprintf(pp, "%s    frame background color %d\n", imbedstr, f.bgcolor);
	}
    }
}

void put_annotation(int gno, FILE * pp, int imbed)
{
    int i;
    boxtype b;
    linetype l;
    ellipsetype e;
    plotstr s;
    char imbedstr[2];

    if (imbed) {
	strcpy(imbedstr, "@");
    } else {
	imbedstr[0] = 0;
    }
    for (i = 0; i < maxboxes; i++) {
	get_graph_box(i, &b);
	if (b.active == ON) {
	    fprintf(pp, "%swith box\n", imbedstr);
	    fprintf(pp, "%s    box on\n", imbedstr);
	    fprintf(pp, "%s    box loctype %s\n", imbedstr, w_or_v(b.loctype));
	    if (b.loctype == WORLD) {
		fprintf(pp, "%s    box g%1d\n", imbedstr, b.gno);
	    }
	    fprintf(pp, "%s    box %.12g, %.12g, %.12g, %.12g\n", imbedstr, b.x1, b.y1, b.x2, b.y2);
	    fprintf(pp, "%s    box linestyle %d\n", imbedstr, b.lines);
	    fprintf(pp, "%s    box linewidth %d\n", imbedstr, b.linew);
	    fprintf(pp, "%s    box color %d\n", imbedstr, b.color);
	    switch (b.fill) {
	    case NONE:
		fprintf(pp, "%s    box fill none\n", imbedstr);
		break;
	    case COLOR:
		fprintf(pp, "%s    box fill color\n", imbedstr);
		break;
	    case PATTERN:
		fprintf(pp, "%s    box fill pattern\n", imbedstr);
		break;
	    }
	    fprintf(pp, "%s    box fill color %d\n", imbedstr, b.fillcolor);
	    fprintf(pp, "%s    box fill pattern %d\n", imbedstr, b.fillpattern);
	    fprintf(pp, "%sbox def\n", imbedstr);
	}
    }

    for (i = 0; i < maxellipses; i++) {
	get_graph_ellipse(i, &e);
	if (e.active == ON) {
	    fprintf(pp, "%swith ellipse\n", imbedstr);
	    fprintf(pp, "%s    ellipse on\n", imbedstr);
	    fprintf(pp, "%s    ellipse loctype %s\n", imbedstr, w_or_v(e.loctype));
	    if (e.loctype == WORLD) {
		fprintf(pp, "%s    ellipse g%1d\n", imbedstr, e.gno);
	    }
	    fprintf(pp, "%s    ellipse %.12g, %.12g, %.12g, %.12g\n", imbedstr, e.x1, e.y1, e.x2, e.y2);
	    fprintf(pp, "%s    ellipse linestyle %d\n", imbedstr, e.lines);
	    fprintf(pp, "%s    ellipse linewidth %d\n", imbedstr, e.linew);
	    fprintf(pp, "%s    ellipse color %d\n", imbedstr, e.color);
	    switch (e.fill) {
	    case NONE:
		fprintf(pp, "%s    ellipse fill none\n", imbedstr);
		break;
	    case COLOR:
		fprintf(pp, "%s    ellipse fill color\n", imbedstr);
		break;
	    case PATTERN:
		fprintf(pp, "%s    ellipse fill pattern\n", imbedstr);
		break;
	    }
	    fprintf(pp, "%s    ellipse fill color %d\n", imbedstr, e.fillcolor);
	    fprintf(pp, "%s    ellipse fill pattern %d\n", imbedstr, e.fillpattern);
	    fprintf(pp, "%sellipse def\n", imbedstr);
	}
    }
   for (i = 0; i < maxlines; i++) {
	get_graph_line(i, &l);
	if (l.active == ON) {
	    fprintf(pp, "%swith line\n", imbedstr);
	    fprintf(pp, "%s    line on\n", imbedstr);
	    fprintf(pp, "%s    line loctype %s\n", imbedstr, w_or_v(l.loctype));
	    if (l.loctype == WORLD) {
		fprintf(pp, "%s    line g%1d\n", imbedstr, l.gno);
	    }
	    fprintf(pp, "%s    line %.12g, %.12g, %.12g, %.12g\n", imbedstr, l.x1, l.y1, l.x2, l.y2);
	    fprintf(pp, "%s    line linewidth %d\n", imbedstr, l.linew);
	    fprintf(pp, "%s    line linestyle %d\n", imbedstr, l.lines);
	    fprintf(pp, "%s    line color %d\n", imbedstr, l.color);
	    fprintf(pp, "%s    line arrow %d\n", imbedstr, l.arrow);
	    fprintf(pp, "%s    line arrow size %f\n", imbedstr, l.asize);
	    fprintf(pp, "%s    line arrow type %d\n", imbedstr, l.atype);
	    fprintf(pp, "%sline def\n", imbedstr);
	}
    }

    for (i = 0; i < maxstr; i++) {
	get_graph_string(i, &s);
	if (s.active == ON && s.s[0]) {
	    fprintf(pp, "%swith string\n", imbedstr);
	    fprintf(pp, "%s    string on\n", imbedstr);
	    fprintf(pp, "%s    string loctype %s\n", imbedstr, w_or_v(s.loctype));
	    if (s.loctype == WORLD) {
		fprintf(pp, "%s    string g%1d\n", imbedstr, s.gno);
	    }
	    fprintf(pp, "%s    string %.12g, %.12g\n", imbedstr, s.x, s.y);
	    fprintf(pp, "%s    string linewidth %d\n", imbedstr, s.linew);
	    fprintf(pp, "%s    string color %d\n", imbedstr, s.color);
	    fprintf(pp, "%s    string rot %d\n", imbedstr, s.rot);
	    fprintf(pp, "%s    string font %d\n", imbedstr, s.font);
	    fprintf(pp, "%s    string just %d\n", imbedstr, s.just);
	    fprintf(pp, "%s    string char size %f\n", imbedstr, s.charsize);
	    fprintf(pp, "%sstring def \"%s\"\n", imbedstr, escapequotes(s.s));
	}
    }
}

void put_region(int gno, FILE * pp, int imbed)
{
    int i, j;
    char imbedstr[2];

    if (imbed) {
	strcpy(imbedstr, "@");
    } else {
	imbedstr[0] = 0;
    }
    for (i = 0; i < MAXREGION; i++) {
	if (rg[i].active == ON) {
	    fprintf(pp, "%sr%1d ON\n", imbedstr, i);
	    switch (rg[i].type) {
	    case ABOVE:
		fprintf(pp, "%sr%1d type above\n", imbedstr, i);
		break;
	    case BELOW:
		fprintf(pp, "%sr%1d type below\n", imbedstr, i);
		break;
	    case LEFT:
		fprintf(pp, "%sr%1d type left\n", imbedstr, i);
		break;
	    case RIGHT:
		fprintf(pp, "%sr%1d type right\n", imbedstr, i);
		break;
	    case POLYI:
		fprintf(pp, "%sr%1d type polyi\n", imbedstr, i);
		break;
	    case POLYO:
		fprintf(pp, "%sr%1d type polyo\n", imbedstr, i);
		break;
	    }
	    fprintf(pp, "%sr%1d linestyle %d\n", imbedstr, i, rg[i].lines);
	    fprintf(pp, "%sr%1d linewidth %d\n", imbedstr, i, rg[i].linew);
	    fprintf(pp, "%sr%1d color %d\n", imbedstr, i, rg[i].color);
	    if (rg[i].type != POLYI && rg[i].type != POLYO) {
		fprintf(pp, "%sr%1d line %.12g, %.12g, %.12g, %.12g\n", imbedstr, i, rg[i].x1, rg[i].y1, rg[i].x2, rg[i].y2);
	    } else {
		if (rg[i].x != NULL) {
		    for (j = 0; j < rg[i].n; j++) {
			fprintf(pp, "%sr%1d xy %.12g, %.12g\n", imbedstr, i, rg[i].x[j], rg[i].y[j]);
		    }
		}
	    }
	    for (j = 0; j < maxgraph; j++) {
		if (rg[i].linkto[j] == TRUE) {
		    fprintf(pp, "%slink r%1d to g%1d\n", imbedstr, i, j);
		}
	    }
	}
    }
}

/*
 * write state information
 */
#define PARMS_MAGIC 1002003
#define HEADERLENGTH 64

/*
 * when changes are done in the format, bump the version number
 * 32 chars - magic, version, msb, ieee, program
 * char length, short, int, float, double
 */
static char *std = "1002003 V1 XDR IEEE xmgr   1 2 4 4 8 |";
/*                  1234567890123456789012345678901234567890123456789012345678901234 */
/*
 * read/write state functions
 */
int putbinary(int gno, char *fname, int imbed)
{
    int i, k, cnt;
    FILE *pp;
    int nblocks = 1;		/* for future expansion of block data */
    char buf[256];

    if ((pp = fopen(fname, "r")) != NULL) { 
    	/* ask if o.k. to overwrite */
    	sprintf( buf, "Overwrite existing project: %s ?", mybasename(fname) );
    	if( !noask && !yesno( buf, NULL, NULL, NULL) ){
    	    fclose(pp);
    	    return 1;
    	}
    }
    fclose(pp);
    if ((pp = fopen(fname, "w")) == NULL) {
	sprintf(buf, "Can't open parameter file %s", fname);
	errmsg(buf);
    }
    open_xdr(pp, 0); /* open XDR stream for write */
    strcpy(buf, std);
    write_char(buf, HEADERLENGTH, pp);
    cnt = 0;

/* write globals */

/*
maxplot
maxarr
maxgraph
maxcolors
maxboxes
maxellipses
maxlines
maxstr
int scrolling_islinked
double scrollper
double shexper
int linked_zoom
int device;
int tdevice
int hdevice
int use_colors;
int monomode
int invert
int backingstore
int redraw_now
int autoscale_onread
int allow_refresh
int use_xvertext
int verify_action
int allow_dc
*/

/* write graphs */
    for (k = 0; k < maxgraph; k++) {
	if (isactive_graph(k)) {
	    cnt++;
	}
    }
    write_int(&cnt, 1, pp);
    for (k = 0; k < maxgraph; k++) {
	if (isactive_graph(k)) {
	    write_int(&k, 1, pp);
	    write_graph(&g[k], pp);
	}
    }
/* write annotation */
    cnt = 0;
    for (k = 0; k < maxlines; k++) {
	if (lines[k].active == ON) {
	    cnt++;
	}
    }
    write_int(&cnt, 1, pp);
    for (k = 0; k < maxlines; k++) {
	if (lines[k].active == ON) {
	    write_int(&k, 1, pp);
	    write_linetype(&lines[k], pp);
	}
    }
    cnt = 0;
    for (k = 0; k < maxboxes; k++) {
	if (boxes[k].active == ON) {
	    cnt++;
	}
    }
    write_int(&cnt, 1, pp);
    for (k = 0; k < maxboxes; k++) {
	if (boxes[k].active == ON) {
	    write_int(&k, 1, pp);
	    write_boxtype(&boxes[k], pp);
	}
    }
    cnt = 0;
    for (k = 0; k < maxellipses; k++) {
	if (ellip[k].active == ON) {
	    cnt++;
	}
    }
    write_int(&cnt, 1, pp);
    for (k = 0; k < maxellipses; k++) {
	if (ellip[k].active == ON) {
	    write_int(&k, 1, pp);
	    write_ellipsetype(&ellip[k], pp);
	}
    }
    cnt = 0;
    for (k = 0; k < maxstr; k++) {
	if (isactive_string(k)) {
	    cnt++;
	}
    }
    write_int(&cnt, 1, pp);
    for (k = 0; k < maxstr; k++) {
	if (isactive_string(k)) {
	    write_int(&k, 1, pp);
	    write_plotstr(&pstr[k], pp);
	}
    }
    if (blocklen != 0 && blockncols != 0) {
	write_int(&nblocks, 1, pp);
	write_int(&blocklen, 1, pp);
	write_int(&blockncols, 1, pp);
	for (i = 0; i < blockncols; i++) {
	    write_int(&i, 1, pp);
	    write_double(blockdata[i], blocklen, pp);
	}
    } else {
	nblocks = 0;
	write_int(&nblocks, 1, pp);
    }
    write_charstr( description, pp );
    write_int(&page_layout, 1, pp);
    close_xdr();
    fclose(pp);
    return 0;
}

int is_state_save(char *fname)
{
    int magic, clen, slen, ilen, flen, dlen;
    char buf[256];
    char ver[64], ord[64], math[64], name[64];
    FILE *fp;
    if ((fp = fopen(fname, "r")) == NULL) {
	return 0;
    }
    open_xdr(fp, 1); /* open XDR stream */
    read_char(buf, HEADERLENGTH, fp);
    buf[HEADERLENGTH - 1] = 0;
    sscanf(buf, "%d %s %s %s %s %d %d %d %d %d",
	&magic, ver, ord, math, name, &clen, &slen, &ilen, &flen, &dlen);
    close_xdr();
    fclose(fp);
    return (magic == PARMS_MAGIC) ? 1 : 0;
}

/*
 * getbinary - read in binary project file
 *
 * return: 0 - o.k.
 *         1 - nothing read in
 *         2 - partial read
 */
int getbinary(int gno, char *fname, int imbed)
{
    int ind, i, k, cnt, ng, magic;
    int clen, slen, ilen, flen, dlen, nblocks;
    char buf[256];
    char ver[64], ord[64], math[64], name[64];
    FILE *pp;
    if ((pp = fopen(fname, "r")) == NULL) {
	sprintf(buf, "Can't open parameter file %s", fname);
	errmsg(buf);
	return 1;
    }
    strcpy( docname, fname );
    open_xdr(pp, 1); /* open XDR stream */
    read_char(buf, HEADERLENGTH, pp);
    buf[HEADERLENGTH - 1] = 0;
    sscanf(buf, "%d %s %s %s %s %d %d %d %d %d",
	&magic, ver, ord, math, name, &clen, &slen, &ilen, &flen, &dlen);
    if (magic != PARMS_MAGIC) {
	errmsg("Bad magic in parameter file");
	fclose(pp);
	return 1;
    }
    read_int(&cnt, 1, pp);
    for (k = 0; k < cnt; k++) {
	read_int(&ng, 1, pp);
	if (read_graph(&g[ng], pp)) {
	    errmsg("Error reading parameter file (graphs), cancelled");
	    fclose(pp);
	    return 2;
	}
    }
    read_int(&cnt, 1, pp);
    for (k = 0; k < cnt; k++) {
	read_int(&ind, 1, pp);
	if (read_linetype(&lines[ind], pp)) {
	    errmsg("Error reading parameter file (lines), cancelled");
	    fclose(pp);
	    return 2;
	}
	lines[ind].active = ON;
    }
    read_int(&cnt, 1, pp);
    for (k = 0; k < cnt; k++) {
	read_int(&ind, 1, pp);
	if (read_boxtype(&boxes[ind], pp)) {
	    errmsg("Error reading parameter file (boxes), cancelled");
	    fclose(pp);
	    return 2;
	}
	boxes[ind].active = ON;
    }
    read_int(&cnt, 1, pp);
    for (k = 0; k < cnt; k++) {
		read_int(&ind, 1, pp);
		switch(read_ellipsetype(&ellip[ind], pp)) {
			case 0:
				ellip[ind].active = ON;
				break;
			case BADMAGIC:
				/* assume error from reading pre-ellipse file so put things
		    		back onto stream										*/
				if( replace_xdr_int( &ind ) || replace_xdr_int( &cnt ) ) {
	    			errmsg("Error reading parameter file (ellipses), cancelled");
	    			fclose(pp);
	    			return 2;
	    		} else
	    			k = cnt;	/* end loop */
	    	break;
	    default:
	    	errmsg("Error reading parameter file (plotstr), cancelled");
	    	fclose(pp);
	    	return 2;
	}
    }
   	read_int(&cnt, 1, pp);
    for (k = 0; k < cnt; k++) {
	read_int(&ind, 1, pp);
	if (read_plotstr(&pstr[ind], pp)) {
	    errmsg("Error reading parameter file (plotstr), cancelled");
	    fclose(pp);
	    return 2;
	}
    }
/* read block data */
    read_int(&nblocks, 1, pp);
    if (nblocks != 0) {
	read_int(&blocklen, 1, pp);
	read_int(&blockncols, 1, pp);
	for (i = 0; i < blockncols; i++) {
	    read_int(&ind, 1, pp); /* TODO  need to fix this malloc business */
	    blockdata[ind] = (double *) malloc(sizeof(double) * blocklen);
	    read_double(blockdata[ind], blocklen, pp);
	}
    }
	/* read description */
	if( read_charstr( description, pp ) )
		strcpy( description, "Just a typical project I assume" );
        if( read_int(&page_layout, 1, pp))
                page_layout=FREE;
    close_xdr();
    fclose(pp);
    return 0;
}
