
##########################################
#        Makefile for XMGR4 (VMS)        #
##########################################

# Rolf Niepraschk, 4/97, niepraschk@ptb.de
# John Hasstedt, 5/97, manager@nuclear.physics.sunysb.edu - support for MULTINET
# v1.8 -- Rolf Niepraschk, 6/97 - hdf/netcdf support, test for the mathematical 
#                         library DPML, new targets "clean" and "veryclean"
# v1.9 -- Rolf Niepraschk, 30-JUN-1997  -- test for VAX/AXP 

.IFDEF SCNDCALL  !-------------- second call ------------

TOP = [-]
VMSDIR = [.VMS]

O = .OBJ

ACEGR = XMGR.EXE

.INCLUDE $(TOP)MAKE.CONF 
X11_MIT = $(VMSDIR)

.IFDEF __ALPHA__
.IFDEF G_FLOAT
CF = /G_FLOAT/PREFIX=ALL
.ELSE
CF = /FLOAT=IEEE/PREFIX=ALL
.ENDIF
.ELSE
CF = /G_FLOAT/PREFIX=ALL
.ENDIF

.IFDEF USE_DEBUG
DB1 = /DEBUG
DB2 = /NOOPTI
.ELSE
DB2 = /NOWARN
.ENDIF	

D0 = MOTIF=1
I0 = $(VMSDIR)    

.IFDEF USE_XBAE
D1 = ,HAS_XBAE=1
I1 = ,$(XBAE_INCLUDES)
.ENDIF

.IFDEF USE_NETCDF
D2 = ,HAVE_NETCDF=1
I2 = ,$(NETCDFINCLUDES)
L1 = ,$(NETCDFLIBS)
.ENDIF	

.IFDEF USE_MFHDF
D3 = ,HAVE_MFHDF=1
I3 = ,$(MFHDFINCLUDES)
L2 = ,$(MFHDFLIBS)
.ENDIF	

.IFDEF USE_DRAGnDROP
D4 = ,DRAGnDROP=1
.ENDIF

.IFDEF HC_ORIENTATION_P
HC_ORIENTATION_FLAG = P
.ELSE
HC_ORIENTATION_FLAG = L
.ENDIF

.IFDEF MIF
D5 = ,MIF_PRSTR=""$(MIF_PRSTR)"",HDEV=GR_MIF_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF HPGL
D5 = ,HPGL_PRSTR=""$(HP_PRSTR)"",HDEV=GR_HPGL_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF LEAF
D5 = ,LEAF_PRSTR=""$(LEAF_PRSTR)"",HDEV=GR_LEAF_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF PS
D5 = ,PS_PRSTR=""$(PS_PRSTR)"",HDEV=GR_PS_$(HC_ORIENTATION_FLAG)
.ENDIF

#D6 = ,$(MAXDIST)

D7 = ,GR_HOME="""$(XMGRDIR)""",GR_HELPVIEWER="""$(HELPVIEWER)"""

.IFDEF USE_LIBHELP
D8 = ,LIBHELP=1
.ENDIF

D9 = ,"lines=lines_"

.IFDEF MULTINET
D10 = ,"MULTINET=1"
L3 = ,$(VMSDIR)multinet.opt/opt 
.ELSE
L3 = ,$(VMSDIR)vms.opt/opt 
.ENDIF

.IFDEF HAVEDPML
D11 = ,"HAVEDPML=1"
.ENDIF

MISCLIBS = $(L3), $(VMSDIR)'MOTIF_OPT' $(L1) $(L2) 

CFLAGS = $(DB1)$(DB2)$(CF)\
/DEFINE=($(D0)$(D1)$(D2)$(D3)$(D4)$(D5)$(D6)$(D7)$(D8)$(D9)$(D10)$(D11))\
/INCL=($(I0)$(I1)$(I2)$(I3))

LFLAGS = $(DB1) 

.INCLUDE MAKE.COMMON
	
VMSOBJS = missing_math.obj getpwnam.obj vms_unix.obj

.FIRST
	@ define X11 DECW$INCLUDE, $(X11_MIT)
	@ @sys$update:decw$get_image_version sys$share:decw$xlibshr.exe \
	  DECW$VERSION
	@ if f$locate("V1.2", DECW$Version) .ne. f$length(DECW$VERSION) \
	  then MOTIF_OPT == "motif1_2.opt/opt" 
	@ if f$locate("V1.1", DECW$Version) .ne. f$length(DECW$VERSION) \
	  then MOTIF_OPT == "motif1_1.opt/opt" 
	
			
DEFAULT : $(ACEGR)
	@ !	
			
$(ACEGR) : $(GROBJS) $(GUIOBJS) $(VMSOBJS)
	link /exe=$@ $(LFLAGS) $+ $(MISCLIBS) 
	
missing_math.obj : $(VMSDIR)missing_math.c $(VMSDIR)missing_math.h

vms_unix.obj : $(VMSDIR)vms_unix.c $(VMSDIR)vms_unix.h
	
getpwnam.obj : $(VMSDIR)getpwnam.c 
		
#
.ELSE	         !-------------- first call ------------

TOP = [-]
.INCLUDE $(TOP)MAKE.CONF 

DEFAULT :
	@ PARAM = "/MACRO=(SCNDCALL=1"
	@ PARAM1 = ""
	@ PARAM2 = ""
	@ PARAM3 = ""
	@ PARAM4 = ""
	@ PARAM5 = ""
	@ PARAM6 = ""
	@ PARAM7 = ""
	@ PARAM8 = ""
	@ PARAM9 = ""
	@ PARAM10 = ""
	@ PARAM11 = ""
	@ PARAM12 = ""
	@ IF F$EDIT("$(USE_DEBUG)","UPCASE") .EQS. "YES" THEN \
	  PARAM1 = ",USE_DEBUG=1"
	@ IF F$EDIT("$(USE_XBAE)","UPCASE") .EQS. "YES" THEN \
	  PARAM2 = ",USE_XBAE=1"
	@ IF F$EDIT("$(USE_NETCDF)","UPCASE") .EQS. "YES" THEN \
	  PARAM3 = ",USE_NETCDF=1"  
	@ IF F$EDIT("$(USE_MFHDF)","UPCASE") .EQS. "YES" THEN \
	  PARAM4 = ",USE_MFHDF=1" 
	@ IF F$EDIT("$(USE_DRAGnDROP)","UPCASE") .EQS. "YES" THEN \
	  PARAM5 = ",USE_DRAGnDROP=1" 
	@ IF F$EDIT("$(HC_ORIENTATION)","UPCASE") .EQS. "PORTRAIT" THEN \
	  PARAM6 = ",HC_ORIENTATION_P=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "MIF" THEN \
	  PARAM7 = ",MIF=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "HPGL" THEN \
	  PARAM7 = ",HPGL=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "LEAF" THEN \
	  PARAM7 = ",LEAF=1" 
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "PS" THEN \
	  PARAM7 = ",PS=1"  
	@ IF F$EDIT("$(USE_LIBHELP)","UPCASE") .EQS. "YES" THEN \
	  PARAM8 = ",USE_LIBHELP=1"     
	@ IF F$TRNLNM("MULTINET") .NES. "" THEN PARAM9 = ",MULTINET=1"
	@ IF F$SEARCH("SYS$SHARE:DPML$SHR.EXE") .NES. "" then \
	  PARAM10 = ",HAVEDPML=1" 
	@ IF F$GETSYI("ARCH_TYPE") .NE. 1 THEN \
	  PARAM11 = ",__ALPHA__=1"
.IFDEF G_FLOAT
        @ PARAM12 = ",G_FLOAT=1"
.ENDIF	  
	@ PARAM = "''PARAM'''PARAM1'''PARAM2'''PARAM3'''PARAM4'''PARAM5'\
''PARAM6'''PARAM7'''PARAM8'''PARAM9'''PARAM10'''PARAM11'''PARAM12')" 
	@ $(MMS)/IGNORE=WARNING 'PARAM' $(MMSTARGETS)	! second call	

CLEAN : 
        IF F$SEARCH("*.OBJ",).NES."" THEN DEL *.OBJ;*

VERYCLEAN : CLEAN
        IF F$SEARCH("xmgr.exe",).NES."" THEN DEL XMGR.EXE;*
		
.ENDIF	! SCNDCALL  
